/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet20NamedEntitySpawn;
import net.minecraft.server.Packet29DestroyEntity;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerMoveEvent;

public class InvisibilitySpell
extends Spell {
    protected ArrayList<Player> cloaked = new ArrayList();
    protected Location location;

    public boolean onCast(ConfigurationNode parameters) {
        this.location = this.player.getLocation();
        String typeString = parameters.getString("type", "");
        if (typeString.equals("decoy")) {
            this.decoy();
        }
        this.cloak();
        this.sendMessage(this.player, "You are invisible");
        this.spells.registerEvent(SpellEventType.PLAYER_MOVE, this);
        return true;
    }

    public void onPlayerMove(PlayerMoveEvent event) {
        if (!this.hasMoved()) {
            return;
        }
        this.sendMessage(this.player, "You are visible again");
        this.uncloak();
        this.spells.unregisterEvent(SpellEventType.PLAYER_MOVE, this);
    }

    public boolean hasMoved() {
        Location current = this.player.getLocation();
        return current.getBlockX() != this.location.getBlockX() || current.getBlockY() != this.location.getBlockY() || current.getBlockZ() != this.location.getBlockZ();
    }

    public void decoy() {
        this.uncloak();
        this.cloak();
    }

    public void cloak() {
        this.uncloak();
        List others = this.player.getWorld().getPlayers();
        for (Player other : others) {
            if (other == this.player || !this.inRange(other)) continue;
            this.cloaked.add(other);
            this.cloakFrom(other);
        }
    }

    public void uncloak() {
        for (Player other : this.cloaked) {
            this.uncloakFrom(other);
        }
        this.cloaked.clear();
    }

    protected boolean inRange(Player other) {
        Location playerLocation = this.player.getLocation();
        Location otherLocation = other.getLocation();
        int maxDistance = 256;
        return Math.pow(playerLocation.getX() - otherLocation.getX(), 2.0) + Math.pow(playerLocation.getY() - otherLocation.getY(), 2.0) + Math.pow(playerLocation.getZ() - otherLocation.getZ(), 2.0) < (double)(maxDistance * maxDistance);
    }

    protected void cloakFrom(Player other) {
        CraftPlayer hide = (CraftPlayer)this.player;
        CraftPlayer hideFrom = (CraftPlayer)other;
        EntityPlayer fromEntity = hideFrom.getHandle();
        fromEntity.netServerHandler.sendPacket((Packet)new Packet29DestroyEntity(hide.getEntityId()));
    }

    protected void uncloakFrom(Player other) {
        CraftPlayer hide = (CraftPlayer)this.player;
        CraftPlayer hideFrom = (CraftPlayer)other;
        EntityPlayer hideEntity = hide.getHandle();
        EntityPlayer fromEntity = hideFrom.getHandle();
        fromEntity.netServerHandler.sendPacket((Packet)new Packet20NamedEntitySpawn((EntityHuman)hideEntity));
    }

    public void onLoad(ConfigurationNode node) {
        this.disableTargeting();
    }
}

