/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.event.entity.EntityDamageEvent;

public class InvincibleSpell
extends Spell {
    protected float protectAmount = 0.0f;

    public boolean onCast(ConfigurationNode parameters) {
        int amount = parameters.getInt("amount", 100);
        if (this.protectAmount != 0.0f) {
            this.sendMessage(this.player, "You feel ... normal.");
            this.spells.unregisterEvent(SpellEventType.PLAYER_DAMAGE, this);
            this.protectAmount = 0.0f;
        } else {
            this.spells.registerEvent(SpellEventType.PLAYER_DAMAGE, this);
            if (amount >= 100) {
                this.sendMessage(this.player, "You feel invincible!");
            } else {
                this.sendMessage(this.player, "You feel strong!");
            }
            this.protectAmount = (float)amount / 100.0f;
        }
        return true;
    }

    public void onPlayerDamage(EntityDamageEvent event) {
        if (this.protectAmount > 0.0f) {
            if (this.protectAmount >= 1.0f) {
                event.setCancelled(true);
            } else {
                int newDamage = (int)Math.floor((1.0f - this.protectAmount) * (float)event.getDamage());
                if (newDamage == 0) {
                    newDamage = 1;
                }
                event.setDamage(newDamage);
            }
        }
    }

    public void onLoad(ConfigurationNode node) {
        this.disableTargeting();
    }
}

