/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class ForceSpell
extends Spell {
    int itemMagnitude = 1;
    int entityMagnitude = 3;
    int maxAllDistance = 20;
    Entity targetEntity = null;
    boolean allowAll = true;

    public void forceAll(double mutliplier, boolean push) {
        List entities = this.player.getWorld().getEntities();
        for (Entity entity : entities) {
            Location playerLocation;
            if (entity == this.player || ForceSpell.getDistance(playerLocation = this.player.getLocation(), entity.getLocation()) > (double)this.maxAllDistance) continue;
            this.forceEntity(entity, mutliplier, playerLocation, !push);
        }
    }

    public boolean onCast(ConfigurationNode parameters) {
        boolean push = false;
        boolean pull = false;
        if (this.targetEntity != null && this.targetEntity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)this.targetEntity;
            if (le.isDead()) {
                this.targetEntity = null;
            }
            if (this.targetEntity != null && ForceSpell.getDistance(this.player.getLocation(), this.targetEntity.getLocation()) > (double)this.getMaxRange()) {
                this.targetEntity = null;
            }
        }
        String typeString = parameters.getString("type", "");
        push = typeString.equals("push");
        pull = typeString.equals("pull");
        double multiplier = parameters.getDouble("size", 1.0);
        this.targetEntity(Entity.class);
        Target target = this.getTarget();
        if ((push || pull) && this.allowAll && (target == null || !target.isEntity() || target.isBlock()) && (this.getYRotation() < -60.0 || this.getYRotation() > 60.0)) {
            if (push) {
                this.castMessage(this.player, "Get away!");
                this.forceAll(multiplier, true);
            } else {
                this.castMessage(this.player, "Gimme!");
                this.forceAll(multiplier, false);
            }
            return true;
        }
        if (target == null || !target.hasTarget()) {
            this.targetEntity = null;
            return false;
        }
        if (target.isEntity()) {
            Entity newEntity = target.getEntity();
            if (this.targetEntity == null || newEntity instanceof LivingEntity || !(this.targetEntity instanceof LivingEntity)) {
                this.targetEntity = newEntity;
                if (!push && !pull) {
                    return true;
                }
            }
        }
        if (this.targetEntity == null) {
            return false;
        }
        Location destination = target.getLocation();
        if (pull) {
            destination = this.player.getLocation();
        }
        this.forceEntity(this.targetEntity, multiplier, destination, push);
        if (pull) {
            this.castMessage(this.player, "Yoink!");
        } else {
            this.castMessage(this.player, "Shove!");
        }
        return true;
    }

    protected void forceEntity(Entity target, double multiplier, Location destination, boolean useAim) {
        Vector destinationLoc;
        int magnitude = target instanceof LivingEntity ? this.entityMagnitude : this.itemMagnitude;
        magnitude = (int)((double)magnitude * multiplier);
        Vector targetLoc = new Vector(target.getLocation().getBlockX(), target.getLocation().getBlockY(), target.getLocation().getBlockZ());
        Vector forceVector = destinationLoc = new Vector(destination.getBlockX(), destination.getBlockY(), destination.getBlockZ());
        if (useAim) {
            forceVector = this.getAimVector();
        } else {
            forceVector.subtract(targetLoc);
        }
        forceVector.normalize();
        forceVector.multiply(magnitude);
        CraftEntity ce = (CraftEntity)target;
        ce.setVelocity(forceVector);
    }

    public void onCancel() {
        if (this.targetEntity != null) {
            this.targetEntity = null;
        }
    }

    public void onLoad(ConfigurationNode properties) {
        this.itemMagnitude = properties.getInt("item_force", this.itemMagnitude);
        this.entityMagnitude = properties.getInt("entity_force", this.entityMagnitude);
        this.allowAll = properties.getBoolean("allow_area", this.allowAll);
        this.maxAllDistance = properties.getInt("area_range", this.maxAllDistance);
    }
}

