/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityFireball;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.MathHelper;
import net.minecraft.server.World;
import net.minecraft.server.WorldServer;
import org.bukkit.Location;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.util.Vector;

public class FireballSpell
extends Spell {
    int defaultSize = 1;

    public boolean onCast(ConfigurationNode parameters) {
        int size = parameters.getInt("size", this.defaultSize);
        boolean useFire = parameters.getBoolean("fire", true);
        CraftWorld cw = (CraftWorld)this.player.getWorld();
        WorldServer world = cw.getHandle();
        CraftPlayer craftPlayer = (CraftPlayer)this.player;
        EntityPlayer playerEntity = craftPlayer.getHandle();
        Location playerLoc = this.player.getLocation();
        Vector aim = this.getAimVector();
        int fireballX = (int)(playerLoc.getX() + aim.getX() * 2.0 + 0.5);
        int fireballY = (int)(playerLoc.getY() + aim.getY() * 2.0 + 2.0);
        int fireballZ = (int)(playerLoc.getZ() + aim.getZ() * 2.0 + 0.5);
        double d0 = aim.getX();
        double d1 = aim.getY();
        double d2 = aim.getZ();
        EntityFireball fireball = new EntityFireball((World)world, (EntityLiving)playerEntity, aim.getX(), aim.getY(), aim.getZ());
        fireball.setPositionRotation((double)fireballX, (double)fireballY, (double)fireballZ, playerLoc.getYaw(), playerLoc.getPitch());
        fireball.yield = size;
        fireball.isIncendiary = useFire;
        double d3 = MathHelper.a((double)(d0 * d0 + d1 * d1 + d2 * d2));
        fireball.c = d0 / d3 * 0.1;
        fireball.d = d1 / d3 * 0.1;
        fireball.e = d2 / d3 * 0.1;
        world.addEntity((Entity)fireball);
        return true;
    }

    public void onLoad(ConfigurationNode node) {
        this.disableTargeting();
    }
}

