/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Creature;
import org.bukkit.entity.CreatureType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.player.PlayerEvent;

public class FamiliarSpell
extends Spell {
    private String DEFAULT_FAMILIARS = "Chicken,Sheep,Cow,Pig,Wolf";
    private String DEFAULT_MONSTERS = "Creeper,PigZombie,Skeleton,Spider,Zombie,Ghast,Giant,Monster,Silverfish,Enderman,CaveSpider";
    private List<String> defaultFamiliars = new ArrayList<String>();
    private List<String> defaultMonsters = new ArrayList<String>();
    private final Random rand = new Random();
    private PlayerFamiliar familiars = new PlayerFamiliar();

    public boolean onCast(ConfigurationNode parameters) {
        Block originalTarget;
        this.noTargetThrough(Material.STATIONARY_WATER);
        this.noTargetThrough(Material.WATER);
        this.targetEntity(LivingEntity.class);
        Target target = this.getTarget();
        if (target == null || !target.hasTarget()) {
            this.castMessage(this.player, "No target");
            return false;
        }
        Block targetBlock = originalTarget = target.getBlock();
        LivingEntity targetEntity = null;
        boolean hasFamiliar = this.familiars.hasFamiliar();
        if (hasFamiliar) {
            boolean isFamiliar;
            boolean bl = isFamiliar = target.isEntity() && this.familiars.isFamiliar(target.getEntity());
            if (isFamiliar) {
                this.castMessage(this.player, "You release your familiar(s)");
                this.checkListener();
                return true;
            }
            this.familiars.releaseFamiliar();
        }
        if (target.isEntity()) {
            targetBlock = targetBlock.getRelative(BlockFace.SOUTH);
            Entity e = target.getEntity();
            if (e instanceof LivingEntity) {
                targetEntity = (LivingEntity)e;
            }
        }
        targetBlock = targetBlock.getRelative(BlockFace.UP);
        CreatureType famType = CreatureType.PIG;
        FamiliarClass famClass = FamiliarClass.FRIENDLY;
        int famCount = parameters.getInt("count", 1);
        String famTypeName = parameters.getString("type", "");
        if (famTypeName.equalsIgnoreCase("any")) {
            famClass = FamiliarClass.ANY;
        } else if (famTypeName.equalsIgnoreCase("mob")) {
            famClass = FamiliarClass.MONSTER;
        } else if (famTypeName.length() > 1) {
            String testType = famTypeName.toUpperCase();
            CreatureType[] creatureTypeArray = CreatureType.values();
            int n = creatureTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                CreatureType ct = creatureTypeArray[n2];
                if (ct.getName().toUpperCase().equals(testType)) {
                    famType = ct;
                    famClass = FamiliarClass.SPECIFIC;
                }
                ++n2;
            }
        }
        if (originalTarget.getType() == Material.WATER || originalTarget.getType() == Material.STATIONARY_WATER) {
            famType = CreatureType.SQUID;
            famClass = FamiliarClass.SPECIFIC;
        }
        ArrayList<Creature> newFamiliars = new ArrayList<Creature>();
        int spawnCount = 0;
        int i = 0;
        while (i < famCount) {
            Creature entity;
            if (famClass != FamiliarClass.SPECIFIC) {
                if (famClass == FamiliarClass.ANY) {
                    int randomFamiliar = this.rand.nextInt(CreatureType.values().length - 1);
                    famType = CreatureType.values()[randomFamiliar];
                } else {
                    List<String> types = this.defaultFamiliars;
                    if (famClass == FamiliarClass.MONSTER) {
                        types = this.defaultMonsters;
                    }
                    int randomFamiliar = this.rand.nextInt(types.size());
                    famType = CreatureType.fromName((String)types.get(randomFamiliar));
                }
            }
            Location targetLoc = targetBlock.getLocation();
            if (famCount > 1) {
                targetLoc.setX(targetLoc.getX() + (double)this.rand.nextInt(2 * famCount) - (double)famCount);
                targetLoc.setZ(targetLoc.getZ() + (double)this.rand.nextInt(2 * famCount) - (double)famCount);
            }
            if ((entity = this.spawnFamiliar(targetLoc, famType, targetEntity)) != null) {
                newFamiliars.add(entity);
                ++spawnCount;
            }
            ++i;
        }
        String typeMessage = "";
        if (famClass == FamiliarClass.SPECIFIC) {
            typeMessage = " " + famType.name().toLowerCase();
        } else if (famClass != FamiliarClass.ANY) {
            typeMessage = " " + famClass.name().toLowerCase();
        }
        this.castMessage(this.player, "You create " + famCount + typeMessage + " familiar(s)!");
        this.familiars.setFamiliars(newFamiliars);
        this.checkListener();
        return true;
    }

    protected Creature spawnFamiliar(Location target, CreatureType famType, LivingEntity targetEntity) {
        LivingEntity famEntity = this.player.getWorld().spawnCreature(target, famType);
        if (!(famEntity instanceof Creature)) {
            return null;
        }
        Creature familiar = (Creature)famEntity;
        if (targetEntity != null) {
            familiar.setTarget(targetEntity);
        }
        return familiar;
    }

    protected void checkListener() {
        if (this.familiars.hasFamiliar()) {
            this.spells.registerEvent(SpellEventType.PLAYER_QUIT, this);
        } else {
            this.spells.unregisterEvent(SpellEventType.PLAYER_QUIT, this);
        }
    }

    public void onLoad(ConfigurationNode properties) {
        this.defaultFamiliars = csv.parseStrings(this.DEFAULT_FAMILIARS);
        this.defaultMonsters = csv.parseStrings(this.DEFAULT_MONSTERS);
    }

    public void onPlayerQuit(PlayerEvent event) {
        if (this.familiars.hasFamiliar()) {
            this.familiars.releaseFamiliar();
            this.checkListener();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FamiliarClass {
        SPECIFIC,
        ANY,
        FRIENDLY,
        MONSTER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PlayerFamiliar {
        public List<Creature> familiars = null;

        public boolean hasFamiliar() {
            return this.familiars != null;
        }

        public void setFamiliars(List<Creature> f) {
            this.familiars = f;
        }

        public void releaseFamiliar() {
            if (this.familiars != null) {
                for (Creature familiar : this.familiars) {
                    familiar.setHealth(0);
                }
                this.familiars = null;
            }
        }

        public boolean isFamiliar(Entity e) {
            if (this.familiars == null) {
                return false;
            }
            for (Creature c : this.familiars) {
                if (c.getEntityId() != e.getEntityId()) continue;
                return true;
            }
            return false;
        }
    }
}

