/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class DisintegrateSpell
extends Spell {
    private int playerDamage = 1;
    private int entityDamage = 100;

    public boolean onCast(ConfigurationNode parameters) {
        Entity targetEntity;
        Target target = this.getTarget();
        if (target == null) {
            this.castMessage(this.player, "No target");
            return false;
        }
        if (target.isEntity() && (targetEntity = target.getEntity()) instanceof LivingEntity) {
            LivingEntity li = (LivingEntity)targetEntity;
            if (li instanceof Player) {
                li.damage(this.playerDamage);
            } else {
                li.damage(this.entityDamage);
            }
            this.castMessage(this.player, "ZOT!");
            return true;
        }
        if (!target.hasTarget()) {
            this.castMessage(this.player, "No target");
            return false;
        }
        Block targetBlock = target.getBlock();
        BlockList disintigrated = new BlockList();
        disintigrated.add(targetBlock);
        if (this.isUnderwater()) {
            targetBlock.setType(Material.STATIONARY_WATER);
        } else {
            targetBlock.setType(Material.AIR);
        }
        this.spells.addToUndoQueue(this.player, disintigrated);
        this.castMessage(this.player, "ZAP!");
        return true;
    }

    public void onLoad(ConfigurationNode properties) {
        this.playerDamage = properties.getInteger("player_damage", this.playerDamage);
        this.entityDamage = properties.getInteger("entity_damage", this.entityDamage);
    }
}

