/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;

public class BridgeSpell
extends Spell {
    int MAX_SEARCH_DISTANCE = 16;

    public boolean onCast(ConfigurationNode parameters) {
        Block playerBlock = this.getPlayerBlock();
        if (playerBlock == null) {
            this.player.sendMessage("You need to be standing on something");
            return false;
        }
        BlockFace direction = this.getPlayerFacing();
        Block attachBlock = playerBlock;
        Block targetBlock = attachBlock.getRelative(direction);
        Material material = targetBlock.getType();
        byte data = targetBlock.getData();
        ItemStack buildWith = this.getBuildingMaterial();
        if (buildWith != null) {
            material = buildWith.getType();
            data = BridgeSpell.getItemData(buildWith);
        }
        int distance = 0;
        while (this.isTargetable(targetBlock.getType()) && distance <= this.MAX_SEARCH_DISTANCE) {
            ++distance;
            attachBlock = targetBlock;
            targetBlock = attachBlock.getRelative(direction);
        }
        if (this.isTargetable(targetBlock.getType())) {
            this.player.sendMessage("Can't bridge any further");
            return false;
        }
        BlockList bridgeBlocks = new BlockList();
        bridgeBlocks.add(targetBlock);
        targetBlock.setType(material);
        targetBlock.setData(data);
        this.castMessage(this.player, "A bridge extends!");
        this.spells.addToUndoQueue(this.player, bridgeBlocks);
        return true;
    }

    public void onLoad(ConfigurationNode node) {
        this.disableTargeting();
    }
}

