/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.CleanupBlocksTask;
import com.elmakers.mine.bukkit.plugins.magic.MagicPlugin;
import com.elmakers.mine.bukkit.plugins.magic.PlayerSpells;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.plugins.magic.spells.AbsorbSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.AlterSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.ArrowSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.BlinkSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.BoomSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.BridgeSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.ConstructSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.CushionSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.DisintegrateSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.FamiliarSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.FillSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.FireSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.FireballSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.FlingSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.ForceSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.FrostSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.GillsSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.GotoSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.GrenadeSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.HealSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.InvincibleSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.InvisibilitySpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.LavaSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.LevitateSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.LightningSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.MineSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.PillarSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.PortalSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.RecallSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.SignSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.TorchSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.TreeSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.UndoSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.WeatherSpell;
import com.elmakers.mine.bukkit.plugins.magic.spells.WolfSpell;
import com.elmakers.mine.bukkit.utilities.CSVParser;
import com.elmakers.mine.bukkit.utilities.UndoQueue;
import com.elmakers.mine.bukkit.utilities.borrowed.Configuration;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import com.nijiko.permissions.PermissionHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.CraftingManager;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Spells {
    private final String spellsFileName = "spells.yml";
    private final String propertiesFileName = "magic.yml";
    private int wandTypeId = 280;
    static final String DEFAULT_BUILDING_MATERIALS = "0,1,2,3,4,5,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,33,34,35,41,42,43,45,46,47,48,49,52,53,55,56,57,58,60,61,62,65,66,67,73,74,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109";
    static final String STICKY_MATERIALS = "37,38,39,50,51,55,59,63,64,65,66,68,70,71,72,75,76,77,78,83";
    static final String STICKY_MATERIALS_DOUBLE_HEIGHT = "64,71,";
    private List<Material> buildingMaterials = new ArrayList<Material>();
    private List<Material> stickyMaterials = new ArrayList<Material>();
    private List<Material> stickyMaterialsDoubleHeight = new ArrayList<Material>();
    private long physicsDisableTimeout = 0L;
    private int undoQueueDepth = 256;
    private boolean silent = false;
    private boolean quiet = true;
    private HashMap<String, UndoQueue> playerUndoQueues = new HashMap();
    private final Logger log = Logger.getLogger("Minecraft");
    private final HashMap<String, Spell> spells = new HashMap();
    private final HashMap<Material, Spell> spellsByMaterial = new HashMap();
    private final HashMap<String, PlayerSpells> playerSpells = new HashMap();
    private MagicPlugin plugin = null;

    public Spell getSpell(Material material, Player player) {
        Spell spell = this.spellsByMaterial.get(material);
        if (spell == null || !spell.hasSpellPermission(player)) {
            return null;
        }
        return this.getSpell(spell.getName(), player);
    }

    public Spell getSpell(String name, Player player) {
        Spell spell = this.spells.get(name);
        if (spell == null || !spell.hasSpellPermission(player)) {
            return null;
        }
        PlayerSpells playerSpells = this.getPlayerSpells(player);
        Spell playerSpell = playerSpells.getSpell(spell.getName());
        if (playerSpell == null) {
            playerSpell = (Spell)spell.clone();
            playerSpells.addSpell(playerSpell);
        }
        playerSpell.setPlayer(player);
        return playerSpell;
    }

    public PlayerSpells getPlayerSpells(Player player) {
        PlayerSpells spells = this.playerSpells.get(player.getName());
        if (spells == null) {
            spells = new PlayerSpells(player);
            this.playerSpells.put(player.getName(), spells);
        }
        spells.setPlayer(player);
        return spells;
    }

    protected void createDefaultSpells() {
        this.createSpell(new AbsorbSpell(), "absorb", Material.BUCKET, "Absorb some of the target", "construction", "");
        this.createSpell(new AlterSpell(), "alter", Material.REDSTONE_TORCH_ON, "Alter certain objects", "construction", "");
        this.createSpell(new ArrowSpell(), "arrow", Material.ARROW, "Fire a magic arrow", "combat", "");
        this.createSpell(new ArrowSpell(), "arrowrain", Material.BOW, "Fire a volley of arrows", "combat", "count 4");
        this.createSpell(new BlinkSpell(), "blink", Material.FEATHER, "Teleport to your target", "psychic", "");
        this.createSpell(new BlinkSpell(), "ascend", Material.RED_MUSHROOM, "Go up to the nearest safe spot", "psychic", "type ascend");
        this.createSpell(new BlinkSpell(), "descend", Material.BROWN_MUSHROOM, "Travel underground", "psychic", "type descend");
        this.createSpell(new BlinkSpell(), "tesseract", Material.WEB, "Blink a short distance", "psychic", "", "range 8 allow_passthrough false allow_ascend false allow_descend false");
        this.createSpell(new BoomSpell(), "boom", Material.RED_ROSE, "Create an explosion", "combat", "");
        this.createSpell(new BoomSpell(), "kaboom", Material.REDSTONE_WIRE, "Create a big explosion", "combat", "size 6");
        this.createSpell(new BoomSpell(), "kamikazee", Material.DEAD_BUSH, "Kill yourself with an explosion", "combat", "size 8 target here");
        this.createSpell(new BoomSpell(), "nuke", Material.BED, "Create a huge explosino", "combat", "size 20");
        this.createSpell(new BridgeSpell(), "bridge", Material.GOLD_HOE, "Extend the ground underneath you", "construction", "");
        this.createSpell(new ConstructSpell(), "blob", Material.CLAY_BALL, "Create a solid blob", "construction", "type sphere radius 3", "allow_max_range true");
        this.createSpell(new ConstructSpell(), "shell", Material.BOWL, "Create a large spherical shell", "construction", "type sphere fill hollow radius 10");
        this.createSpell(new ConstructSpell(), "box", Material.GOLD_HELMET, "Create a large hollow box", "construction", "type cuboid fill hollow radius 6");
        this.createSpell(new ConstructSpell(), "superblob", Material.CLAY_BRICK, "Create a large solid sphere", "construction", "type sphere radius 8", "allow_max_range true");
        this.createSpell(new ConstructSpell(), "sandblast", Material.SANDSTONE, "Drop a big block of sand", "combat", "type cuboid radius 4 material sand", "allow_max_range true");
        this.createSpell(new ConstructSpell(), "blast", Material.SULPHUR, "Mine out a large area", "mining", "type sphere material air", "destructible 1,2,3,4,10,11,12,13,87,88");
        this.createSpell(new ConstructSpell(), "superblast", Material.SLIME_BALL, "Mine out a very large area", "mining", "type sphere radius 16 material air", "destructible 1,2,3,4,10,11,12,13,87,88");
        this.createSpell(new ConstructSpell(), "peek", Material.SUGAR_CANE, "Temporarily glass the target surface", "alchemy", "material glass type sphere radius 3", "undo 4000 destructible 1,2,3,4,8,9,10,11,12,13,87,88");
        this.createSpell(new ConstructSpell(), "breach", Material.SEEDS, "Temporarily destroy the target surface", "alchemy", "material air type sphere radius 4", "undo 10000 destructible 1,2,3,4,8,9,10,11,12,13,87,88");
        this.createSpell(new CushionSpell(), "cushion", Material.SOUL_SAND, "Create a safety bubble", "alchemy", "");
        this.createSpell(new DisintegrateSpell(), "disintegrate", Material.BONE, "Damage your target", "combat", "");
        this.createSpell(new FamiliarSpell(), "familiar", Material.EGG, "Create an animal familiar", "summoner", "");
        this.createSpell(new FamiliarSpell(), "monster", Material.PUMPKIN, "Call a monster to your side", "summoner", "type monster");
        this.createSpell(new FamiliarSpell(), "mob", Material.JACK_O_LANTERN, "Summon a mob of monsters", "summoner", "type mob count 20");
        this.createSpell(new FamiliarSpell(), "ender", Material.ENDER_PEARL, "Summon an enderman", "summoner", "type enderman");
        this.createSpell(new FamiliarSpell(), "farm", Material.WHEAT, "Create a herd", "farming", "30");
        this.createSpell(new FillSpell(), "fill", Material.GOLD_SPADE, "Fill a selected area (cast twice)", "construction", "");
        this.createSpell(new FillSpell(), "paint", Material.PAINTING, "Fill a single block", "alchemy", "type single");
        this.createSpell(new FillSpell(), "recurse", Material.WOOD_SPADE, "Recursively fill blocks", "alchemy", "type recurse");
        this.createSpell(new FireballSpell(), "fireball", Material.NETHERRACK, "Cast an exploding fireball", "combat", "");
        this.createSpell(new FireballSpell(), "icbm", Material.ROTTEN_FLESH, "Cast an exploding fireball", "combat", "size 10");
        this.createSpell(new FireSpell(), "fire", Material.FLINT_AND_STEEL, "Light fires from a distance", "elemental", "");
        this.createSpell(new FireSpell(), "inferno", Material.FIRE, "Burn a wide area", "master", "6");
        this.createSpell(new FlingSpell(), "fling", Material.LEATHER_BOOTS, "Sends you flying in the target direction", "psychic", "size 5");
        this.createSpell(new ForceSpell(), "force", Material.STRING, "Use telekinesis", "psychic", "", "allow_max_range true range 48");
        this.createSpell(new ForceSpell(), "pull", Material.FISHING_ROD, "Pull things toward you", "psychic", "type pull range 32");
        this.createSpell(new ForceSpell(), "push", Material.RAILS, "Push things away from you", "psychic", "type push range 16");
        this.createSpell(new FrostSpell(), "frost", Material.SNOW_BALL, "Freeze water and create snow", "alchemy", "", "range 24");
        this.createSpell(new GillsSpell(), "gills", Material.RAW_FISH, "Restores health while moving underwater", "medic", "");
        this.createSpell(new GotoSpell(), "gather", Material.GLOWSTONE_DUST, "Gather groups of players together", "master", "");
        this.createSpell(new GrenadeSpell(), "grenade", Material.TNT, "Place a primed grenade", "combat", "", "", "tnt 1");
        this.createSpell(new HealSpell(), "heal", Material.BREAD, "Heal yourself or others", "medic", "", "cooldown 5000", "apple 1 wheat 1");
        this.createSpell(new InvincibleSpell(), "invincible", Material.GOLDEN_APPLE, "Make yourself impervious to damage", "master", "");
        this.createSpell(new InvincibleSpell(), "ironskin", Material.IRON_CHESTPLATE, "Protect you from damage", "master", "amount 99");
        this.createSpell(new InvincibleSpell(), "leatherskin", Material.LEATHER_CHESTPLATE, "Protect you from some damage", "combat", "amount 50");
        this.createSpell(new InvisibilitySpell(), "cloak", Material.CHAINMAIL_CHESTPLATE, "Make yourself invisible while still", "psychic", "");
        this.createSpell(new LavaSpell(), "lava", Material.LAVA, "Fire a stream of lava", "combat", "");
        this.createSpell(new LevitateSpell(), "levitate", Material.GOLD_BOOTS, "Levitate yourself up into the air", "psychic", "");
        this.createSpell(new LightningSpell(), "lightning", Material.COOKED_FISH, "Strike lighting at your target", "combat", "");
        this.createSpell(new LightningSpell(), "storm", Material.GRILLED_PORK, "Start a lightning storm", "elemental", "radius 10", "cooldown 500");
        this.createSpell(new MineSpell(), "mine", Material.GOLD_PICKAXE, "Mines and drops the targeted resources", "mining", "");
        this.createSpell(new PillarSpell(), "pillar", Material.GOLD_AXE, "Raises a pillar up", "construction", "");
        this.createSpell(new PillarSpell(), "stalactite", Material.WOOD_AXE, "Create a downward pillar", "construction", "type down");
        this.createSpell(new PortalSpell(), "portal", Material.PORTAL, "Create two connected portals", "psychic", "");
        this.createSpell(new RecallSpell(), "recall", Material.COMPASS, "Marks locations for return", "exploration", "");
        this.createSpell(new RecallSpell(), "spawn", Material.YELLOW_FLOWER, "Take yourself back home", "exploration", "type spawn");
        this.createSpell(new SignSpell(), "sign", Material.SIGN_POST, "Give yourself some signs", "master", "");
        this.createSpell(new SignSpell(), "tag", Material.SIGN, "Leave a sign with your name", "exploration", "tag", "cooldown 10000");
        this.createSpell(new TorchSpell(), "torch", Material.TORCH, "Shed some light", "exploration", "");
        this.createSpell(new TorchSpell(), "day", Material.FLINT, "Change time time to day", "elemental", "time day");
        this.createSpell(new TorchSpell(), "night", Material.COAL, "Change time time to night", "elemental", "time night");
        this.createSpell(new TreeSpell(), "tree", Material.SAPLING, "Instantly grow a tree", "farming", "");
        this.createSpell(new UndoSpell(), "rewind", Material.WATCH, "Undo your last action", "alchemy", "");
        this.createSpell(new UndoSpell(), "erase", Material.LEVER, "Undo your target construction", "alchemy", "");
        this.createSpell(new WeatherSpell(), "weather", Material.WATER, "Change the weather", "elemental", "");
        this.createSpell(new WolfSpell(), "wolf", Material.PORK, "Create a wolf familiar to follow you around", "summoner", "", "cooldown 500");
    }

    public void createSpell(Spell template, String name, Material icon, String description, String category, String parameterString) {
        this.createSpell(template, name, icon, description, category, parameterString, null, null);
    }

    public void createSpell(Spell template, String name, Material icon, String description, String category, String parameterString, String propertiesString) {
        this.createSpell(template, name, icon, description, category, parameterString, propertiesString, null);
    }

    public void createSpell(Spell template, String name, Material icon, String description, String category, String parameterString, String propertiesString, String costsString) {
        ConfigurationNode spellNode = new ConfigurationNode();
        ConfigurationNode parameterNode = spellNode.createChild("parameters");
        ConfigurationNode propertiesNode = spellNode.createChild("properties");
        if (parameterString != null && parameterString.length() > 0) {
            String[] parameters = parameterString.split(" ");
            Spell.addParameters(parameters, parameterNode);
        }
        if (propertiesString != null && propertiesString.length() > 0) {
            String[] properties = propertiesString.split(" ");
            Spell.addParameters(properties, propertiesNode);
        }
        if (costsString != null && costsString.length() > 0) {
            ArrayList costs = new ArrayList();
            String[] costPairs = costsString.split(" ");
            int i = 0;
            while (i < costPairs.length - 1) {
                try {
                    int amount = Integer.parseInt(costPairs[i + 1]);
                    HashMap<String, Object> cost = new HashMap<String, Object>();
                    cost.put("material", costPairs[i]);
                    cost.put("amount", amount);
                    costs.add(cost);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                i += 2;
            }
            spellNode.setProperty("costs", costs);
        }
        spellNode.setProperty("description", description);
        spellNode.setProperty("icon", icon);
        spellNode.setProperty("category", category);
        template.load(name, spellNode);
        this.addSpell(template);
    }

    public void addSpell(Spell variant) {
        Spell conflict = this.spells.get(variant.getName());
        if (conflict != null) {
            this.log.log(Level.WARNING, "Duplicate spell name: '" + conflict.getName() + "'");
        } else {
            this.spells.put(variant.getName(), variant);
        }
        Material m = variant.getMaterial();
        if (m != null && m != Material.AIR) {
            conflict = this.spellsByMaterial.get(m);
            if (conflict != null) {
                this.log.log(Level.WARNING, "Duplicate spell material: " + m.name() + " for " + conflict.getName() + " and " + variant.getName());
            } else {
                this.spellsByMaterial.put(variant.getMaterial(), variant);
            }
        }
        variant.initialize(this);
    }

    public List<Material> getBuildingMaterials() {
        return this.buildingMaterials;
    }

    public UndoQueue getUndoQueue(String playerName) {
        UndoQueue queue = this.playerUndoQueues.get(playerName);
        if (queue == null) {
            queue = new UndoQueue();
            queue.setMaxSize(this.undoQueueDepth);
            this.playerUndoQueues.put(playerName, queue);
        }
        return queue;
    }

    public void addToUndoQueue(Player player, BlockList blocks) {
        UndoQueue queue = this.getUndoQueue(player.getName());
        queue.add(blocks);
    }

    public boolean undoAny(Player player, Block target) {
        for (String playerName : this.playerUndoQueues.keySet()) {
            UndoQueue queue = this.playerUndoQueues.get(playerName);
            if (!queue.undo(target)) continue;
            if (!player.getName().equals(playerName)) {
                player.sendMessage("Undid one of " + playerName + "'s spells");
            }
            return true;
        }
        return false;
    }

    public boolean undo(String playerName) {
        UndoQueue queue = this.getUndoQueue(playerName);
        return queue.undo();
    }

    public boolean undo(String playerName, Block target) {
        UndoQueue queue = this.getUndoQueue(playerName);
        return queue.undo(target);
    }

    public BlockList getLastBlockList(String playerName, Block target) {
        UndoQueue queue = this.getUndoQueue(playerName);
        return queue.getLast(target);
    }

    public BlockList getLastBlockList(String playerName) {
        UndoQueue queue = this.getUndoQueue(playerName);
        return queue.getLast();
    }

    public void scheduleCleanup(BlockList blocks) {
        Server server = this.plugin.getServer();
        BukkitScheduler scheduler = server.getScheduler();
        long ticksToLive = blocks.getTimeToLive() * 20 / 1000;
        scheduler.scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new CleanupBlocksTask(blocks), ticksToLive);
    }

    public void registerEvent(SpellEventType type, Spell spell) {
        PlayerSpells spells = this.getPlayerSpells(spell.getPlayer());
        spells.registerEvent(type, spell);
    }

    public void unregisterEvent(SpellEventType type, Spell spell) {
        PlayerSpells spells = this.getPlayerSpells(spell.getPlayer());
        spells.unregisterEvent(type, spell);
    }

    public int getWandTypeId() {
        return this.wandTypeId;
    }

    public void cancel(Player player) {
        PlayerSpells playerSpells = this.getPlayerSpells(player);
        playerSpells.cancel();
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public boolean isSolid(Material mat) {
        return mat != Material.AIR && mat != Material.WATER && mat != Material.STATIONARY_WATER && mat != Material.LAVA && mat != Material.STATIONARY_LAVA;
    }

    public boolean isSticky(Material mat) {
        return this.stickyMaterials.contains(mat);
    }

    public boolean isStickyAndTall(Material mat) {
        return this.stickyMaterialsDoubleHeight.contains(mat);
    }

    public boolean isAffectedByGravity(Material mat) {
        return mat == Material.GRAVEL || mat == Material.SAND || mat == Material.WOOD_DOOR || mat == Material.IRON_DOOR;
    }

    public Logger getLog() {
        return this.log;
    }

    public MagicPlugin getPlugin() {
        return this.plugin;
    }

    public void initialize(MagicPlugin plugin) {
        this.plugin = plugin;
        this.load();
        CraftingManager cm = CraftingManager.getInstance();
        Object[] shape = new Object[]{"#", "X", Character.valueOf('X'), Item.STICK, Character.valueOf('#'), Item.GLOWSTONE_DUST};
        cm.registerShapedRecipe(new ItemStack(Item.STICK, 1, 10), shape);
    }

    public void load() {
        File dataFolder = this.plugin.getDataFolder();
        dataFolder.mkdirs();
        File propertiesFile = new File(dataFolder, "magic.yml");
        this.loadProperties(propertiesFile);
        File spellsFile = new File(dataFolder, "spells.yml");
        if (!spellsFile.exists()) {
            this.createDefaultSpells();
            this.save(spellsFile);
        } else {
            this.load(spellsFile);
        }
        this.log.info("Magic: Loaded " + this.spells.size() + " spells.");
    }

    protected void save(File spellsFile) {
        Configuration config = new Configuration(spellsFile);
        ConfigurationNode spellsNode = config.createChild("spells");
        for (Spell spell : this.spells.values()) {
            ConfigurationNode spellNode = spellsNode.createChild(spell.getName());
            spell.save(spellNode);
        }
        config.save();
    }

    protected void load(File spellsFile) {
        Configuration config = new Configuration(spellsFile);
        config.load();
        ConfigurationNode spellsNode = config.getNode("spells");
        if (spellsNode == null) {
            return;
        }
        List<String> spellKeys = spellsNode.getKeys();
        for (String key : spellKeys) {
            ConfigurationNode spellNode;
            Spell newSpell = Spell.loadSpell(key, spellNode = spellsNode.getNode(key));
            if (newSpell == null) {
                this.log.warning("Magic: Error loading spell " + key);
                continue;
            }
            this.addSpell(newSpell);
        }
    }

    protected void loadProperties(File propertiesFile) {
        Configuration properties = new Configuration(propertiesFile);
        properties.load();
        ConfigurationNode generalNode = properties.createChild("general");
        this.undoQueueDepth = generalNode.getInteger("undo_depth", this.undoQueueDepth);
        this.silent = generalNode.getBoolean("silent", this.silent);
        this.quiet = generalNode.getBoolean("quiet", this.quiet);
        this.buildingMaterials = generalNode.getMaterials("building", DEFAULT_BUILDING_MATERIALS);
        this.wandTypeId = generalNode.getInteger("wand_type_id", this.wandTypeId);
        CSVParser csv = new CSVParser();
        this.stickyMaterials = csv.parseMaterials(STICKY_MATERIALS);
        this.stickyMaterialsDoubleHeight = csv.parseMaterials(STICKY_MATERIALS_DOUBLE_HEIGHT);
        properties.save();
    }

    public void clear() {
        this.playerSpells.clear();
        this.spells.clear();
        this.spellsByMaterial.clear();
    }

    public void reset() {
        this.log.info("Magic: Resetting all spells to default");
        this.clear();
        File dataFolder = this.plugin.getDataFolder();
        dataFolder.mkdirs();
        File spellsFile = new File(dataFolder, "spells.yml");
        spellsFile.delete();
        this.load();
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
        PlayerSpells spells = this.getPlayerSpells(event.getPlayer());
        spells.onPlayerQuit(event);
    }

    public void onPlayerMove(PlayerMoveEvent event) {
        PlayerSpells spells = this.getPlayerSpells(event.getPlayer());
        spells.onPlayerMove(event);
    }

    public void onPlayerDeath(Player player, EntityDeathEvent event) {
        PlayerSpells spells = this.getPlayerSpells(player);
        spells.onPlayerDeath(event);
    }

    public void onPlayerDamage(Player player, EntityDamageEvent event) {
        PlayerSpells spells = this.getPlayerSpells(player);
        spells.onPlayerDamage(event);
    }

    public List<Spell> getAllSpells() {
        ArrayList<Spell> allSpells = new ArrayList<Spell>();
        allSpells.addAll(this.spells.values());
        return allSpells;
    }

    public void onPlayerAnimation(PlayerAnimationEvent event) {
        Player player = event.getPlayer();
        if (event.getAnimationType() == PlayerAnimationType.ARM_SWING && event.getPlayer().getInventory().getItemInHand().getTypeId() == this.getWandTypeId()) {
            if (!this.hasWandPermission(player)) {
                return;
            }
            PlayerInventory inventory = player.getInventory();
            org.bukkit.inventory.ItemStack[] contents = inventory.getContents();
            Spell spell = null;
            int i = 0;
            while (i < 9) {
                if (contents[i] != null && contents[i].getType() != Material.AIR && contents[i].getTypeId() != this.getWandTypeId() && (spell = this.getSpell(contents[i].getType(), player)) != null) break;
                ++i;
            }
            if (spell != null) {
                spell.cast();
            }
        }
    }

    public boolean cycleMaterials(Player player) {
        List<Material> buildingMaterials = this.getBuildingMaterials();
        PlayerInventory inventory = player.getInventory();
        org.bukkit.inventory.ItemStack[] contents = inventory.getContents();
        int firstMaterialSlot = 8;
        boolean foundAir = false;
        int i = 8;
        while (i >= 0) {
            Material mat;
            Material material = mat = contents[i] == null ? Material.AIR : contents[i].getType();
            if (mat == Material.AIR) {
                if (foundAir) break;
                foundAir = true;
                firstMaterialSlot = i;
            } else {
                if (!buildingMaterials.contains(mat)) break;
                firstMaterialSlot = i;
            }
            --i;
        }
        if (firstMaterialSlot == 8) {
            return false;
        }
        org.bukkit.inventory.ItemStack lastSlot = contents[8];
        int i2 = 7;
        while (i2 >= firstMaterialSlot) {
            contents[i2 + 1] = contents[i2];
            --i2;
        }
        contents[firstMaterialSlot] = lastSlot;
        inventory.setContents(contents);
        player.updateInventory();
        return true;
    }

    public void cycleSpells(Player player) {
        int numSpellSlots;
        PlayerInventory inventory = player.getInventory();
        org.bukkit.inventory.ItemStack[] contents = inventory.getContents();
        org.bukkit.inventory.ItemStack[] active = new org.bukkit.inventory.ItemStack[9];
        int i = 0;
        while (i < 9) {
            active[i] = contents[i];
            ++i;
        }
        int maxSpellSlot = 0;
        int firstSpellSlot = -1;
        int i2 = 0;
        while (i2 < 9) {
            boolean isEmpty = active[i2] == null;
            Material activeType = isEmpty ? Material.AIR : active[i2].getType();
            boolean isWand = activeType.getId() == this.getWandTypeId();
            boolean isSpell = false;
            if (activeType != Material.AIR) {
                Spell spell = this.getSpell(activeType, player);
                boolean bl = isSpell = spell != null;
            }
            if (isSpell) {
                if (firstSpellSlot < 0) {
                    firstSpellSlot = i2;
                }
                maxSpellSlot = i2;
            } else if (!isWand && firstSpellSlot >= 0) break;
            ++i2;
        }
        int n = numSpellSlots = firstSpellSlot < 0 ? 0 : maxSpellSlot - firstSpellSlot + 1;
        if (numSpellSlots < 2) {
            return;
        }
        int ddi = 0;
        while (ddi < numSpellSlots) {
            Material contentsType;
            int i3 = ddi + firstSpellSlot;
            Material material = contentsType = contents[i3] == null ? Material.AIR : active[i3].getType();
            if (contentsType.getId() != this.getWandTypeId()) {
                int di = 1;
                while (di < numSpellSlots) {
                    Material activeType;
                    int dni = (ddi + di) % numSpellSlots;
                    int ni = dni + firstSpellSlot;
                    Material material2 = activeType = active[ni] == null ? Material.AIR : active[ni].getType();
                    if (activeType.getId() != this.getWandTypeId()) {
                        contents[i3] = active[ni];
                        break;
                    }
                    ++di;
                }
            }
            ++ddi;
        }
        inventory.setContents(contents);
        player.updateInventory();
    }

    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            this.cancel(event.getPlayer());
            int materialId = event.getPlayer().getInventory().getItemInHand().getTypeId();
            Player player = event.getPlayer();
            if (!this.hasWandPermission(player)) {
                return;
            }
            boolean cycleSpells = false;
            cycleSpells = player.isSneaking();
            if (materialId == this.getWandTypeId()) {
                if (cycleSpells) {
                    if (!this.cycleMaterials(event.getPlayer())) {
                        this.cycleSpells(event.getPlayer());
                    }
                } else {
                    this.cycleSpells(event.getPlayer());
                }
            }
        }
    }

    public boolean allowPhysics(Block block) {
        if (this.physicsDisableTimeout == 0L) {
            return true;
        }
        if (System.currentTimeMillis() > this.physicsDisableTimeout) {
            this.physicsDisableTimeout = 0L;
        }
        return false;
    }

    public void disablePhysics(int interval) {
        this.physicsDisableTimeout = System.currentTimeMillis() + (long)interval;
    }

    public boolean hasWandPermission(Player player) {
        return this.hasPermission(player, "Magic.wand.use");
    }

    public boolean hasPermission(Player player, String pNode, boolean defaultValue) {
        PermissionHandler permissions = MagicPlugin.getPermissionHandler();
        if (permissions == null) {
            return defaultValue;
        }
        return permissions.has(player, pNode);
    }

    public boolean hasPermission(Player player, String pNode) {
        return this.hasPermission(player, pNode, true);
    }
}

