/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_14.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.entity.EntityExtraData;
import com.elmakers.mine.bukkit.utility.ConfigUtils;
import com.elmakers.mine.bukkit.utility.random.RandomUtils;
import java.util.Arrays;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;

public class EntityVillagerData
extends EntityExtraData {
    protected Villager.Profession profession;
    protected Villager.Type type;
    protected Integer level;
    protected Integer experience;
    protected boolean randomProfession;

    public EntityVillagerData(ConfigurationSection parameters, MageController controller) {
        String typeKey;
        String professionKey = parameters.getString("villager_profession");
        if (professionKey != null && !professionKey.isEmpty()) {
            if ((professionKey = professionKey.toUpperCase()).startsWith("RAND")) {
                this.randomProfession = true;
            } else {
                try {
                    this.profession = Villager.Profession.valueOf((String)professionKey);
                }
                catch (Exception ex) {
                    controller.getLogger().warning("Invalid villager_profession: " + professionKey);
                }
            }
        }
        if ((typeKey = parameters.getString("villager_type")) != null && !typeKey.isEmpty()) {
            typeKey = typeKey.toUpperCase();
            try {
                this.type = Villager.Type.valueOf((String)typeKey);
            }
            catch (Exception ex) {
                controller.getLogger().warning("Invalid villager_type: " + typeKey);
            }
        }
        this.level = ConfigUtils.getOptionalInteger(parameters, "villager_level");
        this.experience = ConfigUtils.getOptionalInteger(parameters, "villager_experience");
    }

    public EntityVillagerData(Entity entity) {
        if (!(entity instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)entity;
        this.profession = villager.getProfession();
        this.level = villager.getVillagerLevel();
        this.experience = villager.getVillagerExperience();
        this.type = villager.getVillagerType();
        this.randomProfession = false;
    }

    @Override
    public void apply(Entity entity) {
        if (!(entity instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)entity;
        if (this.randomProfession) {
            Villager.Profession profession = RandomUtils.getRandom(Arrays.asList(Villager.Profession.values()), 1);
            villager.setProfession(profession);
        } else if (this.profession != null) {
            villager.setProfession(this.profession);
        }
        if (this.level != null) {
            villager.setVillagerLevel(this.level.intValue());
        }
        if (this.experience != null) {
            villager.setVillagerExperience(this.experience.intValue());
        }
        if (this.type != null) {
            villager.setVillagerType(this.type);
        }
    }

    @Override
    public boolean cycle(Entity entity) {
        if (!this.canCycle(entity)) {
            return false;
        }
        Villager villager = (Villager)entity;
        Villager.Profession profession = villager.getProfession();
        Villager.Profession[] professionValues = Villager.Profession.values();
        int villagerOrdinal = (profession.ordinal() + 1) % professionValues.length;
        profession = professionValues[villagerOrdinal];
        villager.setProfession(profession);
        return true;
    }

    @Override
    public boolean canCycle(Entity entity) {
        return entity instanceof Villager;
    }
}

