/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicPropertyType;
import com.elmakers.mine.bukkit.magic.BaseMagicConfigurable;
import com.elmakers.mine.bukkit.magic.CasterProperties;
import com.elmakers.mine.bukkit.magic.TemplateProperties;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;

public abstract class TemplatedProperties
extends CasterProperties {
    @Nullable
    private TemplateProperties template;

    public TemplatedProperties(MagicPropertyType type, MageController controller) {
        this(type, controller, null);
    }

    public TemplatedProperties(MagicPropertyType type, MageController controller, @Nullable TemplateProperties template) {
        super(type, controller);
        this.template = template;
    }

    @Override
    @Nullable
    public ConfigurationSection getConfigurationSection(String key) {
        ConfigurationSection fromTemplate;
        ConfigurationSection own = super.getConfigurationSection(key);
        TemplateProperties template = this.getTemplate();
        ConfigurationSection configurationSection = fromTemplate = template == null ? null : template.getConfigurationSection(key);
        if (own == null) {
            return fromTemplate;
        }
        if (fromTemplate != null) {
            own = ConfigurationUtils.cloneConfiguration(own);
            own = ConfigurationUtils.overlayConfigurations(own, fromTemplate);
        }
        return own;
    }

    @Override
    protected void migrateProperty(String key, MagicPropertyType propertyType) {
        super.migrateProperty(key, propertyType, this.template);
    }

    @Override
    public boolean hasProperty(String key) {
        BaseMagicConfigurable storage = this.getStorage(key);
        if (storage != null) {
            return storage.hasOwnProperty(key);
        }
        return this.hasOwnProperty(key) || this.template != null && this.template.hasProperty(key);
    }

    public void setTemplate(@Nonnull TemplateProperties template) {
        this.template = template;
    }

    @Nullable
    protected TemplateProperties getTemplate() {
        return this.template;
    }

    @Nonnull
    public String getKey() {
        return this.template == null ? "?" : this.template.getKey();
    }

    @Override
    @Nullable
    public String getName() {
        TemplateProperties template = this.getTemplate();
        return template == null ? "?" : template.getName();
    }

    @Override
    public boolean hasOwnProperty(String key) {
        return super.hasOwnProperty(key) || this.template != null && this.template.hasOwnProperty(key);
    }

    @Override
    @Nonnull
    public ConfigurationSection getPropertyConfiguration(String key) {
        BaseMagicConfigurable storage = this.getStorage(key);
        if (storage != null && storage != this) {
            return storage.getPropertyConfiguration(key);
        }
        ConfigurationSection pathConfiguration = this.getPathPropertyConfiguration(key);
        if (pathConfiguration != null) {
            return pathConfiguration;
        }
        if (this.configuration.contains(key) || this.template == null) {
            return this.configuration;
        }
        return this.template.getConfiguration();
    }

    @Override
    public void clear() {
        super.clear();
        this.template = null;
    }

    @Override
    @Nullable
    public String getIconKey(String iconKey) {
        if (super.hasOwnProperty(iconKey)) {
            return this.getString(iconKey);
        }
        return super.getIconKey(iconKey);
    }

    @Override
    public boolean hasIconKey(String iconKey) {
        if (super.hasOwnProperty(iconKey)) {
            return true;
        }
        return super.hasIconKey(iconKey);
    }

    @Override
    public void describe(CommandSender sender, @Nullable Set<String> ignoreProperties) {
        if (this.template != null) {
            sender.sendMessage(ChatColor.GRAY + "Template: " + ChatColor.WHITE + this.template.getKey());
        }
        super.describe(sender, ignoreProperties);
    }
}

