/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.attributes.AttributeProvider;
import com.elmakers.mine.bukkit.api.batch.Batch;
import com.elmakers.mine.bukkit.api.batch.SpellBatch;
import com.elmakers.mine.bukkit.api.batch.UndoBatch;
import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.data.BrushData;
import com.elmakers.mine.bukkit.api.data.MageData;
import com.elmakers.mine.bukkit.api.data.SpellData;
import com.elmakers.mine.bukkit.api.data.UndoData;
import com.elmakers.mine.bukkit.api.economy.Currency;
import com.elmakers.mine.bukkit.api.effect.SoundEffect;
import com.elmakers.mine.bukkit.api.event.WandActivatedEvent;
import com.elmakers.mine.bukkit.api.event.WandDeactivatedEvent;
import com.elmakers.mine.bukkit.api.integration.ClientPlatform;
import com.elmakers.mine.bukkit.api.magic.CastSourceLocation;
import com.elmakers.mine.bukkit.api.magic.MagicAttribute;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.magic.ProgressionPath;
import com.elmakers.mine.bukkit.api.magic.Trigger;
import com.elmakers.mine.bukkit.api.rp.ResourcePackPreference;
import com.elmakers.mine.bukkit.api.spell.CastParameter;
import com.elmakers.mine.bukkit.api.spell.CastingCost;
import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellEventType;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.LostWand;
import com.elmakers.mine.bukkit.api.wand.WandAction;
import com.elmakers.mine.bukkit.api.wand.WandUpgradePath;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.block.UndoQueue;
import com.elmakers.mine.bukkit.boss.BossBarTracker;
import com.elmakers.mine.bukkit.economy.CustomCurrency;
import com.elmakers.mine.bukkit.effect.EffectPlayer;
import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.heroes.HeroesManager;
import com.elmakers.mine.bukkit.integration.VaultController;
import com.elmakers.mine.bukkit.item.AttributeOperation;
import com.elmakers.mine.bukkit.item.InventorySlot;
import com.elmakers.mine.bukkit.item.MagicAttributeModifier;
import com.elmakers.mine.bukkit.kit.MageKit;
import com.elmakers.mine.bukkit.magic.BaseMageModifier;
import com.elmakers.mine.bukkit.magic.CasterProperties;
import com.elmakers.mine.bukkit.magic.MageClass;
import com.elmakers.mine.bukkit.magic.MageClassTemplate;
import com.elmakers.mine.bukkit.magic.MageContext;
import com.elmakers.mine.bukkit.magic.MageConversation;
import com.elmakers.mine.bukkit.magic.MageModifier;
import com.elmakers.mine.bukkit.magic.MageProperties;
import com.elmakers.mine.bukkit.magic.MageTargeting;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.ModifierTemplate;
import com.elmakers.mine.bukkit.magic.TemplateProperties;
import com.elmakers.mine.bukkit.magic.TemplatedProperties;
import com.elmakers.mine.bukkit.materials.MaterialSets;
import com.elmakers.mine.bukkit.slikey.effectlib.util.VectorUtils;
import com.elmakers.mine.bukkit.spell.ActionSpell;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.spell.TriggeredSpell;
import com.elmakers.mine.bukkit.tasks.ArmorUpdatedTask;
import com.elmakers.mine.bukkit.tasks.CheckWandTask;
import com.elmakers.mine.bukkit.tasks.MageFinishLoadTask;
import com.elmakers.mine.bukkit.tasks.SendCurrencyMessageTask;
import com.elmakers.mine.bukkit.tasks.TeleportTask;
import com.elmakers.mine.bukkit.utility.ActionBarSender;
import com.elmakers.mine.bukkit.utility.BukkitMetadataUtils;
import com.elmakers.mine.bukkit.utility.CompatibilityConstants;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.CurrencyAmount;
import com.elmakers.mine.bukkit.utility.Messages;
import com.elmakers.mine.bukkit.utility.QueueSet;
import com.elmakers.mine.bukkit.utility.Replacer;
import com.elmakers.mine.bukkit.utility.TextUtils;
import com.elmakers.mine.bukkit.wand.ActiveWandSet;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandMode;
import com.elmakers.mine.bukkit.wand.WandProperties;
import com.elmakers.mine.bukkit.wand.WandSet;
import com.elmakers.mine.bukkit.wand.WandTemplate;
import com.google.common.base.Objects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.WorldBorder;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class Mage
implements CostReducer,
com.elmakers.mine.bukkit.api.magic.Mage,
Replacer,
ActionBarSender {
    protected static int AUTOMATA_ONLINE_TIMEOUT = 5000;
    public static int CHANGE_WORLD_EQUIP_COOLDOWN = 1000;
    public static int JUMP_EFFECT_FLIGHT_EXEMPTION_DURATION = 0;
    public static int OFFHAND_CAST_COOLDOWN = 500;
    public static int CURRENCY_MESSAGE_DELAY = 1000;
    public static int ACTION_BAR_QUEUE_INTERVAL = 3000;
    public static int ACTION_BAR_QUEUE_MAX_DEPTH = 20;
    public static boolean DEACTIVATE_WAND_ON_WORLD_CHANGE = false;
    public static boolean DEACTIVATE_WAND_ON_GAME_MODE_CHANGE = false;
    public static boolean REOPEN_WAND_ON_JOIN = true;
    public static boolean COMMAND_BLOCKS_SUPERPOWERED = true;
    public static boolean CONSOLE_SUPERPOWERED = true;
    public static boolean ALLOW_PERSISTENT_INVISIBILITY = true;
    public static boolean RP_DOWNLOADED = false;
    public static double MOVEMENT_SPEED_BPS = 43.0;
    public static String DEFAULT_CLASS = "";
    private static String defaultMageName = "Mage";
    public static CastSourceLocation DEFAULT_CAST_LOCATION = CastSourceLocation.MAINHAND;
    public static Vector DEFAULT_CAST_OFFSET = new Vector(0.5, -0.5, 0.0);
    public static double SNEAKING_CAST_OFFSET = -0.2;
    protected final String id;
    @Nonnull
    private final MageProperties properties;
    private final Map<String, MageClass> classes = new HashMap<String, MageClass>();
    private final Map<String, MageModifier> modifiers = new HashMap<String, MageModifier>();
    private final Map<String, MageModifier> transientModifiers = new HashMap<String, MageModifier>();
    private final Map<String, Double> attributes = new HashMap<String, Double>();
    private final Map<String, ActiveWandSet> wandSets = new HashMap<String, ActiveWandSet>();
    private ConfigurationSection variables;
    private final Map<String, List<TriggeredSpell>> triggers = new HashMap<String, List<TriggeredSpell>>();
    private final Set<String> triggeredSpells = new HashSet<String>();
    private final Set<String> triggeringSpells = new HashSet<String>();
    private final Map<String, Long> lastTriggers = new HashMap<String, Long>();
    private final Map<String, MageKit> kits = new HashMap<String, MageKit>();
    private final Map<String, CurrencyMessage> currencyMessages = new HashMap<String, CurrencyMessage>();
    private final QueueSet<String> actionBarQueue = new QueueSet();
    private long lastActionBarSend;
    protected ConfigurationSection data = ConfigurationUtils.newConfigurationSection();
    protected Map<String, SpellData> spellData = new HashMap<String, SpellData>();
    protected WeakReference<Player> playerRef;
    protected WeakReference<Entity> entityRef;
    protected WeakReference<CommandSender> commandSenderRef;
    protected boolean hasEntity;
    protected String playerName;
    protected final MagicController controller;
    protected WeakReference<CommandSender> debugger;
    protected HashMap<String, MageSpell> spells = new HashMap();
    private Wand activeWand = null;
    private Wand offhandWand = null;
    private MageClass activeClass = null;
    private boolean offhandCast = false;
    private Map<String, Wand> boundWands = new HashMap<String, Wand>();
    private final Collection<Listener> quitListeners = new HashSet<Listener>();
    private final Collection<Listener> deathListeners = new HashSet<Listener>();
    private final Collection<Listener> damageListeners = new HashSet<Listener>();
    private final Set<MageSpell> activeSpells = new HashSet<MageSpell>();
    private UndoQueue undoQueue = null;
    private Map<String, UndoData> externalUndoData = null;
    private Deque<Batch> pendingBatches = new ConcurrentLinkedDeque<Batch>();
    private boolean loading = false;
    private boolean unloading = false;
    private int debugLevel = 0;
    private boolean quiet = false;
    private boolean ignoreParticles = false;
    private EntityData entityData;
    private long lastTick;
    private boolean isSwingingArm;
    private Location lastLocation;
    private Vector velocity = new Vector();
    private long lastBlockTime;
    private long lastReflectTime;
    private long ignoreItemActivationUntil = 0L;
    private boolean forget = false;
    private long disableWandOpenUntil = 0L;
    private long created;
    private MageContext effectContext = null;
    private BossBarTracker bossBar = null;
    private Map<Player, MageConversation> conversations = new WeakHashMap<Player, MageConversation>();
    private MageTargeting targeting;
    private WeakReference<Entity> lastDamageSource;
    private WeakReference<Entity> lastDamageTarget;
    private Block lastBlockBroken;
    private Map<PotionEffectType, Integer> effectivePotionEffects = new HashMap<PotionEffectType, Integer>();
    private Map<String, Double> protection = new HashMap<String, Double>();
    private Map<String, Double> weakness = new HashMap<String, Double>();
    private Map<String, Double> strength = new HashMap<String, Double>();
    private Map<String, List<CastParameter>> castOverrides = new HashMap<String, List<CastParameter>>();
    private float costReduction = 0.0f;
    private float cooldownReduction = 0.0f;
    private float consumeReduction = 0.0f;
    private boolean cooldownFree = false;
    private boolean costFree = false;
    private boolean consumeFree = false;
    private float powerMultiplier = 1.0f;
    private float spEarnMultiplier = 1.0f;
    private float manaMaxBoost = 0.0f;
    private float manaRegenerationBoost = 0.0f;
    private double healthScale = 0.0;
    private boolean costFreeOverride = false;
    private boolean cooldownFreeOverride = false;
    private ResourcePackPreference resourcePackPreference = ResourcePackPreference.DEFAULT;
    private String preferredResourcePack = null;
    private boolean hasResourcePack = false;
    protected boolean isVanished = false;
    protected long superProtectionExpiration = 0L;
    protected boolean superProtected;
    protected boolean superPowered;
    protected boolean ignoredByMobs;
    private boolean isInAir = false;
    private boolean isBlocking = false;
    private double lastFallDistance;
    private float manaPerDamage;
    private Map<InventorySlot, Wand> activeArmor = new HashMap<InventorySlot, Wand>();
    private Location location;
    private long cooldownExpiration = 0L;
    private float magePowerBonus = 0.0f;
    private long lastClick = 0L;
    private long lastCast = 0L;
    private long lastOffhandCast = 0L;
    private long blockPlaceTimeout = 0L;
    private Location lastDeathLocation = null;
    private final com.elmakers.mine.bukkit.block.MaterialBrush brush;
    private ItemStack lastHeldItem;
    private long fallProtection = 0L;
    private long fallProtectionCount = 1L;
    private BaseSpell fallingSpell = null;
    private Spell lastSpellCast = null;
    private boolean isAutomaton = false;
    private boolean allowContainerCopy = false;
    private boolean preventDismount = false;
    private boolean shownHelp = false;
    private boolean gaveWelcomeWand = false;
    private GUIAction gui = null;
    private boolean isNPC = false;
    private List<ItemStack> respawnItems;
    private Map<Integer, ItemStack> respawnInventory;
    private Map<Integer, ItemStack> respawnArmor;
    private List<ItemStack> restoreInventory;
    private boolean restoreOpenWand;
    private Float restoreExperience;
    private Integer restoreLevel;
    private boolean virtualExperience = false;
    private float virtualExperienceProgress = 0.0f;
    private int virtualExperienceLevel = 0;
    private boolean glidingAllowed = false;
    private Set<String> tags = new HashSet<String>();
    private String destinationWarp;
    private Integer lastActivatedSlot;
    private String currentDamageType;
    private String lastDamageType;
    private String currentDamageDealtType;
    private String lastDamageDealtType;
    private boolean launchingProjectile;
    private double lastDamage;
    private double lastDamageDealt;
    private double lastBowPull;
    private ItemStack lastBowUsed;
    private boolean cancelLaunch = false;
    private EntityType lastProjectileType;
    private boolean bypassEnabled;
    private long portalsDisabledUntil;
    private float blockFOV = 0.0f;
    private float blockChance = 0.0f;
    private float blockReflectChance = 0.0f;
    private int blockMageCooldown = 0;
    private int blockCooldown = 0;
    private int reflectCooldown = 0;
    private float reflectFOV;
    private float reflectChance;

    public Mage(String id, MagicController controller) {
        this.id = id;
        this.controller = controller;
        this.brush = new com.elmakers.mine.bukkit.block.MaterialBrush((com.elmakers.mine.bukkit.api.magic.Mage)this, Material.DIRT, 0);
        this.properties = new MageProperties(this);
        this.playerRef = new WeakReference<Object>(null);
        this.entityRef = new WeakReference<Object>(null);
        this.commandSenderRef = new WeakReference<Object>(null);
        this.hasEntity = false;
        this.created = System.currentTimeMillis();
    }

    @Override
    public boolean hasStoredInventory() {
        return this.activeWand != null && this.activeWand.hasStoredInventory();
    }

    @Override
    public Set<Spell> getActiveSpells() {
        return new HashSet<Spell>(this.activeSpells);
    }

    @Nullable
    public Inventory getStoredInventory() {
        return this.activeWand != null ? this.activeWand.getStoredInventory() : null;
    }

    @Override
    public void setLocation(Location location) {
        LivingEntity entity = this.getLivingEntity();
        if (entity != null && location != null) {
            entity.teleport(location);
            return;
        }
        this.location = location;
    }

    public void setLocation(Location location, boolean direction) {
        if (!direction) {
            if (this.location == null) {
                this.location = location;
            } else {
                this.location.setX(location.getX());
                this.location.setY(location.getY());
                this.location.setZ(location.getZ());
                this.location.setWorld(location.getWorld());
            }
        } else {
            this.location = location;
        }
    }

    public void clearCache() {
        if (this.brush != null) {
            this.brush.clearSchematic();
        }
    }

    @Override
    public void setCostFree(boolean free) {
        this.costFreeOverride = free;
    }

    @Override
    public void setCooldownFree(boolean free) {
        this.cooldownFreeOverride = free;
    }

    @Override
    public void setPowerMultiplier(float multiplier) {
        this.powerMultiplier = multiplier;
    }

    @Override
    public float getPowerMultiplier() {
        return this.powerMultiplier;
    }

    public boolean usesMana() {
        return this.activeWand == null ? false : this.activeWand.usesMana();
    }

    @Override
    public boolean addToStoredInventory(ItemStack item) {
        return this.activeWand == null ? false : this.activeWand.addToStoredInventory(item);
    }

    public boolean cancelSelection() {
        boolean result = false;
        if (!this.activeSpells.isEmpty()) {
            ArrayList<MageSpell> active = new ArrayList<MageSpell>(this.activeSpells);
            for (MageSpell spell : active) {
                result = spell.cancelSelection() || result;
            }
        }
        return result;
    }

    public void onPlayerQuit(PlayerEvent event) {
        Player player = this.getPlayer();
        if (player == null || player != event.getPlayer()) {
            return;
        }
        ArrayList<Listener> active = new ArrayList<Listener>(this.quitListeners);
        for (Listener listener : active) {
            this.callEvent(listener, (Event)event);
        }
        EffectPlayer.ignorePlayer(player, false);
    }

    public void onPlayerDeath(EntityDeathEvent event) {
        Player player = this.getPlayer();
        if (!player.hasMetadata("arena")) {
            this.lastDeathLocation = player.getLocation();
        }
        ArrayList<Listener> active = new ArrayList<Listener>(this.deathListeners);
        for (Listener listener : active) {
            this.callEvent(listener, (Event)event);
        }
    }

    public void onDeath(EntityDeathEvent event) {
        Player player;
        Iterator<Batch> iterator = this.pendingBatches.iterator();
        while (iterator.hasNext()) {
            SpellBatch spellBatch;
            Spell spell;
            Batch batch = iterator.next();
            if (!(batch instanceof SpellBatch) || !(spell = (spellBatch = (SpellBatch)batch).getSpell()).cancelOnDeath()) continue;
            batch.cancel();
            iterator.remove();
        }
        if (this.getEntity() == event.getEntity()) {
            this.trigger("death");
        }
        if ((player = this.getPlayer()) != null && player == event.getEntity()) {
            this.onPlayerDeath(event);
            return;
        }
        if (this.effectContext != null) {
            this.effectContext.cancelEffects();
            this.effectContext = null;
        }
        this.removed();
    }

    public void onCombust(EntityCombustEvent event) {
        if (this.getProtection("fire") >= 1.0 || this.isSuperProtected()) {
            event.getEntity().setFireTicks(0);
            event.setCancelled(true);
        }
    }

    protected void callEvent(Listener listener, Event event) {
        for (Method method : listener.getClass().getMethods()) {
            Class<?>[] parameters;
            if (!method.isAnnotationPresent(EventHandler.class) || (parameters = method.getParameterTypes()).length != 1 || !parameters[0].isAssignableFrom(event.getClass())) continue;
            try {
                method.invoke((Object)listener, event);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void setTarget(Entity target) {
        if (!this.canTarget(target)) {
            return;
        }
        LivingEntity li = this.getLivingEntity();
        if (li != null && li instanceof Creature && target instanceof LivingEntity) {
            Creature creature = (Creature)li;
            if (creature.getTarget() != target) {
                this.sendDebugMessage("Now targeting " + target.getName(), 6);
            }
            creature.setTarget((LivingEntity)target);
        }
    }

    @Override
    @Nullable
    public Collection<Entity> getDamagers() {
        return this.targeting == null ? null : this.targeting.getDamagers();
    }

    @Override
    @Nullable
    public Entity getLastDamager() {
        return this.lastDamageSource == null ? null : (Entity)this.lastDamageSource.get();
    }

    @Override
    @Nullable
    public Entity getLastDamageTarget() {
        return this.lastDamageTarget == null ? null : (Entity)this.lastDamageTarget.get();
    }

    @Override
    @Nullable
    public Entity getTopDamager() {
        return this.targeting == null ? null : this.targeting.getTopDamager();
    }

    public boolean canTarget(Entity entity) {
        return this.entityData != null ? this.entityData.canTarget(entity) : true;
    }

    @Override
    public void damagedBy(@Nonnull Entity initialDamager, double damage) {
        this.lastDamage = damage;
        Entity damager = this.controller.getDamageSource(initialDamager);
        if (damager == null || damager == this.getEntity()) {
            return;
        }
        if (this.targeting != null) {
            this.targeting.damagedBy(damager, damage);
        }
        this.lastDamageSource = new WeakReference<Entity>(damager);
    }

    public void onDamageDealt(EntityDamageEvent event) {
        boolean isMelee;
        String damageType = this.currentDamageDealtType;
        this.lastDamageTarget = new WeakReference<Entity>(event.getEntity());
        this.lastDamageDealt = event.getFinalDamage();
        this.currentDamageDealtType = null;
        this.lastDamageDealtType = this.getDamageType(damageType, event.getCause());
        this.trigger("damage_dealt");
        boolean bl = isMelee = event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK && !CompatibilityLib.getCompatibilityUtils().isDamaging();
        if (isMelee) {
            float damage = (float)event.getFinalDamage();
            this.processMeleeDamage(damage);
        }
    }

    protected void processMeleeDamage(float damage) {
        this.playEffects("hit_entity");
        if (this.manaPerDamage > 0.0f) {
            int manaMax = this.getEffectiveManaMax();
            float mana = this.getMana();
            if (manaMax > 0 && mana < (float)manaMax) {
                this.setMana(Math.min((float)manaMax, mana + damage * this.manaPerDamage));
                this.updateMana();
            }
        }
    }

    public void playEffects(String effects) {
        if (this.activeWand != null) {
            this.activeWand.playEffects(effects);
        }
        if (this.offhandWand != null) {
            this.offhandWand.playEffects(effects);
        }
        for (Wand armorWand : this.activeArmor.values()) {
            armorWand.playEffects(effects);
        }
    }

    public void onBlockBroken(Block block) {
        this.lastBlockBroken = block;
        this.trigger("block_broken");
    }

    @Override
    @Nullable
    public Block getLastBlockBroken() {
        return this.lastBlockBroken;
    }

    private String getDamageType(String damageType, EntityDamageEvent.DamageCause cause) {
        if (damageType == null) {
            switch (cause) {
                case CONTACT: 
                case ENTITY_ATTACK: {
                    damageType = "physical";
                    break;
                }
                case FIRE: 
                case FIRE_TICK: 
                case LAVA: {
                    damageType = "fire";
                    break;
                }
                case BLOCK_EXPLOSION: 
                case ENTITY_EXPLOSION: {
                    damageType = "explosion";
                    break;
                }
                default: {
                    damageType = cause.name().toLowerCase();
                }
            }
        }
        return damageType;
    }

    public void onDamage(EntityDamageEvent event) {
        double damageReductionFire;
        double defendMultiplier;
        EntityDamageEvent.DamageCause cause;
        String damageType = this.currentDamageType;
        this.currentDamageType = null;
        this.lastDamage = event.getDamage();
        LivingEntity entity = this.getLivingEntity();
        if (entity == null) {
            return;
        }
        ArrayList<Listener> damageSpells = new ArrayList<Listener>(this.damageListeners);
        for (Listener listener : damageSpells) {
            this.callEvent(listener, (Event)event);
            if (!event.isCancelled()) continue;
            break;
        }
        if ((cause = event.getCause()) == EntityDamageEvent.DamageCause.FALL) {
            if (this.fallProtectionCount > 0L && this.fallProtection > 0L && this.fallProtection > System.currentTimeMillis()) {
                event.setCancelled(true);
                --this.fallProtectionCount;
                if (this.fallingSpell != null) {
                    double scale = 1.0;
                    LivingEntity li = this.getLivingEntity();
                    if (li != null) {
                        scale = event.getDamage() / CompatibilityLib.getCompatibilityUtils().getMaxHealth((Damageable)li);
                    }
                    this.fallingSpell.playEffects("land", (float)scale, this.getLocation().getBlock().getRelative(BlockFace.DOWN));
                }
                if (this.fallProtectionCount <= 0L) {
                    this.fallProtection = 0L;
                    this.fallingSpell = null;
                }
                return;
            }
            this.fallingSpell = null;
        }
        if (this.isSuperProtected()) {
            event.setCancelled(true);
            if (entity.getFireTicks() > 0) {
                entity.setFireTicks(0);
            }
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        double reduction = 0.0;
        Double overallProtection = this.protection.get("overall");
        if (overallProtection != null) {
            reduction = overallProtection * this.controller.getMaxDamageReduction("overall");
        }
        double multiplier = 1.0;
        Double overallWeakness = this.weakness.get("overall");
        if (overallWeakness != null && overallWeakness > 0.0 && (defendMultiplier = this.controller.getMaxDefendMultiplier("overall")) > 1.0) {
            defendMultiplier = 1.0 + (defendMultiplier - 1.0) * overallWeakness;
            multiplier *= defendMultiplier;
        }
        if (cause == EntityDamageEvent.DamageCause.FIRE_TICK && (damageReductionFire = this.getProtection("fire")) >= 1.0 && entity.getFireTicks() > 0) {
            entity.setFireTicks(0);
        }
        damageType = this.lastDamageType = this.getDamageType(damageType, cause);
        this.trigger("damage");
        double protection = this.getProtection(damageType);
        double maxReduction = this.controller.getMaxDamageReduction(damageType);
        reduction += protection * maxReduction;
        if (reduction >= 1.0) {
            event.setCancelled(true);
            this.sendDebugMessage(ChatColor.RED + "Damage nullified by " + ChatColor.BLUE + damageType + " (" + cause + ")", 8);
            return;
        }
        double damage = event.getDamage();
        this.sendDebugMessage(ChatColor.RED + "Damaged by " + ChatColor.BLUE + (damageType == null ? "generic" : damageType) + " (" + cause + ")" + ChatColor.RED + " for " + ChatColor.DARK_RED + damage, 10);
        if (reduction > 0.0) {
            damage = (1.0 - reduction) * damage;
            this.sendDebugMessage(ChatColor.DARK_RED + "Damage type " + ChatColor.BLUE + damageType + " reduced by " + ChatColor.AQUA + reduction + ChatColor.DARK_RED + " to " + ChatColor.RED + damage, 9);
            event.setDamage(damage);
        }
        double weakness = this.getWeakness(damageType);
        double maxMultiplier = this.controller.getMaxDefendMultiplier(damageType);
        if (maxMultiplier > 1.0 && weakness > 0.0) {
            weakness = 1.0 + (maxMultiplier - 1.0) * weakness;
            multiplier *= weakness;
        }
        if (multiplier > 1.0) {
            damage = multiplier * damage;
            this.sendDebugMessage(ChatColor.DARK_RED + "Damage type " + ChatColor.BLUE + damageType + " multiplied by " + ChatColor.AQUA + multiplier + ChatColor.DARK_RED + " to " + ChatColor.RED + damage, 9);
            event.setDamage(damage);
        }
        if (damage > 0.0) {
            Iterator<Batch> iterator = this.pendingBatches.iterator();
            while (iterator.hasNext()) {
                SpellBatch spellBatch;
                Spell spell;
                double cancelOnDamage;
                Batch batch = iterator.next();
                if (!(batch instanceof SpellBatch) || !((cancelOnDamage = (spell = (spellBatch = (SpellBatch)batch).getSpell()).cancelOnDamage()) > 0.0) || !(cancelOnDamage < damage)) continue;
                batch.cancel();
                iterator.remove();
            }
            for (MageSpell spell : this.activeSpells) {
                double cancelOnDamage = spell.cancelOnDamage();
                if (!(cancelOnDamage > 0.0) || !(cancelOnDamage < damage)) continue;
                spell.cancel();
            }
        }
    }

    public double getProtection(String damageType) {
        Double value = this.protection.get(damageType);
        return value == null ? 0.0 : value;
    }

    public double getWeakness(String damageType) {
        Double value = this.weakness.get(damageType);
        return value == null ? 0.0 : value;
    }

    @Override
    public void unbindAll() {
        this.boundWands.clear();
    }

    @Override
    public void unbind(com.elmakers.mine.bukkit.api.wand.Wand wand) {
        this.unbind(wand.getTemplateKey());
    }

    @Override
    public boolean unbind(String template) {
        if (template != null) {
            return this.boundWands.remove(template) != null;
        }
        return false;
    }

    public void checkActiveSpells(Wand wand) {
        Iterator<Batch> iterator = this.pendingBatches.iterator();
        while (iterator.hasNext()) {
            SpellBatch spellBatch;
            Spell spell;
            Batch batch = iterator.next();
            if (!(batch instanceof SpellBatch) || !(spell = (spellBatch = (SpellBatch)batch).getSpell()).cancelOnNoWand() || spell.getCurrentCast().getWand() != wand) continue;
            batch.cancel();
            iterator.remove();
        }
        if (this.activeSpells.isEmpty()) {
            return;
        }
        ArrayList<MageSpell> active = new ArrayList<MageSpell>(this.activeSpells);
        for (MageSpell spell : active) {
            if (!spell.cancelOnNoWand() || spell.getCurrentCast().getWand() != wand) continue;
            spell.deactivate();
        }
    }

    protected void deactivateWand() {
        if (this.activeWand != null) {
            this.activeWand.deactivate();
        }
    }

    public void deactivateWand(Wand wand) {
        if (wand == null) {
            return;
        }
        if (wand == this.activeWand) {
            this.checkActiveSpells(this.activeWand);
            this.setActiveWand(null);
        }
        if (wand == this.offhandWand) {
            this.checkActiveSpells(this.activeWand);
            this.setOffhandWand(null);
        }
        WandDeactivatedEvent event = new WandDeactivatedEvent(this, wand);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public void onTeleport(PlayerTeleportEvent event) {
        Iterator<Batch> iterator = this.pendingBatches.iterator();
        while (iterator.hasNext()) {
            SpellBatch spellBatch;
            Spell spell;
            Batch batch = iterator.next();
            if (!(batch instanceof SpellBatch) || !(spell = (spellBatch = (SpellBatch)batch).getSpell()).cancelOnWorldChange()) continue;
            batch.cancel();
            iterator.remove();
        }
        if (DEACTIVATE_WAND_ON_WORLD_CHANGE) {
            Location from = event.getFrom();
            Location to = event.getTo();
            if (from.getWorld().equals(to.getWorld())) {
                return;
            }
            this.deactivateWand();
            this.checkWandNextTick();
        }
    }

    public void onChangeWorld() {
        this.checkWandNextTick(true);
        if (CHANGE_WORLD_EQUIP_COOLDOWN > 0) {
            this.ignoreItemActivationUntil = System.currentTimeMillis() + (long)CHANGE_WORLD_EQUIP_COOLDOWN;
        }
    }

    public void onGameModeChange(GameMode oldGameMode, GameMode newGameMode) {
        if (DEACTIVATE_WAND_ON_GAME_MODE_CHANGE || newGameMode == GameMode.CREATIVE || oldGameMode == GameMode.CREATIVE) {
            this.deactivateWand();
            this.checkWandNextTick();
        }
    }

    public void activateIcon(Wand activeWand, ItemStack icon) {
        if (System.currentTimeMillis() < this.ignoreItemActivationUntil) {
            return;
        }
        if (icon != null && icon.getType() != Material.AIR) {
            MageSpell spell = this.getSpell(Wand.getSpell(icon));
            if (spell != null) {
                boolean isQuickCast = spell.isQuickCast() && !activeWand.isQuickCastDisabled();
                boolean bl = isQuickCast = isQuickCast || activeWand.getMode() == WandMode.CHEST && activeWand.isQuickCast();
                if (spell.isPassive()) {
                    this.toggleSpellEnabled(spell);
                } else if (isQuickCast) {
                    activeWand.cast(spell);
                } else {
                    activeWand.setActiveSpell(spell.getKey());
                }
            } else if (Wand.isBrush(icon)) {
                activeWand.setActiveBrush(icon);
            }
        } else {
            activeWand.setActiveSpell("");
        }
        CompatibilityLib.getDeprecatedUtils().updateInventory(this.getPlayer());
    }

    public void setActiveWand(Wand activeWand) {
        if (this.activeWand != null && this.activeWand.isBound()) {
            this.addBound(this.activeWand);
        }
        if (this.activeWand == activeWand) {
            return;
        }
        this.activeWand = activeWand;
        if (activeWand != null && activeWand.isBound() && activeWand.canUse(this.getPlayer())) {
            this.addBound(activeWand);
        }
        this.blockPlaceTimeout = System.currentTimeMillis() + 200L;
        this.updatePassiveEffects();
        if (activeWand != null && !this.isLoading()) {
            WandActivatedEvent activatedEvent = new WandActivatedEvent(this, activeWand);
            Bukkit.getPluginManager().callEvent((Event)activatedEvent);
        }
    }

    public void setOffhandWand(Wand offhandWand) {
        if (this.offhandWand == offhandWand) {
            return;
        }
        if (offhandWand != null && !offhandWand.allowOffhand()) {
            return;
        }
        this.offhandWand = offhandWand;
        if (offhandWand != null && offhandWand.isBound() && offhandWand.canUse(this.getPlayer())) {
            this.addBound(offhandWand);
        }
        this.blockPlaceTimeout = System.currentTimeMillis() + 200L;
        this.updatePassiveEffects();
        if (offhandWand != null && !this.isLoading()) {
            WandActivatedEvent activatedEvent = new WandActivatedEvent(this, offhandWand);
            Bukkit.getPluginManager().callEvent((Event)activatedEvent);
        }
    }

    @Override
    public boolean tryToOwn(com.elmakers.mine.bukkit.api.wand.Wand wand) {
        if (this.isPlayer() && wand instanceof Wand && ((Wand)wand).tryToOwn(this.getPlayer())) {
            this.addBound((Wand)wand);
            return true;
        }
        return false;
    }

    protected void addBound(Wand wand) {
        String templateKey;
        WandTemplate template = wand.getTemplate();
        if (template != null && template.isRestorable() && (templateKey = template.getKey()) != null && !templateKey.isEmpty()) {
            this.boundWands.put(templateKey, (Wand)wand.duplicate());
        }
    }

    public long getBlockPlaceTimeout() {
        return this.blockPlaceTimeout;
    }

    @Override
    public void castMessage(String message) {
        if (!this.controller.showCastMessages()) {
            return;
        }
        this.sendMessage(this.controller.getCastMessagePrefix(), message);
    }

    @Override
    public void sendMessage(String message) {
        this.sendMessage(this.controller.getMessagePrefix(), message);
    }

    public void sendMessage(String prefix, String message) {
        if (message == null || message.length() == 0 || this.quiet || !this.controller.showMessages()) {
            return;
        }
        TextUtils.sendMessage(this.getCommandSender(), this.getPlayer(), prefix, message, this);
    }

    public void clearBuildingMaterial() {
        this.brush.setMaterial(this.controller.getDefaultMaterial(), (short)1);
    }

    @Override
    public void playSoundEffect(SoundEffect soundEffect) {
        if (!this.controller.soundsEnabled() || soundEffect == null) {
            return;
        }
        soundEffect.play(this.controller.getPlugin(), (Logger)this.controller.getLogger(), this.getEntity());
    }

    @Override
    public UndoQueue getUndoQueue() {
        if (this.undoQueue == null) {
            this.undoQueue = new UndoQueue(this);
            this.undoQueue.setMaxSize(this.controller.getUndoQueueDepth());
        }
        return this.undoQueue;
    }

    @Override
    @Nullable
    public UndoList getLastUndoList() {
        if (this.undoQueue == null || this.undoQueue.isEmpty()) {
            return null;
        }
        return this.undoQueue.getLast();
    }

    @Override
    public boolean prepareForUndo(UndoList undoList) {
        if (undoList == null) {
            return false;
        }
        if (undoList.bypass()) {
            return false;
        }
        UndoQueue queue = this.getUndoQueue();
        queue.add(undoList);
        return true;
    }

    @Override
    public boolean registerForUndo(UndoList undoList) {
        if (!this.prepareForUndo(undoList)) {
            return false;
        }
        int autoUndo = this.controller.getAutoUndoInterval();
        if (autoUndo > 0 && undoList.getScheduledUndo() == 0) {
            undoList.setScheduleUndo(autoUndo);
        } else {
            undoList.updateScheduledUndo();
        }
        if (!undoList.hasBeenScheduled() && undoList.isScheduled()) {
            if (undoList.hasChanges()) {
                this.controller.scheduleUndo(undoList);
            } else {
                this.undoQueue.skippedUndo(undoList);
            }
        }
        return true;
    }

    @Override
    public void addUndoBatch(UndoBatch batch) {
        this.pendingBatches.addLast(batch);
        this.controller.addPending(this);
    }

    protected void setPlayer(Player player) {
        if (player != null) {
            this.playerName = player.getName();
            this.playerRef = new WeakReference<Player>(player);
            this.entityRef = new WeakReference<Player>(player);
            this.commandSenderRef = new WeakReference<Player>(player);
            this.hasEntity = true;
        } else {
            this.playerRef.clear();
            this.entityRef.clear();
            this.commandSenderRef.clear();
            this.hasEntity = false;
        }
    }

    protected void setEntity(Entity entity) {
        if (entity != null) {
            LivingEntity li;
            String customName;
            this.playerName = entity.getType().name().toLowerCase().replace("_", " ");
            if (entity instanceof LivingEntity && (customName = (li = (LivingEntity)entity).getCustomName()) != null && customName.length() > 0) {
                this.playerName = customName;
            }
            if (entity instanceof Player && !ALLOW_PERSISTENT_INVISIBILITY) {
                CompatibilityLib.getCompatibilityUtils().setPersistentInvisible(entity, false);
            }
            this.entityRef = new WeakReference<Entity>(entity);
            this.hasEntity = true;
            this.isNPC = this.controller.isNPC(entity);
        } else {
            this.entityRef.clear();
            this.hasEntity = false;
            this.isNPC = false;
        }
    }

    protected void setCommandSender(CommandSender sender) {
        if (sender != null) {
            this.commandSenderRef = new WeakReference<CommandSender>(sender);
            if (sender instanceof BlockCommandSender) {
                BlockCommandSender commandBlock = (BlockCommandSender)sender;
                this.playerName = commandBlock.getName();
                Location location = this.getLocation();
                if (location == null) {
                    location = commandBlock.getBlock().getLocation();
                } else {
                    Location blockLocation = commandBlock.getBlock().getLocation();
                    location.setX(blockLocation.getX());
                    location.setY(blockLocation.getY());
                    location.setZ(blockLocation.getZ());
                    location.setWorld(blockLocation.getWorld());
                }
                this.setLocation(location, false);
            } else {
                this.setLocation(null);
            }
        } else {
            this.commandSenderRef.clear();
            this.setLocation(null);
        }
    }

    public void onLoad(MageData data) {
        try {
            Player player;
            Collection<SpellData> spellDataList;
            ArrayList<SpellData> activeSpells = new ArrayList<SpellData>();
            Collection<SpellData> collection = spellDataList = data == null ? null : data.getSpellData();
            if (spellDataList != null) {
                for (SpellData spellData : spellDataList) {
                    if (spellData.isActive()) {
                        activeSpells.add(spellData);
                    }
                    this.spellData.put(spellData.getKey().getKey(), spellData);
                }
            }
            if ((player = this.getPlayer()) != null) {
                this.discoverRecipes(this.controller.getAutoDiscoverRecipeKeys());
                if (this.controller.isInventoryBackupEnabled()) {
                    if (this.restoreInventory != null) {
                        this.controller.getLogger().info("Restoring saved inventory for player " + player.getName() + " - did the server not shut down properly?");
                        if (this.activeWand != null) {
                            this.activeWand.deactivate();
                        }
                        PlayerInventory inventory = player.getInventory();
                        for (int slot = 0; slot < this.restoreInventory.size(); ++slot) {
                            ItemStack item = this.restoreInventory.get(slot);
                            if (item instanceof ItemStack) {
                                inventory.setItem(slot, item);
                                continue;
                            }
                            inventory.setItem(slot, null);
                        }
                        this.restoreInventory = null;
                    }
                    if (this.restoreExperience != null) {
                        player.setExp(this.restoreExperience.floatValue());
                        this.restoreExperience = null;
                    }
                    if (this.restoreLevel != null) {
                        player.setLevel(this.restoreLevel.intValue());
                        this.restoreLevel = null;
                    }
                }
                if (this.activeWand == null) {
                    String welcomeWand = this.controller.getWelcomeWand();
                    if (!this.gaveWelcomeWand && welcomeWand.length() > 0) {
                        this.gaveWelcomeWand = true;
                        Wand wand = Wand.createWand(this.controller, welcomeWand);
                        if (wand != null) {
                            wand.takeOwnership(player);
                            this.giveItem(wand.getItem());
                            this.controller.getLogger().info("Gave welcome wand " + wand.getName() + " to " + player.getName());
                        } else {
                            this.controller.getLogger().warning("Unable to give welcome wand '" + welcomeWand + "' to " + player.getName());
                        }
                    }
                }
                if (!player.isDead()) {
                    this.restoreRespawnInventories();
                }
                if (!this.shownHelp && player.hasPermission("magic.notify") && player.hasPermission("magic.commands.mhelp")) {
                    this.sendMessage(this.controller.getMessages().get("commands.mhelp.prompt"));
                }
            }
            this.loading = false;
            this.checkWand();
            if (this.activeWand != null && this.restoreOpenWand && !this.activeWand.isInventoryOpen() && REOPEN_WAND_ON_JOIN) {
                this.activeWand.openInventory();
            }
            this.restoreOpenWand = false;
            this.getActiveClass();
            this.armorUpdated();
            for (SpellData activeData : activeSpells) {
                MageSpell spell = this.getSpell(activeData.getKey().getKey());
                if (spell == null) continue;
                spell.reactivate();
            }
            this.trigger("join");
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.WARNING, "Error finalizing player data for " + this.playerName, ex);
        }
        this.controller.finalizeMageLoad(this);
    }

    protected void finishLoad(MageData data) {
        MageFinishLoadTask loadTask = new MageFinishLoadTask(this, data);
        Bukkit.getScheduler().scheduleSyncDelayedTask(this.controller.getPlugin(), (Runnable)loadTask, 1L);
    }

    @Override
    public boolean load(MageData data) {
        try {
            boolean bl;
            if (data == null) {
                this.finishLoad(data);
                return true;
            }
            this.data = data.getExtraData();
            this.properties.load(data.getProperties());
            this.properties.loadProperties();
            this.variables = data.getVariables();
            this.loadKits(data.getKits());
            this.shownHelp = data.getShownHelp();
            this.boundWands.clear();
            Map<String, ItemStack> boundWandItems = data.getBoundWands();
            if (boundWandItems != null) {
                for (ItemStack boundWandItem : boundWandItems.values()) {
                    try {
                        Wand wand = this.controller.getWand(boundWandItem);
                        String string = wand.getTemplateKey();
                        if (string != null && !string.isEmpty()) {
                            this.boundWands.put(string, wand);
                            continue;
                        }
                        this.controller.info("Failed to load bound wand for " + this.playerName + ", wand has no template assigned");
                    }
                    catch (Exception exception) {
                        this.controller.getLogger().log(Level.WARNING, "Failed to load bound wand for " + this.playerName + ": " + boundWandItem, exception);
                    }
                }
            }
            this.classes.clear();
            Map<String, ConfigurationSection> classProperties = data.getClassProperties();
            for (Map.Entry entry : classProperties.entrySet()) {
                String string = (String)entry.getKey();
                MageClassTemplate classTemplate = this.controller.getMageClass(string);
                MageClass newClass = new MageClass(this, classTemplate);
                newClass.load((ConfigurationSection)entry.getValue());
                this.classes.put(string, newClass);
            }
            this.transientModifiers.clear();
            Map<String, ConfigurationSection> modifierProperties = data.getModifierProperties();
            for (Map.Entry<String, ConfigurationSection> entry : modifierProperties.entrySet()) {
                String modifierKey = entry.getKey();
                ModifierTemplate template = this.controller.getModifierTemplate(modifierKey);
                if (template == null) continue;
                MageModifier newModifier = new MageModifier(this, template);
                newModifier.load(entry.getValue());
                this.transientModifiers.put(modifierKey, newModifier);
            }
            HashSet<String> hashSet = new HashSet<String>();
            boolean bl2 = false;
            while (!bl) {
                ArrayList<MageClass> mageClasses = new ArrayList<MageClass>(this.classes.values());
                for (MageClass mageClass : mageClasses) {
                    if (hashSet.contains(mageClass.getKey())) continue;
                    hashSet.add(mageClass.getKey());
                    this.assignParent(mageClass);
                }
                bl = hashSet.containsAll(this.classes.keySet());
            }
            this.setActiveClass(data.getActiveClass());
            this.updateModifiers();
            this.activateClasses();
            this.activateModifiers();
            double health = data.getHealth();
            LivingEntity li = this.getLivingEntity();
            if (health > 0.0 && li != null) {
                health = Math.min(health, CompatibilityLib.getCompatibilityUtils().getMaxHealth((Damageable)li));
                li.setHealth(health);
            }
            this.cooldownExpiration = data.getCooldownExpiration();
            this.fallProtectionCount = data.getFallProtectionCount();
            this.fallProtection = data.getFallProtectionDuration();
            if (this.fallProtectionCount > 0L && this.fallProtection > 0L) {
                this.fallProtection = System.currentTimeMillis() + this.fallProtection;
            }
            this.resourcePackPreference = data.getResourcePackPreference();
            this.preferredResourcePack = data.getPreferredResourcePack();
            this.gaveWelcomeWand = data.getGaveWelcomeWand();
            this.playerName = data.getName();
            this.lastDeathLocation = data.getLastDeathLocation();
            this.lastCast = data.getLastCast();
            this.created = data.getCreatedTime();
            this.destinationWarp = data.getDestinationWarp();
            if (this.destinationWarp != null) {
                if (!this.destinationWarp.isEmpty()) {
                    Location destination = this.controller.getWarp(this.destinationWarp);
                    if (destination != null) {
                        Plugin plugin = this.controller.getPlugin();
                        this.controller.info("Warping " + this.getEntity().getName() + " to " + this.destinationWarp + " on login");
                        TeleportTask task = new TeleportTask(this.getController(), this.getEntity(), destination, 4, true, true, null);
                        Bukkit.getScheduler().scheduleSyncDelayedTask(plugin, (Runnable)task, 1L);
                    } else {
                        this.controller.info("Failed to warp " + this.getEntity().getName() + " to " + this.destinationWarp + " on login, warp doesn't exist");
                    }
                }
                this.destinationWarp = null;
            }
            this.getUndoQueue().load(data.getUndoData());
            this.externalUndoData = data.getExternalUndoData();
            this.respawnInventory = data.getRespawnInventory();
            this.respawnArmor = data.getRespawnArmor();
            this.restoreOpenWand = data.isOpenWand();
            BrushData brushData = data.getBrushData();
            if (brushData != null) {
                this.brush.load(brushData);
            }
            if (this.controller.isInventoryBackupEnabled()) {
                this.restoreInventory = data.getStoredInventory();
                this.restoreLevel = data.getStoredLevel();
                this.restoreExperience = data.getStoredExperience();
            }
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.WARNING, "Failed to load player data for " + this.playerName, ex);
            return false;
        }
        this.finishLoad(data);
        return true;
    }

    @Override
    @Nullable
    public MageClass getActiveClass() {
        if (this.activeClass == null && !DEFAULT_CLASS.isEmpty()) {
            this.setActiveClass(DEFAULT_CLASS);
        }
        return this.activeClass;
    }

    @Override
    public boolean setActiveClass(String classKey) {
        if (classKey == null) {
            this.activeClass = null;
            return true;
        }
        MageClass targetClass = this.getClass(classKey);
        if (targetClass == null) {
            return false;
        }
        this.activeClass = targetClass;
        if (!this.loading) {
            this.updatePassiveEffects();
        }
        return true;
    }

    @Override
    public boolean removeClass(String classKey) {
        if (!this.classes.containsKey(classKey)) {
            return false;
        }
        this.classes.get(classKey).onRemoved();
        this.classes.remove(classKey);
        if (this.activeClass != null && this.activeClass.getTemplate().getKey().equals(classKey)) {
            this.activeClass = null;
        }
        return true;
    }

    public boolean useArrow(ItemStack itemStack, int slot, ProjectileLaunchEvent event) {
        String spellKey = Wand.getArrowSpell(itemStack);
        if (spellKey == null) {
            return false;
        }
        MageSpell spell = this.getSpell(spellKey);
        if (spell == null) {
            return false;
        }
        event.setCancelled(true);
        String skillClass = Wand.getArrowSpellClass(itemStack);
        if (skillClass != null && !skillClass.isEmpty() && !this.setActiveClass(skillClass)) {
            this.sendMessage(this.controller.getMessages().get("mage.no_class").replace("$name", spell.getName()));
            return false;
        }
        if (!this.canUse(itemStack)) {
            this.sendMessage(this.controller.getMessages().get("mage.no_class").replace("$name", spell.getName()));
            return false;
        }
        if (!this.isCostFree()) {
            if (itemStack.getAmount() <= 1) {
                this.clearSlot(slot);
            } else {
                itemStack.setAmount(itemStack.getAmount() - 1);
            }
        }
        try {
            spell.cast();
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.SEVERE, "Error casting arrow spell", ex);
        }
        return true;
    }

    public boolean useSkill(ItemStack skillItem) {
        MageSpell spell = this.getSpell(Wand.getSpell(skillItem));
        if (spell == null) {
            return false;
        }
        if (spell.isPassive()) {
            if (spell.isToggleable()) {
                spell.setEnabled(!spell.isEnabled());
                Wand.updateSpellItem(this.controller.getMessages(), skillItem, spell, "", null, null, false, true);
            }
            return true;
        }
        boolean canUse = true;
        String skillClass = Wand.getSpellClass(skillItem);
        if (skillClass != null && !skillClass.isEmpty()) {
            if (!this.setActiveClass(skillClass)) {
                canUse = false;
                this.sendMessage(this.controller.getMessages().get("mage.no_class").replace("$name", spell.getName()));
            } else if (!this.activeClass.hasSpell(spell.getKey())) {
                canUse = false;
                this.sendMessage(this.controller.getMessages().get("mage.no_spell").replace("$name", spell.getName()));
            }
        }
        if (canUse) {
            Wand activeWand = this.activeWand;
            this.activeWand = null;
            spell.cast();
            this.activeWand = activeWand;
        }
        return canUse;
    }

    @Override
    @Nullable
    public MageClass unlockClass(@Nonnull String key) {
        return this.getClass(key, true);
    }

    @Override
    public boolean lockClass(@Nonnull String key) {
        MageClass mageClass = this.getClass(key);
        if (mageClass == null) {
            return false;
        }
        mageClass.lock();
        if (this.activeClass != null && this.activeClass.isLocked()) {
            this.setActiveClass(null);
        }
        this.checkWand();
        this.checkOffhandWand();
        this.updatePassiveEffects();
        return true;
    }

    @Override
    @Nonnull
    public Collection<com.elmakers.mine.bukkit.api.magic.MageClass> getClasses() {
        ArrayList<com.elmakers.mine.bukkit.api.magic.MageClass> mageClasses = new ArrayList<com.elmakers.mine.bukkit.api.magic.MageClass>();
        mageClasses.addAll(this.classes.values());
        return mageClasses;
    }

    @Override
    @Nonnull
    public Collection<String> getClassKeys() {
        return this.classes.keySet();
    }

    @Override
    @Nullable
    public MageClass getClass(@Nonnull String key) {
        return this.getClass(key, false);
    }

    @Nullable
    private MageClass getClass(@Nonnull String key, boolean unlock) {
        MageClass mageClass = this.classes.get(key);
        boolean updated = false;
        if (mageClass == null) {
            MageClassTemplate template = this.controller.getMageClass(key);
            if (unlock || !template.isLocked()) {
                mageClass = new MageClass(this, template);
                this.assignParent(mageClass);
                mageClass.loadProperties();
                this.classes.put(key, mageClass);
                mageClass.onUnlocked();
                updated = true;
            }
        }
        if (mageClass != null && mageClass.isLocked()) {
            if (unlock) {
                mageClass.unlock();
                updated = true;
            } else {
                mageClass = null;
            }
        }
        if (updated) {
            this.updatePassiveEffects();
        }
        return mageClass;
    }

    @Override
    public boolean hasClassUnlocked(@Nonnull String key) {
        MageClass mageClass = this.classes.get(key);
        return mageClass != null && !mageClass.isLocked();
    }

    private void assignParent(MageClass mageClass) {
        MageClass parentClass;
        TemplateProperties template = mageClass.getTemplate();
        TemplateProperties parentTemplate = template.getParent();
        if (parentTemplate != null && (parentClass = this.getClass(parentTemplate.getKey(), true)) != null) {
            mageClass.setParent(parentClass);
        }
    }

    @Override
    public boolean save(MageData data) {
        if (this.loading) {
            return false;
        }
        try {
            data.setName(this.getName());
            data.setId(this.getId());
            data.setCreatedTime(this.created);
            data.setLastCast(this.lastCast);
            data.setLastDeathLocation(this.lastDeathLocation);
            data.setLocation(this.location);
            data.setDestinationWarp(this.destinationWarp);
            data.setCooldownExpiration(this.cooldownExpiration);
            long now = System.currentTimeMillis();
            if (this.fallProtectionCount > 0L && this.fallProtection > now) {
                data.setFallProtectionCount(this.fallProtectionCount);
                data.setFallProtectionDuration(this.fallProtection - now);
            } else {
                data.setFallProtectionCount(0L);
                data.setFallProtectionDuration(0L);
            }
            BrushData brushData = new BrushData();
            this.brush.save(brushData);
            data.setBrushData(brushData);
            UndoData undoData = new UndoData();
            this.getUndoQueue().save(undoData);
            data.setUndoData(undoData);
            data.setExternalUndoData(this.externalUndoData);
            data.setSpellData(this.spellData.values());
            if (this.boundWands.size() > 0) {
                HashMap<String, ItemStack> wandItems = new HashMap<String, ItemStack>();
                for (Map.Entry<String, Wand> entry : this.boundWands.entrySet()) {
                    Wand wand = entry.getValue();
                    ItemStack item = wand.getItem();
                    if (CompatibilityLib.getItemUtils().isEmpty(item)) {
                        this.controller.getLogger().warning("Empty item found in bound wand list, this should not happen");
                        continue;
                    }
                    wandItems.put(entry.getKey(), item);
                }
                data.setBoundWands(wandItems);
            }
            data.setRespawnArmor(this.respawnArmor);
            data.setRespawnInventory(this.respawnInventory);
            data.setOpenWand(this.restoreOpenWand);
            if (this.activeWand != null) {
                if (this.activeWand.hasStoredInventory()) {
                    data.setStoredInventory(Arrays.asList(this.activeWand.getStoredInventory().getContents()));
                }
                if (this.activeWand.isInventoryOpen()) {
                    data.setOpenWand(true);
                }
            }
            data.setGaveWelcomeWand(this.gaveWelcomeWand);
            data.setResourcePackPreference(this.resourcePackPreference);
            data.setPreferredResourcePack(this.preferredResourcePack);
            data.setExtraData(this.data);
            data.setProperties(this.properties.getConfiguration());
            data.setVariables(this.variables);
            data.setKits(this.saveKits());
            data.setShownHelp(this.shownHelp);
            HashMap<String, ConfigurationSection> classProperties = new HashMap<String, ConfigurationSection>();
            for (Map.Entry<String, TemplatedProperties> entry : this.classes.entrySet()) {
                classProperties.put(entry.getKey(), ((MageClass)entry.getValue()).getConfiguration());
            }
            data.setClassProperties(classProperties);
            HashMap<String, ConfigurationSection> modifierProperties = new HashMap<String, ConfigurationSection>();
            for (Map.Entry<String, MageModifier> entry : this.transientModifiers.entrySet()) {
                modifierProperties.put(entry.getKey(), entry.getValue().getConfiguration());
            }
            data.setModifierProperties(modifierProperties);
            String string = this.activeClass == null ? null : this.activeClass.getTemplate().getKey();
            data.setActiveClass(string);
            LivingEntity livingEntity = this.getLivingEntity();
            if (livingEntity != null) {
                data.setHealth(livingEntity.getHealth());
            }
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.WARNING, "Failed to save player data for " + this.playerName, ex);
            return false;
        }
        return true;
    }

    public boolean checkLastClick(long maxInterval) {
        boolean onCooldown;
        long now = System.currentTimeMillis();
        boolean bl = onCooldown = now < this.lastClick + maxInterval;
        if (!onCooldown) {
            this.lastClick = now;
        }
        return !onCooldown;
    }

    protected void removeActiveEffects() {
        LivingEntity entity = this.getLivingEntity();
        if (entity == null) {
            return;
        }
        Collection activeEffects = entity.getActivePotionEffects();
        for (PotionEffect effect : activeEffects) {
            if (effect.getDuration() <= 0x3FFFFFFF) continue;
            entity.removePotionEffect(effect.getType());
        }
    }

    public void sendMessageKey(String key) {
        this.sendMessage(this.controller.getMessages().get(key, key));
    }

    @Nullable
    private Wand checkMainhandWand() {
        ItemStack activeWandItem;
        ItemStack autoWand;
        Player player = this.getPlayer();
        if (this.isLoading() || player == null) {
            return null;
        }
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        boolean isWand = Wand.isWand(itemInHand);
        if (!isWand && itemInHand != null && (autoWand = this.controller.getAutoWand(itemInHand)) != null) {
            itemInHand = autoWand;
            player.getInventory().setItemInMainHand(itemInHand);
            isWand = true;
        }
        ItemStack itemStack = activeWandItem = this.activeWand != null ? this.activeWand.getItem() : null;
        if (CompatibilityLib.getInventoryUtils().isSameInstance(activeWandItem, itemInHand)) {
            return this.activeWand;
        }
        if (this.activeWand != null && this.activeWand.getMode() == WandMode.SKILLS && this.activeWand.isInventoryOpen()) {
            return this.activeWand;
        }
        if (!isWand) {
            itemInHand = null;
        }
        if (itemInHand != null && activeWandItem == null || activeWandItem != null && itemInHand == null || activeWandItem != null && itemInHand != null && !this.controller.isSameItem(activeWandItem, itemInHand)) {
            Wand newActiveWand;
            if (this.activeWand != null) {
                this.activeWand.deactivate();
            }
            if (itemInHand != null && this.controller.hasWandPermission(player) && !(newActiveWand = this.controller.getWand(itemInHand)).activate(this)) {
                this.setActiveWand(null);
            }
        }
        return this.activeWand;
    }

    @Override
    @Nullable
    public Wand checkWand() {
        Player player = this.getPlayer();
        if (this.isLoading() || player == null) {
            return null;
        }
        this.checkOffhandWand();
        return this.checkMainhandWand();
    }

    public boolean offhandCast(Wand wand) {
        long now = System.currentTimeMillis();
        if (this.lastOffhandCast > 0L && now < this.lastOffhandCast + (long)OFFHAND_CAST_COOLDOWN) {
            return false;
        }
        this.lastOffhandCast = now;
        if (this.isLoading() || wand == null) {
            return false;
        }
        WandAction leftClickAction = wand.getLeftClickAction();
        if (leftClickAction != WandAction.NONE) {
            this.offhandCast = true;
            boolean castResult = false;
            try {
                wand.tickMana();
                wand.setActiveMage(this);
                castResult = wand.performAction(leftClickAction);
                Player player = this.getPlayer();
                if (player != null) {
                    CompatibilityLib.getCompatibilityUtils().swingOffhand((Entity)player);
                }
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.WARNING, "Error casting from offhand wand", ex);
            }
            this.offhandCast = false;
            return castResult;
        }
        return false;
    }

    public boolean setOffhandActive(boolean active) {
        boolean wasActive = this.offhandCast;
        this.offhandCast = active;
        return wasActive;
    }

    @Nullable
    public Wand checkOffhandWand() {
        ItemStack offhandWandItem;
        ItemStack autoWand;
        Player player = this.getPlayer();
        if (this.isLoading() || player == null) {
            return null;
        }
        ItemStack itemInHand = player.getInventory().getItemInOffHand();
        boolean isWand = Wand.isWand(itemInHand);
        if (!isWand && itemInHand != null && (autoWand = this.controller.getAutoWand(itemInHand)) != null) {
            itemInHand = autoWand;
            player.getInventory().setItemInOffHand(itemInHand);
            isWand = true;
        }
        ItemStack itemStack = offhandWandItem = this.offhandWand != null ? this.offhandWand.getItem() : null;
        if (CompatibilityLib.getInventoryUtils().isSameInstance(offhandWandItem, itemInHand)) {
            return this.offhandWand;
        }
        if (!isWand) {
            itemInHand = null;
        }
        if (itemInHand != null && offhandWandItem == null || offhandWandItem != null && itemInHand == null || itemInHand != null && offhandWandItem != null && !itemInHand.equals((Object)offhandWandItem)) {
            Wand newActiveWand;
            if (this.offhandWand != null) {
                this.offhandWand.deactivate();
            }
            if (itemInHand != null && this.controller.hasWandPermission(player) && !(newActiveWand = this.controller.getWand(itemInHand)).activateOffhand(this)) {
                this.setOffhandWand(null);
            }
        }
        return this.offhandWand;
    }

    public void checkWandNextTick(boolean checkAll) {
        if (!this.controller.getPlugin().isEnabled()) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask(this.controller.getPlugin(), (Runnable)new CheckWandTask(this, checkAll));
    }

    public void checkWandNextTick() {
        if (!this.controller.getPlugin().isEnabled()) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask(this.controller.getPlugin(), (Runnable)new CheckWandTask(this));
    }

    @Override
    public Vector getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Vector velocity) {
        this.velocity = velocity;
    }

    protected void updateVelocity() {
        if (this.lastLocation != null) {
            Location currentLocation = this.getLocation();
            if (currentLocation.getWorld().equals(this.lastLocation.getWorld())) {
                long interval = System.currentTimeMillis() - this.lastTick;
                this.velocity.setX((currentLocation.getX() - this.lastLocation.getX()) * 1000.0 / (double)interval);
                this.velocity.setY((currentLocation.getY() - this.lastLocation.getY()) * 1000.0 / (double)interval);
                this.velocity.setZ((currentLocation.getZ() - this.lastLocation.getZ()) * 1000.0 / (double)interval);
            } else {
                this.velocity.setX(0);
                this.velocity.setY(0);
                this.velocity.setZ(0);
            }
        }
        this.lastLocation = this.getLocation();
        Entity entity = this.getEntity();
        if (entity != null) {
            boolean isOnGround = entity.isOnGround();
            double fallDistance = entity.getFallDistance();
            if (fallDistance > 0.0) {
                this.lastFallDistance = fallDistance;
            }
            if (this.isInAir && isOnGround) {
                this.trigger("land");
            }
            this.isInAir = !isOnGround;
        }
    }

    private void updateBlocking(Player player) {
        boolean currentlyBlocking;
        boolean bl = currentlyBlocking = player.isBlocking() || CompatibilityLib.getCompatibilityUtils().isHandRaised(player);
        if (currentlyBlocking != this.isBlocking) {
            this.isBlocking = currentlyBlocking;
            if (this.isBlocking) {
                this.trigger("block");
            } else {
                this.trigger("stop_block");
            }
        }
        if (currentlyBlocking && this.blockMageCooldown > 0) {
            this.setRemainingCooldown(this.blockMageCooldown);
        }
    }

    @Override
    public void removed() {
        if (this.bossBar != null) {
            this.bossBar.remove();
            this.bossBar = null;
        }
    }

    @Override
    public void tick() {
        if (this.loading) {
            return;
        }
        this.triggeringSpells.clear();
        long now = System.currentTimeMillis();
        if (this.entityData != null) {
            boolean swinging = CompatibilityLib.getCompatibilityUtils().isSwingingArm(this.getEntity());
            if (swinging != this.isSwingingArm) {
                this.isSwingingArm = swinging;
                if (swinging) {
                    this.trigger("swing");
                }
            }
            if (this.lastTick != 0L) {
                long tickInterval = this.entityData.getTickInterval();
                if (tickInterval > 0L && now - this.lastTick > tickInterval) {
                    this.updateVelocity();
                    this.entityData.tick(this);
                    this.lastTick = now;
                }
            } else {
                this.lastTick = now;
            }
        } else {
            this.trigger("interval");
            this.updateVelocity();
            this.lastTick = now;
        }
        if (this.bossBar != null) {
            this.bossBar.tick();
        }
        boolean needsUpdate = false;
        Iterator<Map.Entry<String, MageModifier>> modifierIterator = this.transientModifiers.entrySet().iterator();
        while (modifierIterator.hasNext()) {
            MageModifier modifier = modifierIterator.next().getValue();
            if (!modifier.hasDuration() || modifier.getTimeRemaining() > 0) continue;
            modifierIterator.remove();
            needsUpdate = true;
        }
        if (needsUpdate) {
            this.updatePassiveEffects();
        }
        if (this.isNPC) {
            return;
        }
        Player player = this.getPlayer();
        if (player != null && player.isOnline()) {
            this.checkWand();
            this.updateBlocking(player);
            this.checkActionBarQueue();
            if (this.activeWand != null) {
                this.activeWand.tick();
            } else if (this.virtualExperience) {
                this.resetSentExperience();
            }
            if (this.offhandWand != null) {
                this.offhandWand.tick();
            }
            if (this.activeClass != null) {
                this.activeClass.tick();
            }
            this.properties.tick();
            if (Wand.LiveHotbarSkills && (this.activeWand == null || !this.activeWand.isInventoryOpen())) {
                this.updateHotbarStatus();
            }
            if (JUMP_EFFECT_FLIGHT_EXEMPTION_DURATION > 0 && player.hasPotionEffect(PotionEffectType.JUMP)) {
                this.controller.addFlightExemption(player, JUMP_EFFECT_FLIGHT_EXEMPTION_DURATION);
            }
            for (Wand armorWand : this.activeArmor.values()) {
                armorWand.updateEffects(this);
            }
            ArrayList<MageSpell> active = new ArrayList<MageSpell>(this.activeSpells);
            for (MageSpell spell : active) {
                spell.tick();
                if (spell.isActive()) continue;
                this.deactivateSpell(spell);
            }
        }
    }

    public int processPendingBatches(int maxWorldAllowed) {
        int updated = 0;
        Iterator<Batch> iterator = this.pendingBatches.iterator();
        while (iterator.hasNext()) {
            Batch batch = iterator.next();
            int batchUpdated = 0;
            boolean errored = false;
            try {
                batchUpdated = batch.process(Math.max(1, maxWorldAllowed - updated));
            }
            catch (Exception ex) {
                errored = true;
                this.controller.getLogger().log(Level.SEVERE, "Error processing batch: " + batch, ex);
                try {
                    batch.finish();
                }
                catch (Exception finishEx) {
                    this.controller.getLogger().log(Level.SEVERE, " Additional error force-finishing batch", finishEx);
                }
            }
            updated += batchUpdated;
            if (!batch.isFinished() && !errored) continue;
            iterator.remove();
        }
        return updated;
    }

    public boolean hasPendingBatches() {
        return !this.pendingBatches.isEmpty();
    }

    public void setLastHeldItem(ItemStack itemStack) {
        if (DefaultMaterials.isFilledMap(itemStack.getType())) {
            this.brush.setMapId(CompatibilityLib.getInventoryUtils().getMapId(itemStack));
        }
        this.lastHeldItem = itemStack;
    }

    @Override
    public int getLastHeldMapId() {
        return this.brush.getMapId();
    }

    protected void reloadClasses() {
        for (Map.Entry<String, MageClass> entry : this.classes.entrySet()) {
            MageClassTemplate template;
            String templateKey = entry.getKey();
            MageClass mageClass = entry.getValue();
            if (!mageClass.isLocked()) {
                mageClass.deactivate();
            }
            if ((template = this.controller.getMageClassTemplate(templateKey)) == null) {
                if (this.activeClass != mageClass) continue;
                this.setActiveClass(null);
                continue;
            }
            mageClass.setTemplate(template);
            mageClass.loadProperties();
            if (mageClass.isLocked()) continue;
            mageClass.activate();
        }
    }

    protected void reloadModifiers() {
        Iterator<Map.Entry<String, MageModifier>> it = this.modifiers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, MageModifier> entry = it.next();
            String templateKey = entry.getKey();
            MageModifier modifier = entry.getValue();
            ModifierTemplate template = this.controller.getModifierTemplate(templateKey);
            if (template == null) {
                modifier.onRemoved();
                it.remove();
                continue;
            }
            modifier.deactivate();
            modifier.setTemplate(template);
            modifier.loadProperties();
            modifier.activate();
        }
    }

    protected void reloadAttributes() {
        for (Map.Entry<String, MageClass> entry : this.classes.entrySet()) {
            MageClass mageClass = entry.getValue();
            if (mageClass.isLocked()) continue;
            mageClass.deactivate();
            mageClass.activate();
        }
        for (Map.Entry<String, BaseMageModifier> entry : this.modifiers.entrySet()) {
            MageModifier modifier = (MageModifier)entry.getValue();
            modifier.deactivate();
            modifier.activate();
        }
    }

    protected void loadSpells(ConfigurationSection spellConfiguration) {
        if (spellConfiguration == null) {
            return;
        }
        ArrayList<MageSpell> currentSpells = new ArrayList<MageSpell>(this.spells.values());
        for (MageSpell spell : currentSpells) {
            String key = spell.getKey();
            if (spellConfiguration.contains(key)) {
                ConfigurationSection template = spellConfiguration.getConfigurationSection(key);
                String className = template.getString("class");
                if (className == null) {
                    className = ActionSpell.class.getName();
                }
                if (!spell.getClass().getName().contains(className)) {
                    this.spells.remove(key);
                    this.spellData.put(key, spell.getSpellData());
                    continue;
                }
                spell.loadTemplate(key, template);
                spell.loadPrerequisites(template);
                continue;
            }
            this.spells.remove(key);
        }
    }

    @Override
    public Collection<Batch> getPendingBatches() {
        ArrayList<Batch> pending = new ArrayList<Batch>();
        pending.addAll(this.pendingBatches);
        return pending;
    }

    @Override
    public String getName() {
        return this.playerName == null || this.playerName.length() == 0 ? defaultMageName : this.playerName;
    }

    @Override
    public String getDisplayName() {
        Entity entity = this.getEntity();
        if (entity == null) {
            return this.getName();
        }
        if (entity instanceof Player) {
            return ((Player)entity).getDisplayName();
        }
        return this.controller.getEntityDisplayName(entity);
    }

    public void setName(String name) {
        this.playerName = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public Location getLocation() {
        if (this.location != null) {
            return this.location.clone();
        }
        LivingEntity livingEntity = this.getLivingEntity();
        if (livingEntity == null) {
            return null;
        }
        return livingEntity.getLocation();
    }

    @Override
    @Nullable
    public Location getEyeLocation() {
        Entity entity = this.getEntity();
        if (entity != null) {
            Location eyeLocation;
            if (CompatibilityConstants.USE_METADATA_LOCATIONS && (eyeLocation = BukkitMetadataUtils.getLocation((Entity)this.getPlayer(), "head.pos")) != null) {
                return eyeLocation;
            }
            return CompatibilityLib.getCompatibilityUtils().getEyeLocation(entity);
        }
        return this.getLocation();
    }

    @Override
    @Nullable
    public Location getCastLocation() {
        Location castLocation = this.getEyeLocation();
        if (this.activeWand != null && !this.offhandCast) {
            castLocation = this.activeWand.getLocation();
        } else if (this.offhandWand != null && this.offhandCast) {
            castLocation = this.offhandWand.getLocation();
        } else if (DEFAULT_CAST_LOCATION == CastSourceLocation.MAINHAND) {
            castLocation = this.getOffsetLocation(castLocation, false, DEFAULT_CAST_OFFSET);
        } else if (DEFAULT_CAST_LOCATION == CastSourceLocation.OFFHAND) {
            castLocation = this.getOffsetLocation(castLocation, true, DEFAULT_CAST_OFFSET);
        }
        return castLocation;
    }

    @Override
    @Nullable
    public Location getWandLocation() {
        return this.getCastLocation();
    }

    public Location getOffsetLocation(Location baseLocation, boolean isInOffhand, Vector offset) {
        HumanEntity human;
        Entity entity = this.getEntity();
        if (entity == null) {
            return baseLocation;
        }
        boolean leftHand = isInOffhand;
        if (entity instanceof HumanEntity && (human = (HumanEntity)entity).getMainHand() == MainHand.LEFT) {
            leftHand = !leftHand;
        }
        double sneakOffset = 0.0;
        if (entity instanceof Player && ((Player)entity).isSneaking()) {
            sneakOffset = SNEAKING_CAST_OFFSET;
        }
        if (leftHand) {
            offset = new Vector(offset.getX(), offset.getY() + sneakOffset, -offset.getZ());
        } else if (sneakOffset != 0.0) {
            offset = new Vector(offset.getX(), offset.getY() + sneakOffset, offset.getZ());
        }
        baseLocation.add(VectorUtils.rotateVector(offset, baseLocation));
        return baseLocation;
    }

    @Override
    @Nullable
    public Location getOffhandWandLocation() {
        Location wandLocation = this.getEyeLocation();
        if (this.offhandWand != null) {
            wandLocation = this.offhandWand.getLocation();
        }
        return wandLocation;
    }

    @Override
    public Vector getDirection() {
        Location location = this.getLocation();
        if (location != null) {
            return location.getDirection();
        }
        return new Vector(0, 1, 0);
    }

    @Override
    @Nullable
    public UndoList undo(Block target) {
        return this.getUndoQueue().undo(target);
    }

    @Override
    @Nullable
    public UndoList undo() {
        return this.getUndoQueue().undo();
    }

    @Override
    @Nullable
    public Batch cancelPending() {
        return this.cancelPending(null, true);
    }

    @Override
    @Nullable
    public Batch cancelPending(String spellKey) {
        return this.cancelPending(spellKey, true);
    }

    @Override
    @Nullable
    public Batch cancelPending(boolean force) {
        return this.cancelPending(null, force);
    }

    @Override
    @Nullable
    public Batch cancelPending(String spellKey, boolean force) {
        return this.cancelPending(spellKey, force, true);
    }

    @Override
    @Nullable
    public Batch cancelPending(String spellKey, boolean force, boolean nonBatched) {
        return this.cancelPending(spellKey, force, nonBatched, null);
    }

    @Nullable
    public Batch cancelPending(String spellKey, boolean force, boolean nonBatched, String exceptSpellKey) {
        return this.cancelPending(spellKey, force, nonBatched, exceptSpellKey, false);
    }

    @Nullable
    public Batch cancelPending(String spellKey, boolean force, boolean nonBatched, String exceptSpellKey, boolean fromDeactivate) {
        MageSpell cancelSpell;
        Batch stoppedPending = null;
        if (!this.pendingBatches.isEmpty()) {
            ArrayList<Batch> batches = new ArrayList<Batch>();
            batches.addAll(this.pendingBatches);
            for (Batch batch : batches) {
                SpellBatch spellBatch;
                Spell spell;
                if ((spellKey != null || !force || fromDeactivate) && (!(batch instanceof SpellBatch) || (spell = (spellBatch = (SpellBatch)batch).getSpell()) == null || fromDeactivate && !spell.cancelOnDeactivate() || !force && !spell.isCancellable() || spellKey != null && !spell.getSpellKey().getBaseKey().equalsIgnoreCase(spellKey)) || exceptSpellKey != null && batch instanceof SpellBatch && (spell = (spellBatch = (SpellBatch)batch).getSpell()) != null && spell.getSpellKey().getBaseKey().equalsIgnoreCase(exceptSpellKey) || batch instanceof com.elmakers.mine.bukkit.batch.UndoBatch) continue;
                batch.cancel();
                this.pendingBatches.remove(batch);
                stoppedPending = batch;
            }
        }
        if (nonBatched && stoppedPending == null && spellKey != null && !spellKey.isEmpty() && (cancelSpell = this.getSpell(spellKey)) != null) {
            cancelSpell.cancel();
        }
        return stoppedPending;
    }

    @Override
    public int finishPendingUndo() {
        int finished = 0;
        if (!this.pendingBatches.isEmpty()) {
            ArrayList<Batch> batches = new ArrayList<Batch>();
            batches.addAll(this.pendingBatches);
            for (Batch batch : batches) {
                if (!(batch instanceof com.elmakers.mine.bukkit.batch.UndoBatch)) continue;
                ((com.elmakers.mine.bukkit.batch.UndoBatch)batch).complete();
                this.pendingBatches.remove(batch);
                ++finished;
            }
        }
        return finished;
    }

    @Override
    public boolean commit() {
        if (this.externalUndoData != null) {
            this.externalUndoData.clear();
            this.externalUndoData = null;
        }
        return this.getUndoQueue().commit();
    }

    @Override
    public boolean hasCastPermission(Spell spell) {
        return spell.hasCastPermission(this.getCommandSender());
    }

    @Override
    public boolean hasSpell(String key) {
        return this.spells.containsKey(key);
    }

    @Override
    @Nullable
    public MageSpell getSpell(String key) {
        if (this.loading) {
            return null;
        }
        MageSpell playerSpell = this.spells.get(key);
        if (playerSpell == null) {
            playerSpell = this.createSpell(key);
            if (playerSpell != null) {
                SpellData spellData = this.spellData.get(key);
                if (spellData == null) {
                    spellData = new SpellData(key);
                    this.spellData.put(key, spellData);
                }
                playerSpell.setSpellData(spellData);
            }
        } else {
            playerSpell.setMage(this);
        }
        return playerSpell;
    }

    @Nullable
    protected MageSpell createSpell(String key) {
        MageSpell playerSpell = this.spells.get(key);
        if (playerSpell != null) {
            playerSpell.setMage(this);
            return playerSpell;
        }
        SpellTemplate spellTemplate = this.controller.getSpellTemplate(key);
        if (spellTemplate == null) {
            return null;
        }
        playerSpell = spellTemplate.createMageSpell(this);
        if (playerSpell == null) {
            return null;
        }
        this.spells.put(playerSpell.getKey(), playerSpell);
        return playerSpell;
    }

    @Override
    public Collection<Spell> getSpells() {
        ArrayList<Spell> export = new ArrayList<Spell>(this.spells.values());
        return export;
    }

    @Override
    public void activateSpell(Spell spell) {
        if (spell instanceof MageSpell) {
            MageSpell mageSpell = (MageSpell)spell;
            this.activeSpells.add(mageSpell);
            mageSpell.setActive(true);
        }
    }

    @Override
    public void deactivateSpell(Spell spell) {
        this.activeSpells.remove(spell);
        if (spell instanceof MageSpell) {
            ((MageSpell)spell).deactivate();
        }
    }

    @Override
    public void deactivateAllSpells() {
        this.deactivateAllSpells(false, false);
    }

    @Override
    public void deactivateAllSpells(boolean force, boolean quiet) {
        this.deactivateAllSpells(force, quiet, null);
    }

    @Override
    public void deactivateAllSpells(boolean force, boolean quiet, String exceptSpellKey) {
        ArrayList<MageSpell> active = new ArrayList<MageSpell>(this.activeSpells);
        for (MageSpell spell : active) {
            if (exceptSpellKey != null && spell.getSpellKey().getBaseKey().equalsIgnoreCase(exceptSpellKey) || !spell.deactivate(force, quiet)) continue;
            this.activeSpells.remove(spell);
        }
        this.cancelPending(null, true, true, exceptSpellKey, true);
    }

    @Override
    public boolean isCostFree() {
        if (this.costFreeOverride || this.costFree || this.getPlayer() == null) {
            return true;
        }
        return this.getCostReduction() > 1.0f;
    }

    @Override
    public boolean isConsumeFree() {
        return this.consumeFree || this.consumeReduction >= 1.0f || this.activeWand != null && this.activeWand.isConsumeFree();
    }

    @Override
    public boolean isSuperProtected() {
        if (this.superProtectionExpiration != 0L) {
            if (System.currentTimeMillis() > this.superProtectionExpiration) {
                this.superProtectionExpiration = 0L;
            } else {
                return true;
            }
        }
        return this.superProtected;
    }

    @Override
    public boolean isSuperPowered() {
        if (this.isCommandBlock() && COMMAND_BLOCKS_SUPERPOWERED) {
            return true;
        }
        if (this.isConsole() && CONSOLE_SUPERPOWERED) {
            return true;
        }
        return this.superPowered;
    }

    @Override
    public boolean isIgnoredByMobs() {
        return this.ignoredByMobs || this.superProtected;
    }

    @Override
    public float getCostReduction() {
        if (this.costFreeOverride) {
            return 2.0f;
        }
        return this.costReduction * this.controller.getMaxCostReduction() + this.controller.getCostReduction();
    }

    @Override
    public float getConsumeReduction() {
        return this.consumeReduction;
    }

    @Override
    public float getCostScale() {
        return 1.0f;
    }

    @Override
    public float getCooldownReduction() {
        if (this.cooldownFreeOverride) {
            return 2.0f;
        }
        return this.cooldownReduction * this.controller.getMaxCooldownReduction() + this.controller.getCooldownReduction();
    }

    @Override
    public boolean isCooldownFree() {
        return this.cooldownFreeOverride || this.cooldownFree || this.getCooldownReduction() > 1.0f;
    }

    @Override
    public long getRemainingCooldown() {
        long remaining = 0L;
        if (this.cooldownExpiration > 0L) {
            long now = System.currentTimeMillis();
            if (this.cooldownExpiration > now) {
                remaining = this.cooldownExpiration - now;
            } else {
                this.cooldownExpiration = 0L;
            }
        }
        return remaining;
    }

    @Override
    public void clearCooldown() {
        this.cooldownExpiration = 0L;
        HeroesManager heroes = this.controller.getHeroes();
        Player player = this.getPlayer();
        if (heroes != null && player != null) {
            heroes.clearCooldown(player);
        }
    }

    @Override
    public void setRemainingCooldown(long ms) {
        this.cooldownExpiration = Math.max(ms + System.currentTimeMillis(), this.cooldownExpiration);
        HeroesManager heroes = this.controller.getHeroes();
        Player player = this.getPlayer();
        if (heroes != null && player != null) {
            heroes.setCooldown(player, ms);
        }
    }

    @Override
    public void reduceRemainingCooldown(long ms) {
        this.cooldownExpiration = Math.max(0L, this.cooldownExpiration - ms);
        HeroesManager heroes = this.controller.getHeroes();
        Player player = this.getPlayer();
        if (heroes != null && player != null) {
            heroes.reduceCooldown(player, ms);
        }
    }

    @Override
    @Nullable
    public Color getEffectColor() {
        MageClass activeClass;
        if (this.offhandCast && this.offhandWand != null) {
            return this.offhandWand.getEffectColor();
        }
        Color color = this.getActiveProperties().getEffectColor();
        if (color == null && (activeClass = this.getActiveClass()) != null) {
            color = activeClass.getEffectColor();
        }
        return color;
    }

    @Override
    @Nullable
    public String getEffectParticleName() {
        MageClass activeClass;
        if (this.offhandCast && this.offhandWand != null) {
            return this.offhandWand.getEffectParticleName();
        }
        String particleName = this.getActiveProperties().getEffectParticleName();
        if (particleName == null && (activeClass = this.getActiveClass()) != null) {
            particleName = activeClass.getEffectParticleName();
        }
        return particleName;
    }

    @Override
    public void onCast(Spell spell, SpellResult result) {
        this.lastCast = System.currentTimeMillis();
        if (spell != null) {
            this.controller.onCast(this, spell, result);
            this.lastSpellCast = spell;
        }
    }

    @Override
    public float getPower() {
        if (this.offhandCast && this.offhandWand != null) {
            float power = Math.min(this.controller.getMaxPower(), this.offhandWand.getPower() + this.getMagePowerBonus());
            return power * this.powerMultiplier;
        }
        float power = Math.min(this.controller.getMaxPower(), this.activeWand == null ? this.getMagePowerBonus() : this.activeWand.getPower() + this.getMagePowerBonus());
        return power * this.powerMultiplier;
    }

    @Override
    public float getMagePowerBonus() {
        return this.magePowerBonus;
    }

    @Override
    public void setMagePowerBonus(float magePowerBonus) {
        this.magePowerBonus = magePowerBonus;
    }

    @Override
    public boolean isRestricted(Material material) {
        Player player = this.getPlayer();
        if (this.controller.hasBypassPermission((CommandSender)player)) {
            return false;
        }
        if (player != null && player.hasPermission("magic.bypass_restricted")) {
            return false;
        }
        return this.controller.isRestricted(material);
    }

    @Override
    public boolean isRestricted(Material material, Short data) {
        Player player = this.getPlayer();
        if (this.controller.hasBypassPermission((CommandSender)player)) {
            return false;
        }
        if (player != null && player.hasPermission("magic.bypass_restricted")) {
            return false;
        }
        return this.controller.isRestricted(material, data);
    }

    @Override
    public MagicController getController() {
        return this.controller;
    }

    @Override
    @Nullable
    @Deprecated
    public Set<Material> getRestrictedMaterials() {
        return MaterialSets.toLegacy(this.getRestrictedMaterialSet());
    }

    @Override
    public MaterialSet getRestrictedMaterialSet() {
        if (this.isSuperPowered()) {
            return MaterialSets.empty();
        }
        return this.controller.getRestrictedMaterialSet();
    }

    @Override
    public boolean isPVPAllowed(Location location) {
        return this.controller.isPVPAllowed(this.getPlayer(), location == null ? this.getLocation() : location);
    }

    @Override
    public boolean hasBuildPermission(Block block) {
        return this.controller.hasBuildPermission(this.getPlayer(), block);
    }

    @Override
    public boolean hasBreakPermission(Block block) {
        return this.controller.hasBreakPermission(this.getPlayer(), block);
    }

    @Override
    public boolean isIndestructible(Block block) {
        return this.controller.isIndestructible(block);
    }

    @Override
    public boolean isDestructible(Block block) {
        return this.controller.isDestructible(block);
    }

    @Override
    public boolean isDead() {
        LivingEntity entity = this.getLivingEntity();
        if (entity != null) {
            return entity.isDead();
        }
        if (this.isAutomaton) {
            return !this.isValid();
        }
        return false;
    }

    @Override
    public boolean isOnline() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.isOnline();
        }
        CommandSender sender = this.getCommandSender();
        if (sender == null || !(sender instanceof BlockCommandSender)) {
            return true;
        }
        return this.lastCast > System.currentTimeMillis() - (long)AUTOMATA_ONLINE_TIMEOUT;
    }

    @Override
    public boolean isPlayer() {
        Player player = this.getPlayer();
        return player != null;
    }

    public boolean isConsole() {
        CommandSender sender = this.getCommandSender();
        return sender != null && sender instanceof ConsoleCommandSender;
    }

    public boolean isCommandBlock() {
        CommandSender sender = this.getCommandSender();
        return sender != null && sender instanceof BlockCommandSender;
    }

    @Override
    public boolean hasLocation() {
        return this.getLocation() != null;
    }

    @Override
    @Nullable
    public Inventory getInventory() {
        if (this.hasStoredInventory()) {
            return this.getStoredInventory();
        }
        Player player = this.getPlayer();
        if (player != null) {
            return player.getInventory();
        }
        return null;
    }

    @Override
    @Nullable
    public ItemStack getItem(int slotIndex) {
        InventorySlot slot = InventorySlot.getSlot(slotIndex);
        if (slot.isArmorSlot()) {
            Player player = this.getPlayer();
            if (player != null) {
                return player.getInventory().getItem(slotIndex);
            }
            LivingEntity living = this.getLivingEntity();
            if (living != null) {
                return slot.getItem(living.getEquipment());
            }
            return null;
        }
        Inventory inventory = this.getInventory();
        if (slotIndex >= 0 && slotIndex < inventory.getSize()) {
            return inventory.getItem(slotIndex);
        }
        return null;
    }

    @Override
    public boolean setItem(int slotIndex, ItemStack item) {
        Player player = this.getPlayer();
        if (player != null && player.isDead() && !CompatibilityLib.getItemUtils().isEmpty(item)) {
            this.controller.info("** Giving item while dead (slot " + slotIndex + "): " + TextUtils.nameItem(item));
            this.addToRespawnInventory(slotIndex, item);
            return true;
        }
        InventorySlot slot = InventorySlot.getSlot(slotIndex);
        if (slot.isArmorSlot()) {
            if (player != null) {
                player.getInventory().setItem(slotIndex, item);
                return true;
            }
            LivingEntity living = this.getLivingEntity();
            if (living != null) {
                return slot.setItem(living.getEquipment(), item);
            }
            return false;
        }
        Inventory inventory = this.getInventory();
        if (slotIndex >= 0 && slotIndex < inventory.getSize()) {
            inventory.setItem(slotIndex, item);
            return true;
        }
        return false;
    }

    @Override
    public int removeItem(ItemStack itemStack, boolean allowVariants) {
        boolean modified;
        ItemStack item;
        int index;
        if (!this.isPlayer()) {
            return 0;
        }
        CurrencyAmount currency = CompatibilityLib.getInventoryUtils().getCurrencyAmount(itemStack);
        if (currency != null) {
            currency.scale(itemStack.getAmount());
            this.removeCurrency(currency.getType(), currency.getAmount());
            return currency.getAmount();
        }
        int amount = itemStack == null ? 0 : itemStack.getAmount();
        Inventory inventory = this.getInventory();
        ItemStack[] contents = inventory.getContents();
        for (int index2 = 0; amount > 0 && index2 < contents.length; ++index2) {
            ItemStack item2 = contents[index2];
            if (!this.isMatch(itemStack, item2, allowVariants)) continue;
            if (amount >= item2.getAmount()) {
                amount -= item2.getAmount();
                inventory.setItem(index2, null);
                continue;
            }
            item2.setAmount(item2.getAmount() - amount);
            amount = 0;
        }
        PlayerInventory playerInventory = this.getPlayer().getInventory();
        if (amount > 0) {
            ItemStack[] extra = playerInventory.getExtraContents();
            for (index = 0; amount > 0 && index < extra.length; ++index) {
                item = extra[index];
                modified = false;
                if (this.isMatch(itemStack, item, allowVariants)) {
                    if (amount >= item.getAmount()) {
                        amount -= item.getAmount();
                        extra[index] = null;
                        modified = true;
                    } else {
                        item.setAmount(item.getAmount() - amount);
                        amount = 0;
                        modified = true;
                    }
                }
                if (!modified) continue;
                playerInventory.setExtraContents(extra);
            }
        }
        if (amount > 0) {
            ItemStack[] armor = playerInventory.getArmorContents();
            for (index = 0; amount > 0 && index < armor.length; ++index) {
                item = armor[index];
                modified = false;
                if (this.isMatch(itemStack, item, allowVariants)) {
                    if (amount >= item.getAmount()) {
                        amount -= item.getAmount();
                        armor[index] = null;
                        modified = true;
                    } else {
                        item.setAmount(item.getAmount() - amount);
                        amount = 0;
                        modified = true;
                    }
                }
                if (!modified) continue;
                playerInventory.setArmorContents(armor);
            }
        }
        return amount;
    }

    @Override
    public int removeItem(ItemStack itemStack) {
        return this.removeItem(itemStack, false);
    }

    protected boolean isMatch(ItemStack itemStack, ItemStack candidate, boolean allowVariants) {
        if (candidate == null || itemStack == null) {
            return false;
        }
        if (!allowVariants) {
            return this.controller.itemsAreEqual(itemStack, candidate);
        }
        if (itemStack.getType() != candidate.getType()) {
            return false;
        }
        if (itemStack.hasItemMeta() != candidate.hasItemMeta()) {
            return false;
        }
        if (itemStack.hasItemMeta()) {
            ItemMeta meta = itemStack.getItemMeta();
            ItemMeta candidateMeta = candidate.getItemMeta();
            if (meta.hasDisplayName() != candidateMeta.hasDisplayName()) {
                return false;
            }
            if (meta.hasDisplayName() && !meta.getDisplayName().equals(candidateMeta.getDisplayName())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasItem(ItemStack itemStack, boolean allowVariants) {
        ItemStack[] extra;
        ItemStack[] armor;
        ItemStack[] contents;
        int amount;
        if (!this.isPlayer()) {
            return false;
        }
        CurrencyAmount currency = CompatibilityLib.getInventoryUtils().getCurrencyAmount(itemStack);
        if (currency != null) {
            return this.getCurrency(currency.getType()) >= (double)(currency.getAmount() * itemStack.getAmount());
        }
        int n = amount = itemStack == null ? 0 : itemStack.getAmount();
        if (amount <= 0) {
            return true;
        }
        Inventory inventory = this.getInventory();
        for (ItemStack item : contents = inventory.getContents()) {
            if (!this.isMatch(itemStack, item, allowVariants) || (amount -= item.getAmount()) > 0) continue;
            return true;
        }
        PlayerInventory playerInventory = this.getPlayer().getInventory();
        for (ItemStack item : armor = playerInventory.getArmorContents()) {
            if (!this.isMatch(itemStack, item, allowVariants) || (amount -= item.getAmount()) > 0) continue;
            return true;
        }
        for (ItemStack item : extra = playerInventory.getExtraContents()) {
            if (!this.isMatch(itemStack, item, allowVariants) || (amount -= item.getAmount()) > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasItem(ItemStack itemStack) {
        return this.hasItem(itemStack, false);
    }

    @Override
    public boolean consumeBlock(MaterialAndData block, boolean allowVariants) {
        ItemStack requires = block.getItemStack(1);
        if (!this.hasItem(requires, allowVariants)) {
            Double itemWorth;
            Currency currency = this.controller.getBlockExchangeCurrency();
            Double d = itemWorth = currency == null ? null : this.controller.getWorth(requires, currency.getKey());
            if (currency != null && itemWorth != null && itemWorth > 0.0 && currency.has(this, this.getActiveProperties(), itemWorth)) {
                currency.deduct(this, this.getActiveProperties(), itemWorth);
                return true;
            }
            return false;
        }
        this.removeItem(requires, allowVariants);
        return true;
    }

    @Override
    public void refundBlock(MaterialAndData block) {
        Double itemWorth;
        boolean gave = false;
        ItemStack refund = block.getItemStack(1);
        Currency currency = this.controller.getBlockExchangeCurrency();
        if (currency != null && !this.isAtMaxCurrency(currency.getKey()) && (itemWorth = this.controller.getWorth(refund, currency.getKey())) != null && itemWorth > 0.0) {
            gave = true;
            this.addCurrency(currency.getKey(), itemWorth);
        }
        if (!gave) {
            this.giveItem(refund);
        }
    }

    @Override
    public int getItemCount(ItemStack itemStack, boolean allowDamaged) {
        ItemStack[] extra;
        ItemStack[] armor;
        ItemStack[] contents;
        if (!this.isPlayer()) {
            return 0;
        }
        CurrencyAmount currency = CompatibilityLib.getInventoryUtils().getCurrencyAmount(itemStack);
        if (currency != null) {
            int amount = currency.getAmount() <= 0 ? 1 : currency.getAmount();
            return (int)Math.ceil(this.getCurrency(currency.getType()) / (double)amount);
        }
        int amount = 0;
        Inventory inventory = this.getInventory();
        for (ItemStack item : contents = inventory.getContents()) {
            if (!this.isMatch(itemStack, item, allowDamaged)) continue;
            amount += item.getAmount();
        }
        PlayerInventory playerInventory = this.getPlayer().getInventory();
        for (ItemStack item : armor = playerInventory.getArmorContents()) {
            if (!this.isMatch(itemStack, item, allowDamaged)) continue;
            amount += item.getAmount();
        }
        for (ItemStack item : extra = playerInventory.getExtraContents()) {
            if (!this.isMatch(itemStack, item, allowDamaged)) continue;
            amount += item.getAmount();
        }
        return amount;
    }

    @Override
    public int getItemCount(ItemStack itemStack) {
        return this.getItemCount(itemStack, false);
    }

    @Override
    @Nullable
    @Deprecated
    public Wand getSoulWand() {
        return null;
    }

    @Override
    public Wand getActiveWand() {
        if (this.offhandCast && this.offhandWand != null) {
            return this.offhandWand;
        }
        return this.activeWand;
    }

    @Override
    public Wand getOffhandWand() {
        return this.offhandWand;
    }

    public Wand getProjectileWand() {
        Material wandIcon;
        Wand wand = this.getActiveWand();
        if (wand != null && !DefaultMaterials.isBow(wandIcon = wand.getIcon().getMaterial())) {
            wand = null;
        }
        if (wand == null && (wand = this.getOffhandWand()) != null && !DefaultMaterials.isBow(wandIcon = wand.getIcon().getMaterial())) {
            wand = null;
        }
        return wand;
    }

    @Override
    public MaterialBrush getBrush() {
        return this.brush;
    }

    @Override
    public float getDamageMultiplier() {
        double attackMultiplier;
        Double overallMultiplier;
        float multiplier = 1.0f;
        float maxPowerMultiplier = this.controller.getMaxDamagePowerMultiplier() - 1.0f;
        if (maxPowerMultiplier > 0.0f) {
            multiplier = 1.0f + maxPowerMultiplier * this.getPower();
        }
        if ((overallMultiplier = this.strength.get("overall")) != null && overallMultiplier != 0.0 && (attackMultiplier = this.controller.getMaxAttackMultiplier("overall")) > 1.0) {
            attackMultiplier = 1.0 + (attackMultiplier - 1.0) * overallMultiplier;
            multiplier = (float)((double)multiplier * attackMultiplier);
        }
        return Math.max(0.0f, multiplier);
    }

    @Override
    public double getDamageMultiplier(String damageType) {
        double attackMultiplier;
        Double typeMultiplier;
        double overallMultiplier = this.getDamageMultiplier();
        Double d = typeMultiplier = damageType == null || damageType.isEmpty() ? null : this.strength.get(damageType);
        if (typeMultiplier != null && typeMultiplier > 0.0 && (attackMultiplier = this.controller.getMaxAttackMultiplier(damageType)) > 1.0) {
            attackMultiplier = 1.0 + (attackMultiplier - 1.0) * typeMultiplier;
            overallMultiplier *= attackMultiplier;
        }
        return Math.max(0.0, overallMultiplier);
    }

    @Override
    public float getRangeMultiplier() {
        if (this.activeWand == null) {
            return 1.0f;
        }
        float maxPowerMultiplier = this.controller.getMaxRangePowerMultiplier() - 1.0f;
        float maxPowerMultiplierMax = this.controller.getMaxRangePowerMultiplierMax();
        float multiplier = 1.0f + maxPowerMultiplier * this.getPower();
        return Math.min(multiplier, maxPowerMultiplierMax);
    }

    @Override
    public float getConstructionMultiplier() {
        float maxPowerMultiplier = this.controller.getMaxConstructionPowerMultiplier() - 1.0f;
        return 1.0f + maxPowerMultiplier * this.getPower();
    }

    @Override
    public float getRadiusMultiplier() {
        if (this.activeWand == null) {
            return 1.0f;
        }
        float maxPowerMultiplier = this.controller.getMaxRadiusPowerMultiplier() - 1.0f;
        float maxPowerMultiplierMax = this.controller.getMaxRadiusPowerMultiplierMax();
        float multiplier = 1.0f + maxPowerMultiplier * this.getPower();
        return Math.min(multiplier, maxPowerMultiplierMax);
    }

    @Override
    @Nonnull
    public CasterProperties getActiveProperties() {
        if (this.offhandCast && this.offhandWand != null) {
            return this.offhandWand;
        }
        if (this.activeWand != null) {
            return this.activeWand;
        }
        if (this.activeClass != null) {
            return this.activeClass;
        }
        return this.properties;
    }

    @Override
    @Nullable
    public CasterProperties getCasterProperties(String propertyType) {
        CasterProperties properties = null;
        properties = propertyType.equals("wand") ? this.getActiveWand() : (propertyType.equals("active_wand") ? this.checkWand() : (propertyType.equals("player") ? this.getProperties() : (propertyType.equals("class") ? this.getActiveClass() : (propertyType.equals("active") ? this.getActiveProperties() : this.getClass(propertyType)))));
        if (properties == null && propertyType.equals("mage")) {
            properties = this.getProperties();
        }
        return properties;
    }

    @Override
    public float getMana() {
        return this.getActiveProperties().getMana();
    }

    @Override
    public int getManaMax() {
        return this.getActiveProperties().getManaMax();
    }

    @Override
    public int getManaRegeneration() {
        return this.getActiveProperties().getManaRegeneration();
    }

    @Override
    public void setMana(float mana) {
        this.getActiveProperties().setMana(mana);
    }

    @Override
    public void updateMana() {
        this.getActiveProperties().updateMana();
    }

    @Override
    public int getEffectiveManaMax() {
        return this.getActiveProperties().getEffectiveManaMax();
    }

    @Override
    public int getEffectiveManaRegeneration() {
        return this.getActiveProperties().getEffectiveManaRegeneration();
    }

    @Override
    public void removeMana(float mana) {
        this.getActiveProperties().removeMana(mana);
    }

    @Override
    public void removeExperience(int xp) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        float expProgress = player.getExp();
        int expLevel = player.getLevel();
        while ((expProgress > 0.0f || expLevel > 0) && xp > 0) {
            if (expProgress > 0.0f) {
                float expToLevel = Wand.getExpToLevel(expLevel);
                int expAtLevel = (int)(expProgress * expToLevel);
                if (expAtLevel > xp) {
                    xp = 0;
                    expProgress = (float)(expAtLevel -= xp) / expToLevel;
                    continue;
                }
                expProgress = 0.0f;
                xp -= expAtLevel;
                continue;
            }
            if ((xp -= Wand.getExpToLevel(--expLevel - 1)) >= 0) continue;
            expProgress = (float)(-xp) / (float)Wand.getExpToLevel(expLevel);
            xp = 0;
        }
        player.setExp(Math.max(0.0f, Math.min(1.0f, expProgress)));
        player.setLevel(Math.max(0, expLevel));
    }

    @Override
    public int getLevel() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getLevel();
        }
        return 0;
    }

    @Override
    public void setLevel(int level) {
        Player player = this.getPlayer();
        if (player != null) {
            player.setLevel(level);
        }
    }

    @Override
    public int getExperience() {
        Player player = this.getPlayer();
        if (player == null) {
            return 0;
        }
        float expProgress = player.getExp();
        int expLevel = player.getLevel();
        return Wand.getExperience(expLevel, expProgress);
    }

    @Override
    public void giveExperience(int xp) {
        Player player = this.getPlayer();
        if (player != null) {
            player.giveExp(xp);
        }
    }

    public void sendExperience(float exp, int level) {
        if (this.virtualExperience && exp == this.virtualExperienceProgress && level == this.virtualExperienceLevel) {
            return;
        }
        if (Float.isNaN(exp)) {
            return;
        }
        Player player = this.getPlayer();
        if (player != null) {
            exp = Math.max(Math.min(exp, 1.0f), 0.0f);
            CompatibilityLib.getCompatibilityUtils().sendExperienceUpdate(player, exp, level);
            this.virtualExperience = true;
            this.virtualExperienceProgress = exp;
            this.virtualExperienceLevel = level;
        }
    }

    public void resetSentExperience() {
        Player player = this.getPlayer();
        if (player != null) {
            CompatibilityLib.getCompatibilityUtils().sendExperienceUpdate(player, player.getExp(), player.getLevel());
        }
        this.virtualExperience = false;
    }

    public void experienceChanged() {
        this.virtualExperience = false;
    }

    @Override
    public boolean addBatch(Batch batch) {
        if (this.pendingBatches.size() >= this.controller.getPendingQueueDepth()) {
            this.controller.getLogger().info("Rejected spell cast for " + this.getName() + ", already has " + this.pendingBatches.size() + " pending, limit: " + this.controller.getPendingQueueDepth());
            return false;
        }
        this.pendingBatches.addLast(batch);
        this.controller.addPending(this);
        return true;
    }

    @Override
    public void registerEvent(SpellEventType type, Listener spell) {
        switch (type) {
            case PLAYER_QUIT: {
                if (this.quitListeners.contains(spell)) break;
                this.quitListeners.add(spell);
                break;
            }
            case PLAYER_DAMAGE: {
                if (this.damageListeners.contains(spell)) break;
                this.damageListeners.add(spell);
                break;
            }
            case PLAYER_DEATH: {
                if (this.deathListeners.contains(spell)) break;
                this.deathListeners.add(spell);
            }
        }
    }

    @Override
    public void unregisterEvent(SpellEventType type, Listener spell) {
        switch (type) {
            case PLAYER_DAMAGE: {
                this.damageListeners.remove(spell);
                break;
            }
            case PLAYER_QUIT: {
                this.quitListeners.remove(spell);
                break;
            }
            case PLAYER_DEATH: {
                this.deathListeners.remove(spell);
            }
        }
    }

    @Override
    @Nullable
    public Player getPlayer() {
        return this.isNPC ? null : (Player)this.playerRef.get();
    }

    @Override
    public Entity getEntity() {
        return (Entity)this.entityRef.get();
    }

    @Override
    public EntityData getEntityData() {
        return this.entityData;
    }

    @Override
    @Nullable
    public LivingEntity getLivingEntity() {
        Entity entity = (Entity)this.entityRef.get();
        return entity != null && entity instanceof LivingEntity ? (LivingEntity)entity : null;
    }

    @Override
    public CommandSender getCommandSender() {
        return (CommandSender)this.commandSenderRef.get();
    }

    @Override
    public List<LostWand> getLostWands() {
        Entity entity = this.getEntity();
        Collection<LostWand> allWands = this.controller.getLostWands();
        ArrayList<LostWand> mageWands = new ArrayList<LostWand>();
        if (entity == null) {
            return mageWands;
        }
        String playerId = entity.getUniqueId().toString();
        for (LostWand lostWand : allWands) {
            String owner = lostWand.getOwnerId();
            if (owner == null || !owner.equals(playerId)) continue;
            mageWands.add(lostWand);
        }
        return mageWands;
    }

    @Override
    public Location getLastDeathLocation() {
        return this.lastDeathLocation;
    }

    @Override
    @Deprecated
    public void showHoloText(Location location, String text, int duration) {
    }

    @Override
    public void enableFallProtection(int ms) {
        this.enableFallProtection(ms, null);
    }

    @Override
    public void enableFallProtection(int ms, @Nullable Spell protector) {
        this.enableFallProtection(ms, 1, protector);
    }

    @Override
    public void enableFallProtection(int ms, int count, @Nullable Spell protector) {
        long nextTime;
        if (ms <= 0 || count <= 0) {
            return;
        }
        if (protector != null && protector instanceof BaseSpell) {
            this.fallingSpell = (BaseSpell)protector;
        }
        if ((nextTime = System.currentTimeMillis() + (long)ms) > this.fallProtection) {
            this.fallProtection = nextTime;
        }
        if ((long)count > this.fallProtectionCount) {
            this.fallProtectionCount = count;
        }
    }

    @Override
    public void clearFallProtection() {
        this.fallingSpell = null;
        this.fallProtection = 0L;
        this.fallProtectionCount = 0L;
    }

    @Override
    public void enableSuperProtection(int ms) {
        if (ms <= 0) {
            return;
        }
        long nextTime = System.currentTimeMillis() + (long)ms;
        if (nextTime > this.superProtectionExpiration) {
            this.superProtectionExpiration = nextTime;
        }
    }

    @Override
    public void clearSuperProtection() {
        this.superProtectionExpiration = 0L;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    @Override
    public void disable() {
        this.loading = true;
    }

    @Override
    public boolean isLoading() {
        return this.loading;
    }

    public void setUnloading(boolean unloading) {
        this.unloading = unloading;
    }

    public boolean isUnloading() {
        return this.unloading;
    }

    @Override
    public boolean hasPending() {
        if (this.undoQueue != null && this.undoQueue.hasScheduled()) {
            return true;
        }
        return this.hasPendingBatches();
    }

    @Override
    public boolean isValid() {
        if (this.forget) {
            return false;
        }
        if (!this.hasEntity) {
            return true;
        }
        Entity entity = this.getEntity();
        if (entity == null || !entity.isValid()) {
            return false;
        }
        if (!this.isNPC && entity instanceof Player) {
            Player player = (Player)entity;
            return player.isOnline();
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return !living.isDead();
        }
        return true;
    }

    @Override
    public boolean restoreWand() {
        Wand tempWand;
        String template;
        ItemStack[] inventory;
        if (this.boundWands.size() == 0) {
            return false;
        }
        Player player = this.getPlayer();
        if (player == null) {
            return false;
        }
        HashSet<String> foundTemplates = new HashSet<String>();
        for (ItemStack item : inventory = this.getInventory().getContents()) {
            if (!Wand.isWand(item) || (template = (tempWand = this.controller.getWand(item)).getTemplateKey()) == null) continue;
            foundTemplates.add(template);
        }
        for (ItemStack item : inventory = player.getEnderChest().getContents()) {
            if (!Wand.isWand(item) || (template = (tempWand = this.controller.getWand(item)).getTemplateKey()) == null) continue;
            foundTemplates.add(template);
        }
        int givenWands = 0;
        for (Map.Entry<String, Wand> wandEntry : this.boundWands.entrySet()) {
            String templateKey = wandEntry.getKey();
            if (foundTemplates.contains(templateKey)) continue;
            WandTemplate template2 = this.controller.getWandTemplate(templateKey);
            Wand wand = wandEntry.getValue();
            if (template2 == null || !wand.isBound()) continue;
            ++givenWands;
            ItemStack wandItem = wand.duplicate().getItem();
            wandItem.setAmount(1);
            this.giveItem(wandItem);
        }
        return givenWands > 0;
    }

    @Override
    public boolean isStealth() {
        if (this.isSneaking()) {
            return true;
        }
        return this.activeWand != null && this.activeWand.isStealth();
    }

    @Override
    public boolean isSneaking() {
        Player player = this.getPlayer();
        return player != null && player.isSneaking();
    }

    @Override
    public boolean isJumping() {
        Entity entity = this.getEntity();
        return entity != null && !entity.isOnGround();
    }

    @Override
    public ConfigurationSection getData() {
        if (this.loading) {
            return ConfigurationUtils.newConfigurationSection();
        }
        return this.data;
    }

    public void onGUIDeactivate() {
        GUIAction previousGUI = this.gui;
        this.gui = null;
        Player player = this.getPlayer();
        if (player != null) {
            CompatibilityLib.getDeprecatedUtils().updateInventory(player);
        }
        if (previousGUI != null) {
            previousGUI.deactivated();
        }
    }

    @Override
    public void activateGUI(GUIAction action, Inventory inventory) {
        Player player = this.getPlayer();
        if (player != null) {
            this.controller.disableItemSpawn();
            try {
                player.closeInventory();
                if (inventory != null) {
                    this.gui = action;
                    player.openInventory(inventory);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            this.controller.enableItemSpawn();
        }
        this.gui = action;
    }

    @Override
    public void continueGUI(GUIAction action, Inventory inventory) {
        Player player = this.getPlayer();
        if (player != null) {
            this.controller.disableItemSpawn();
            try {
                if (inventory != null) {
                    this.gui = action;
                    player.openInventory(inventory);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            this.controller.enableItemSpawn();
        }
        this.gui = action;
    }

    @Override
    public void deactivateGUI() {
        this.activateGUI(null, null);
    }

    @Override
    public GUIAction getActiveGUI() {
        return this.gui;
    }

    @Override
    public int getDebugLevel() {
        return this.debugLevel;
    }

    @Override
    public void setDebugger(CommandSender sender) {
        this.debugger = new WeakReference<CommandSender>(sender);
    }

    @Override
    @Nullable
    public CommandSender getDebugger() {
        return this.debugger == null ? null : (CommandSender)this.debugger.get();
    }

    @Override
    public void setDebugLevel(int debugLevel) {
        this.debugLevel = debugLevel;
    }

    @Override
    public void debugBrain(CommandSender sender) {
        Entity entity = this.getEntity();
        if (entity != null && !(entity instanceof Player)) {
            this.debugMob(sender, entity);
        }
    }

    public void debugMob(CommandSender sender, Entity entity) {
        UUID uUID;
        Creature creature;
        LivingEntity currentTarget;
        Collection<String> targetGoals;
        String mobType = this.entityData != null ? this.entityData.getName() + ChatColor.DARK_GRAY + " (" + ChatColor.GRAY + this.entityData.getKey() + ChatColor.DARK_GRAY + ")" : entity.getType().name().toLowerCase();
        sender.sendMessage(ChatColor.DARK_AQUA + "Mob type: " + ChatColor.AQUA + mobType);
        Collection<String> goals = CompatibilityLib.getMobUtils().getGoalDescriptions(entity);
        if (goals != null && !goals.isEmpty()) {
            sender.sendMessage(ChatColor.YELLOW + "Current goals:");
            for (String string : goals) {
                sender.sendMessage(" " + string);
            }
        }
        if ((targetGoals = CompatibilityLib.getMobUtils().getTargetGoalDescriptions(entity)) != null && !targetGoals.isEmpty()) {
            sender.sendMessage(ChatColor.YELLOW + "Current targets:");
            for (String goal : targetGoals) {
                sender.sendMessage(" " + goal);
            }
        }
        if (entity instanceof Creature && (currentTarget = (creature = (Creature)entity).getTarget()) != null) {
            String mobName = currentTarget.getCustomName();
            if (mobName == null || mobName.isEmpty()) {
                mobName = currentTarget.getName();
            }
            if (mobName == null || mobName.isEmpty()) {
                mobName = currentTarget.getType().name().toLowerCase();
            }
            sender.sendMessage(ChatColor.YELLOW + "Targeting: " + ChatColor.GOLD + mobName);
        }
        if ((uUID = CompatibilityLib.getCompatibilityUtils().getOwnerId(entity)) != null) {
            sender.sendMessage(ChatColor.GREEN + "Owner: " + ChatColor.GRAY + uUID);
        }
    }

    @Override
    public void debugPermissions(CommandSender sender, Spell spell) {
        Wand wand = this.getActiveWand();
        Location location = this.getLocation();
        if (spell == null && wand != null) {
            spell = wand.getActiveSpell();
        }
        sender.sendMessage(ChatColor.GOLD + "Permission check for " + ChatColor.AQUA + this.getDisplayName());
        sender.sendMessage(ChatColor.GOLD + "  id " + ChatColor.DARK_AQUA + this.getId());
        sender.sendMessage(ChatColor.YELLOW + " On " + ChatColor.GRAY + location.getBlock().getRelative(BlockFace.DOWN).getType().name().toLowerCase() + ChatColor.YELLOW + " at " + TextUtils.printBlockLocation(location) + " " + ChatColor.DARK_BLUE + location.getWorld().getName());
        Player player = this.getPlayer();
        boolean hasBypass = false;
        boolean hasPVPBypass = false;
        boolean hasBuildBypass = false;
        boolean hasBreakBypass = false;
        if (player != null) {
            Block lookingAt = player.getTargetBlock(new HashSet<Material>(this.controller.getMaterialSetManager().getMaterialSet("all_air").getMaterials()), 128);
            if (lookingAt != null) {
                sender.sendMessage(ChatColor.YELLOW + " Looking at " + ChatColor.GRAY + lookingAt.getType().name().toLowerCase() + ChatColor.YELLOW + " at " + TextUtils.printBlockLocation(location));
            }
            hasBypass = this.controller.hasBypassPermission((CommandSender)player);
            hasPVPBypass = player.hasPermission("magic.bypass_pvp");
            hasBuildBypass = player.hasPermission("magic.bypass_build");
            sender.sendMessage(ChatColor.AQUA + " Has bypass: " + Mage.formatBoolean(hasBypass, true, null));
            sender.sendMessage(ChatColor.AQUA + " Has PVP bypass: " + Mage.formatBoolean(hasPVPBypass, true, null));
            sender.sendMessage(ChatColor.AQUA + " Has Build bypass: " + Mage.formatBoolean(hasBuildBypass, true, null));
            sender.sendMessage(ChatColor.AQUA + " Has Break bypass: " + Mage.formatBoolean(hasBreakBypass, true, null));
        }
        boolean buildPermissionRequired = spell == null ? false : spell.requiresBuildPermission();
        boolean breakPermissionRequired = spell == null ? false : spell.requiresBreakPermission();
        boolean pvpRestricted = spell == null ? false : spell.isPvpRestricted();
        sender.sendMessage(ChatColor.AQUA + " Can build: " + Mage.formatBoolean(this.hasBuildPermission(location.getBlock()), hasBuildBypass || !buildPermissionRequired ? null : Boolean.valueOf(true)));
        sender.sendMessage(ChatColor.AQUA + " Can break: " + Mage.formatBoolean(this.hasBreakPermission(location.getBlock()), hasBreakBypass || !breakPermissionRequired ? null : Boolean.valueOf(true)));
        sender.sendMessage(ChatColor.AQUA + " Can pvp: " + Mage.formatBoolean(this.isPVPAllowed(location), hasPVPBypass || !pvpRestricted ? null : Boolean.valueOf(true)));
        boolean isPlayer = player != null;
        boolean spellDisguiseRestricted = spell == null ? false : spell.isDisguiseRestricted();
        sender.sendMessage(ChatColor.AQUA + " Is disguised: " + Mage.formatBoolean(this.controller.isDisguised(this.getEntity()), null, isPlayer && spellDisguiseRestricted ? Boolean.valueOf(true) : null));
        WorldBorder border = location.getWorld().getWorldBorder();
        double borderSize = border.getSize();
        if (borderSize < 5.0E7) {
            borderSize = borderSize / 2.0 - (double)border.getWarningDistance();
            Location offset = location.subtract(border.getCenter());
            boolean isOutsideBorder = offset.getX() < -borderSize || offset.getX() > borderSize || offset.getZ() < -borderSize || offset.getZ() > borderSize;
            sender.sendMessage(ChatColor.AQUA + " Is in world border (" + ChatColor.GRAY + borderSize + ChatColor.AQUA + "): " + Mage.formatBoolean(!isOutsideBorder, true, false));
        }
        if (spell != null) {
            sender.sendMessage(ChatColor.AQUA + " Has pnode " + ChatColor.GOLD + spell.getPermissionNode() + ChatColor.AQUA + ": " + Mage.formatBoolean(spell.hasCastPermission((CommandSender)player), hasBypass ? null : Boolean.valueOf(true)));
            sender.sendMessage(ChatColor.AQUA + " Region override: " + Mage.formatBoolean(this.controller.getRegionCastPermission(player, spell, location), hasBypass ? null : Boolean.valueOf(true)));
            sender.sendMessage(ChatColor.AQUA + " Field override: " + Mage.formatBoolean(this.controller.getPersonalCastPermission(player, spell, location), hasBypass ? null : Boolean.valueOf(true)));
            MaterialBrush brush = spell.getBrush();
            if (brush != null) {
                sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " is erase: " + Mage.formatBoolean(brush.isErase(), null));
            }
            sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " requires build: " + Mage.formatBoolean(spell.requiresBuildPermission(), null, true, true));
            sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " requires break: " + Mage.formatBoolean(spell.requiresBreakPermission(), null, true, true));
            sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " requires pvp: " + Mage.formatBoolean(spell.isPvpRestricted(), null, true, true));
            sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " allowed while disguised: " + Mage.formatBoolean(!spell.isDisguiseRestricted(), null, false, true));
            if (spell instanceof BaseSpell) {
                boolean buildPermission = ((BaseSpell)spell).hasBuildPermission(location.getBlock());
                sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " has build: " + Mage.formatBoolean(buildPermission, hasBuildBypass || !spell.requiresBuildPermission() ? null : Boolean.valueOf(true)));
                boolean breakPermission = ((BaseSpell)spell).hasBreakPermission(location.getBlock());
                sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " has break: " + Mage.formatBoolean(breakPermission, hasBreakBypass || !spell.requiresBreakPermission() ? null : Boolean.valueOf(true)));
            }
            sender.sendMessage(ChatColor.AQUA + " Can cast " + ChatColor.GOLD + spell.getName() + ChatColor.AQUA + ": " + Mage.formatBoolean(spell.canCast(location)));
        }
    }

    public static String formatBoolean(Boolean flag, Boolean greenState) {
        return Mage.formatBoolean(flag, greenState, greenState == null ? null : Boolean.valueOf(greenState == false), false);
    }

    public static String formatBoolean(Boolean flag) {
        return Mage.formatBoolean(flag, true, false, false);
    }

    public static String formatBoolean(Boolean flag, Boolean greenState, Boolean redState) {
        return Mage.formatBoolean(flag, greenState, redState, false);
    }

    public static String formatBoolean(Boolean flag, Boolean greenState, Boolean redState, boolean dark) {
        String text;
        if (flag == null) {
            return ChatColor.GRAY + "none";
        }
        String string = text = flag != false ? "true" : "false";
        if (greenState != null && Objects.equal((Object)flag, (Object)greenState)) {
            return (dark ? ChatColor.DARK_GREEN : ChatColor.GREEN) + text;
        }
        if (redState != null && Objects.equal((Object)flag, (Object)redState)) {
            return (dark ? ChatColor.DARK_RED : ChatColor.RED) + text;
        }
        return ChatColor.GRAY + text;
    }

    @Override
    public void sendDebugMessage(String message) {
        this.sendDebugMessage(message, 1);
    }

    @Override
    public void sendDebugMessage(String message, int level) {
        if (this.debugLevel >= level && message != null && !message.isEmpty()) {
            CommandSender sender = this.getDebugger();
            if (sender == null) {
                sender = this.getCommandSender();
            }
            if (sender != null) {
                sender.sendMessage(this.controller.getMessagePrefix() + message);
            }
        }
    }

    public void clearRespawnInventories() {
        this.respawnItems = null;
        this.respawnArmor = null;
        this.respawnInventory = null;
    }

    public void addRespawnInventories(List<ItemStack> items) {
        if (this.respawnArmor != null) {
            items.addAll(this.respawnArmor.values());
        }
        if (this.respawnInventory != null) {
            items.addAll(this.respawnInventory.values());
        }
        if (this.respawnItems != null) {
            items.addAll(this.respawnItems);
        }
    }

    public void restoreRespawnInventories() {
        ItemStack item;
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        boolean updated = false;
        PlayerInventory inventory = player.getInventory();
        List<ItemStack> addToInventory = null;
        if (this.respawnItems != null) {
            this.controller.info("** Restoring " + this.respawnItems.size() + " items", 15);
            addToInventory = this.respawnItems;
        }
        if (this.respawnArmor != null) {
            this.controller.info("** Restoring " + this.respawnArmor.size() + " armor items", 15);
            ItemStack[] armor = inventory.getArmorContents();
            for (Map.Entry<Integer, ItemStack> entry : this.respawnArmor.entrySet()) {
                item = entry.getValue();
                if (CompatibilityLib.getItemUtils().isEmpty(item)) continue;
                int index = entry.getKey();
                ItemStack existing = armor[index];
                if (!CompatibilityLib.getItemUtils().isEmpty(existing)) {
                    this.controller.info("*** Restoring armor " + TextUtils.nameItem(item) + " in slot " + index + " but found item " + TextUtils.nameItem(existing), 18);
                    if (addToInventory == null) {
                        addToInventory = new ArrayList<ItemStack>();
                    }
                    addToInventory.add(existing);
                }
                updated = true;
                armor[index] = item;
            }
            if (updated) {
                player.getInventory().setArmorContents(armor);
            }
        }
        if (this.respawnInventory != null) {
            this.controller.info("** Restoring " + this.respawnInventory.size() + " inventory items", 15);
            for (Map.Entry entry : this.respawnInventory.entrySet()) {
                int slot = (Integer)entry.getKey();
                item = (ItemStack)entry.getValue();
                if (slot < 0) {
                    if (addToInventory == null) {
                        addToInventory = new ArrayList<ItemStack>();
                    }
                    addToInventory.add(item);
                    continue;
                }
                if (CompatibilityLib.getItemUtils().isEmpty(item)) continue;
                updated = true;
                ItemStack existing = inventory.getItem(slot);
                if (!CompatibilityLib.getItemUtils().isEmpty(existing)) {
                    this.controller.info("*** Restoring item " + TextUtils.nameItem(item) + " in slot " + slot + " but found item " + TextUtils.nameItem(existing), 18);
                    if (addToInventory == null) {
                        addToInventory = new ArrayList<ItemStack>();
                    }
                    addToInventory.add(existing);
                }
                inventory.setItem(slot, item);
            }
        }
        if (addToInventory != null) {
            for (ItemStack itemStack : addToInventory) {
                if (CompatibilityLib.getItemUtils().isEmpty(itemStack)) continue;
                HashMap returned = inventory.addItem(new ItemStack[]{itemStack});
                if (returned.isEmpty()) continue;
                this.controller.info("*** Restoring item " + TextUtils.nameItem(itemStack) + " but inventory was full, dropping", 18);
                player.getWorld().dropItem(player.getLocation(), itemStack);
            }
        }
        this.clearRespawnInventories();
        if (updated) {
            this.controller.getPlugin().getServer().getScheduler().runTaskLater(this.controller.getPlugin(), (Runnable)new ArmorUpdatedTask(this), 1L);
        }
    }

    public void onRespawn() {
        this.restoreRespawnInventories();
        this.checkWand();
        Inventory inventory = this.getInventory();
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (CompatibilityLib.getItemUtils().isEmpty(item) || !CompatibilityLib.getNBTUtils().getBoolean(item, "return_on_death", false)) continue;
            ItemStack replacement = CompatibilityLib.getItemUtils().getReplacement(item);
            this.controller.info("Replacing item on respawn: " + TextUtils.nameItem(item) + " with " + TextUtils.nameItem(replacement));
            inventory.setItem(i, replacement);
        }
        this.trigger("respawn");
    }

    public void addToRespawnInventory(ItemStack item) {
        if (this.respawnItems == null) {
            this.respawnItems = new ArrayList<ItemStack>();
        }
        this.respawnItems.add(item);
    }

    public void addToRespawnInventory(int slot, ItemStack item) {
        if (this.respawnInventory == null) {
            this.respawnInventory = new HashMap<Integer, ItemStack>();
        }
        if (this.respawnInventory.containsKey(slot)) {
            this.addToRespawnInventory(item);
        } else {
            this.respawnInventory.put(slot, item);
        }
    }

    public void addToRespawnArmor(int slot, ItemStack item) {
        if (this.respawnArmor == null) {
            this.respawnArmor = new HashMap<Integer, ItemStack>();
        }
        if (this.respawnArmor.containsKey(slot)) {
            this.addToRespawnInventory(item);
        } else {
            this.respawnArmor.put(slot, item);
        }
    }

    @Override
    public void setArmorItem(int armorSlot, ItemStack itemStack) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        if (player.isDead()) {
            this.addToRespawnArmor(armorSlot, itemStack);
            return;
        }
        ItemStack[] armor = player.getInventory().getArmorContents();
        armor[armorSlot] = itemStack;
        player.getInventory().setArmorContents(armor);
    }

    @Override
    public boolean giveItem(ItemStack itemStack, boolean putInHand, boolean allowDropping) {
        if (!this.tryGiveItem(itemStack, putInHand)) {
            Item item;
            if (!allowDropping || CompatibilityLib.getNBTUtils().getBoolean(itemStack, "undroppable", false)) {
                return false;
            }
            Entity entity = this.getEntity();
            if (!(entity == null || (item = entity.getWorld().dropItem(entity.getLocation(), itemStack)) != null && item.isValid())) {
                this.controller.getLogger().warning("Tried to give an item to a player with a full inventory and couldn't spawn item entity: " + itemStack);
            }
        }
        return true;
    }

    @Override
    public void giveItem(ItemStack itemStack, boolean putInHand) {
        this.giveItem(itemStack, putInHand, true);
    }

    @Override
    public void giveItem(ItemStack itemStack) {
        this.giveItem(itemStack, true, true);
    }

    @Override
    public boolean tryGiveItem(ItemStack itemStack, boolean putInHand) {
        if (putInHand) {
            return this.tryGiveItem(itemStack);
        }
        Player player = this.getPlayer();
        if (player == null) {
            return true;
        }
        if (player.isDead()) {
            this.controller.info("** Giving item while dead: " + TextUtils.nameItem(itemStack));
            this.addToRespawnInventory(itemStack);
            return true;
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack inHand = inventory.getItemInMainHand();
        Integer freeSlot = null;
        if (CompatibilityLib.getItemUtils().isEmpty(inHand)) {
            for (int i = 0; i < inventory.getSize() && freeSlot == null; ++i) {
                if (i == inventory.getHeldItemSlot() || !CompatibilityLib.getItemUtils().isEmpty(inventory.getItem(i))) continue;
                freeSlot = i;
            }
        }
        if (freeSlot == null) {
            return this.tryGiveItem(itemStack);
        }
        inventory.setItem(freeSlot.intValue(), itemStack);
        return true;
    }

    @Override
    public boolean tryGiveItem(ItemStack itemStack) {
        Wand wand;
        if (CompatibilityLib.getItemUtils().isEmpty(itemStack)) {
            return true;
        }
        Player player = this.getPlayer();
        if (player == null) {
            return true;
        }
        if (this.controller.isBindOnGive() && Wand.isWand(itemStack) && (wand = this.controller.getWand(itemStack)).isBound()) {
            wand.tryToOwn(player);
            itemStack = wand.getItem();
        }
        if (player.isDead()) {
            this.controller.info("** Giving item while dead: " + TextUtils.nameItem(itemStack));
            this.addToRespawnInventory(itemStack);
            return true;
        }
        if (this.hasStoredInventory()) {
            return this.addToStoredInventory(itemStack);
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack inHand = inventory.getItemInMainHand();
        if (inHand == null || inHand.getType() == Material.AIR) {
            inventory.setItemInMainHand(itemStack);
            itemStack = inventory.getItemInMainHand();
            if (Wand.isWand(itemStack)) {
                this.checkWand();
            } else {
                this.setLastHeldItem(itemStack);
            }
        } else {
            HashMap returned = player.getInventory().addItem(new ItemStack[]{itemStack});
            return returned.isEmpty();
        }
        return true;
    }

    public void armorUpdated() {
        this.activeArmor.clear();
        Player player = this.getPlayer();
        if (player != null) {
            boolean changed = false;
            ItemStack[] armor = player.getInventory().getArmorContents();
            for (int index = 0; index < armor.length; ++index) {
                ItemStack armorItem = armor[index];
                if (CompatibilityLib.getItemUtils().isEmpty(armorItem)) continue;
                if (!this.canUse(armorItem)) {
                    this.sendMessage(this.controller.getMessages().get("mage.no_class").replace("$name", this.controller.describeItem(armorItem)));
                    changed = true;
                    armor[index] = null;
                    this.giveItem(armorItem);
                    continue;
                }
                if (!Wand.isWand(armorItem)) continue;
                this.activeArmor.put(InventorySlot.getArmorSlot(index), this.controller.getWand(armorItem));
            }
            if (changed) {
                player.getInventory().setArmorContents(armor);
            }
        }
        this.updatePassiveEffects();
    }

    protected void addPassiveEffectsGroup(Map<String, Double> properties, CasterProperties addProperties, String section, boolean stack, double maxValue) {
        ConfigurationSection addSection = addProperties.getConfigurationSection(section);
        if (addSection != null) {
            Set sectionTypes = addSection.getKeys(false);
            for (String sectionType : sectionTypes) {
                Double existing = properties.get(sectionType);
                if (existing == null) {
                    existing = 0.0;
                }
                double addValue = addSection.getDouble(sectionType);
                existing = stack ? Double.valueOf(Math.min(maxValue, existing + addValue)) : Double.valueOf(Math.max(existing, addValue));
                properties.put(sectionType, existing);
            }
        }
    }

    protected void addPassiveAttributes(CasterProperties properties) {
        this.addPassiveAttributes(properties, AttributeOperation.MAXIMUM, InventorySlot.FREE);
    }

    protected void addPassiveAttributes(CasterProperties addProperties, AttributeOperation defaultOperation, InventorySlot slot) {
        List<MagicAttributeModifier> modifiers;
        if (addProperties.getBoolean("stack", false)) {
            defaultOperation = AttributeOperation.ADD_NUMBER;
        }
        if ((modifiers = addProperties.getAttributes()) != null) {
            for (MagicAttributeModifier modifier : modifiers) {
                Double minValue;
                Double maxValue;
                String attributeKey = modifier.getAttribute();
                MagicAttribute magicAttribute = this.controller.getAttribute(attributeKey);
                Double attributeValue = this.attributes.get(attributeKey);
                if (attributeValue == null) {
                    if (magicAttribute != null) {
                        attributeValue = magicAttribute.getDefault();
                    }
                    if (attributeValue == null) {
                        attributeValue = 0.0;
                    }
                }
                InventorySlot modifierSlot = modifier.getSlot();
                if (slot != InventorySlot.FREE && modifierSlot != InventorySlot.FREE && modifierSlot != slot) continue;
                double modifierValue = modifier.getValue();
                AttributeOperation operation = modifier.getOperation();
                if (operation == AttributeOperation.DEFAULT) {
                    operation = defaultOperation;
                }
                switch (operation) {
                    case ADD_NUMBER: {
                        attributeValue = attributeValue + modifierValue;
                        break;
                    }
                    case ADD_SCALAR: {
                        attributeValue = attributeValue * modifierValue;
                        break;
                    }
                    case MULTIPLY_SCALAR_1: {
                        attributeValue = attributeValue * (modifierValue + 1.0);
                        break;
                    }
                    case MAXIMUM: {
                        attributeValue = Math.max(modifierValue, attributeValue);
                        break;
                    }
                    default: {
                        this.controller.getLogger().warning("Unhandled modifier operation: " + (Object)((Object)operation));
                    }
                }
                Double d = maxValue = magicAttribute == null ? null : magicAttribute.getMax();
                if (maxValue != null) {
                    attributeValue = Math.min(maxValue, attributeValue);
                }
                Double d2 = minValue = magicAttribute == null ? null : magicAttribute.getMin();
                if (minValue != null) {
                    attributeValue = Math.max(minValue, attributeValue);
                }
                this.attributes.put(attributeKey, attributeValue);
            }
        }
    }

    protected void addPassiveEffects(CasterProperties properties, boolean activeReduction) {
        this.spEarnMultiplier = (float)((double)this.spEarnMultiplier * properties.getDouble("earn_multiplier", properties.getDouble("sp_multiplier", 1.0)));
        this.manaRegenerationBoost += properties.getFloat("mana_regeneration_boost", 0.0f);
        this.manaMaxBoost += properties.getFloat("mana_max_boost", 0.0f);
        this.healthScale = Math.max(this.healthScale, properties.getDouble("health_scale"));
        this.manaPerDamage += properties.getFloat("mana_per_damage");
        this.blockChance = Math.max(this.blockChance, properties.getFloat("block_chance"));
        this.blockReflectChance = Math.max(this.blockReflectChance, properties.getFloat("block_reflect_chance"));
        this.blockFOV = Math.max(this.blockFOV, properties.getFloat("block_fov"));
        this.blockMageCooldown = Math.max(this.blockMageCooldown, properties.getInt("block_mage_cooldown"));
        this.blockCooldown = Math.max(this.blockCooldown, properties.getInt("block_cooldown"));
        this.reflectChance = Math.max(this.reflectChance, properties.getFloat("reflect_chance"));
        this.reflectFOV = Math.max(this.reflectFOV, properties.getFloat("reflect_fov"));
        this.reflectCooldown = Math.max(this.reflectCooldown, properties.getInt("reflect_cooldown"));
        boolean stack = properties.getBoolean("stack", false);
        this.addPassiveEffectsGroup(this.protection, properties, "protection", stack, 1.0);
        this.addPassiveEffectsGroup(this.weakness, properties, "weakness", stack, 1.0);
        this.addPassiveEffectsGroup(this.strength, properties, "strength", stack, 1.0);
        if (properties.getBoolean("ignore_particles")) {
            this.ignoreParticles = true;
        }
        if (properties.isCostFree()) {
            this.costFree = true;
        }
        if (properties.isConsumeFree()) {
            this.consumeFree = true;
        }
        if (properties.isCooldownFree()) {
            this.cooldownFree = true;
        }
        if (activeReduction || properties.isPassive() || stack) {
            if (stack) {
                this.cooldownReduction = this.stackValue(this.cooldownReduction, properties.getFloat("cooldown_reduction", 0.0f));
                this.costReduction = this.stackValue(this.costReduction, properties.getFloat("cost_reduction", 0.0f));
                this.consumeReduction = this.stackValue(this.consumeReduction, properties.getFloat("consume_reduction", 0.0f));
            } else {
                this.cooldownReduction = Math.max(this.cooldownReduction, properties.getFloat("cooldown_reduction", 0.0f));
                this.costReduction = Math.max(this.costReduction, properties.getFloat("cost_reduction", 0.0f));
                this.consumeReduction = Math.max(this.consumeReduction, properties.getFloat("consume_reduction", 0.0f));
            }
        }
        if (!this.superProtected && properties.getBoolean("protected")) {
            this.superProtected = true;
        }
        if (!this.superPowered && properties.getBoolean("powered")) {
            this.superPowered = true;
        }
        if (!this.ignoredByMobs && properties.getBoolean("ignored_by_mobs")) {
            this.ignoredByMobs = true;
        }
        if (!this.allowContainerCopy && properties.getBoolean("allow_container_copy")) {
            this.allowContainerCopy = true;
        }
        this.effectivePotionEffects.putAll(properties.getPotionEffects());
        Map<String, String> overrides = properties.getOverrides();
        if (overrides != null) {
            for (Map.Entry<String, String> entry : overrides.entrySet()) {
                List<CastParameter> spellParameters;
                String[] path = StringUtils.split((String)entry.getKey(), (String)".", (int)2);
                if (path.length == 0) continue;
                String key = path.length == 1 ? path[0] : path[1];
                String spell = "";
                CastParameter parameter = new CastParameter(key, entry.getValue());
                if (path.length > 1 && !path[1].equals("default")) {
                    spell = path[0];
                }
                if ((spellParameters = this.castOverrides.get(spell)) == null) {
                    spellParameters = new ArrayList<CastParameter>();
                    this.castOverrides.put(spell, spellParameters);
                }
                spellParameters.add(parameter);
            }
        }
        for (String spellKey : properties.getSpells()) {
            Collection<Trigger> spellTriggers;
            SpellTemplate spell;
            if (this.triggeredSpells.contains(spellKey) || (spell = this.controller.getSpellTemplate(spellKey)) == null || (spellTriggers = spell.getTriggers()) == null) continue;
            this.triggeredSpells.add(spellKey);
            for (Trigger trigger : spellTriggers) {
                String triggerType = trigger.getTrigger();
                List<TriggeredSpell> typeTriggers = this.triggers.get(triggerType);
                if (typeTriggers == null) {
                    typeTriggers = new ArrayList<TriggeredSpell>();
                    this.triggers.put(triggerType, typeTriggers);
                }
                typeTriggers.add(new TriggeredSpell(spellKey, trigger));
            }
        }
    }

    protected float stackValue(float currentValue, float stackValue) {
        return Math.min(1.0f, stackValue + currentValue);
    }

    protected void addModifiers(CasterProperties properties, Set<String> modifierKeys) {
        List<String> modifiers = properties.getStringList("modifiers");
        if (modifiers != null) {
            modifierKeys.addAll(modifiers);
        }
    }

    private void updateModifiers() {
        HashSet<String> modifierKeys = new HashSet<String>();
        this.addModifiers(this.properties, modifierKeys);
        if (this.activeClass != null) {
            this.addModifiers(this.activeClass, modifierKeys);
        }
        for (MageClass mageClass : this.classes.values()) {
            if (mageClass == this.activeClass || mageClass.isLocked() || !mageClass.isPassive()) continue;
            this.addModifiers(mageClass, modifierKeys);
        }
        if (this.activeWand != null && !this.activeWand.isWorn()) {
            this.addModifiers(this.activeWand, modifierKeys);
        }
        if (this.offhandWand != null && !this.offhandWand.isWorn()) {
            this.addModifiers(this.offhandWand, modifierKeys);
        }
        for (Wand wand : this.activeArmor.values()) {
            if (wand == null) continue;
            this.addModifiers(wand, modifierKeys);
        }
        Set<String> currentKeys = this.modifiers.keySet();
        for (String string : modifierKeys) {
            if (currentKeys.contains(string)) continue;
            this.applyModifier(string);
        }
        modifierKeys.addAll(this.transientModifiers.keySet());
        if (!currentKeys.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>(currentKeys);
            for (String currentKey : arrayList) {
                if (modifierKeys.contains(currentKey)) continue;
                this.unapplyModifier(currentKey);
            }
        }
        for (Map.Entry<String, MageModifier> entry : this.transientModifiers.entrySet()) {
            String key = entry.getKey();
            if (currentKeys.contains(key)) continue;
            this.applyModifier(key, entry.getValue());
        }
    }

    private void countSets(Wand wand, boolean isArmor) {
        if (wand == null || wand.isWorn() && !isArmor) {
            return;
        }
        wand.clearSetBonuses();
        ConfigurationSection sets = wand.getSets();
        if (sets == null) {
            return;
        }
        Set keys = sets.getKeys(false);
        for (String key : keys) {
            ActiveWandSet wandSet = this.wandSets.get(key);
            if (wandSet == null) {
                wandSet = new ActiveWandSet(key);
                this.wandSets.put(key, wandSet);
            }
            wandSet.add(wand, sets.getConfigurationSection(key));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updatePassiveEffects() {
        void var4_9;
        this.updateModifiers();
        this.attributes.clear();
        double previousHealthScale = this.healthScale;
        this.healthScale = 0.0;
        this.ignoreParticles = false;
        this.manaPerDamage = 0.0f;
        this.blockChance = 0.0f;
        this.blockReflectChance = 0.0f;
        this.blockFOV = 0.0f;
        this.blockMageCooldown = 0;
        this.blockCooldown = 0;
        this.reflectChance = 0.0f;
        this.reflectFOV = 0.0f;
        this.addPassiveAttributes(this.properties);
        if (this.activeClass != null) {
            this.addPassiveAttributes(this.activeClass);
        }
        for (MageClass mageClass : this.classes.values()) {
            if (mageClass == this.activeClass || mageClass.isLocked() || !mageClass.isPassive()) continue;
            this.addPassiveAttributes(mageClass);
        }
        for (MageModifier mageModifier : this.modifiers.values()) {
            this.addPassiveAttributes(mageModifier, AttributeOperation.ADD_NUMBER, InventorySlot.FREE);
        }
        boolean hadSets = !this.wandSets.isEmpty();
        this.wandSets.clear();
        this.countSets(this.activeWand, false);
        this.countSets(this.offhandWand, false);
        for (Wand wand : this.activeArmor.values()) {
            this.countSets(wand, true);
        }
        Object var4_8 = null;
        for (Map.Entry<String, ActiveWandSet> entry : this.wandSets.entrySet()) {
            String setKey = entry.getKey();
            WandSet wandSet = this.controller.getWandSet(setKey);
            ActiveWandSet activeSet = entry.getValue();
            if (!activeSet.isActive(wandSet)) continue;
            WandProperties wandProperties = wandSet == null ? null : wandSet.getBonus();
            activeSet.applyBonuses();
        }
        if (hadSets || !this.wandSets.isEmpty()) {
            if (this.activeWand != null) {
                this.activeWand.updateLore();
            }
            if (this.offhandWand != null) {
                this.offhandWand.updateLore();
            }
            for (Wand wand : this.activeArmor.values()) {
                if (wand == null) continue;
                wand.updateLore();
            }
        }
        if (var4_9 != null) {
            this.addPassiveAttributes((CasterProperties)var4_9, AttributeOperation.ADD_NUMBER, InventorySlot.FREE);
        }
        if (this.activeWand != null && !this.activeWand.isWorn()) {
            this.addPassiveAttributes(this.activeWand, AttributeOperation.ADD_NUMBER, InventorySlot.MAIN_HAND);
        }
        if (this.offhandWand != null && !this.offhandWand.isWorn()) {
            this.addPassiveAttributes(this.offhandWand, AttributeOperation.ADD_NUMBER, InventorySlot.OFF_HAND);
        }
        for (Map.Entry<InventorySlot, Wand> entry : this.activeArmor.entrySet()) {
            Wand armorWand = entry.getValue();
            if (armorWand == null) continue;
            this.addPassiveAttributes(armorWand, AttributeOperation.ADD_NUMBER, entry.getKey());
        }
        this.reloadAttributes();
        this.protection.clear();
        this.strength.clear();
        this.weakness.clear();
        this.castOverrides.clear();
        this.superProtected = false;
        this.superPowered = false;
        this.ignoredByMobs = false;
        this.allowContainerCopy = false;
        for (List<TriggeredSpell> list : this.triggers.values()) {
            list.clear();
        }
        this.triggeredSpells.clear();
        this.spEarnMultiplier = 1.0f;
        this.cooldownReduction = 0.0f;
        this.costReduction = 0.0f;
        this.consumeReduction = 0.0f;
        this.manaMaxBoost = 0.0f;
        this.manaRegenerationBoost = 0.0f;
        this.cooldownFree = false;
        this.costFree = false;
        this.consumeFree = false;
        ArrayList<PotionEffectType> arrayList = new ArrayList<PotionEffectType>(this.effectivePotionEffects.keySet());
        LivingEntity livingEntity = this.getLivingEntity();
        this.effectivePotionEffects.clear();
        if (var4_9 != null) {
            this.addPassiveEffects((CasterProperties)var4_9, false);
        }
        this.addPassiveEffects(this.properties, true);
        if (this.activeClass != null) {
            this.addPassiveEffects(this.activeClass, true);
        }
        for (MageClass mageClass : this.classes.values()) {
            if (mageClass == this.activeClass || mageClass.isLocked() || !mageClass.isPassive()) continue;
            this.addPassiveEffects(mageClass, true);
        }
        for (MageModifier mageModifier : this.modifiers.values()) {
            this.addPassiveEffects(mageModifier, true);
        }
        if (this.activeWand != null && !this.activeWand.isWorn()) {
            this.addPassiveEffects(this.activeWand, false);
        }
        if (this.offhandWand != null && !this.offhandWand.isWorn()) {
            this.addPassiveEffects(this.offhandWand, false);
        }
        for (Wand wand : this.activeArmor.values()) {
            if (wand == null) continue;
            this.addPassiveEffects(wand, false);
        }
        if (livingEntity != null) {
            for (PotionEffectType potionEffectType : arrayList) {
                if (this.effectivePotionEffects.containsKey(potionEffectType)) continue;
                livingEntity.removePotionEffect(potionEffectType);
            }
            for (Map.Entry entry : this.effectivePotionEffects.entrySet()) {
                PotionEffect effect = new PotionEffect((PotionEffectType)entry.getKey(), Integer.MAX_VALUE, ((Integer)entry.getValue()).intValue(), true, false);
                CompatibilityLib.getCompatibilityUtils().applyPotionEffect(livingEntity, effect);
            }
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                EffectPlayer.ignorePlayer(player, this.ignoreParticles);
                if (previousHealthScale != this.healthScale) {
                    if (this.healthScale > 0.0) {
                        player.setHealthScale(this.healthScale);
                    } else {
                        player.setHealthScaled(false);
                    }
                }
            }
        }
        if (this.activeWand != null) {
            this.activeWand.passiveEffectsUpdated();
        } else if (this.activeClass != null) {
            this.activeClass.passiveEffectsUpdated();
        }
        if (this.offhandWand != null) {
            this.offhandWand.passiveEffectsUpdated();
        }
    }

    @Override
    public boolean allowContainerCopy() {
        return this.allowContainerCopy;
    }

    @Override
    public boolean isPreventDismount() {
        return this.preventDismount;
    }

    @Override
    public void setPreventDismount(boolean prevent) {
        this.preventDismount = prevent;
    }

    public Collection<Wand> getActiveArmor() {
        return this.activeArmor.values();
    }

    public void flagForReactivation() {
        this.restoreOpenWand = this.activeWand != null && this.activeWand.isInventoryOpen();
        for (Batch batch : this.pendingBatches) {
            SpellBatch spellBatch;
            Spell spell;
            if (!(batch instanceof SpellBatch) || !((spell = (spellBatch = (SpellBatch)batch).getSpell()) instanceof BaseSpell)) continue;
            ((BaseSpell)spell).flagForReactivation();
        }
        for (MageSpell spell : this.activeSpells) {
            if (!(spell instanceof BaseSpell)) continue;
            ((BaseSpell)spell).flagForReactivation();
        }
    }

    @Override
    public void deactivate() {
        this.deactivateWand();
        this.deactivateAllSpells(true, true);
        this.removeActiveEffects();
    }

    @Override
    public void undoScheduled(String spellKey) {
        if (this.undoQueue != null) {
            this.undoQueue.undoScheduled(spellKey);
        }
    }

    @Override
    public void undoScheduled() {
        int finished;
        int undid;
        if (this.undoQueue != null && (undid = this.undoQueue.undoScheduled()) != 0) {
            this.controller.info("Player " + this.getName() + " logging out, auto-undid " + undid + " spells");
        }
        if ((finished = this.finishPendingUndo()) != 0) {
            this.controller.info("Player " + this.getName() + " logging out, fast-forwarded undo for " + finished + " spells");
        }
        if (this.undoQueue != null && !this.undoQueue.isEmpty()) {
            if (this.controller.commitOnQuit()) {
                this.controller.info("Player logging out, committing constructions: " + this.getName());
                this.undoQueue.commit();
            } else {
                this.controller.info("Player " + this.getName() + " logging out with " + this.undoQueue.getSize() + " spells in their undo queue");
            }
        }
    }

    @Override
    public void removeItemsWithTag(String tag) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack[] contents = inventory.getContents();
        for (int index = 0; index < contents.length; ++index) {
            ItemStack item = contents[index];
            if (item == null || item.getType() == Material.AIR || !CompatibilityLib.getNBTUtils().containsTag(item, tag)) continue;
            inventory.setItem(index, null);
        }
        boolean modified = false;
        ItemStack[] armor = inventory.getArmorContents();
        for (int index = 0; index < armor.length; ++index) {
            ItemStack item = armor[index];
            if (item == null || item.getType() == Material.AIR || !CompatibilityLib.getNBTUtils().containsTag(item, tag)) continue;
            modified = true;
            armor[index] = null;
        }
        if (modified) {
            inventory.setArmorContents(armor);
        }
    }

    @Override
    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    @Override
    public boolean isQuiet() {
        return this.quiet;
    }

    public void setDestinationWarp(String warp) {
        this.destinationWarp = warp;
    }

    @Nullable
    private Currency initCurrency(String type) {
        Currency currency = this.controller.getCurrency(type);
        if (currency instanceof CustomCurrency && !this.data.contains(type)) {
            this.data.set(type, (Object)currency.getDefaultValue());
        }
        return currency;
    }

    @Override
    public double getCurrency(String type) {
        Currency currency = this.controller.getCurrency(type);
        if (currency == null) {
            return 0.0;
        }
        if (currency instanceof CustomCurrency) {
            return this.data.getDouble(type, currency.getDefaultValue());
        }
        return currency.getBalance(this);
    }

    private void queueCurrencyMessage(String currency, double amount) {
        if (CURRENCY_MESSAGE_DELAY <= 0 || !this.controller.getPlugin().isEnabled()) {
            this.sendCurrencyMessage(currency, amount);
            return;
        }
        BukkitScheduler scheduler = this.controller.getPlugin().getServer().getScheduler();
        CurrencyMessage pending = this.currencyMessages.get(currency);
        if (pending == null) {
            pending = new CurrencyMessage();
            this.currencyMessages.put(currency, pending);
        } else {
            amount += pending.amount;
            pending.timer.cancel();
        }
        pending.amount = amount;
        SendCurrencyMessageTask task = new SendCurrencyMessageTask(this, currency, amount);
        pending.timer = scheduler.runTaskLater(this.controller.getPlugin(), (Runnable)task, (long)(CURRENCY_MESSAGE_DELAY / 50));
    }

    @Override
    public void addCurrency(String type, double delta) {
        this.addCurrency(type, delta, false);
    }

    @Override
    public void addCurrency(String type, double delta, boolean quiet) {
        boolean isFirstEarn = !this.data.contains(type);
        Currency currency = this.initCurrency(type);
        if (currency instanceof CustomCurrency) {
            double previousValue = this.data.getDouble(type, currency.getDefaultValue());
            delta = this.doSetCurrency(currency, type, previousValue + delta);
        } else if (currency == null || !currency.give(this, delta)) {
            return;
        }
        if (!quiet) {
            this.queueCurrencyMessage(type, delta);
        }
        if (this.activeWand != null && this.activeWand.usesCurrency(type) && this.activeWand.usesInstructions()) {
            if (isFirstEarn && !quiet) {
                this.startInstructions();
                String message = this.activeWand.getMessage(currency.getKey() + "_earn_instructions", this.activeWand.getMessage("earn_instructions"));
                this.sendMessage(message.replace("$currency", currency.getName(this.controller.getMessages())));
                this.endInstructions();
            }
            this.activeWand.updateMana();
        }
    }

    @Override
    public void removeCurrency(String type, double delta) {
        this.removeCurrency(type, delta, false);
    }

    @Override
    public void removeCurrency(String type, double delta, boolean quiet) {
        Currency currency = this.initCurrency(type);
        if (currency == null) {
            this.controller.getLogger().warning("Trying to deduct unknown currency type: " + type);
            return;
        }
        if (currency instanceof CustomCurrency) {
            double previousValue = this.data.getDouble(type, currency.getDefaultValue());
            delta = this.doSetCurrency(currency, type, previousValue - delta);
        } else {
            currency.deduct(this, delta);
        }
        if (!quiet) {
            this.queueCurrencyMessage(type, delta);
        }
        if (this.activeWand != null && this.activeWand.usesCurrency(type)) {
            this.activeWand.updateMana();
        }
    }

    @Override
    public void setCurrency(String type, double amount) {
        this.doSetCurrency(type, amount);
    }

    private double doSetCurrency(String key, double newValue) {
        Currency currency = this.initCurrency(key);
        return this.doSetCurrency(currency, key, newValue);
    }

    private double doSetCurrency(Currency currency, String type, double newValue) {
        double delta;
        if (currency != null) {
            if (currency.hasMaxValue()) {
                newValue = Math.min(newValue, currency.getMaxValue());
            }
            if (currency.hasMinValue()) {
                newValue = Math.max(newValue, currency.getMinValue());
            }
            if (currency instanceof CustomCurrency) {
                delta = newValue - this.data.getDouble(type);
                this.data.set(type, (Object)newValue);
            } else {
                delta = newValue - currency.getBalance(this);
                if (delta < 0.0) {
                    currency.deduct(this, -delta);
                } else if (delta > 0.0) {
                    currency.give(this, delta);
                }
            }
        } else {
            delta = newValue - this.data.getDouble(type);
            this.data.set(type, (Object)newValue);
        }
        return delta;
    }

    @Override
    public boolean isAtMaxCurrency(String type) {
        Currency currency = this.controller.getCurrency(type);
        if (currency == null || !currency.hasMaxValue()) {
            return false;
        }
        double value = this.getCurrency(type);
        return value >= currency.getMaxValue();
    }

    @Override
    public boolean isAtMaxSkillPoints() {
        return this.isAtMaxCurrency("sp");
    }

    @Override
    public int getSkillPoints() {
        return (int)this.getCurrency("sp");
    }

    @Override
    public void setSkillPoints(int amount) {
        this.setCurrency("sp", amount);
    }

    @Override
    public void addSkillPoints(int delta) {
        this.addCurrency("sp", delta);
    }

    @Override
    public Wand getBoundWand(String template) {
        return this.boundWands.get(template);
    }

    @Override
    @Nullable
    public WandUpgradePath getBoundWandPath(String templateKey) {
        com.elmakers.mine.bukkit.api.wand.Wand boundWand = this.boundWands.get(templateKey);
        if (boundWand != null) {
            return boundWand.getPath();
        }
        return null;
    }

    public void setEntityData(EntityData entityData) {
        this.entityData = entityData;
        ConfigurationSection mageProperties = entityData.getMageProperties();
        if (mageProperties != null) {
            ConfigurationUtils.addConfigurations(this.properties.getConfiguration(), mageProperties);
            this.properties.loadProperties();
            this.updatePassiveEffects();
        }
        if (this.bossBar != null) {
            this.bossBar.remove();
        }
        this.bossBar = entityData.getBossBar(this);
        this.targeting = new MageTargeting(this);
    }

    public List<Wand> getBoundWands() {
        return ImmutableList.copyOf(this.boundWands.values());
    }

    public void updateHotbarStatus() {
        Player player = this.getPlayer();
        if (player != null) {
            boolean isWandInventory = this.hasStoredInventory();
            for (int i = 0; i < 9; ++i) {
                MageSpell spell;
                ItemStack spellItem = player.getInventory().getItem(i);
                String spellKey = Wand.getSpell(spellItem);
                String classKey = Wand.getSpellClass(spellItem);
                boolean isSkill = Wand.isSkill(spellItem);
                if (spellKey == null || !isSkill && !isWandInventory || (spell = this.getSpell(spellKey)) == null || !(spell instanceof BaseSpell)) continue;
                Long timeToCast = null;
                BaseSpell baseSpell = (BaseSpell)spell;
                int targetAmount = 1;
                MageClass mageClass = null;
                if (classKey != null && !classKey.isEmpty()) {
                    mageClass = this.getClass(classKey);
                }
                if (mageClass != null) {
                    baseSpell.setMageClass(mageClass);
                    timeToCast = baseSpell.getTimeToCast();
                    baseSpell.setMageClass(null);
                } else {
                    timeToCast = baseSpell.getTimeToCast();
                }
                boolean canCastSpell = timeToCast != null;
                boolean canCast = timeToCast != null && timeToCast == 0L;
                targetAmount = !canCastSpell ? 1 : (int)Math.ceil((double)timeToCast.longValue() / 1000.0);
                targetAmount = Math.max(Math.min(targetAmount, 99), 1);
                ItemStack newItem = baseSpell.updateItem(spellItem, canCast);
                if (newItem != null) {
                    spellItem = newItem;
                    player.getInventory().setItem(i, spellItem);
                }
                if (spellItem.getAmount() == targetAmount) continue;
                spellItem.setAmount(targetAmount);
            }
        }
    }

    public boolean isBlocking() {
        Player player = this.getPlayer();
        return player != null && player.isBlocking();
    }

    @Override
    public boolean isBlocked(double angle) {
        boolean isBlocked;
        if (!this.isBlocking()) {
            return false;
        }
        if (this.blockChance == 0.0f) {
            return false;
        }
        if (this.blockFOV > 0.0f && angle > (double)this.blockFOV) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (this.blockCooldown > 0 && this.lastBlockTime > 0L && this.lastBlockTime + (long)this.blockCooldown > now) {
            return false;
        }
        boolean bl = isBlocked = Math.random() <= (double)this.blockChance;
        if (isBlocked) {
            this.playEffects("spell_blocked");
            this.lastBlockTime = now;
        }
        return isBlocked;
    }

    @Override
    public boolean isReflected(double angle) {
        if (this.blockReflectChance == 0.0f && this.reflectChance == 0.0f) {
            return false;
        }
        if (this.reflectChance == 0.0f && !this.isBlocking()) {
            return false;
        }
        if (this.blockFOV > 0.0f && angle > (double)this.blockFOV) {
            return false;
        }
        if (this.reflectFOV > 0.0f && angle > (double)this.reflectFOV) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (this.reflectChance == 0.0f && this.blockCooldown > 0 && this.lastBlockTime > 0L && this.lastBlockTime + (long)this.blockCooldown > now) {
            return false;
        }
        if (this.reflectCooldown > 0 && this.lastReflectTime > 0L && this.lastReflectTime + (long)this.reflectCooldown > now) {
            return false;
        }
        double r = Math.random();
        if (this.blockReflectChance > 0.0f && r > (double)this.blockReflectChance) {
            return false;
        }
        if (this.reflectChance > 0.0f && r > (double)this.reflectChance) {
            return false;
        }
        this.playEffects("spell_reflected");
        if (this.reflectChance == 0.0f) {
            this.lastBlockTime = now;
        }
        this.lastReflectTime = now;
        return true;
    }

    @Override
    @Deprecated
    public float getSPMultiplier() {
        return (float)this.getEarnMultiplier("sp");
    }

    @Override
    @Deprecated
    public float getEarnMultiplier() {
        return (float)this.getEarnMultiplier("sp");
    }

    @Override
    public double getEarnMultiplier(String currency) {
        return currency.equals("sp") ? (double)this.spEarnMultiplier : 1.0;
    }

    @Override
    @Nonnull
    public MageProperties getProperties() {
        return this.properties;
    }

    @Override
    public double getVehicleMovementDirection() {
        LivingEntity li = this.getLivingEntity();
        if (li == null) {
            return 0.0;
        }
        return CompatibilityLib.getCompatibilityUtils().getForwardMovement(li);
    }

    @Override
    public double getVehicleStrafeDirection() {
        LivingEntity li = this.getLivingEntity();
        if (li == null) {
            return 0.0;
        }
        return CompatibilityLib.getCompatibilityUtils().getStrafeMovement(li);
    }

    @Override
    public boolean isVehicleJumping() {
        LivingEntity li = this.getLivingEntity();
        if (li == null) {
            return false;
        }
        return CompatibilityLib.getCompatibilityUtils().isJumping(li);
    }

    @Override
    public void setVanished(boolean vanished) {
        Player thisPlayer = this.getPlayer();
        if (thisPlayer != null && this.isVanished != vanished) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (vanished) {
                    CompatibilityLib.getDeprecatedUtils().hidePlayer(this.controller.getPlugin(), player, thisPlayer);
                    continue;
                }
                CompatibilityLib.getDeprecatedUtils().showPlayer(this.controller.getPlugin(), player, thisPlayer);
            }
        }
        this.isVanished = vanished;
    }

    @Override
    public boolean isVanished() {
        return this.isVanished;
    }

    @Override
    public void setGlidingAllowed(boolean allow) {
        this.glidingAllowed = allow;
        Player player = this.getPlayer();
        if (player != null) {
            this.controller.addFlightExemption(player, 5000);
        }
    }

    @Override
    public boolean isGlidingAllowed() {
        return this.glidingAllowed;
    }

    public boolean isForget() {
        return this.forget;
    }

    public void setForget(boolean forget) {
        this.forget = forget;
    }

    @Override
    public double getVaultBalance() {
        if (!VaultController.hasEconomy() || !this.isPlayer()) {
            return 0.0;
        }
        return VaultController.getInstance().getBalance((OfflinePlayer)this.getPlayer());
    }

    @Override
    public boolean addVaultCurrency(double delta) {
        if (!VaultController.hasEconomy() || !this.isPlayer()) {
            return false;
        }
        VaultController.getInstance().depositPlayer((OfflinePlayer)this.getPlayer(), delta);
        return true;
    }

    @Override
    public boolean removeVaultCurrency(double delta) {
        if (!VaultController.hasEconomy() || !this.isPlayer()) {
            return false;
        }
        VaultController.getInstance().withdrawPlayer((OfflinePlayer)this.getPlayer(), delta);
        return true;
    }

    public void setIsAutomaton(boolean automaton) {
        this.isAutomaton = automaton;
    }

    @Override
    public boolean isAutomaton() {
        return this.isAutomaton;
    }

    @Override
    public void addTag(String tag) {
        this.tags.add(tag);
    }

    @Override
    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    public void setOpenCooldown(long openCooldown) {
        if (openCooldown > 0L) {
            this.disableWandOpenUntil = System.currentTimeMillis() + openCooldown;
        }
    }

    public long getWandDisableTime() {
        return this.disableWandOpenUntil;
    }

    public Integer getLastActivatedSlot() {
        return this.lastActivatedSlot;
    }

    public void setLastActivatedSlot(int slot) {
        this.lastActivatedSlot = slot;
    }

    @Override
    @Nullable
    public Double getAttribute(String attributeKey) {
        Player player;
        MagicAttribute defaultSetting;
        Double attribute = this.getBuiltinAttribute(attributeKey);
        if (attribute == null) {
            attribute = this.attributes.get(attributeKey);
        }
        if (attribute == null && (defaultSetting = this.controller.getAttribute(attributeKey)) != null) {
            attribute = defaultSetting.getDefault();
        }
        if (attribute == null && (player = this.getPlayer()) != null) {
            List<AttributeProvider> providers = this.controller.getAttributeProviders();
            for (AttributeProvider provider : providers) {
                Double value = provider.getAttributeValue(attributeKey, player);
                if (value == null) continue;
                attribute = value;
                break;
            }
        }
        return attribute;
    }

    @Nullable
    private Double getBuiltinAttribute(String attributeKey) {
        PotionEffectType potionEffectType;
        Enchantment enchantment;
        Double globalValue = this.controller.getBuiltinAttribute(attributeKey);
        if (globalValue != null) {
            return globalValue;
        }
        switch (attributeKey) {
            case "air": {
                LivingEntity living = this.getLivingEntity();
                return living == null ? null : Double.valueOf(living.getRemainingAir());
            }
            case "air_max": {
                LivingEntity living = this.getLivingEntity();
                return living == null ? null : Double.valueOf(living.getMaximumAir());
            }
            case "hunger": {
                Player player = this.getPlayer();
                return player == null ? null : Double.valueOf(player.getFoodLevel());
            }
            case "health": {
                LivingEntity living = this.getLivingEntity();
                return living == null ? null : Double.valueOf(living.getHealth());
            }
            case "health_max": {
                LivingEntity living = this.getLivingEntity();
                return living == null ? null : Double.valueOf(CompatibilityLib.getCompatibilityUtils().getMaxHealth((Damageable)living));
            }
            case "armor": {
                return this.getVanillaAttribute(Attribute.GENERIC_ARMOR);
            }
            case "attack_damage": {
                return this.getVanillaAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
            }
            case "luck": {
                return this.getVanillaAttribute(Attribute.GENERIC_LUCK);
            }
            case "knockback_resistance": {
                return this.getVanillaAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE);
            }
            case "movement_speed": {
                return this.getVanillaAttribute(Attribute.GENERIC_MOVEMENT_SPEED);
            }
            case "movement_speed_bps": {
                return this.getVanillaAttribute(Attribute.GENERIC_MOVEMENT_SPEED) * MOVEMENT_SPEED_BPS;
            }
            case "mana": {
                return this.getMana();
            }
            case "mana_max": {
                return this.getEffectiveManaMax();
            }
            case "xp": {
                return this.getExperience();
            }
            case "level": {
                return this.getLevel();
            }
            case "time": {
                Location location = this.getLocation();
                return location == null ? null : Double.valueOf(location.getWorld().getTime());
            }
            case "fulltime": {
                Location location = this.getLocation();
                return location == null ? null : Double.valueOf(location.getWorld().getFullTime());
            }
            case "moon": {
                Location location = this.getLocation();
                return location == null ? null : Double.valueOf((int)(location.getWorld().getFullTime() / 24000L % 8L));
            }
            case "location_x": {
                Location location = this.getLocation();
                return location == null ? null : Double.valueOf(location.getX());
            }
            case "location_y": {
                Location location = this.getLocation();
                return location == null ? null : Double.valueOf(location.getY());
            }
            case "location_z": {
                Location location = this.getLocation();
                return location == null ? null : Double.valueOf(location.getZ());
            }
            case "yaw": {
                Location location = this.getLocation();
                return location == null ? null : Double.valueOf(location.getYaw());
            }
            case "pitch": {
                Location location = this.getLocation();
                return location == null ? null : Double.valueOf(location.getPitch());
            }
            case "temperature": {
                Location location = this.getLocation();
                return location == null ? null : Double.valueOf(location.getBlock().getTemperature());
            }
            case "light": {
                Location location = this.getLocation();
                return location == null ? null : Double.valueOf(location.getBlock().getLightLevel());
            }
            case "humidity": {
                Location location = this.getLocation();
                return location == null ? null : Double.valueOf(location.getBlock().getHumidity());
            }
            case "difficulty": {
                Location location = this.getLocation();
                return location == null ? null : Double.valueOf(location.getWorld().getDifficulty().ordinal());
            }
            case "damage": {
                return this.getLastDamage();
            }
            case "damage_dealt": {
                return this.getLastDamageDealt();
            }
            case "bowpull": {
                return this.getLastBowPull();
            }
            case "fall_distance": {
                return this.lastFallDistance;
            }
            case "bowpower": {
                return this.getLastBowPower();
            }
            case "play_time": {
                Player player = this.getPlayer();
                if (player == null) {
                    return null;
                }
                return System.currentTimeMillis() - player.getFirstPlayed();
            }
            case "velocity": {
                return this.getVelocity().length();
            }
        }
        Player player = this.getPlayer();
        if (player != null && (enchantment = CompatibilityLib.getCompatibilityUtils().getEnchantmentByKey(attributeKey)) != null) {
            ItemStack item = player.getInventory().getItemInMainHand();
            double level = 0.0;
            if (item != null && item.hasItemMeta()) {
                ItemMeta meta = item.getItemMeta();
                level = Math.max(level, (double)meta.getEnchantLevel(enchantment));
            }
            for (ItemStack armor : player.getInventory().getArmorContents()) {
                if (armor == null || !armor.hasItemMeta()) continue;
                ItemMeta meta = armor.getItemMeta();
                level = Math.max(level, (double)meta.getEnchantLevel(enchantment));
            }
            return level;
        }
        LivingEntity living = this.getLivingEntity();
        if (living != null && (potionEffectType = PotionEffectType.getByName((String)attributeKey.toUpperCase())) != null) {
            for (PotionEffect effect : living.getActivePotionEffects()) {
                if (effect.getType() != potionEffectType) continue;
                return (double)effect.getAmplifier() + 1.0;
            }
            return 0.0;
        }
        return null;
    }

    @Nullable
    private Double getVanillaAttribute(Attribute attribute) {
        LivingEntity living = this.getLivingEntity();
        if (living == null) {
            return null;
        }
        AttributeInstance instance = living.getAttribute(attribute);
        return instance == null ? null : Double.valueOf(instance.getValue());
    }

    @Override
    public double getLastFallDistance() {
        return this.lastFallDistance;
    }

    @Override
    public void setLastDamageType(String damageType) {
        this.currentDamageType = damageType;
        this.lastDamageType = damageType;
    }

    @Override
    public String getLastDamageType() {
        return this.lastDamageType;
    }

    @Override
    public void setLastDamageDealtType(String damageType) {
        this.currentDamageDealtType = damageType;
        this.lastDamageDealtType = damageType;
    }

    @Override
    public String getLastDamageDealtType() {
        return this.lastDamageDealtType;
    }

    public boolean isManaRegenerationDisabled() {
        for (MageSpell spell : this.activeSpells) {
            if (!spell.disableManaRegenerationWhenActive()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Wand findWand(@Nonnull String template) {
        Player player = this.getPlayer();
        if (player == null) {
            return null;
        }
        PlayerInventory inventory = player.getInventory();
        for (ItemStack itemStack : inventory.getContents()) {
            String itemTemplate = Wand.getWandTemplate(itemStack);
            if (itemTemplate == null || !itemTemplate.equals(template)) continue;
            return this.controller.getWand(itemStack);
        }
        return null;
    }

    @Override
    @Nonnull
    public MageContext getContext() {
        if (this.effectContext == null) {
            this.effectContext = new MageContext(this);
        }
        return (MageContext)Verify.verifyNotNull((Object)this.effectContext);
    }

    @Override
    public long getCreatedTime() {
        return this.created;
    }

    @Override
    public boolean trigger(String trigger) {
        if (!trigger.equals("interval")) {
            this.sendDebugMessage("Processing trigger: " + trigger, 50);
        }
        this.lastTriggers.put(trigger, System.currentTimeMillis());
        if (this.entityData != null) {
            this.cancelLaunch = true;
            return this.entityData.trigger(this, trigger);
        }
        for (MageClass mageClass : this.classes.values()) {
            if (!mageClass.isPassive() && mageClass != this.activeClass || mageClass.isLocked()) continue;
            mageClass.trigger(trigger);
        }
        for (MageModifier mageModifier : this.modifiers.values()) {
            mageModifier.trigger(trigger);
        }
        List<TriggeredSpell> spells = this.triggers.get(trigger.toLowerCase());
        if (spells == null || spells.isEmpty()) {
            return false;
        }
        ArrayList<TriggeredSpell> processingTriggers = new ArrayList<TriggeredSpell>(spells);
        boolean activated = false;
        this.cancelLaunch = false;
        for (TriggeredSpell triggered : processingTriggers) {
            MageSpell spell;
            if (!triggered.getTrigger().isValid(this) || (spell = this.getSpell(triggered.getSpellKey())) == null || !spell.isEnabled() || this.triggeringSpells.contains(spell.getKey())) continue;
            this.triggeringSpells.add(spell.getKey());
            this.cancelLaunch = this.cancelLaunch || triggered.getTrigger().isCancelLaunch();
            activated = spell.cast() || activated;
            triggered.getTrigger().triggered();
        }
        return activated;
    }

    @Override
    public void attributesUpdated() {
        this.updatePassiveEffects();
        for (MageSpell spell : this.spells.values()) {
            spell.updateTemplateParameters();
        }
        if (this.activeWand != null) {
            this.activeWand.deactivate();
            this.checkWand();
        }
    }

    @Override
    public void deactivateClasses() {
        for (MageClass mageClass : this.classes.values()) {
            if (mageClass.isLocked()) continue;
            mageClass.deactivate();
        }
    }

    @Override
    public void activateClasses() {
        for (MageClass mageClass : this.classes.values()) {
            mageClass.loadProperties();
            if (mageClass.isLocked()) continue;
            mageClass.activate();
        }
    }

    @Override
    public void deactivateModifiers() {
        for (MageModifier modifier : this.modifiers.values()) {
            modifier.deactivate();
        }
    }

    @Override
    public void activateModifiers() {
        for (MageModifier modifier : this.modifiers.values()) {
            modifier.activate();
        }
    }

    @Override
    public void setLaunchingProjectile(boolean launching) {
        this.launchingProjectile = launching;
    }

    @Override
    public boolean isLaunchingProjectile() {
        return this.launchingProjectile;
    }

    @Override
    public double getLastDamage() {
        return this.lastDamage;
    }

    public void setLastDamage(double lastDamage) {
        this.lastDamage = lastDamage;
    }

    @Override
    public double getLastDamageDealt() {
        return this.lastDamageDealt;
    }

    @Override
    public double getLastBowPull() {
        return this.lastBowPull;
    }

    public void setLastBowPull(double lastBowPull) {
        this.lastBowPull = lastBowPull;
    }

    public int getLastBowPower() {
        if (this.lastBowUsed == null || !this.lastBowUsed.hasItemMeta()) {
            return 0;
        }
        ItemMeta meta = this.lastBowUsed.getItemMeta();
        return meta.getEnchantLevel(Enchantment.ARROW_DAMAGE);
    }

    public void setLastBowUsed(ItemStack itemStack) {
        this.lastBowUsed = itemStack;
    }

    public void setLastProjectileType(EntityType t) {
        this.lastProjectileType = t;
    }

    @Override
    public EntityType getLastProjectileType() {
        return this.lastProjectileType;
    }

    @Override
    public double getHealth() {
        LivingEntity li = this.getLivingEntity();
        return li == null ? 0.0 : li.getHealth();
    }

    @Override
    public double getMaxHealth() {
        LivingEntity li = this.getLivingEntity();
        return li == null ? 0.0 : CompatibilityLib.getCompatibilityUtils().getMaxHealth((Damageable)li);
    }

    public boolean isCancelLaunch() {
        if (this.entityData != null) {
            return this.entityData.isCancelLaunch();
        }
        return this.cancelLaunch;
    }

    @Override
    @Nullable
    public Long getLastTrigger(String trigger) {
        return this.lastTriggers.get(trigger);
    }

    @Override
    public boolean toggleSpellEnabled(String spellKey) {
        return this.toggleSpellEnabled(this.getSpell(spellKey));
    }

    public boolean toggleSpellEnabled(Spell spell) {
        if (spell != null && spell.isToggleable()) {
            spell.setEnabled(!spell.isEnabled());
            if (this.activeWand != null) {
                this.activeWand.updateSpellItem(spell);
            }
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public ConfigurationSection getVariables() {
        if (this.variables == null) {
            this.variables = ConfigurationUtils.newConfigurationSection();
        }
        return this.variables;
    }

    @Override
    public boolean addModifier(@Nonnull String key) {
        return this.addModifier(key, 0);
    }

    @Override
    public boolean addModifier(@Nonnull String key, @Nullable ConfigurationSection properties) {
        int duration = properties == null ? 0 : properties.getInt("duration");
        return this.addModifier(key, duration, properties);
    }

    @Override
    public boolean addModifier(@Nonnull String key, int duration) {
        return this.addModifier(key, duration, null);
    }

    @Override
    public boolean addModifier(@Nonnull String key, int duration, @Nullable ConfigurationSection properties) {
        MageModifier modifier = this.modifiers.get(key);
        if (modifier != null) {
            if (!modifier.hasDuration()) {
                return false;
            }
            if (duration > 0 && modifier.getTimeRemaining() > duration) {
                return false;
            }
            modifier.reset(duration);
            if (!this.transientModifiers.containsKey(key)) {
                this.controller.getLogger().warning("Modifier seems to have been applied incorrectly, is permanent but has a duration " + key);
            }
            return true;
        }
        ModifierTemplate template = this.controller.getModifierTemplate(key);
        if (template == null) {
            this.controller.getLogger().warning("Invalid modifier key: " + key);
            return false;
        }
        template = template.getMageTemplate(this);
        modifier = new MageModifier(this, template);
        modifier.loadProperties();
        modifier.reset(duration);
        this.transientModifiers.put(key, modifier);
        this.updatePassiveEffects();
        return true;
    }

    public boolean applyModifier(@Nonnull String key) {
        return this.applyModifier(key, null);
    }

    public boolean applyModifier(@Nonnull String key, MageModifier transientTemplate) {
        MageModifier modifier = this.modifiers.get(key);
        if (modifier != null) {
            if (modifier.hasDuration()) {
                this.controller.info("Unexpected duplicate timed modifier: " + key, 5);
            }
            return false;
        }
        modifier = transientTemplate;
        if (modifier == null) {
            ModifierTemplate template = this.controller.getModifierTemplate(key);
            if (template == null) {
                this.controller.getLogger().warning("Invalid modifier key: " + key);
                return false;
            }
            template = template.getMageTemplate(this);
            modifier = new MageModifier(this, template);
            modifier.loadProperties();
        }
        this.modifiers.put(key, modifier);
        modifier.onAdd();
        return true;
    }

    @Override
    public MageModifier removeModifier(@Nonnull String key) {
        MageModifier modifier = this.transientModifiers.remove(key);
        if (modifier != null) {
            this.updatePassiveEffects();
        }
        return modifier;
    }

    public MageModifier unapplyModifier(@Nonnull String key) {
        MageModifier modifier = this.modifiers.remove(key);
        if (modifier != null) {
            modifier.onRemoved();
        }
        return modifier;
    }

    @Override
    @Nonnull
    public Set<String> getModifierKeys() {
        return this.modifiers.keySet();
    }

    @Override
    @Nullable
    public MageModifier getModifier(String key) {
        return this.modifiers.get(key);
    }

    @Override
    public boolean hasModifier(String key) {
        return this.modifiers.containsKey(key);
    }

    @Nullable
    public Integer getArrowToLaunch() {
        PlayerInventory inventory;
        Player player = this.getPlayer();
        PlayerInventory playerInventory = inventory = player == null ? null : player.getInventory();
        if (inventory == null) {
            return null;
        }
        ItemStack itemStack = inventory.getItemInMainHand();
        if (itemStack.getType() == Material.ARROW) {
            return -1;
        }
        itemStack = inventory.getItemInOffHand();
        if (itemStack.getType() == Material.ARROW) {
            return -2;
        }
        ItemStack[] contents = inventory.getContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack item = contents[i];
            if (item == null || item.getType() != Material.ARROW) continue;
            return i;
        }
        return null;
    }

    @Nullable
    public ItemStack getItemInSlot(int slot) {
        PlayerInventory inventory;
        Player player = this.getPlayer();
        PlayerInventory playerInventory = inventory = player == null ? null : player.getInventory();
        if (inventory == null) {
            return null;
        }
        if (slot == -1) {
            return inventory.getItemInMainHand();
        }
        if (slot == -2) {
            return inventory.getItemInOffHand();
        }
        return inventory.getItem(slot);
    }

    public void clearSlot(int slot) {
        PlayerInventory inventory;
        Player player = this.getPlayer();
        PlayerInventory playerInventory = inventory = player == null ? null : player.getInventory();
        if (inventory == null) {
            return;
        }
        if (slot == -1) {
            inventory.setItemInMainHand(null);
        } else if (slot == -2) {
            inventory.setItemInOffHand(null);
        } else {
            inventory.setItem(slot, null);
        }
    }

    @Nonnull
    public Map<Player, MageConversation> getConversations() {
        return this.conversations;
    }

    @Nullable
    public MageTargeting getTargeting() {
        return this.targeting;
    }

    @Override
    public boolean isBypassEnabled() {
        return this.bypassEnabled;
    }

    @Override
    public void setBypassEnabled(boolean enable) {
        this.bypassEnabled = enable;
    }

    public float getManaMaxMultiplier() {
        return 1.0f + this.manaMaxBoost;
    }

    public float getManaRegenerationMultiplier() {
        return 1.0f + this.manaRegenerationBoost;
    }

    @Override
    public boolean isResourcePackEnabled() {
        switch (this.resourcePackPreference) {
            case DEFAULT: {
                return this.controller.isResourcePackEnabledByDefault();
            }
            case AUTOMATIC: {
                return true;
            }
        }
        return false;
    }

    public boolean isResourcePackDisabled() {
        switch (this.resourcePackPreference) {
            case DEFAULT: {
                return !this.controller.isResourcePackEnabledByDefault();
            }
            case DISABLED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasResourcePack() {
        if (this.resourcePackPreference == ResourcePackPreference.DOWNLOADED || RP_DOWNLOADED) {
            return true;
        }
        if (this.preferredResourcePack != null && this.preferredResourcePack.equals("skulls")) {
            return false;
        }
        return this.hasResourcePack && !this.isResourcePackDisabled();
    }

    public ResourcePackPreference getResourcePackPreference() {
        return this.resourcePackPreference;
    }

    public void setResourcePackPreference(ResourcePackPreference resourcePackPreference) {
        this.resourcePackPreference = resourcePackPreference;
    }

    public boolean isResourcePackPrompt() {
        return this.resourcePackPreference == ResourcePackPreference.MANUAL;
    }

    public void setPreferredResourcePack(String pack) {
        this.preferredResourcePack = pack;
    }

    @Override
    @Nullable
    public String getPreferredResourcePack() {
        return this.preferredResourcePack;
    }

    public void setHasResourcePack(boolean has) {
        this.hasResourcePack = has;
    }

    @Override
    public boolean isUrlIconsEnabled() {
        if (this.preferredResourcePack == null) {
            return this.controller.isUrlIconsEnabled();
        }
        return this.controller.resourcePackUsesSkulls(this.preferredResourcePack);
    }

    protected void startInstructions() {
        String message = this.controller.getMessages().get("mage.instructions_header", "");
        this.sendMessage(message);
    }

    protected void endInstructions() {
        String message = this.controller.getMessages().get("mage.instructions_footer", "");
        this.sendMessage(message);
    }

    @Override
    @Nullable
    public List<CastParameter> getOverrides(String spellKey) {
        List<CastParameter> overrides = this.castOverrides.get("");
        List<CastParameter> spellOverrides = this.castOverrides.get(spellKey);
        if (overrides == null) {
            overrides = spellOverrides;
        } else if (spellOverrides != null) {
            overrides = new ArrayList<CastParameter>(overrides);
            overrides.addAll(spellOverrides);
        }
        return overrides;
    }

    public boolean canUse(String lockKey) {
        MageClass activeClass = this.getActiveClass();
        if (activeClass != null && activeClass.canUse(lockKey)) {
            return true;
        }
        for (MageClass passiveClass : this.classes.values()) {
            if (passiveClass.isLocked() || !passiveClass.isPassive() || !passiveClass.canUse(lockKey)) continue;
            return true;
        }
        for (MageModifier modifier : this.modifiers.values()) {
            if (modifier.isLocked() || !modifier.isPassive() || !modifier.canUse(lockKey)) continue;
            return true;
        }
        return false;
    }

    protected boolean canUse(ItemStack itemStack, Wand wand) {
        if (wand != null && !this.controller.hasWandPermission(this.getPlayer(), wand)) {
            return false;
        }
        String lockKey = this.controller.getLockKey(itemStack);
        if (lockKey == null) {
            return true;
        }
        return this.canUse(lockKey);
    }

    @Override
    public boolean canUse(com.elmakers.mine.bukkit.api.wand.Wand apiWand) {
        Wand wand = apiWand instanceof Wand ? (Wand)apiWand : null;
        return this.canUse(wand.getItem(), wand);
    }

    @Override
    public boolean canUse(ItemStack itemStack) {
        itemStack = itemStack.clone();
        return this.canUse(itemStack, this.controller.getIfWand(itemStack));
    }

    @Override
    public boolean canCraft(String recipeKey) {
        MageClass activeClass = this.getActiveClass();
        if (activeClass != null && activeClass.canCraft(recipeKey)) {
            return true;
        }
        for (MageClass passiveClass : this.classes.values()) {
            if (passiveClass.isLocked() || !passiveClass.isPassive() || !passiveClass.canCraft(recipeKey)) continue;
            return true;
        }
        for (MageModifier modifier : this.modifiers.values()) {
            if (modifier.isLocked() || !modifier.isPassive() || !modifier.canCraft(recipeKey)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public String getReplacement(String symbol, boolean integerValues) {
        Currency currency;
        CasterProperties casterProperties = this.getActiveProperties();
        switch (symbol) {
            case "_": {
                return " ";
            }
            case "pd": {
                return this.getDisplayName();
            }
            case "pn": 
            case "p": {
                return this.getName();
            }
            case "uuid": {
                return this.getId();
            }
            case "last_spell": {
                return this.lastSpellCast == null ? null : this.lastSpellCast.getName();
            }
            case "spell": {
                ItemStack item;
                String spellKey;
                Spell spell = this.activeWand == null ? null : this.activeWand.getActiveSpell();
                Player player = this.getPlayer();
                if (spell == null && player != null && (spellKey = this.controller.getSpell(item = player.getInventory().getItemInMainHand())) != null) {
                    spell = this.getSpell(spellKey);
                }
                if (spell == null && player != null && (spellKey = this.controller.getSpell(item = player.getInventory().getItemInOffHand())) != null) {
                    spell = this.getSpell(spellKey);
                }
                return spell == null ? null : spell.getName();
            }
            case "wand": {
                return this.activeWand == null ? null : this.activeWand.getName();
            }
            case "class": {
                return this.activeClass == null ? null : this.activeClass.getName();
            }
            case "path": {
                ProgressionPath path = casterProperties.getPath();
                return path == null ? "" : path.getName();
            }
            case "sp": {
                return Integer.toString(this.getSkillPoints());
            }
            case "spell_count": {
                return Integer.toString(casterProperties.getSpells().size());
            }
        }
        Double value = this.getAttribute(symbol);
        if (value == null && (currency = this.controller.getCurrency(symbol)) != null) {
            value = this.getCurrency(currency.getKey());
        }
        if (value != null) {
            if (integerValues) {
                return Integer.toString((int)value.doubleValue());
            }
            return Double.toString(value);
        }
        if (this.activeWand != null) {
            return this.activeWand.getReplacement(symbol, integerValues);
        }
        return null;
    }

    @Override
    @Deprecated
    public String parameterizeMessage(String message) {
        return this.parameterize(message);
    }

    @Override
    @Deprecated
    public String parameterize(String command, String prefix) {
        return this.parameterize(command);
    }

    @Override
    public String parameterize(String text) {
        text = CompatibilityLib.getCompatibilityUtils().translateColors(text);
        if (!(text.contains("@") || text.contains("$") || text.contains("%"))) {
            return text;
        }
        Player player = this.getPlayer();
        if (player != null) {
            text = this.controller.setPlaceholders(player, text);
        }
        return TextUtils.parameterize(text, this);
    }

    public void discoverRecipes(Collection<String> recipes) {
        if (recipes == null) {
            return;
        }
        Player player = this.getPlayer();
        if (player != null && this.controller.hasPermission(player, "magic.wand.craft")) {
            for (String recipe : recipes) {
                if (!this.controller.hasPermission(player, "magic.craft." + recipe)) continue;
                CompatibilityLib.getCompatibilityUtils().discoverRecipe((HumanEntity)player, recipe);
            }
        }
    }

    public void loadKits(ConfigurationSection kitConfig) {
        this.kits.clear();
        if (kitConfig != null) {
            for (String kitKey : kitConfig.getKeys(false)) {
                this.kits.put(kitKey, MageKit.load(kitKey, kitConfig.getConfigurationSection(kitKey)));
            }
        }
    }

    @Nullable
    public ConfigurationSection saveKits() {
        ConfigurationSection kitConfig = null;
        if (!this.kits.isEmpty()) {
            kitConfig = ConfigurationUtils.newConfigurationSection();
            for (MageKit kit : this.kits.values()) {
                kit.saveTo(kitConfig);
            }
        }
        return kitConfig;
    }

    @Nullable
    public MageKit getKit(String kitKey) {
        return this.kits.get(kitKey);
    }

    @Nonnull
    private MageKit createKit(String kitKey) {
        MageKit kit = this.kits.get(kitKey);
        if (kit == null) {
            kit = new MageKit(kitKey);
            this.kits.put(kitKey, kit);
        }
        return kit;
    }

    public void gaveItemFromKit(String kitKey, String itemKey, int itemAmount) {
        this.createKit(kitKey).gave(itemKey, itemAmount);
    }

    public void tookItemFromKit(String kitKey, String itemKey) {
        this.createKit(kitKey).took(itemKey);
    }

    public boolean hasGivenWelcomeWand() {
        return this.gaveWelcomeWand;
    }

    @Override
    public ClientPlatform getClientPlatform() {
        Player player = this.getPlayer();
        if (player == null) {
            return ClientPlatform.JAVA;
        }
        return this.controller.getClientPlatform(player);
    }

    @Override
    public boolean showModalForm(com.elmakers.mine.bukkit.api.magic.Mage source, String title, String content, String[] buttonLabels, String[] buttonTriggers) {
        return this.controller.showModalForm(this.getPlayer(), source, title, content, buttonLabels, buttonTriggers);
    }

    public void sendCurrencyMessage(String type, double amount) {
        Messages messages = this.controller.getMessages();
        Currency currency = this.controller.getCurrency(type);
        if (currency != null) {
            String spendMessage;
            if (amount > 0.0) {
                String earnMessage = messages.get("currency." + type + ".earned", messages.get("currency.default.earned"));
                if (!earnMessage.isEmpty()) {
                    String amountString = currency.formatAmount(amount, messages);
                    this.sendMessage(earnMessage.replace("$amount", amountString));
                }
            } else if (amount < 0.0 && !(spendMessage = messages.get("currency." + type + ".spent", messages.get("currency.default.spent"))).isEmpty()) {
                String amountString = currency.formatAmount(Math.abs(amount), messages);
                this.sendMessage(spendMessage.replace("$amount", amountString));
            }
        }
        this.currencyMessages.remove(type);
    }

    public void setPortalCooldown(int cooldown) {
        this.portalsDisabledUntil = Math.max(this.portalsDisabledUntil, System.currentTimeMillis() + (long)cooldown);
    }

    public boolean isOnPortalCooldown() {
        return System.currentTimeMillis() < this.portalsDisabledUntil;
    }

    @Override
    public void sendToActionBar(String message) {
        if (!this.isPlayer()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (this.actionBarQueue.contains(message)) {
            return;
        }
        if (now > this.lastActionBarSend + (long)ACTION_BAR_QUEUE_INTERVAL || ACTION_BAR_QUEUE_INTERVAL == 0 || this.actionBarQueue.size() > ACTION_BAR_QUEUE_MAX_DEPTH) {
            this.doSendToActionBar(message);
        } else {
            this.actionBarQueue.add(message);
        }
    }

    protected void checkActionBarQueue() {
        if (!this.actionBarQueue.isEmpty() && System.currentTimeMillis() > this.lastActionBarSend + (long)ACTION_BAR_QUEUE_INTERVAL) {
            this.doSendToActionBar(this.actionBarQueue.remove());
        }
    }

    protected void doSendToActionBar(String message) {
        this.lastActionBarSend = System.currentTimeMillis();
        Wand wand = this.getActiveWand();
        if (wand != null && wand.handleActionBar(message)) {
            return;
        }
        Player player = this.getPlayer();
        if (player != null) {
            CompatibilityLib.getCompatibilityUtils().sendActionBar(player, message);
        } else {
            CommandSender sender = this.getCommandSender();
            if (sender != null) {
                this.sendMessage(message);
            }
        }
    }

    public boolean handleInsufficientResources(Spell spell, CastingCost cost) {
        Wand wand = this.getActiveWand();
        if (wand == null) {
            return false;
        }
        return wand.handleInsufficientResources(spell, cost);
    }

    public boolean handleCooldown(Spell spell) {
        Wand wand = this.getActiveWand();
        if (wand == null) {
            return false;
        }
        return wand.handleCooldown(spell);
    }

    public boolean handleInsufficientCharges(Spell spell) {
        Wand wand = this.getActiveWand();
        if (wand == null) {
            return false;
        }
        return wand.handleInsufficientCharges(spell);
    }

    public void setShownHelp() {
        this.shownHelp = true;
    }

    public void messageNoUse(Wand wand) {
        ItemStack item = wand.getItem();
        if (this.lastHeldItem == null || !item.equals((Object)this.lastHeldItem)) {
            this.lastHeldItem = item;
            String owner = wand.getOwner();
            if (owner == null || owner.isEmpty()) {
                this.sendMessage(this.controller.getMessages().get("mage.no_class").replace("$name", wand.getName()));
            } else {
                this.sendMessage(wand.getMessage("bound").replace("$name", owner));
            }
        }
    }

    private static class CurrencyMessage {
        public double amount;
        public BukkitTask timer;

        private CurrencyMessage() {
        }
    }
}

