/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.data;

import com.elmakers.mine.bukkit.api.data.MageData;
import com.elmakers.mine.bukkit.api.data.MageDataCallback;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.data.ConfigurationMageDataStore;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class SQLMageDataStore
extends ConfigurationMageDataStore {
    private Connection connection;
    private final Object lockingLock = new Object();
    private int lockTimeout = 0;
    private int lockRetry = 0;
    private boolean hasIsValid = true;

    @Nonnull
    protected abstract Connection createConnection() throws SQLException;

    @Override
    public void initialize(MageController controller, ConfigurationSection configuration) {
        super.initialize(controller, configuration);
        this.lockTimeout = configuration.getInt("lock_timeout", 5000);
        this.lockRetry = configuration.getInt("lock_retry", 100);
        if (this.lockRetry < 2) {
            this.lockRetry = 2;
        }
    }

    protected boolean isValid(Connection connection) {
        if (connection == null) {
            return false;
        }
        if (!this.hasIsValid) {
            return true;
        }
        try {
            return connection.isValid(5000);
        }
        catch (AbstractMethodError old) {
            this.hasIsValid = false;
            return true;
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.WARNING, "Error checking database connection", ex);
            return false;
        }
    }

    @Nonnull
    protected Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.createConnection();
            this.checkSchema();
        }
        boolean isValid = this.isValid(this.connection);
        for (int retries = 3; !isValid && retries >= 0; --retries) {
            try {
                Thread.sleep(1000L);
                isValid = this.isValid(this.connection);
                continue;
            }
            catch (InterruptedException ex) {
                break;
            }
        }
        return this.connection;
    }

    public String getTextFieldType() {
        return "TEXT";
    }

    protected void checkSchema() throws SQLException {
        if (!this.tableExists("mage")) {
            this.controller.getLogger().info("Creating table: mage");
            String sql = "CREATE TABLE IF NOT EXISTS `mage` (`id` varchar(64) NOT NULL,`data` " + this.getTextFieldType() + ",`locked` tinyint default 0,`migrated` tinyint default 0,PRIMARY KEY  (`id`))";
            sql = sql + this.getTableEncoding() + ';';
            this.execute(sql);
        }
    }

    protected String getTableEncoding() {
        return "";
    }

    public void execute(String query) throws SQLException {
        try (Statement statement = this.getConnection().createStatement();){
            statement.execute(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(String table) throws SQLException {
        ResultSet tableData = null;
        boolean exists = false;
        try {
            tableData = this.getConnection().getMetaData().getTables(null, null, table, null);
            exists = tableData.next();
            this.close(tableData);
        }
        catch (Throwable throwable) {
            this.close(tableData);
            throw throwable;
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean columnExists(String table, String column) throws SQLException {
        ResultSet columnData = null;
        boolean exists = false;
        try {
            columnData = this.getConnection().getMetaData().getColumns(null, null, table, column);
            exists = columnData.next();
            this.close(columnData);
        }
        catch (Throwable throwable) {
            this.close(columnData);
            throw throwable;
        }
        return exists;
    }

    @Override
    @Deprecated
    public void save(MageData mage, MageDataCallback callback) {
        this.save(mage, callback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(MageData mage, MageDataCallback callback, boolean releaseLock) {
        YamlConfiguration serialized = new YamlConfiguration();
        this.save(mage, (ConfigurationSection)serialized);
        PreparedStatement insert = null;
        try {
            String sql = releaseLock ? "REPLACE INTO mage (id, data, locked) VALUES (?, ?, ?)" : "REPLACE INTO mage (id, data) VALUES (?, ?)";
            insert = this.getConnection().prepareStatement(sql);
            insert.setString(1, mage.getId());
            insert.setString(2, serialized.saveToString());
            if (releaseLock) {
                insert.setInt(3, 0);
            }
            insert.execute();
            this.close(insert);
        }
        catch (Exception ex) {
            try {
                this.controller.getLogger().log(Level.SEVERE, "Error saving player " + mage.getId(), ex);
                this.close();
                this.close(insert);
            }
            catch (Throwable throwable) {
                this.close(insert);
                throw throwable;
            }
        }
        this.controller.info("Finished saving data for " + mage.getId() + (releaseLock ? " and released lock " : " at " + System.currentTimeMillis()), 10);
        if (callback != null) {
            callback.run(mage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseLock(MageData mage) {
        Object object = this.lockingLock;
        synchronized (object) {
            PreparedStatement release = null;
            try {
                release = this.getConnection().prepareStatement("UPDATE mage SET locked = 0 WHERE id = ?");
                release.setString(1, mage.getId());
                release.execute();
                this.controller.info("Released lock for " + mage.getId() + " at " + System.currentTimeMillis());
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.WARNING, "Unable to release lock for " + mage.getId(), ex);
                this.close();
            }
            finally {
                this.close(release);
            }
        }
    }

    @Override
    public void obtainLock(MageData mage) {
        this.obtainLock(mage.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void obtainLock(String id) {
        Object object = this.lockingLock;
        synchronized (object) {
            boolean hasLock = false;
            long start = System.currentTimeMillis();
            this.controller.info("Obtaining lock for player " + id + " at " + start, 10);
            PreparedStatement lockLookup = null;
            PreparedStatement lock = null;
            ResultSet results = null;
            try {
                long now;
                lockLookup = this.getConnection().prepareStatement("SELECT locked FROM mage WHERE id = ?");
                while (!hasLock) {
                    lockLookup.setString(1, id);
                    results = lockLookup.executeQuery();
                    hasLock = results.next() ? !results.getBoolean(1) : true;
                    if (!hasLock) {
                        now = System.currentTimeMillis();
                        if (now > start + (long)this.lockTimeout) {
                            this.controller.info("Lock timeout of " + this.lockTimeout + "ms expired at " + now + " while waiting for mage " + id + ", claiming lock");
                            break;
                        }
                        Thread.sleep(this.lockRetry);
                    }
                    this.close(results);
                    results = null;
                }
                lock = this.getConnection().prepareStatement("UPDATE mage SET locked = 1 WHERE id = ?");
                lock.setString(1, id);
                lock.execute();
                now = System.currentTimeMillis();
                long duration = now - start;
                this.controller.info("Obtained lock for player " + id + " at " + now + " in " + duration + "ms", 10);
                this.close(lockLookup);
                this.close(results);
                this.close(lock);
            }
            catch (Exception ex) {
                try {
                    this.controller.info("Could not obtain lock for mage " + id);
                    this.close();
                    this.close(lockLookup);
                    this.close(results);
                    this.close(lock);
                }
                catch (Throwable throwable) {
                    this.close(lockLookup);
                    this.close(results);
                    this.close(lock);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isLocked(String id) {
        boolean isLocked = false;
        Object object = this.lockingLock;
        synchronized (object) {
            long start = System.currentTimeMillis();
            this.controller.info("Checking lock for player " + id + " at " + start, 10);
            PreparedStatement lockLookup = null;
            Statement lock = null;
            ResultSet results = null;
            try {
                lockLookup = this.getConnection().prepareStatement("SELECT locked FROM mage WHERE id = ?");
                lockLookup.setString(1, id);
                results = lockLookup.executeQuery();
                isLocked = results.next() ? results.getBoolean(1) : false;
                this.close(results);
                results = null;
                this.close(lockLookup);
                this.close(results);
                this.close(lock);
            }
            catch (Exception ex) {
                try {
                    this.controller.info("Could not check lock for mage " + id);
                    this.close();
                    this.close(lockLookup);
                    this.close(results);
                    this.close(lock);
                }
                catch (Throwable throwable) {
                    this.close(lockLookup);
                    this.close(results);
                    this.close(lock);
                    throw throwable;
                }
            }
        }
        return isLocked;
    }

    @Override
    @Deprecated
    public void load(String id, MageDataCallback callback) {
        this.load(id, callback, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(String id, MageDataCallback callback, boolean lock) {
        if (lock) {
            this.obtainLock(id);
        } else if (this.isLocked(id)) {
            this.controller.info("Skipping locked data preload", 10);
            if (callback != null) {
                callback.run(null);
            }
            return;
        }
        MageData data = null;
        PreparedStatement loadQuery = null;
        ResultSet results = null;
        try {
            loadQuery = this.getConnection().prepareStatement("SELECT data FROM mage WHERE id = ?");
            loadQuery.setString(1, id);
            results = loadQuery.executeQuery();
            if (results.next()) {
                YamlConfiguration saveFile = new YamlConfiguration();
                saveFile.loadFromString(results.getString(1));
                data = this.load(id, (ConfigurationSection)saveFile);
            }
            this.close(results);
            this.close(loadQuery);
        }
        catch (Exception ex) {
            try {
                this.controller.getLogger().log(Level.SEVERE, "Error loading player " + id, ex);
                this.close();
                this.close(results);
                this.close(loadQuery);
            }
            catch (Throwable throwable) {
                this.close(results);
                this.close(loadQuery);
                throw throwable;
            }
        }
        if (callback != null) {
            callback.run(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String id) {
        PreparedStatement delete = null;
        try {
            delete = this.getConnection().prepareStatement("DELETE FROM mage WHERE id = ?");
            delete.setString(1, id);
            delete.execute();
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.WARNING, "Unable to delete mage " + id, ex);
            this.close();
        }
        finally {
            this.close(delete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getAllIds() {
        PreparedStatement idsQuery = null;
        ResultSet idResults = null;
        ArrayList<String> ids = new ArrayList<String>();
        try {
            idsQuery = this.getConnection().prepareStatement("SELECT id FROM mage WHERE migrated = 0");
            idResults = idsQuery.executeQuery();
            while (idResults.next()) {
                ids.add(idResults.getString(1));
            }
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.WARNING, "Unable to lookup all mage ids", ex);
            this.close();
        }
        finally {
            this.close(idsQuery);
            this.close(idResults);
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void migrate(String id) {
        PreparedStatement migrate = null;
        try {
            migrate = this.getConnection().prepareStatement("UPDATE mage SET migrated = 1 WHERE id = ?");
            migrate.setString(1, id);
            migrate.execute();
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.WARNING, "Could not set mage " + id + " as migrated", ex);
            this.close();
        }
        finally {
            this.close(migrate);
        }
    }

    @Override
    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.WARNING, "Error closing player data connection", ex);
            }
            this.connection = null;
        }
    }

    private void close(@Nullable Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ex) {
                this.controller.getLogger().log(Level.WARNING, "Error closing statement", ex);
            }
        }
    }

    private void close(@Nullable ResultSet results) {
        if (results != null) {
            try {
                results.close();
            }
            catch (SQLException ex) {
                this.controller.getLogger().log(Level.WARNING, "Error closing result set", ex);
            }
        }
    }
}

