/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseTeleportAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.utility.TextUtils;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class TeleportAction
extends BaseTeleportAction {
    private static int DEFAULT_PASSTHROUGH_RANGE = 4;
    private boolean autoPassthrough = true;
    private boolean useTargetLocation;
    private int passthroughRange;
    private int ledgeSearchDistance = 2;
    private boolean direct = false;
    private boolean sameBlock = false;
    private double roundUp = 0.75;
    private boolean teleportTarget = false;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        Mage mage = context.getMage();
        this.ledgeSearchDistance = parameters.getInt("ledge_range", 2);
        this.autoPassthrough = parameters.getBoolean("allow_passthrough", false);
        this.useTargetLocation = parameters.getBoolean("use_target_location", false);
        this.passthroughRange = (int)Math.floor(mage.getRangeMultiplier() * (float)parameters.getInt("passthrough_range", DEFAULT_PASSTHROUGH_RANGE));
        this.direct = parameters.getBoolean("direct", false);
        this.roundUp = parameters.getDouble("round_up", 0.75);
        this.sameBlock = parameters.getBoolean("same_block", false);
        this.teleportTarget = parameters.getBoolean("teleport_target", false);
    }

    @Override
    public SpellResult perform(CastContext context) {
        Location targetLocation;
        Entity entity;
        Entity entity2 = entity = this.teleportTarget ? context.getTargetEntity() : context.getEntity();
        if (entity == null) {
            return this.teleportTarget ? SpellResult.NO_TARGET : SpellResult.ENTITY_REQUIRED;
        }
        if (this.direct) {
            targetLocation = context.getTargetLocation();
            if (targetLocation == null) {
                return SpellResult.NO_TARGET;
            }
        } else {
            Location safeLocation;
            int distanceUp;
            Block target;
            LivingEntity sourceEntity;
            boolean isPassthrough = false;
            if (this.autoPassthrough) {
                Block firstBlock = context.getInteractBlock();
                if (firstBlock == null) {
                    return SpellResult.NO_TARGET;
                }
                if (!context.allowPassThrough(firstBlock)) {
                    return SpellResult.NO_TARGET;
                }
                if (!context.isPassthrough(firstBlock)) {
                    context.retarget(this.passthroughRange, 0.0, this.passthroughRange, 0.0, false, -1, true, 1);
                    isPassthrough = true;
                    context.getMage().sendDebugMessage(ChatColor.BLUE + "Teleporting passthrough engaged", 11);
                }
            }
            Location sourceLocation = (sourceEntity = context.getLivingEntity()) == null ? context.getEyeLocation() : sourceEntity.getEyeLocation();
            Block source = sourceLocation.getBlock();
            Block face = context.getPreviousBlock();
            if (this.useTargetLocation) {
                int wholeY;
                Location location = context.getTargetLocation();
                target = location == null ? null : location.getBlock();
                face = null;
                double absY = Math.abs(location.getY());
                double yDecimal = absY - (double)(wholeY = (int)absY);
                if (yDecimal > this.roundUp) {
                    context.getMage().sendDebugMessage(ChatColor.GREEN + "Rounding up y coordinate of " + yDecimal, 15);
                    target = target.getRelative(BlockFace.UP);
                }
            } else {
                target = context.getTargetBlock();
            }
            if (target == null) {
                context.getMage().sendDebugMessage(ChatColor.RED + "Teleporting entity failed, no target block", 11);
                return SpellResult.NO_TARGET;
            }
            if (!this.sameBlock && !this.autoPassthrough && target.getX() == source.getX() && target.getY() == source.getY() && target.getZ() == source.getZ()) {
                context.getMage().sendDebugMessage(ChatColor.RED + "Teleporting entity failed, can't stand in half block at " + ChatColor.DARK_RED + target.getType(), 11);
                return SpellResult.NO_TARGET;
            }
            if (face == null) {
                face = target;
            }
            context.getMage().sendDebugMessage(ChatColor.GREEN + "Teleporting to block: " + TextUtils.printBlock(target) + ChatColor.GREEN + " face: " + TextUtils.printBlock(face), 12);
            World world = face.getWorld();
            Block destination = face;
            int verticalSearchDistance = context.getVerticalSearchDistance();
            if (isPassthrough) {
                destination = target;
            }
            Block ledge = null;
            if (!(isPassthrough || face.equals(target.getRelative(BlockFace.DOWN)) && !this.autoPassthrough)) {
                ledge = target;
                Block inFront = face;
                Block oneUp = ledge.getRelative(BlockFace.UP);
                Block twoUp = oneUp.getRelative(BlockFace.UP);
                Block faceOneUp = face.getRelative(BlockFace.UP);
                Block faceTwoUp = faceOneUp.getRelative(BlockFace.UP);
                if (!(this.autoPassthrough || context.isTransparent(face) && context.isTransparent(faceOneUp) && context.isTransparent(faceTwoUp) && !context.isTransparent(ledge))) {
                    ledge = null;
                } else {
                    for (distanceUp = 0; (this.autoPassthrough || context.isTransparent(face) && context.isTransparent(faceOneUp) && context.isTransparent(faceTwoUp)) && distanceUp < this.ledgeSearchDistance && context.isOkToStandIn(inFront) && (!context.isOkToStandOn(ledge) || !context.isOkToStandIn(oneUp) || !context.isOkToStandIn(twoUp)); ++distanceUp) {
                        faceOneUp = faceOneUp.getRelative(BlockFace.UP);
                        faceTwoUp = faceTwoUp.getRelative(BlockFace.UP);
                        inFront = inFront.getRelative(BlockFace.UP);
                        oneUp = oneUp.getRelative(BlockFace.UP);
                        twoUp = twoUp.getRelative(BlockFace.UP);
                        ledge = ledge.getRelative(BlockFace.UP);
                    }
                }
                if (distanceUp >= this.ledgeSearchDistance) {
                    ledge = null;
                }
            }
            if (ledge != null && context.isOkToStandOn(ledge)) {
                Block floor = face;
                while (!context.isOkToStandOn(floor) && distanceUp >= 0) {
                    floor = floor.getRelative(BlockFace.DOWN);
                    --distanceUp;
                }
                if (distanceUp > 0) {
                    destination = floor.getRelative(BlockFace.UP);
                    context.getMage().sendDebugMessage(ChatColor.GREEN + "Teleporting found ledge at " + TextUtils.printBlock(ledge) + ChatColor.GREEN + " but ground is closer: " + TextUtils.printBlock(destination), 11);
                } else {
                    destination = ledge.getRelative(BlockFace.UP);
                    context.getMage().sendDebugMessage(ChatColor.GREEN + "Teleporting hit ledge at " + TextUtils.printBlock(destination), 11);
                }
            }
            if (!(entity instanceof Player && ((Player)entity).isFlying() || !this.safe || (safeLocation = context.findPlaceToStand(destination.getLocation(), verticalSearchDistance, false)) == null)) {
                destination = safeLocation.getBlock();
                context.getMage().sendDebugMessage(ChatColor.GREEN + "Teleporting destination changed to safe location", 11);
            }
            Block oneUp = destination.getRelative(BlockFace.UP);
            if (!context.isOkToStandIn(destination) || !context.isOkToStandIn(oneUp)) {
                context.getMage().sendDebugMessage(ChatColor.RED + "Teleporting entity failed, can't stand in " + ChatColor.DARK_RED + destination.getType() + ChatColor.RED + " or " + ChatColor.DARK_RED + oneUp.getType(), 11);
                return SpellResult.NO_TARGET;
            }
            targetLocation = new Location(world, (double)destination.getX() + 0.5, (double)destination.getY(), (double)destination.getZ() + 0.5, entity.getLocation().getYaw(), entity.getLocation().getPitch());
        }
        context.getMage().sendDebugMessage(ChatColor.AQUA + "Teleporting entity " + ChatColor.DARK_AQUA + entity.getType() + ChatColor.AQUA + " to " + TextUtils.printLocation(targetLocation), 11);
        return this.teleport(context, entity, targetLocation);
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }
}

