/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_20_0;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.requirements.Requirement;
import com.elmakers.mine.bukkit.mob.GoalConfiguration;
import com.elmakers.mine.bukkit.mob.GoalType;
import com.elmakers.mine.bukkit.utility.platform.ItemUtils;
import com.elmakers.mine.bukkit.utility.platform.base.MobUtilsBase;
import com.elmakers.mine.bukkit.utility.platform.v1_20_0.Platform;
import com.elmakers.mine.bukkit.utility.platform.v1_20_0.goal.IdleGoal;
import com.elmakers.mine.bukkit.utility.platform.v1_20_0.goal.MagicCheckOwnerGoal;
import com.elmakers.mine.bukkit.utility.platform.v1_20_0.goal.MagicFindOwnerGoal;
import com.elmakers.mine.bukkit.utility.platform.v1_20_0.goal.MagicFollowMobGoal;
import com.elmakers.mine.bukkit.utility.platform.v1_20_0.goal.MagicFollowOwnerGoal;
import com.elmakers.mine.bukkit.utility.platform.v1_20_0.goal.MagicGoal;
import com.elmakers.mine.bukkit.utility.platform.v1_20_0.goal.MagicOwnerHurtByTargetGoal;
import com.elmakers.mine.bukkit.utility.platform.v1_20_0.goal.MagicOwnerHurtTargetGoal;
import com.elmakers.mine.bukkit.utility.platform.v1_20_0.goal.MagicPanicGoal;
import com.elmakers.mine.bukkit.utility.platform.v1_20_0.goal.RequirementsGoal;
import com.elmakers.mine.bukkit.utility.platform.v1_20_0.goal.SpinGoal;
import com.elmakers.mine.bukkit.utility.platform.v1_20_0.goal.TriggerGoal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBeg;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreakDoor;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreath;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalDoorOpen;
import net.minecraft.world.entity.ai.goal.PathfinderGoalEatTile;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFishSchool;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowBoat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalInteract;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveThroughVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalNearestVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalOcelotAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalOfferFlower;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPerch;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomSwim;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRestrictSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalStrollVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalStrollVillageGolem;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSwell;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTame;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWater;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;
import net.minecraft.world.entity.ai.goal.PathfinderGoalZombieAttack;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalDefendVillage;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalTarget;
import net.minecraft.world.entity.ambient.EntityAmbient;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityCod;
import net.minecraft.world.entity.animal.EntityCow;
import net.minecraft.world.entity.animal.EntityDolphin;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.EntityFishSchool;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.EntityPanda;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPerchable;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityPufferFish;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntitySalmon;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.entity.animal.EntitySnowman;
import net.minecraft.world.entity.animal.EntitySquid;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.EntityHorse;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseChestedAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseDonkey;
import net.minecraft.world.entity.animal.horse.EntityHorseMule;
import net.minecraft.world.entity.animal.horse.EntityHorseZombie;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.animal.horse.EntityLlamaTrader;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.monster.EntityBlaze;
import net.minecraft.world.entity.monster.EntityCaveSpider;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityDrowned;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityEvoker;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntityGiantZombie;
import net.minecraft.world.entity.monster.EntityGuardian;
import net.minecraft.world.entity.monster.EntityGuardianElder;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityIllagerIllusioner;
import net.minecraft.world.entity.monster.EntityIllagerWizard;
import net.minecraft.world.entity.monster.EntityMagmaCube;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityPhantom;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityPillager;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.entity.monster.EntitySkeleton;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.monster.EntitySkeletonStray;
import net.minecraft.world.entity.monster.EntitySkeletonWither;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.entity.monster.EntitySpider;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.EntityVindicator;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.monster.EntityZombieHusk;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglinBrute;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.crafting.RecipeItemStack;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class MobUtils
extends MobUtilsBase {
    private final Platform platform;

    public MobUtils(Platform platform) {
        this.platform = platform;
    }

    private net.minecraft.world.entity.Entity getNMS(Entity entity) {
        if (entity == null) {
            return null;
        }
        CraftEntity craft = (CraftEntity)entity;
        return craft.getHandle();
    }

    private EntityInsentient getMob(Entity entity) {
        net.minecraft.world.entity.Entity nms = this.getNMS(entity);
        if (!(nms instanceof EntityInsentient)) {
            return null;
        }
        return (EntityInsentient)nms;
    }

    @Override
    public boolean removeGoals(Entity entity) {
        EntityInsentient mob = this.getMob(entity);
        if (mob == null) {
            return false;
        }
        mob.bO.b().clear();
        return true;
    }

    @Override
    public boolean removeTargetGoals(Entity entity) {
        EntityInsentient mob = this.getMob(entity);
        if (mob == null) {
            return false;
        }
        mob.bP.b().clear();
        return true;
    }

    protected boolean removeGoal(PathfinderGoalSelector selector, EntityInsentient mob, Entity entity, GoalType goalType) {
        try {
            PathfinderGoal targetGoal = this.getGoal(goalType, entity, mob, (ConfigurationSection)new MemoryConfiguration());
            Set available = selector.b();
            ArrayList<PathfinderGoal> found = new ArrayList<PathfinderGoal>();
            for (PathfinderGoalWrapped wrappedGoal : available) {
                if (!targetGoal.getClass().isAssignableFrom(wrappedGoal.k().getClass())) continue;
                found.add(wrappedGoal.k());
            }
            for (PathfinderGoal removeGoal : found) {
                selector.a(removeGoal);
            }
        }
        catch (Exception ex) {
            this.platform.getLogger().log(Level.WARNING, "Error removing goal: " + (Object)((Object)goalType) + " from " + entity.getType(), ex);
            return false;
        }
        return true;
    }

    @Override
    public boolean removeGoal(Entity entity, GoalType goalType) {
        EntityInsentient mob = this.getMob(entity);
        if (mob == null) {
            return false;
        }
        return this.removeGoal(mob.bO, mob, entity, goalType);
    }

    @Override
    public boolean removeTargetGoal(Entity entity, GoalType goalType) {
        EntityInsentient mob = this.getMob(entity);
        if (mob == null) {
            return false;
        }
        return this.removeGoal(mob.bP, mob, entity, goalType);
    }

    public String getGoalParentDescriptions(PathfinderGoal goal) {
        ArrayList<String> parentClasses = null;
        for (Class<?> superClass = goal.getClass().getSuperclass(); superClass != null && superClass != PathfinderGoal.class && superClass != MagicGoal.class && superClass != PathfinderGoalTarget.class; superClass = superClass.getSuperclass()) {
            if (parentClasses == null) {
                parentClasses = new ArrayList<String>();
            }
            parentClasses.add(superClass.getSimpleName());
        }
        if (parentClasses == null || parentClasses.isEmpty()) {
            return null;
        }
        return ChatColor.DARK_GRAY + " -> " + ChatColor.GRAY + StringUtils.join(parentClasses, (String)(ChatColor.DARK_GRAY + " -> " + ChatColor.GRAY));
    }

    protected Collection<String> getGoalDescriptions(PathfinderGoalSelector selector) {
        ArrayList<String> descriptions = new ArrayList<String>();
        Set available = selector.b();
        for (PathfinderGoalWrapped wrappedGoal : available) {
            PathfinderGoal goal = wrappedGoal.k();
            String description = goal.toString();
            String parentDescription = this.getGoalParentDescriptions(goal);
            if (parentDescription != null) {
                description = description + " " + parentDescription;
            }
            description = wrappedGoal.h() ? ChatColor.AQUA + description : ChatColor.GOLD + description;
            descriptions.add(ChatColor.BLUE + Integer.toString(wrappedGoal.i()) + ChatColor.DARK_GRAY + ": " + description);
        }
        return descriptions;
    }

    @Override
    public Collection<String> getGoalDescriptions(Entity entity) {
        EntityInsentient mob = this.getMob(entity);
        if (mob == null) {
            return null;
        }
        return this.getGoalDescriptions(mob.bO);
    }

    @Override
    public Collection<String> getTargetGoalDescriptions(Entity entity) {
        EntityInsentient mob = this.getMob(entity);
        if (mob == null) {
            return null;
        }
        return this.getGoalDescriptions(mob.bP);
    }

    protected boolean addGoal(PathfinderGoalSelector selector, EntityInsentient mob, Entity entity, GoalType goalType, int priority, ConfigurationSection config) {
        try {
            PathfinderGoal goal = this.getGoal(goalType, entity, mob, config);
            if (goal == null) {
                return false;
            }
            selector.a(priority, goal);
        }
        catch (Exception ex) {
            this.platform.getLogger().log(Level.WARNING, "Error creating goal: " + (Object)((Object)goalType) + " on " + entity.getType(), ex);
            return false;
        }
        return true;
    }

    @Override
    public boolean addGoal(Entity entity, GoalType goalType, int priority, ConfigurationSection config) {
        EntityInsentient mob = this.getMob(entity);
        if (mob == null) {
            return false;
        }
        return this.addGoal(mob.bO, mob, entity, goalType, priority, config);
    }

    @Override
    public boolean addTargetGoal(Entity entity, GoalType goalType, int priority, ConfigurationSection config) {
        EntityInsentient mob = this.getMob(entity);
        if (mob == null) {
            return false;
        }
        return this.addGoal(mob.bP, mob, entity, goalType, priority, config);
    }

    private PathfinderGoal getGoal(GoalType goalType, Entity entity, EntityInsentient mob, ConfigurationSection config) {
        String classType = config.getString("entity_class", "player");
        double speed = config.getDouble("speed", 1.0);
        double sprintSpeed = config.getDouble("sprint_speed", 1.0);
        float distance = (float)config.getDouble("distance", 16.0);
        boolean doors = config.getBoolean("doors", true);
        boolean interruptable = config.getBoolean("interruptable", true);
        boolean see = config.getBoolean("see", true);
        boolean reach = config.getBoolean("reach", false);
        float startDistance = (float)config.getDouble("start_distance", 5.0);
        float stopDistance = (float)config.getDouble("stop_distance", 1.0);
        float radius = (float)config.getDouble("radius", 16.0);
        EntityCreature pathfinder = mob instanceof EntityCreature ? (EntityCreature)mob : null;
        int interval = config.getInt("interval", 1000);
        interval /= 50;
        MageController controller = this.platform.getController();
        switch (goalType) {
            case AVOID_ENTITY: {
                if (pathfinder == null) {
                    return null;
                }
                return new PathfinderGoalAvoidTarget(pathfinder, this.getMobClass(classType), distance, sprintSpeed, sprintSpeed);
            }
            case BEG: {
                if (mob instanceof EntityWolf) {
                    return new PathfinderGoalBeg((EntityWolf)mob, distance);
                }
                return null;
            }
            case BREAK_DOOR: {
                return new PathfinderGoalBreakDoor(mob, difficulty -> true);
            }
            case BREATHE_AIR: {
                if (pathfinder == null) {
                    return null;
                }
                return new PathfinderGoalBreath(pathfinder);
            }
            case BREED: {
                if (mob instanceof EntityAnimal) {
                    return new PathfinderGoalBreed((EntityAnimal)mob, speed);
                }
                return null;
            }
            case EAT_BLOCK: {
                return new PathfinderGoalEatTile(mob);
            }
            case FLEE_SUN: {
                if (pathfinder == null) {
                    return null;
                }
                return new PathfinderGoalFleeSun(pathfinder, speed);
            }
            case FLOAT: {
                return new PathfinderGoalFloat(mob);
            }
            case FOLLOW_BOAT: {
                if (pathfinder == null) {
                    return null;
                }
                return new PathfinderGoalFollowBoat(pathfinder);
            }
            case FOLLOW_FLOCK_LEADER: {
                if (mob instanceof EntityFishSchool) {
                    return new PathfinderGoalFishSchool((EntityFishSchool)mob);
                }
                return null;
            }
            case FOLLOW_MOB: {
                return new PathfinderGoalFollowEntity(mob, speed, distance, radius);
            }
            case FOLLOW_OWNER: {
                if (mob instanceof EntityTameableAnimal) {
                    return new PathfinderGoalFollowOwner((EntityTameableAnimal)mob, speed, startDistance, stopDistance, config.getBoolean("fly", false));
                }
            }
            case MAGIC_FOLLOW_OWNER: {
                return new MagicFollowOwnerGoal(this.platform, mob, speed, startDistance, stopDistance, interval, config);
            }
            case FOLLOW_PARENT: {
                if (mob instanceof EntityAnimal) {
                    return new PathfinderGoalFollowParent((EntityAnimal)mob, speed);
                }
                return null;
            }
            case GOLEM_RANDOM_STROLL_IN_VILLAGE: {
                if (pathfinder == null) {
                    return null;
                }
                return new PathfinderGoalStrollVillageGolem(pathfinder, speed);
            }
            case INTERACT: {
                return new PathfinderGoalInteract(mob, this.getMobClass(classType), distance, (float)config.getDouble("probability", 1.0));
            }
            case LAND_ON_OWNERS_SHOULDER: {
                if (mob instanceof EntityPerchable) {
                    return new PathfinderGoalPerch((EntityPerchable)mob);
                }
                return null;
            }
            case LEAP_AT_TARGET: {
                return new PathfinderGoalLeapAtTarget(mob, (float)config.getDouble("y_offset", 0.4));
            }
            case LOOK_AT_PLAYER: {
                return new PathfinderGoalLookAtPlayer(mob, this.getMobClass(classType), distance, (float)config.getDouble("probability", 1.0), config.getBoolean("horizontal"));
            }
            case MELEE_ATTACK: {
                if (pathfinder == null) {
                    return null;
                }
                return new PathfinderGoalMeleeAttack(pathfinder, speed, config.getBoolean("follow", true));
            }
            case MOVE_BACK_TO_VILLAGE: {
                if (pathfinder == null) {
                    return null;
                }
                return new PathfinderGoalStrollVillage(pathfinder, speed, config.getBoolean("check", true));
            }
            case MOVE_THROUGH_VILLAGE: {
                if (pathfinder == null) {
                    return null;
                }
                return new PathfinderGoalMoveThroughVillage(pathfinder, speed, config.getBoolean("night", true), (int)distance, () -> doors);
            }
            case MOVE_TOWARDS_RESTRICTION: {
                if (pathfinder == null) {
                    return null;
                }
                return new PathfinderGoalMoveTowardsRestriction(pathfinder, speed);
            }
            case MOVE_TOWARDS_TARGET: {
                if (pathfinder == null) {
                    return null;
                }
                return new PathfinderGoalMoveTowardsTarget(pathfinder, speed, distance);
            }
            case OCELOT_ATTACK: {
                return new PathfinderGoalOcelotAttack(mob);
            }
            case OFFER_FLOWER: {
                if (mob instanceof EntityIronGolem) {
                    return new PathfinderGoalOfferFlower((EntityIronGolem)mob);
                }
                return null;
            }
            case OPEN_DOOR: {
                return new PathfinderGoalDoorOpen(mob, config.getBoolean("close", false));
            }
            case PANIC_FIRE: {
                if (pathfinder == null) {
                    return null;
                }
                return new PathfinderGoalPanic(pathfinder, speed);
            }
            case PANIC: 
            case MAGIC_PANIC: {
                if (pathfinder == null) {
                    return null;
                }
                return new MagicPanicGoal(pathfinder, speed, config.getInt("panic", 3000), config.getInt("calm", 5000), interruptable);
            }
            case RANDOM_LOOK_AROUND: {
                return new PathfinderGoalRandomLookaround(mob);
            }
            case RANDOM_STROLL: {
                if (pathfinder == null) {
                    return null;
                }
                return new PathfinderGoalRandomStroll(pathfinder, speed, interval);
            }
            case RANDOM_SWIMMING: {
                if (pathfinder == null) {
                    return null;
                }
                return new PathfinderGoalRandomSwim(pathfinder, speed, interval);
            }
            case RESTRICT_SUN: {
                if (pathfinder == null) {
                    return null;
                }
                return new PathfinderGoalRestrictSun(pathfinder);
            }
            case RUN_AROUND_LIKE_CRAZY: {
                if (mob instanceof EntityHorse) {
                    return new PathfinderGoalTame((EntityHorseAbstract)((EntityHorse)mob), speed);
                }
                return null;
            }
            case STROLL_THROUGH_VILLAGE: {
                if (pathfinder == null) {
                    return null;
                }
                return new PathfinderGoalNearestVillage(pathfinder, interval);
            }
            case SWELL: {
                if (mob instanceof EntityCreeper) {
                    return new PathfinderGoalSwell((EntityCreeper)mob);
                }
                return null;
            }
            case TEMPT: {
                if (pathfinder == null) {
                    return null;
                }
                String itemKey = config.getString("item", "EMERALD");
                try {
                    Material material = Material.valueOf((String)itemKey.toUpperCase());
                    ItemStack itemStack = new ItemStack(material);
                    ItemUtils itemUtils = this.platform.getItemUtils();
                    itemStack = itemUtils.makeReal(itemStack);
                    net.minecraft.world.item.ItemStack nms = (net.minecraft.world.item.ItemStack)itemUtils.getHandle(itemStack);
                    if (nms == null) {
                        this.platform.getLogger().warning("Invalid item from material in temp goal: " + itemKey);
                        return null;
                    }
                    boolean scare = config.getBoolean("scare", false);
                    return new PathfinderGoalTempt(pathfinder, speed, RecipeItemStack.a((net.minecraft.world.item.ItemStack[])new net.minecraft.world.item.ItemStack[]{nms}), scare);
                }
                catch (Exception ex) {
                    this.platform.getLogger().warning("Invalid material in temp goal: " + itemKey);
                    return null;
                }
            }
            case TRY_FIND_WATER: {
                if (pathfinder == null) {
                    return null;
                }
                return new PathfinderGoalWater(pathfinder);
            }
            case WATER_AVOIDING_RANDOM_FLYING: {
                if (pathfinder == null) {
                    return null;
                }
                return new PathfinderGoalRandomFly(pathfinder, speed);
            }
            case WATER_AVOIDING_RANDOM_STROLL: {
                if (pathfinder == null) {
                    return null;
                }
                return new PathfinderGoalRandomStrollLand(pathfinder, speed);
            }
            case ZOMBIE_ATTACK: {
                if (mob instanceof EntityZombie) {
                    return new PathfinderGoalZombieAttack((EntityZombie)mob, speed, config.getBoolean("follow", true));
                }
                return null;
            }
            case DEFEND_VILLAGE_TARGET: {
                if (mob instanceof EntityIronGolem) {
                    return new PathfinderGoalDefendVillage((EntityIronGolem)mob);
                }
                return null;
            }
            case HURT_BY_TARGET: {
                if (pathfinder == null) {
                    return null;
                }
                return new PathfinderGoalHurtByTarget(pathfinder, new Class[0]);
            }
            case NEAREST_ATTACKABLE_TARGET: {
                return new PathfinderGoalNearestAttackableTarget(mob, this.getMobClass(classType), see, reach);
            }
            case OWNER_HURT_BY_TARGET: {
                if (mob instanceof EntityTameableAnimal) {
                    return new PathfinderGoalOwnerHurtByTarget((EntityTameableAnimal)mob);
                }
            }
            case MAGIC_OWNER_HURT_BY_TARGET: {
                return new MagicOwnerHurtByTargetGoal(this.platform, mob, entity, see, reach);
            }
            case OWNER_HURT_TARGET: {
                if (mob instanceof EntityTameableAnimal) {
                    return new PathfinderGoalOwnerHurtTarget((EntityTameableAnimal)mob);
                }
            }
            case MAGIC_OWNER_HURT_TARGET: {
                return new MagicOwnerHurtTargetGoal(this.platform, mob, entity, see, reach);
            }
            case FOLLOW_ENTITY: 
            case MAGIC_FOLLOW_MOB: {
                Class<? extends EntityLiving> mobClass = this.getMobClass(classType);
                if (mobClass == null) {
                    this.platform.getLogger().warning("Unsupported entity_class in magic_follow_mob goal: " + classType);
                    return null;
                }
                return new MagicFollowMobGoal(mob, speed, radius, distance, interval, mobClass);
            }
            case REQUIREMENT: 
            case REQUIREMENTS: {
                if (pathfinder == null) {
                    return null;
                }
                Mage mage = controller.getMage(entity);
                Collection<Requirement> requirements = controller.getRequirements(config);
                List<PathfinderGoal> goals = this.getGoals(entity, mob, config, "magic requirement goal");
                return new RequirementsGoal(mage, goals, interruptable, requirements);
            }
            case GROUP: {
                List<PathfinderGoal> goals = this.getGoals(entity, mob, config, "magic group goal");
                return new MagicGoal(goals, interruptable);
            }
            case TRIGGER: {
                Mage mage = controller.getMage(entity);
                List<PathfinderGoal> goals = this.getGoals(entity, mob, config, "magic trigger goal");
                return new TriggerGoal(mage, goals, interruptable, config.getString("trigger", "goal"), interval);
            }
            case FIND_OWNER: {
                return new MagicFindOwnerGoal(this.platform, mob, radius, this.getMobClass(classType));
            }
            case CHECK_OWNER: {
                return new MagicCheckOwnerGoal(this.platform, mob);
            }
            case IDLE: {
                return new IdleGoal();
            }
            case SPIN: {
                return new SpinGoal(mob, (float)config.getDouble("degrees", 10.0));
            }
        }
        this.platform.getLogger().warning("Unsupported goal type: " + (Object)((Object)goalType));
        return null;
    }

    private List<PathfinderGoal> getGoals(Entity entity, EntityInsentient mob, ConfigurationSection config, String logContext) {
        ArrayList<PathfinderGoal> goals = new ArrayList<PathfinderGoal>();
        List<GoalConfiguration> goalConfigurations = GoalConfiguration.fromList(config, "goals", this.platform.getLogger(), logContext);
        if (goalConfigurations != null) {
            Collections.sort(goalConfigurations);
            for (GoalConfiguration goalConfig : goalConfigurations) {
                try {
                    PathfinderGoal goal = this.getGoal(goalConfig.getGoalType(), entity, mob, goalConfig.getConfiguration());
                    if (goal == null) continue;
                    goals.add(goal);
                }
                catch (Exception ex) {
                    this.platform.getLogger().log(Level.WARNING, "Error creating goal: " + (Object)((Object)goalConfig.getGoalType()) + " on mob " + entity.getType(), ex);
                }
            }
        }
        if (goals.isEmpty()) {
            goals.add(new IdleGoal());
        }
        return goals;
    }

    private Class<? extends EntityLiving> getMobClass(String classType) {
        switch (classType) {
            case "ambient_creature": 
            case "ambientcreature": 
            case "ambient": {
                return EntityAmbient.class;
            }
            case "bat": {
                return EntityBat.class;
            }
            case "axolotl": {
                return Axolotl.class;
            }
            case "goat": {
                return Goat.class;
            }
            case "abstractchestedhorse": 
            case "abstract_chested_horse": 
            case "chestedhorse": 
            case "chested_horse": {
                return EntityHorseChestedAbstract.class;
            }
            case "abstract_horse": 
            case "abstracthorse": 
            case "any_horse": {
                return EntityHorseAbstract.class;
            }
            case "donkey": {
                return EntityHorseDonkey.class;
            }
            case "horse": {
                return EntityHorse.class;
            }
            case "llama": {
                return EntityLlama.class;
            }
            case "mule": {
                return EntityHorseMule.class;
            }
            case "skeleton_horse": 
            case "skeletonhorse": {
                return EntitySkeleton.class;
            }
            case "trader_llama": 
            case "traderllama": {
                return EntityLlamaTrader.class;
            }
            case "zombiehorse": 
            case "zombie_horse": {
                return EntityHorseZombie.class;
            }
            case "abstractfish": 
            case "abstract_fish": 
            case "any_fish": 
            case "fish": {
                return EntityFish.class;
            }
            case "abstractgolem": 
            case "abstract_golem": 
            case "golem": {
                return EntityGolem.class;
            }
            case "abstractschoolingfish": 
            case "abstract_schooling_fish": 
            case "schooling_fish": {
                return EntityFishSchool.class;
            }
            case "animal": {
                return EntityAnimal.class;
            }
            case "bee": {
                return EntityBee.class;
            }
            case "cat": {
                return EntityCat.class;
            }
            case "chicken": {
                return EntityChicken.class;
            }
            case "cod": {
                return EntityCod.class;
            }
            case "cow": {
                return EntityCow.class;
            }
            case "dolphin": {
                return EntityDolphin.class;
            }
            case "fox": {
                return EntityFox.class;
            }
            case "iron_golem": 
            case "irongolem": {
                return EntityIronGolem.class;
            }
            case "mushroomcow": 
            case "mushroom_cow": 
            case "mooshroom": {
                return EntityMushroomCow.class;
            }
            case "ocelot": {
                return EntityOcelot.class;
            }
            case "panda": {
                return EntityPanda.class;
            }
            case "parrot": {
                return EntityParrot.class;
            }
            case "pig": {
                return EntityPig.class;
            }
            case "polarbear": 
            case "polar_bear": {
                return EntityPolarBear.class;
            }
            case "pufferfish": {
                return EntityPufferFish.class;
            }
            case "rabbit": {
                return EntityRabbit.class;
            }
            case "salmon": {
                return EntitySalmon.class;
            }
            case "sheep": {
                return EntitySheep.class;
            }
            case "snowgolem": 
            case "snow_golem": 
            case "snowman": {
                return EntitySnowman.class;
            }
            case "squid": {
                return EntitySquid.class;
            }
            case "tropicalfish": 
            case "tropical_fish": {
                return EntityTropicalFish.class;
            }
            case "turle": 
            case "sea_turtle": {
                return EntityTurtle.class;
            }
            case "wolf": {
                return EntityWolf.class;
            }
            case "dragon": 
            case "enderdragon": 
            case "ender_dragon": {
                return EntityEnderDragon.class;
            }
            case "wither": 
            case "wither_boss": 
            case "witherboss": {
                return EntityWither.class;
            }
            case "armorstand": 
            case "armor_stand": {
                return EntityArmorStand.class;
            }
            case "hoglin": {
                return EntityHoglin.class;
            }
            case "piglin": {
                return EntityPiglin.class;
            }
            case "piglinbrute": 
            case "piglin_brute": {
                return EntityPiglinBrute.class;
            }
            case "abstractillager": 
            case "abstract_illager": 
            case "illager": {
                return EntityIllagerAbstract.class;
            }
            case "abstractskeleton": 
            case "abstract_skeleton": 
            case "any_skeleton": {
                return EntitySkeletonAbstract.class;
            }
            case "blaze": {
                return EntityBlaze.class;
            }
            case "cavespider": 
            case "cave_spider": {
                return EntityCaveSpider.class;
            }
            case "creeper": {
                return EntityCreeper.class;
            }
            case "drowned": {
                return EntityDrowned.class;
            }
            case "elderguardian": 
            case "elder_guardian": {
                return EntityGuardianElder.class;
            }
            case "enderman": {
                return EntityEnderman.class;
            }
            case "endermite": {
                return EntityEndermite.class;
            }
            case "evoker": {
                return EntityEvoker.class;
            }
            case "ghast": {
                return EntityGhast.class;
            }
            case "giant": {
                return EntityGiantZombie.class;
            }
            case "guardian": {
                return EntityGuardian.class;
            }
            case "husk": {
                return EntityZombieHusk.class;
            }
            case "illusioner": {
                return EntityIllagerIllusioner.class;
            }
            case "magmacube": 
            case "magma_cube": {
                return EntityMagmaCube.class;
            }
            case "monster": {
                return EntityMonster.class;
            }
            case "phantom": {
                return EntityPhantom.class;
            }
            case "pillager": {
                return EntityPillager.class;
            }
            case "ravager": {
                return EntityRavager.class;
            }
            case "shulker": {
                return EntityShulker.class;
            }
            case "silverfish": {
                return EntitySilverfish.class;
            }
            case "skeleton": {
                return EntitySkeleton.class;
            }
            case "slime": {
                return EntitySlime.class;
            }
            case "spellcasterillager": 
            case "spellcaster_illager": 
            case "spellcaster": {
                return EntityIllagerWizard.class;
            }
            case "spider": {
                return EntitySpider.class;
            }
            case "stray": {
                return EntitySkeletonStray.class;
            }
            case "strider": {
                return EntityStrider.class;
            }
            case "vex": {
                return EntityVex.class;
            }
            case "vindicator": {
                return EntityVindicator.class;
            }
            case "witch": {
                return EntityWitch.class;
            }
            case "witherskeleton": 
            case "wither_skeleton": {
                return EntitySkeletonWither.class;
            }
            case "zoglin": {
                return EntityZoglin.class;
            }
            case "zombie": {
                return EntityZombie.class;
            }
            case "zombievillager": 
            case "zombie_villager": {
                return EntityZombieVillager.class;
            }
            case "zombifiedpiglin": 
            case "zombified_piglin": {
                return EntityPigZombie.class;
            }
            case "villager": {
                return EntityVillager.class;
            }
            case "wanderingtrader": 
            case "wandering_trader": {
                return EntityVillagerTrader.class;
            }
            case "player": {
                return EntityHuman.class;
            }
            case "glowsquid": {
                return GlowSquid.class;
            }
            case "mob": {
                return EntityInsentient.class;
            }
            case "livingentity": 
            case "living_entity": {
                return EntityLiving.class;
            }
        }
        this.platform.getLogger().warning("Invalid entity_class in goal config: " + classType);
        return EntityLiving.class;
    }

    @Override
    public boolean setPathfinderTarget(Entity entity, Entity target, double speed) {
        if (entity == null || target == null) {
            return false;
        }
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        net.minecraft.world.entity.Entity nmstarget = ((CraftEntity)target).getHandle();
        if (!(nmsEntity instanceof EntityInsentient)) {
            return false;
        }
        EntityInsentient mob = (EntityInsentient)nmsEntity;
        mob.J().a(nmstarget, speed);
        return true;
    }
}

