/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.tasks;

import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.tasks.ReloadConfigurationTask;
import java.io.File;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ConfigCheckTask
implements Runnable {
    private final MagicController controller;
    private final File configCheckFile;
    private Long lastModified = null;

    public ConfigCheckTask(MagicController controller) {
        this.controller = controller;
        this.configCheckFile = new File(controller.getPlugin().getDataFolder(), "data/updated.yml");
    }

    @Override
    public void run() {
        if (this.configCheckFile.exists()) {
            long modified = this.configCheckFile.lastModified();
            UUID modifiedUserId = null;
            if (this.lastModified != null && modified > this.lastModified) {
                Player player;
                try {
                    YamlConfiguration updated = new YamlConfiguration();
                    updated.load(this.configCheckFile);
                    String userId = updated.getString("user_id");
                    if (userId != null && !userId.isEmpty()) {
                        modifiedUserId = UUID.fromString(userId);
                    }
                }
                catch (Exception ex) {
                    this.controller.getLogger().log(Level.WARNING, "Error reading update file", ex);
                }
                Player player2 = player = modifiedUserId == null ? null : Bukkit.getPlayer(modifiedUserId);
                if (player != null || modifiedUserId == null) {
                    Mage mage;
                    this.controller.getLogger().info("Config check file modified, reloading configuration");
                    Mage mage2 = mage = player == null ? null : this.controller.getRegisteredMage((Entity)player);
                    if (mage != null) {
                        this.controller.setReloadingMage(mage);
                    }
                    Bukkit.getScheduler().runTask(this.controller.getPlugin(), (Runnable)new ReloadConfigurationTask(this.controller));
                }
            }
            this.lastModified = modified;
        } else {
            this.lastModified = 0L;
        }
    }
}

