/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseTeleportAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.magic.DeathLocation;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.protection.PlayerWarp;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.LostWand;
import com.elmakers.mine.bukkit.api.warp.Warp;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityConstants;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.warp.MagicWarp;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class RecallAction
extends BaseTeleportAction
implements GUIAction {
    private static final Material DefaultWaypointMaterial = Material.BEACON;
    private boolean allowCrossWorld = true;
    private List<RecallType> enabledTypes = new ArrayList<RecallType>();
    private List<Waypoint> options = new ArrayList<Waypoint>();
    private CastContext context;
    private ConfigurationSection parameters;
    private int protectionTime;
    private String markerKey = "recall_marker";
    private String unlockKey = "recall_warps";
    private String friendKey = "recall_friends";
    private int markerCount = 1;
    private int delay = 0;
    private boolean teleport = true;
    private boolean teleportTarget = false;
    private boolean requireTargetPermission = true;
    private boolean markerMaintainDirection = false;
    private String titleKey = null;
    private boolean isActive = false;
    private long delayExpiration = 0L;
    private Waypoint selectedWaypoint;
    private Location pendingTeleport = null;

    private String getMarkerKey(int markerNumber) {
        Object key = this.markerKey;
        if (markerNumber > 1) {
            key = (String)key + markerNumber;
        }
        return key;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public void deactivated() {
        if (this.context != null) {
            this.context.getMage().removeItemsWithTag("waypoint");
        }
    }

    @Override
    public void dragged(InventoryDragEvent event) {
        event.setCancelled(true);
    }

    @Override
    public void clicked(InventoryClickEvent event) {
        event.setCancelled(true);
        if (this.context == null) {
            event.getWhoClicked().closeInventory();
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (CompatibilityLib.getNBTUtils().containsTag(item, "placeholder") || CompatibilityLib.getNBTUtils().containsTag(item, "unavailable")) {
            this.context.getMage().deactivateGUI();
            return;
        }
        if (CompatibilityLib.getNBTUtils().containsTag(item, "move_marker")) {
            int markerNumber = CompatibilityLib.getNBTUtils().getInt(item, "move_marker", 1);
            if (this.placeMarker(this.context.getLocation().getBlock(), markerNumber)) {
                this.context.sendMessageKey("target_selected");
            }
            this.context.getMage().deactivateGUI();
            return;
        }
        if (item == null || item.getType() == Material.AIR) {
            this.context.getMage().deactivateGUI();
        }
        int slot = event.getRawSlot();
        if (event.getSlotType() == InventoryType.SlotType.CONTAINER) {
            Waypoint waypoint;
            Waypoint waypoint2 = waypoint = slot < 0 || slot >= this.options.size() ? null : this.options.get(slot);
            if (waypoint != null && !waypoint.unavailable) {
                Mage mage = this.context.getMage();
                Player player = mage.getPlayer();
                mage.deactivateGUI();
                this.tryTeleport(player, waypoint);
            }
        }
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.parameters = parameters;
        this.context = context;
        this.markerKey = parameters.getString("marker_key", "recall_marker");
        this.unlockKey = parameters.getString("unlock_key", "recall_warps");
        this.friendKey = parameters.getString("friend_key", "recall_friends");
        this.protectionTime = parameters.getInt("protection_duration", 0);
        this.markerCount = parameters.getInt("marker_count", 1);
        this.teleport = parameters.getBoolean("teleport", true);
        this.teleportTarget = parameters.getBoolean("teleport_target", false);
        this.requireTargetPermission = parameters.getBoolean("require_target_permission", true);
        this.markerMaintainDirection = parameters.getBoolean("marker_maintain_direction", false);
        this.delay = parameters.getInt("delay", 0);
        this.delay = parameters.getInt("warmup", this.delay);
        this.titleKey = parameters.getString("title_key", "title");
        this.allowCrossWorld = parameters.getBoolean("allow_cross_world", true);
    }

    @Override
    public SpellResult perform(CastContext context) {
        String uuid;
        Player online;
        String friendName;
        if (this.pendingTeleport != null) {
            return this.doTeleport();
        }
        if (this.isActive) {
            if (context.getMage().getActiveGUI() != this) {
                if (context.getTargetLocation() == null) {
                    this.isActive = false;
                    return SpellResult.NO_TARGET;
                }
                if (this.delayExpiration > 0L && System.currentTimeMillis() < this.delayExpiration) {
                    return SpellResult.PENDING;
                }
                if (this.delayExpiration == 0L && this.delay > 0) {
                    context.playEffects("wait");
                    this.delayExpiration = System.currentTimeMillis() + (long)this.delay;
                    return SpellResult.PENDING;
                }
                this.isActive = false;
                if (this.teleport) {
                    return this.doTeleport();
                }
                return SpellResult.CAST;
            }
            return SpellResult.PENDING;
        }
        this.context = context;
        this.enabledTypes.clear();
        this.options.clear();
        Mage mage = context.getMage();
        MageController controller = context.getController();
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        HashSet<String> unlockedWarps = new HashSet<String>();
        ConfigurationSection mageData = mage.getData();
        String unlockedString = mageData.getString(this.unlockKey);
        if (unlockedString != null && !unlockedString.isEmpty()) {
            unlockedWarps.addAll(Arrays.asList(StringUtils.split((String)unlockedString, (char)',')));
        }
        HashSet<String> friends = new HashSet<String>();
        String friendString = mageData.getString(this.friendKey);
        if (friendString != null && !friendString.isEmpty()) {
            friends.addAll(Arrays.asList(StringUtils.split((String)friendString, (char)',')));
        }
        ConfigurationSection warpConfig = null;
        if (this.parameters.contains("warps")) {
            warpConfig = ConfigurationUtils.getConfigurationSection(this.parameters, "warps");
        }
        if (this.parameters.getBoolean("allow_magic_warps", true) && controller instanceof MagicController) {
            String group = this.parameters.getString("group", null);
            MagicController magic = (MagicController)controller;
            Collection<MagicWarp> warps = magic.getWarps().getMagicWarps();
            if (!warps.isEmpty() && warpConfig == null) {
                warpConfig = ConfigurationUtils.newConfigurationSection();
            }
            for (MagicWarp magicWarp : warps) {
                String icon = magicWarp.getIcon();
                if (icon == null || icon.isEmpty()) continue;
                String warpGroup = magicWarp.getGroup();
                if (group != null && !group.isEmpty() && warpGroup != null && !warpGroup.isEmpty() && !warpGroup.equalsIgnoreCase(group)) continue;
                ConfigurationSection magicWarpConfig = ConfigurationUtils.newConfigurationSection();
                magicWarpConfig.set("name", (Object)magicWarp.getName());
                magicWarpConfig.set("icon", (Object)icon);
                magicWarpConfig.set("description", (Object)magicWarp.getDescription());
                magicWarpConfig.set("locked", (Object)magicWarp.isLocked());
                warpConfig.set(magicWarp.getKey(), (Object)magicWarpConfig);
            }
        }
        ConfigurationSection commandConfig = null;
        if (this.parameters.contains("commands")) {
            commandConfig = ConfigurationUtils.getConfigurationSection(this.parameters, "commands");
        }
        if (this.parameters.contains("unlock")) {
            ConfigurationSection config;
            String unlockWarp = this.parameters.getString("unlock");
            if (unlockWarp == null || unlockWarp.isEmpty() || unlockedWarps.contains(unlockWarp)) {
                return SpellResult.NO_ACTION;
            }
            if (warpConfig == null && commandConfig == null) {
                return SpellResult.FAIL;
            }
            unlockedWarps.add(unlockWarp);
            unlockedString = StringUtils.join(unlockedWarps, (String)",");
            mageData.set(this.unlockKey, (Object)unlockedString);
            String warpName = unlockWarp;
            ConfigurationSection configurationSection = config = warpConfig == null ? null : warpConfig.getConfigurationSection(unlockWarp);
            if (config != null) {
                warpName = config.getString("name", warpName);
            } else {
                ConfigurationSection configurationSection2 = config = commandConfig == null ? null : commandConfig.getConfigurationSection(unlockWarp);
                if (config != null) {
                    warpName = config.getString("name", warpName);
                }
            }
            warpName = CompatibilityLib.getCompatibilityUtils().translateColors(warpName);
            String string = context.getMessage("unlock_warp").replace("$name", warpName);
            context.sendMessageKey("unlock_warp", string);
            return SpellResult.CAST;
        }
        if (this.parameters.contains("lock")) {
            String lockWarpString = this.parameters.getString("lock");
            String[] lockWarps = StringUtils.split((String)lockWarpString, (char)',');
            boolean locked = false;
            for (String lockWarp : lockWarps) {
                if (!unlockedWarps.contains(lockWarp)) continue;
                locked = true;
                unlockedWarps.remove(lockWarp);
            }
            if (locked) {
                unlockedString = StringUtils.join(unlockedWarps, (String)",");
                mageData.set(this.unlockKey, (Object)unlockedString);
            }
            return locked ? SpellResult.DEACTIVATE : SpellResult.NO_ACTION;
        }
        if (this.parameters.contains("addfriend")) {
            friendName = this.parameters.getString("addfriend");
            if (friendName == null || friendName.isEmpty()) {
                return SpellResult.NO_ACTION;
            }
            online = null;
            if (friendName.equals("target")) {
                Entity targetEntity = context.getTargetEntity();
                if (targetEntity != null && targetEntity instanceof Player) {
                    online = (Player)targetEntity;
                }
            } else if (friendName.equals("source")) {
                Entity sourceEntity = context.getEntity();
                if (sourceEntity != null && sourceEntity instanceof Player) {
                    online = (Player)sourceEntity;
                }
            } else {
                online = CompatibilityLib.getDeprecatedUtils().getPlayer(friendName);
            }
            if (online == null) {
                return SpellResult.FAIL;
            }
            uuid = online.getUniqueId().toString();
            if (friends.contains(uuid)) {
                return SpellResult.NO_ACTION;
            }
            friends.add(uuid);
            friendString = StringUtils.join(friends, (String)",");
            mageData.set(this.friendKey, (Object)friendString);
            String string = context.getMessage("add_friend").replace("$name", online.getDisplayName());
            context.sendMessageKey("add_friend", string);
            return SpellResult.CAST;
        }
        if (this.parameters.contains("removefriend")) {
            friendName = this.parameters.getString("removefriend");
            online = CompatibilityLib.getDeprecatedUtils().getPlayer(friendName);
            if (online == null) {
                return SpellResult.FAIL;
            }
            uuid = online.getUniqueId().toString();
            if (!friends.contains(uuid)) {
                return SpellResult.NO_ACTION;
            }
            friends.remove(uuid);
            friendString = StringUtils.join(friends, (String)",");
            mageData.set(this.friendKey, (Object)friendString);
            String string = context.getMessage("remove_friend").replace("$name", online.getDisplayName());
            context.sendMessageKey("remove_friend", string);
            return SpellResult.DEACTIVATE;
        }
        Location playerLocation = mage.getLocation();
        HashSet<RecallType> optionTypes = new HashSet<RecallType>();
        List<ConfigurationSection> optionConfiguration = ConfigurationUtils.getNodeList(this.parameters, "options");
        if (optionConfiguration != null) {
            for (ConfigurationSection optionConfig : optionConfiguration) {
                Waypoint newWaypoint = new Waypoint(this, context, optionConfig);
                this.options.add(newWaypoint);
                optionTypes.add(newWaypoint.type);
            }
        }
        boolean bl = this.parameters.getBoolean("allow_all", true);
        block14: for (ConfigurationSection testType : RecallType.values()) {
            if (optionTypes.contains(testType) || !this.parameters.getBoolean("allow_" + testType.name().toLowerCase(), bl && testType.showByDefault)) continue;
            switch (testType.ordinal()) {
                case 11: {
                    for (String string : friends) {
                        Waypoint targetLocation = this.getFriend(string);
                        if (targetLocation == null || !targetLocation.isValid(this.allowCrossWorld, playerLocation)) continue;
                        this.options.add(targetLocation);
                    }
                    continue block14;
                }
                case 12: {
                    for (String string : friends) {
                        Waypoint targetFriend = this.getRemoveFriend(string);
                        if (targetFriend == null) continue;
                        this.options.add(targetFriend);
                    }
                    continue block14;
                }
                case 10: {
                    ConfigurationSection config;
                    if (warpConfig == null) continue block14;
                    Set warpKeys = warpConfig.getKeys(false);
                    for (String warpKey : warpKeys) {
                        config = warpConfig.getConfigurationSection(warpKey);
                        config.set("warp", (Object)warpKey);
                        Waypoint warp = new Waypoint(this, context, config);
                        this.options.add(warp);
                    }
                    continue block14;
                }
                case 9: {
                    ConfigurationSection config;
                    if (commandConfig == null) continue block14;
                    Set commandKeys = commandConfig.getKeys(false);
                    for (String commandKey : commandKeys) {
                        config = commandConfig.getConfigurationSection(commandKey);
                        Waypoint command = new Waypoint(this, context, config);
                        this.options.add(command);
                    }
                    continue block14;
                }
                case 8: {
                    List<LostWand> lostWands = mage.getLostWands();
                    for (LostWand lostWand : lostWands) {
                        Waypoint targetLocation = this.getWaypoint(player, (RecallType)testType, lostWand.getLocation(), this.parameters, context);
                        if (targetLocation == null || !targetLocation.isValid(this.allowCrossWorld, playerLocation)) continue;
                        this.options.add(targetLocation);
                    }
                    continue block14;
                }
                case 3: {
                    Object targetLocation;
                    List<DeathLocation> list = controller.getDeathLocations(player);
                    if (list == null) continue block14;
                    for (DeathLocation death : list) {
                        targetLocation = this.getWaypoint(player, (RecallType)testType, death.getLocation(), this.parameters, context);
                        if (targetLocation == null || !((Waypoint)targetLocation).isValid(this.allowCrossWorld, playerLocation)) continue;
                        ItemStack[] items = death.getItems();
                        int itemCount = items == null ? 0 : items.length;
                        ((Waypoint)targetLocation).description = ((Waypoint)targetLocation).description.replace("$items", Integer.toString(itemCount)).replace("$xp", Integer.toString(death.getExperiencePoints()));
                        this.options.add((Waypoint)targetLocation);
                    }
                    continue block14;
                }
                case 0: 
                case 1: {
                    boolean allRegions = testType == RecallType.ALL_REGIONS;
                    Set<String> warpProviders = controller.getPlayerWarpProviderKeys();
                    for (String key : warpProviders) {
                        Collection<PlayerWarp> warps;
                        boolean allowDefault;
                        String allowKey = allRegions ? "all_" : "";
                        boolean bl2 = allowDefault = !allRegions;
                        if (!this.parameters.getBoolean("allow_" + allowKey + key.toLowerCase(), allowDefault)) continue;
                        Collection<PlayerWarp> collection = warps = allRegions ? controller.getAllPlayerWarps(key) : controller.getPlayerWarps(player, key);
                        if (warps == null) continue block14;
                        for (PlayerWarp warp : warps) {
                            Waypoint waypoint;
                            ItemData icon;
                            MaterialAndData warpIcon;
                            Location location = warp.getLocation();
                            String description = warp.getDescription();
                            if (description == null) {
                                description = context.getMessage("description_" + key, context.getMessage("description_regions"));
                            }
                            if ((warpIcon = (MaterialAndData)warp.getIcon()) != null) {
                                icon = context.getController().getOrCreateItem(warpIcon);
                            } else {
                                icon = RecallAction.getIcon(context, this.parameters, "icon_" + key);
                                if (icon == null) {
                                    icon = RecallAction.getIcon(context, this.parameters, "icon_regions");
                                }
                            }
                            if (!(waypoint = new Waypoint(this, context, RecallType.REGIONS, location, warp.getName(), context.getMessage("cast_" + key, context.getMessage("cast_regions")), context.getMessage("no_target_" + key, context.getMessage("no_target_regions")), description, icon, true)).isValid(this.allowCrossWorld, playerLocation)) continue;
                            this.options.add(waypoint);
                        }
                    }
                    continue block14;
                }
                default: {
                    Object targetLocation = this.getWaypoint(player, (RecallType)testType, null, this.parameters, context);
                    if (targetLocation == null || !((Waypoint)targetLocation).isValid(this.allowCrossWorld, playerLocation)) continue block14;
                    this.options.add((Waypoint)targetLocation);
                }
            }
        }
        if (this.parameters.contains("warp")) {
            String warpName = this.parameters.getString("warp");
            Waypoint waypoint = this.getWarp(warpName);
            if (this.tryTeleport(player, waypoint)) {
                if (this.teleport) {
                    return this.doTeleport();
                }
                return SpellResult.CAST;
            }
            return SpellResult.FAIL;
        }
        if (this.parameters.contains("type")) {
            RecallType recallType;
            String typeString = this.parameters.getString("type", "");
            if (this.parameters.getBoolean("allow_marker", true)) {
                if (typeString.equalsIgnoreCase("remove")) {
                    if (this.removeMarker()) {
                        return SpellResult.TARGET_SELECTED;
                    }
                    return SpellResult.FAIL;
                }
                if (typeString.equalsIgnoreCase("place")) {
                    Block block = context.getLocation().getBlock();
                    if (this.parameters.getBoolean("marker_requires_build", true) && !context.hasBuildPermission(block)) {
                        return SpellResult.NO_TARGET;
                    }
                    if (this.hasMarker() && this.parameters.getBoolean("confirm_marker", true)) {
                        this.showMarkerConfirm(context);
                        return SpellResult.CAST;
                    }
                    if (this.placeMarker(block, 1)) {
                        return SpellResult.TARGET_SELECTED;
                    }
                    return SpellResult.FAIL;
                }
            }
            try {
                recallType = RecallType.valueOf(typeString.toUpperCase());
            }
            catch (Exception ex) {
                controller.getLogger().warning("Invalid recall type: " + typeString);
                return SpellResult.FAIL;
            }
            Waypoint location = this.getWaypoint(player, recallType, null, this.parameters, context);
            if (this.tryTeleport(player, location)) {
                if (this.teleport) {
                    return this.doTeleport();
                }
                return SpellResult.CAST;
            }
            return SpellResult.FAIL;
        }
        if (this.options.size() == 0) {
            return SpellResult.NO_TARGET;
        }
        String inventoryTitle = context.getMessage(this.titleKey, this.parameters.getString("title", "Recall"));
        int invSize = (int)Math.ceil((float)this.options.size() / 9.0f) * 9;
        Inventory displayInventory = CompatibilityLib.getCompatibilityUtils().createInventory(null, invSize, inventoryTitle);
        int index = 0;
        for (Waypoint waypoint : this.options) {
            ItemMeta meta;
            if (waypoint.permission != null && !player.hasPermission(waypoint.permission)) continue;
            boolean isPlaceholder = waypoint.type == RecallType.PLACEHOLDER;
            boolean isValid = !isPlaceholder && waypoint.isValid(this.allowCrossWorld, playerLocation);
            boolean isUnavailable = false;
            if (!isPlaceholder && !this.parameters.getBoolean("allow_" + waypoint.type.name().toLowerCase(), true)) {
                isUnavailable = true;
            }
            if (!(isUnavailable || !waypoint.locked || waypoint.warpName != null && unlockedWarps.contains(waypoint.warpName))) {
                if (!waypoint.showUnavailable) continue;
                isUnavailable = true;
            }
            if (!isValid) {
                isUnavailable = true;
            }
            if (isUnavailable && !waypoint.showUnavailable) {
                waypoint.unavailable = true;
                isPlaceholder = true;
            }
            ItemStack waypointItem = null;
            if (isPlaceholder) {
                String iconPlaceholderKey = this.parameters.getString("placeholder_icon", "air");
                waypointItem = controller.createItem(iconPlaceholderKey);
                if (waypointItem == null) {
                    waypointItem = new ItemStack(DefaultWaypointMaterial);
                }
            } else if (isUnavailable) {
                if (waypoint.unavailableIcon != null) {
                    waypointItem = waypoint.unavailableIcon.getItemStack(1);
                } else if (waypoint.iconURL != null && !waypoint.iconURL.isEmpty()) {
                    waypointItem = controller.getURLSkull(waypoint.iconURL);
                } else if (waypoint.icon != null) {
                    waypointItem = waypoint.icon.getItemStack(1);
                }
            } else if (waypoint.iconURL != null && !waypoint.iconURL.isEmpty()) {
                waypointItem = controller.getURLSkull(waypoint.iconURL);
            } else if (waypoint.icon != null) {
                waypointItem = waypoint.icon.getItemStack(1);
            }
            ItemMeta itemMeta = meta = waypointItem == null ? null : waypointItem.getItemMeta();
            if (meta == null && !isPlaceholder) {
                waypointItem = new ItemStack(DefaultWaypointMaterial);
                meta = waypointItem.getItemMeta();
                controller.getLogger().warning("Invalid waypoint icon for " + waypoint.name);
            }
            if (meta != null) {
                String name = waypoint.name;
                if (!isValid || isUnavailable || isPlaceholder) {
                    name = context.getMessage("unavailable_name", " ").replace("$name", name);
                }
                meta.setDisplayName(name);
                if (waypoint.description != null && waypoint.description.length() > 0) {
                    ArrayList<String> lore = new ArrayList<String>();
                    CompatibilityLib.getInventoryUtils().wrapText(context.parameterize(waypoint.description), lore);
                    meta.setLore(lore);
                }
                String invalidMessage = context.getMessage("invalid_description");
                if (!isValid) {
                    lore = meta.getLore();
                    if (lore == null) {
                        lore = new ArrayList<String>();
                    }
                    CompatibilityLib.getInventoryUtils().wrapText(invalidMessage, lore);
                    meta.setLore(lore);
                } else if (isUnavailable && waypoint.unavailableMessage != null && waypoint.unavailableMessage.length() > 0) {
                    lore = meta.getLore();
                    if (lore == null) {
                        lore = new ArrayList();
                    }
                    CompatibilityLib.getInventoryUtils().wrapText(waypoint.unavailableMessage, lore);
                    meta.setLore(lore);
                }
                waypointItem.setItemMeta(meta);
                waypointItem = CompatibilityLib.getItemUtils().makeReal(waypointItem);
                CompatibilityLib.getItemUtils().hideFlags(waypointItem, CompatibilityConstants.ALL_HIDE_FLAGS);
                CompatibilityLib.getNBTUtils().setString(waypointItem, "waypoint", "true");
                CompatibilityLib.getItemUtils().makeUnbreakable(waypointItem);
                if (isPlaceholder) {
                    CompatibilityLib.getNBTUtils().setBoolean(waypointItem, "placeholder", true);
                }
                if (isUnavailable) {
                    CompatibilityLib.getNBTUtils().setBoolean(waypointItem, "unavailable", true);
                }
            }
            displayInventory.setItem(index, waypointItem);
            if (++index < displayInventory.getSize()) continue;
            break;
        }
        context.playEffects("menu");
        mage.activateGUI(this, displayInventory);
        this.isActive = true;
        return SpellResult.PENDING;
    }

    protected void showMarkerConfirm(CastContext context) {
        this.options.clear();
        String inventoryTitle = context.getMessage("move_marker_title", "Move Marker");
        int invSize = (int)Math.ceil((float)this.markerCount / 9.0f) * 9;
        Inventory displayInventory = CompatibilityLib.getCompatibilityUtils().createInventory(null, invSize, inventoryTitle);
        ItemData iconType = RecallAction.getIcon(context, this.parameters, "icon_move_marker");
        if (iconType == null) {
            iconType = context.getController().getOrCreateItem(Material.STICK);
        }
        int startIndex = 0;
        if (this.markerCount < 8) {
            startIndex = (9 - this.markerCount) / 2;
        }
        for (int marker = 1; marker <= this.markerCount; ++marker) {
            int inventoryIndex = startIndex + marker - 1;
            ItemStack markerItem = iconType.getItemStack(1);
            ItemMeta meta = markerItem.getItemMeta();
            meta.setDisplayName(context.getMessage("title_move_marker").replace("$number", Integer.toString(marker)));
            String description = context.getMessage("description_move_marker");
            if (!description.isEmpty()) {
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(description);
                meta.setLore(lore);
            }
            markerItem.setItemMeta(meta);
            markerItem = CompatibilityLib.getItemUtils().makeReal(markerItem);
            CompatibilityLib.getItemUtils().hideFlags(markerItem, CompatibilityConstants.ALL_HIDE_FLAGS);
            CompatibilityLib.getNBTUtils().setInt(markerItem, "move_marker", marker);
            displayInventory.setItem(inventoryIndex, markerItem);
            context.getMage().activateGUI(this, displayInventory);
        }
    }

    @Nullable
    protected Waypoint getFriend(String uuid) {
        Player onlinePlayer = Bukkit.getPlayer((UUID)UUID.fromString(uuid));
        if (onlinePlayer == null) {
            return null;
        }
        String playerName = onlinePlayer.getDisplayName();
        String castMessage = this.context.getMessage("cast_friend").replace("$name", playerName);
        String failMessage = this.context.getMessage("no_target_friend").replace("$name", playerName);
        String title = this.context.getMessage("title_friend", "$name").replace("$name", playerName);
        String iconURL = CompatibilityLib.getSkinUtils().getOnlineSkinURL(onlinePlayer);
        return new Waypoint(this, this.context, RecallType.FRIENDS, onlinePlayer.getLocation(), title, castMessage, failMessage, "", null, iconURL);
    }

    @Nullable
    protected Waypoint getRemoveFriend(String uuid) {
        UUID playerId = UUID.fromString(uuid);
        Player onlinePlayer = Bukkit.getPlayer((UUID)playerId);
        if (onlinePlayer == null) {
            return null;
        }
        String playerName = onlinePlayer.getDisplayName();
        String castMessage = this.context.getMessage("cast_remove_friend").replace("$name", playerName);
        String failMessage = this.context.getMessage("no_target_remove_friend").replace("$name", playerName);
        String title = this.context.getMessage("title_remove_friend", "$name").replace("$name", playerName);
        String iconURL = CompatibilityLib.getSkinUtils().getOnlineSkinURL(onlinePlayer);
        Waypoint removeWaypoint = new Waypoint(this, this.context, RecallType.REMOVE_FRIENDS, onlinePlayer.getLocation(), title, castMessage, failMessage, "", null, iconURL);
        removeWaypoint.friendId = playerId;
        return removeWaypoint;
    }

    @Nullable
    protected Waypoint getWarp(String warpName) {
        for (Waypoint waypoint : this.options) {
            if (waypoint.type != RecallType.WARP || !waypoint.warpName.equals(warpName)) continue;
            return waypoint;
        }
        return null;
    }

    @Nullable
    protected Waypoint getWaypoint(Player player, RecallType type, Location location, ConfigurationSection parameters, CastContext context) {
        Mage mage = context.getMage();
        MageController controller = context.getController();
        switch (type.ordinal()) {
            case 7: {
                location = ConfigurationUtils.getLocation(mage.getData(), this.markerKey);
                return new Waypoint(this, context, type, location, context.getMessage("title_marker"), context.getMessage("cast_marker", "Market"), context.getMessage("no_target_marker"), context.getMessage("description_marker", ""), RecallAction.getIcon(context, parameters, "icon_marker"), this.markerMaintainDirection);
            }
            case 2: {
                Waypoint death = new Waypoint(this, context, type, mage.getLastDeathLocation(), "Last Death", context.getMessage("cast_death", "Last Death"), context.getMessage("no_target_death"), context.getMessage("description_death", ""), RecallAction.getIcon(context, parameters, "icon_death"), true);
                death.safe = false;
                return death;
            }
            case 4: {
                return new Waypoint(this, context, type, context.getWorld().getSpawnLocation(), context.getMessage("title_spawn", "Spawn"), context.getMessage("cast_spawn"), context.getMessage("no_target_spawn"), context.getMessage("description_spawn", ""), RecallAction.getIcon(context, parameters, "icon_spawn"), false);
            }
            case 5: {
                return new Waypoint(this, context, type, controller.getTownLocation(player), context.getMessage("title_town", "Town"), context.getMessage("cast_town"), context.getMessage("no_target_town"), context.getMessage("description_town", ""), RecallAction.getIcon(context, parameters, "icon_town"), false);
            }
            case 6: {
                Location bedLocation;
                Location location2 = bedLocation = player == null ? null : player.getBedSpawnLocation();
                if (bedLocation == null || bedLocation.getWorld() == null) {
                    return null;
                }
                bedLocation.setX(bedLocation.getX() + 0.5);
                bedLocation.setZ(bedLocation.getZ() + 0.5);
                bedLocation.setY(bedLocation.getY() + 1.0);
                return new Waypoint(this, context, type, bedLocation, context.getMessage("title_home", "Home"), context.getMessage("cast_home"), context.getMessage("no_target_home"), context.getMessage("description_home", ""), RecallAction.getIcon(context, parameters, "icon_home"), false);
            }
            case 8: {
                return new Waypoint(this, context, type, location, context.getMessage("title_wand", "Lost Wand"), context.getMessage("cast_wand"), context.getMessage("no_target_wand"), context.getMessage("description_wand", ""), RecallAction.getIcon(context, parameters, "icon_wand"), true);
            }
            case 3: {
                return new Waypoint(this, context, type, location, context.getMessage("title_soul", "Lost Soul"), context.getMessage("cast_soul"), context.getMessage("no_target_soul"), context.getMessage("description_soul", ""), RecallAction.getIcon(context, parameters, "icon_soul"), false);
            }
        }
        return null;
    }

    @Nullable
    protected static ItemData getIcon(CastContext context, String key, ItemData defaultIcon) {
        if (key == null || key.isEmpty()) {
            return defaultIcon;
        }
        return context.getController().getOrCreateItem(key);
    }

    @Nullable
    protected static ItemData getIcon(CastContext context, ConfigurationSection parameters, String key, ItemData defaultIcon) {
        String iconKey = parameters.getString(key);
        return RecallAction.getIcon(context, iconKey, defaultIcon);
    }

    @Nullable
    protected static ItemData getIcon(CastContext context, ConfigurationSection parameters, String key) {
        return RecallAction.getIcon(context, parameters, key, null);
    }

    protected boolean removeMarker() {
        Mage mage = this.context.getMage();
        ConfigurationSection mageData = mage.getData();
        Location location = ConfigurationUtils.getLocation(mageData, this.markerKey);
        if (location == null) {
            return false;
        }
        mageData.set(this.markerKey, null);
        return true;
    }

    protected boolean hasMarker() {
        Mage mage = this.context.getMage();
        ConfigurationSection mageData = mage.getData();
        Location location = ConfigurationUtils.getLocation(mageData, this.markerKey);
        return location != null;
    }

    protected boolean tryTeleport(Player player, Waypoint waypoint) {
        Mage mage = this.context.getMage();
        if (waypoint == null) {
            return false;
        }
        if (waypoint.isCommand()) {
            if (waypoint.asConsole) {
                try {
                    player.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), waypoint.command);
                }
                catch (Exception ex) {
                    this.context.getLogger().log(Level.WARNING, "Error running command as console " + waypoint.command, ex);
                }
            } else {
                CommandSender sender = mage.getCommandSender();
                boolean isOp = sender.isOp();
                if (waypoint.opPlayer && !isOp) {
                    sender.setOp(true);
                }
                try {
                    player.getServer().dispatchCommand(sender, waypoint.command);
                }
                catch (Exception ex) {
                    this.context.getLogger().log(Level.WARNING, "Error running command " + waypoint.command, ex);
                }
                if (waypoint.opPlayer && !isOp) {
                    sender.setOp(false);
                }
            }
            mage.enableSuperProtection(this.protectionTime);
            return true;
        }
        if (waypoint.type == RecallType.REMOVE_FRIENDS) {
            this.removeFriend(mage, waypoint.friendId);
            MageController controller = this.context.getController();
            Player online = controller.getPlugin().getServer().getPlayer(waypoint.friendId);
            Entity mageEntity = mage.getEntity();
            if (online != null && mageEntity != null) {
                Mage friendMage = controller.getMage(online);
                this.removeFriend(friendMage, mageEntity.getUniqueId());
            }
            return true;
        }
        Location targetLocation = waypoint.location;
        if (targetLocation == null) {
            String serverName = waypoint.serverName;
            String warpName = waypoint.warpName;
            if (warpName != null && serverName != null) {
                this.context.getController().warpPlayerToServer(player, serverName, warpName);
            } else if (serverName != null) {
                this.context.getController().sendPlayerToServer(player, serverName);
            } else {
                this.context.sendMessageKey("teleport_failed", waypoint.failMessage);
            }
            return false;
        }
        if (!this.allowCrossWorld && !mage.getLocation().getWorld().equals((Object)targetLocation.getWorld())) {
            this.context.sendMessageKey("cross_world_disallowed");
            return false;
        }
        if (waypoint.maintainDirection) {
            Location playerLocation = player.getLocation();
            targetLocation.setYaw(playerLocation.getYaw());
            targetLocation.setPitch(playerLocation.getPitch());
        }
        if (!this.teleport) {
            mage.enableSuperProtection(this.protectionTime);
        }
        this.context.getMage().sendDebugMessage(String.valueOf(ChatColor.DARK_GREEN) + " Set new target location to " + String.valueOf(ChatColor.GRAY) + targetLocation.getBlockX() + String.valueOf(ChatColor.DARK_GRAY) + "," + String.valueOf(ChatColor.GRAY) + targetLocation.getBlockY() + String.valueOf(ChatColor.DARK_GRAY) + "," + String.valueOf(ChatColor.GRAY) + targetLocation.getBlockZ() + String.valueOf(ChatColor.DARK_GRAY), 6);
        this.context.setTargetLocation(targetLocation);
        this.selectedWaypoint = waypoint;
        return true;
    }

    protected SpellResult doTeleport() {
        Mage mage;
        Entity targetEntity;
        if (this.teleportTarget) {
            targetEntity = this.context.getTargetEntity();
            mage = this.context.getController().getRegisteredMage(targetEntity);
        } else {
            mage = this.context.getMage();
            targetEntity = mage.getPlayer();
        }
        if (targetEntity == null) {
            return SpellResult.NO_TARGET;
        }
        Location targetLocation = this.context.getTargetLocation();
        if (this.requireTargetPermission && !this.context.canContinue(targetLocation)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (!CompatibilityLib.getCompatibilityUtils().checkChunk(targetLocation)) {
            this.pendingTeleport = targetLocation;
            return SpellResult.PENDING;
        }
        this.pendingTeleport = null;
        if (this.selectedWaypoint == null) {
            this.context.getLogger().warning("RecallAction got to doTeleport with no waypoint selected in spell " + this.context.getSpell().getName());
            return SpellResult.FAIL;
        }
        this.context.playEffects("teleporting");
        if (!this.context.teleport(targetEntity, targetLocation, this.verticalSearchDistance, this.selectedWaypoint.safe, this.selectedWaypoint.safe)) {
            this.context.sendMessageKey("teleport_failed", this.selectedWaypoint.failMessage);
            return SpellResult.FAIL;
        }
        this.context.castMessageKey("teleport", this.selectedWaypoint.message);
        if (mage != null) {
            mage.enableSuperProtection(this.protectionTime);
        }
        return SpellResult.CAST;
    }

    protected boolean placeMarker(Block target, int markerNumber) {
        if (target == null) {
            return false;
        }
        Mage mage = this.context.getMage();
        ConfigurationSection mageData = mage.getData();
        String markerKey = this.getMarkerKey(markerNumber);
        Location location = ConfigurationUtils.getLocation(mageData, markerKey);
        this.context.registerForUndo(new UndoMarkerMove(mage, location, markerKey));
        if (location != null) {
            this.context.sendMessageKey("cast_marker_move");
        } else {
            this.context.sendMessageKey("cast_marker_place");
        }
        location = this.context.getLocation();
        location.setX((double)target.getX() + 0.5);
        location.setY((double)target.getY());
        location.setZ((double)target.getZ() + 0.5);
        mageData.set(markerKey, (Object)ConfigurationUtils.fromLocation(location));
        return true;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("addfriend");
        parameters.add("removefriend");
        parameters.add("lock");
        parameters.add("unlock");
        parameters.add("warp");
        parameters.add("type");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("addfriend") || parameterKey.equals("removefriend")) {
            examples.addAll(spell.getController().getPlayerNames());
        }
    }

    @Override
    public void reset(CastContext context) {
        this.delayExpiration = 0L;
        this.selectedWaypoint = null;
        this.isActive = false;
    }

    private void removeFriend(Mage mage, UUID playerId) {
        ConfigurationSection mageData = mage.getData();
        HashSet<String> friends = new HashSet<String>();
        String friendString = mageData.getString(this.friendKey);
        if (friendString != null && !friendString.isEmpty()) {
            friends.addAll(Arrays.asList(StringUtils.split((String)friendString, (char)',')));
        }
        friends.remove(playerId.toString());
        friendString = StringUtils.join(friends, (String)",");
        mageData.set(this.friendKey, (Object)friendString);
    }

    private class Waypoint
    implements Comparable<Waypoint> {
        public final RecallType type;
        public final String name;
        public final Location location;
        public final String message;
        public final String failMessage;
        public final ItemData icon;
        public final String iconURL;
        public final String command;
        public final boolean opPlayer;
        public final boolean asConsole;
        public final boolean maintainDirection;
        public final String warpName;
        public final String serverName;
        public UUID friendId;
        public boolean unavailable = false;
        public String description;
        public boolean showUnavailable;
        public String unavailableMessage;
        public ItemData unavailableIcon;
        public boolean safe = true;
        public boolean locked = false;
        public String permission;

        public Waypoint(RecallAction recallAction, CastContext context, RecallType type, Location location, String name, String message, String failMessage, String description, ItemData icon, boolean maintainDirection) {
            this.name = CompatibilityLib.getCompatibilityUtils().translateColors(name);
            this.type = type;
            this.location = location;
            this.message = message;
            this.description = description == null ? null : CompatibilityLib.getCompatibilityUtils().translateColors(description);
            this.failMessage = failMessage;
            this.icon = icon == null ? context.getController().getOrCreateItem(DefaultWaypointMaterial) : icon;
            this.iconURL = null;
            this.command = null;
            this.opPlayer = false;
            this.asConsole = false;
            this.maintainDirection = maintainDirection;
            this.serverName = null;
            this.warpName = null;
        }

        public Waypoint(RecallAction recallAction, CastContext context, RecallType type, Location location, String name, String message, String failMessage, String description, ItemData icon, String iconURL) {
            this.name = CompatibilityLib.getCompatibilityUtils().translateColors(name);
            this.type = type;
            this.location = location;
            this.message = message;
            this.description = description == null ? null : CompatibilityLib.getCompatibilityUtils().translateColors(description);
            this.failMessage = failMessage;
            this.icon = icon == null ? context.getController().getOrCreateItem(DefaultWaypointMaterial) : icon;
            this.iconURL = iconURL;
            this.command = null;
            this.opPlayer = false;
            this.asConsole = false;
            this.maintainDirection = false;
            this.serverName = null;
            this.warpName = null;
        }

        public Waypoint(RecallAction recallAction, CastContext context, ConfigurationSection configuration) {
            this.warpName = configuration.getString("warp", "");
            this.serverName = configuration.getString("server");
            this.command = configuration.getString("command");
            if (this.command != null) {
                this.type = RecallType.COMMAND;
            } else if (!this.warpName.isEmpty() || this.serverName != null) {
                this.type = RecallType.WARP;
            } else {
                RecallType parsedType;
                try {
                    parsedType = RecallType.valueOf(configuration.getString("type", "placeholder").toUpperCase());
                }
                catch (Exception ex) {
                    parsedType = RecallType.PLACEHOLDER;
                }
                this.type = parsedType;
            }
            Mage mage = context.getMage();
            Player player = mage.getPlayer();
            ItemData defaultIcon = null;
            String defaultTitle = "";
            String defaultMessage = "";
            String defaultFailMessage = "";
            String defaultDescription = "";
            String defaultUnavailableMessage = context.getMessage("unavailable_description", "");
            ItemData defaultUnavailableIcon = RecallAction.getIcon(context, recallAction.parameters, "unavailable_icon");
            boolean defaultShowUnavailable = recallAction.parameters.getBoolean("show_unavailable", false);
            Location location = null;
            boolean defaultMaintainDirection = false;
            boolean defaultSafe = true;
            switch (this.type.ordinal()) {
                case 9: {
                    defaultTitle = context.getMessage("title_warp", "$name").replace("$name", this.command);
                    defaultMessage = context.getMessage("cast_warp", "");
                    defaultFailMessage = context.getMessage("no_target_warp", "");
                    defaultUnavailableMessage = recallAction.parameters.getString("unavailable_warp_description", "");
                    break;
                }
                case 10: {
                    location = context.getController().getWarp(this.warpName);
                    Warp magicWarp = context.getController().getMagicWarp(this.warpName);
                    String warpLabel = this.warpName;
                    if (magicWarp != null) {
                        String iconKey;
                        warpLabel = magicWarp.getName();
                        String warpDescription = magicWarp.getDescription();
                        if (warpDescription != null) {
                            defaultDescription = warpDescription;
                        }
                        if ((iconKey = magicWarp.getIcon()) != null && !iconKey.isEmpty()) {
                            defaultIcon = context.getController().getOrCreateItem(iconKey);
                        }
                    }
                    defaultTitle = context.getMessage("title_warp", "$name").replace("$name", warpLabel);
                    defaultMessage = context.getMessage("cast_warp", "");
                    defaultFailMessage = context.getMessage("no_target_warp", "");
                    defaultUnavailableMessage = context.getMessage("unavailable_warp_description", "");
                    break;
                }
                case 7: {
                    int markerNumber = configuration.getInt("marker", 1);
                    location = ConfigurationUtils.getLocation(mage.getData(), recallAction.getMarkerKey(markerNumber));
                    defaultTitle = context.getMessage("title_marker", "Marker #$number").replace("$number", Integer.toString(markerNumber));
                    defaultMessage = context.getMessage("cast_marker", "").replace("$number", Integer.toString(markerNumber));
                    defaultFailMessage = context.getMessage("no_target_marker", "").replace("$number", Integer.toString(markerNumber));
                    defaultDescription = context.getMessage("description_marker", "").replace("$number", Integer.toString(markerNumber));
                    defaultIcon = RecallAction.getIcon(context, recallAction.parameters, "icon_marker");
                    defaultMaintainDirection = recallAction.markerMaintainDirection;
                    break;
                }
                case 2: {
                    location = mage.getLastDeathLocation();
                    defaultTitle = context.getMessage("title_death", "Last Death");
                    defaultMessage = context.getMessage("cast_death", "");
                    defaultFailMessage = context.getMessage("no_target_death", "");
                    defaultDescription = context.getMessage("description_death", "");
                    String iconString = recallAction.parameters.getString("icon_death");
                    defaultIcon = iconString.equals("skull_item") ? context.getController().getOrCreateItem(DefaultMaterials.getSkeletonSkullItem()) : RecallAction.getIcon(context, recallAction.parameters, "icon_death");
                    defaultMaintainDirection = true;
                    defaultSafe = false;
                    break;
                }
                case 4: {
                    location = context.getWorld().getSpawnLocation();
                    defaultTitle = context.getMessage("title_spawn", "Spawn");
                    defaultMessage = context.getMessage("cast_spawn", "");
                    defaultFailMessage = context.getMessage("no_target_spawn", "");
                    defaultDescription = context.getMessage("description_spawn", "");
                    defaultIcon = RecallAction.getIcon(context, recallAction.parameters, "icon_spawn");
                    break;
                }
                case 5: {
                    location = player == null ? null : context.getController().getTownLocation(player);
                    defaultTitle = context.getMessage("title_town", "Town");
                    defaultMessage = context.getMessage("cast_town", "");
                    defaultFailMessage = context.getMessage("no_target_town", "");
                    defaultDescription = context.getMessage("description_town", "");
                    defaultIcon = RecallAction.getIcon(context, recallAction.parameters, "icon_town");
                    break;
                }
                case 6: {
                    Location bedLocation = CompatibilityLib.getCompatibilityUtils().getBedSpawnLocation(player);
                    if (bedLocation != null) {
                        bedLocation = bedLocation.clone();
                        bedLocation.setX(bedLocation.getX() + 0.5);
                        bedLocation.setZ(bedLocation.getZ() + 0.5);
                        bedLocation.setY(bedLocation.getY() + 1.0);
                    }
                    location = bedLocation;
                    defaultTitle = context.getMessage("title_home", "Home");
                    defaultMessage = context.getMessage("cast_home", "");
                    defaultFailMessage = context.getMessage("no_target_home", "");
                    defaultDescription = context.getMessage("description_home", "");
                    defaultIcon = RecallAction.getIcon(context, recallAction.parameters, "icon_home");
                    break;
                }
            }
            String optionName = configuration.getString("name", defaultTitle);
            this.name = CompatibilityLib.getCompatibilityUtils().translateColors(optionName);
            this.message = configuration.getString("message", defaultMessage).replace("$name", this.name);
            this.description = CompatibilityLib.getCompatibilityUtils().translateColors(configuration.getString("description", defaultDescription));
            this.failMessage = configuration.getString("fail_message", defaultFailMessage).replace("$name", this.name);
            this.icon = RecallAction.getIcon(context, configuration.getString("icon"), defaultIcon);
            this.iconURL = configuration.getString("icon_url");
            this.opPlayer = configuration.getBoolean("op");
            this.asConsole = configuration.getBoolean("console");
            this.maintainDirection = configuration.getBoolean("keep_direction", defaultMaintainDirection);
            this.safe = configuration.getBoolean("safe", defaultSafe);
            this.showUnavailable = configuration.getBoolean("show_unavailable", defaultShowUnavailable);
            this.unavailableIcon = RecallAction.getIcon(context, configuration, "icon_disabled", defaultUnavailableIcon);
            this.unavailableMessage = configuration.getString("unavailable_description", defaultUnavailableMessage);
            this.locked = configuration.getBoolean("locked", false);
            this.permission = configuration.getString("permission");
            this.location = location;
        }

        @Override
        public int compareTo(Waypoint o) {
            if (this.type != o.type) {
                if (this.type == RecallType.COMMAND) {
                    return -1;
                }
                if (o.type == RecallType.COMMAND) {
                    return 1;
                }
                if (this.type == RecallType.WARP) {
                    return -1;
                }
                if (o.type == RecallType.WARP) {
                    return 1;
                }
            }
            return this.name.compareTo(o.name);
        }

        public boolean isValid(boolean crossWorld, Location source) {
            if (this.isCommand()) {
                return true;
            }
            if (this.location == null || this.location.getWorld() == null) {
                return this.serverName != null;
            }
            return crossWorld || source.getWorld().equals((Object)this.location.getWorld());
        }

        public boolean isCommand() {
            return this.command != null;
        }
    }

    private static enum RecallType {
        REGIONS,
        ALL_REGIONS,
        DEATH,
        SOULS,
        SPAWN,
        TOWN,
        HOME,
        MARKER,
        WAND,
        COMMAND,
        WARP,
        FRIENDS,
        REMOVE_FRIENDS(false),
        PLACEHOLDER;

        public final boolean showByDefault;

        private RecallType() {
            this.showByDefault = true;
        }

        private RecallType(boolean show) {
            this.showByDefault = show;
        }
    }

    private static class UndoMarkerMove
    implements Runnable {
        private final Location location;
        private final WeakReference<Mage> mage;
        private final String markerKey;

        public UndoMarkerMove(Mage mage, Location currentLocation, String markerKey) {
            this.location = currentLocation;
            this.mage = new WeakReference<Mage>(mage);
            this.markerKey = markerKey;
        }

        @Override
        public void run() {
            Mage mage = (Mage)this.mage.get();
            if (mage != null) {
                mage.getData().set(this.markerKey, (Object)ConfigurationUtils.fromLocation(this.location));
            }
        }
    }
}

