/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_20_6;

import com.elmakers.mine.bukkit.ChatUtils;
import com.elmakers.mine.bukkit.utility.BoundingBox;
import com.elmakers.mine.bukkit.utility.EnteredStateTracker;
import com.elmakers.mine.bukkit.utility.ReflectionUtils;
import com.elmakers.mine.bukkit.utility.platform.ItemUtils;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import com.elmakers.mine.bukkit.utility.platform.SpigotUtils;
import com.elmakers.mine.bukkit.utility.platform.modern.ModernCompatibilityUtils;
import com.elmakers.mine.bukkit.utility.platform.v1_20_6.populator.OutOfBoundsEntityCleanup;
import com.google.common.collect.Multimap;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityDragonFireball;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.entity.projectile.EntityFireballFireball;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.EntitySpectralArrow;
import net.minecraft.world.entity.projectile.EntityThrownExpBottle;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemBoneMeal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Rotation;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Jukebox;
import org.bukkit.block.Lectern;
import org.bukkit.block.Lockable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemorySection;
import org.bukkit.craftbukkit.v1_20_R4.CraftArt;
import org.bukkit.craftbukkit.v1_20_R4.CraftServer;
import org.bukkit.craftbukkit.v1_20_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftArmorStand;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftHanging;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftItem;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R4.scheduler.CraftTask;
import org.bukkit.craftbukkit.v1_20_R4.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_20_R4.util.CraftMagicNumbers;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Sittable;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.KnowledgeBookMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.loot.Lootable;
import org.bukkit.map.MapView;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class CompatibilityUtils
extends ModernCompatibilityUtils {
    private final Map<String, EntityTypes<?>> projectileEntityTypes = new HashMap();
    private final Map<String, Class<? extends IProjectile>> projectileClasses = new HashMap<String, Class<? extends IProjectile>>();

    public CompatibilityUtils(Platform platform) {
        super(platform);
        this.populateProjectileClasses();
    }

    private void addProjectileClass(String key, Class<? extends IProjectile> projectileClass, EntityTypes<?> entityType) {
        this.projectileClasses.put(key, projectileClass);
        this.projectileEntityTypes.put(projectileClass.getSimpleName(), entityType);
    }

    private void populateProjectileClasses() {
        this.addProjectileClass("arrow", EntityTippedArrow.class, EntityTypes.e);
        this.addProjectileClass("tippedarrow", EntityTippedArrow.class, EntityTypes.e);
        this.addProjectileClass("tipped_arrow", EntityTippedArrow.class, EntityTypes.e);
        this.addProjectileClass("dragonfireball", EntityDragonFireball.class, EntityTypes.A);
        this.addProjectileClass("dragon_fireball", EntityDragonFireball.class, EntityTypes.A);
        this.addProjectileClass("fireball", EntityLargeFireball.class, EntityTypes.ak);
        this.addProjectileClass("largefireball", EntityLargeFireball.class, EntityTypes.ak);
        this.addProjectileClass("large_fireball", EntityLargeFireball.class, EntityTypes.ak);
        this.addProjectileClass("smallfireball", EntitySmallFireball.class, EntityTypes.aQ);
        this.addProjectileClass("small_fireball", EntitySmallFireball.class, EntityTypes.aQ);
        this.addProjectileClass("fireworks", EntityFireworks.class, EntityTypes.P);
        this.addProjectileClass("firework", EntityFireworks.class, EntityTypes.P);
        this.addProjectileClass("fireworkrocket", EntityFireworks.class, EntityTypes.P);
        this.addProjectileClass("firework_rocket", EntityFireworks.class, EntityTypes.P);
        this.addProjectileClass("fireworkrocketentity", EntityFireworks.class, EntityTypes.P);
        this.addProjectileClass("fishinghook", EntityFishingHook.class, EntityTypes.bz);
        this.addProjectileClass("fishing_hook", EntityFishingHook.class, EntityTypes.bz);
        this.addProjectileClass("fishing_bobber", EntityFishingHook.class, EntityTypes.bz);
        this.addProjectileClass("llamaspit", EntityLlamaSpit.class, EntityTypes.ao);
        this.addProjectileClass("llama_spit", EntityLlamaSpit.class, EntityTypes.ao);
        this.addProjectileClass("shulkerbullet", EntityShulkerBullet.class, EntityTypes.aL);
        this.addProjectileClass("shulker_bullet", EntityShulkerBullet.class, EntityTypes.aL);
        this.addProjectileClass("snowball", EntitySnowball.class, EntityTypes.aT);
        this.addProjectileClass("spectralarrow", EntitySpectralArrow.class, EntityTypes.aV);
        this.addProjectileClass("spectral_arrow", EntitySpectralArrow.class, EntityTypes.aV);
        this.addProjectileClass("egg", EntityEgg.class, EntityTypes.C);
        this.addProjectileClass("thrownegg", EntityEgg.class, EntityTypes.C);
        this.addProjectileClass("enderpearl", EntityEnderPearl.class, EntityTypes.G);
        this.addProjectileClass("ender_pearl", EntityEnderPearl.class, EntityTypes.G);
        this.addProjectileClass("thrownenderpearl", EntityEnderPearl.class, EntityTypes.G);
        this.addProjectileClass("thrownexperiencebottle", EntityThrownExpBottle.class, EntityTypes.L);
        this.addProjectileClass("experiencebottle", EntityThrownExpBottle.class, EntityTypes.L);
        this.addProjectileClass("thrownpotion", EntityPotion.class, EntityTypes.aE);
        this.addProjectileClass("potion", EntityPotion.class, EntityTypes.aE);
        this.addProjectileClass("throwntrident", EntityThrownTrident.class, EntityTypes.bf);
        this.addProjectileClass("trident", EntityThrownTrident.class, EntityTypes.bf);
        this.addProjectileClass("witherskull", EntityWitherSkull.class, EntityTypes.br);
        this.addProjectileClass("wither_skull", EntityWitherSkull.class, EntityTypes.br);
    }

    @Override
    public Inventory createInventory(InventoryHolder holder, int size, String name) {
        size = (int)(Math.ceil((double)size / 9.0) * 9.0);
        size = Math.min(size, 54);
        String translatedName = this.translateColors(name);
        return Bukkit.createInventory((InventoryHolder)holder, (int)size, (String)translatedName);
    }

    @Override
    public boolean isInvulnerable(Entity entity) {
        return entity.isInvulnerable();
    }

    @Override
    public void setInvulnerable(Entity entity, boolean flag) {
        entity.setInvulnerable(flag);
    }

    @Override
    public boolean isSilent(Entity entity) {
        return entity.isSilent();
    }

    @Override
    public void setSilent(Entity entity, boolean flag) {
        entity.setSilent(flag);
    }

    @Override
    public boolean isPersist(Entity entity) {
        return entity.isPersistent();
    }

    @Override
    public void setPersist(Entity entity, boolean flag) {
        entity.setPersistent(flag);
    }

    @Override
    public void setRemoveWhenFarAway(Entity entity, boolean flag) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity li = (LivingEntity)entity;
        li.setRemoveWhenFarAway(flag);
    }

    @Override
    public boolean isSitting(Entity entity) {
        if (!(entity instanceof Sittable)) {
            return false;
        }
        Sittable sittable = (Sittable)entity;
        return sittable.isSitting();
    }

    @Override
    public void setSitting(Entity entity, boolean flag) {
        if (!(entity instanceof Sittable)) {
            return;
        }
        Sittable sittable = (Sittable)entity;
        sittable.setSitting(flag);
    }

    @Override
    public Painting createPainting(Location location, BlockFace facing, Art art) {
        Painting newPainting = null;
        WorldServer level = ((CraftWorld)location.getWorld()).getHandle();
        EnumDirection directionEnum = null;
        try {
            directionEnum = EnumDirection.valueOf((String)facing.name());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        BlockPosition blockLocation = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        EntityPainting newEntity = new EntityPainting((net.minecraft.world.level.World)level, blockLocation, directionEnum, Holder.a((Object)CraftArt.bukkitToMinecraft((Art)art)));
        CraftEntity bukkitEntity = newEntity.getBukkitEntity();
        if (bukkitEntity != null && bukkitEntity instanceof Painting) {
            newPainting = (Painting)bukkitEntity;
        }
        return newPainting;
    }

    @Override
    public ItemFrame createItemFrame(Location location, BlockFace facing, Rotation rotation, org.bukkit.inventory.ItemStack item) {
        ItemFrame newItemFrame = null;
        WorldServer level = ((CraftWorld)location.getWorld()).getHandle();
        EnumDirection directionEnum = null;
        try {
            directionEnum = EnumDirection.valueOf((String)facing.name());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        BlockPosition blockLocation = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        EntityItemFrame newEntity = new EntityItemFrame((net.minecraft.world.level.World)level, blockLocation, directionEnum);
        CraftEntity bukkitEntity = newEntity.getBukkitEntity();
        if (bukkitEntity != null && bukkitEntity instanceof ItemFrame) {
            newItemFrame = (ItemFrame)bukkitEntity;
            newItemFrame.setItem(this.platform.getItemUtils().getCopy(item));
            newItemFrame.setRotation(rotation);
        }
        return newItemFrame;
    }

    @Override
    public Entity createEntity(Location location, EntityType entityType) {
        World world = location.getWorld();
        Entity bukkitEntity = null;
        try {
            bukkitEntity = world.createEntity(location, entityType.getEntityClass());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return bukkitEntity;
    }

    @Override
    public boolean addToWorld(World world, Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        WorldServer level = ((CraftWorld)world).getHandle();
        net.minecraft.world.entity.Entity entityHandle = ((CraftEntity)entity).getHandle();
        level.addFreshEntity(entityHandle, reason);
        return true;
    }

    @Override
    public Collection<Entity> getNearbyEntities(Location location, double x, double y, double z) {
        if (location == null) {
            return null;
        }
        x = Math.min(x, 72.0);
        z = Math.min(z, 72.0);
        return location.getWorld().getNearbyEntities(location, x, y, z);
    }

    @Override
    public void ageItem(Item item, int ticksToAge) {
        EntityItem nmsItem = ((CraftItem)item).getHandle();
        nmsItem.i = ticksToAge;
    }

    @Override
    public void magicDamage(org.bukkit.entity.Damageable target, double amount, Entity source) {
        block18: {
            try {
                net.minecraft.world.entity.Entity sourceHandle;
                if (target == null || target.isDead()) {
                    return;
                }
                if (!USE_MAGIC_DAMAGE || target instanceof Witch || target instanceof Enderman || target instanceof ArmorStand || !(target instanceof LivingEntity)) {
                    this.damage(target, amount, source);
                    return;
                }
                net.minecraft.world.entity.Entity targetHandle = ((CraftEntity)target).getHandle();
                if (targetHandle == null) {
                    return;
                }
                net.minecraft.world.entity.Entity entity = sourceHandle = source == null ? null : ((CraftEntity)source).getHandle();
                if (sourceHandle != null && source instanceof LivingEntity) {
                    Location location = target.getLocation();
                    ThrownPotion potion = this.getOrCreatePotionEntity(location);
                    net.minecraft.world.entity.Entity potionHandle = ((CraftEntity)potion).getHandle();
                    potion.setShooter((ProjectileSource)((LivingEntity)source));
                    DamageSource magicSource = sourceHandle.dQ().c(potionHandle, sourceHandle);
                    try (EnteredStateTracker.Touchable damaging = this.isDamaging.enter();){
                        damaging.touch();
                        targetHandle.a(magicSource, (float)amount);
                        break block18;
                    }
                }
                try (EnteredStateTracker.Touchable damaging = this.isDamaging.enter();){
                    damaging.touch();
                    targetHandle.a(targetHandle.dQ().o(), (float)amount);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected DamageSource getDamageSource(String damageType, net.minecraft.world.entity.Entity source, DamageSources damageSources) {
        switch (damageType.toUpperCase()) {
            case "IN_FIRE": {
                return damageSources.a();
            }
            case "LIGHTNING_BOLT": {
                return damageSources.b();
            }
            case "ON_FIRE": {
                return damageSources.c();
            }
            case "LAVA": {
                return damageSources.d();
            }
            case "HOT_FLOOR": {
                return damageSources.e();
            }
            case "IN_WALL": {
                return damageSources.f();
            }
            case "CRAMMING": {
                return damageSources.g();
            }
            case "DROWN": {
                return damageSources.h();
            }
            case "STARVE": {
                return damageSources.i();
            }
            case "CACTUS": {
                return damageSources.j();
            }
            case "FALL": {
                return damageSources.k();
            }
            case "FLY_INTO_WALL": {
                return damageSources.l();
            }
            case "OUT_OF_WORLD": {
                return damageSources.m();
            }
            case "GENERIC": {
                return damageSources.n();
            }
            case "MAGIC": {
                return damageSources.o();
            }
            case "WITHER": {
                return damageSources.p();
            }
            case "ANVIL": {
                return damageSources.b(source);
            }
            case "FALLING_BLOCK": {
                return damageSources.a(source);
            }
            case "DRAGON_BREATH": {
                return damageSources.q();
            }
            case "DRY_OUT": {
                return damageSources.r();
            }
            case "SWEET_BERRY_BUSH": {
                return damageSources.s();
            }
            case "FREEZE": {
                return damageSources.t();
            }
            case "FALLING_STALACTITE": {
                return damageSources.c(source);
            }
            case "STALAGMITE": {
                return damageSources.u();
            }
        }
        return null;
    }

    @Override
    public void damage(org.bukkit.entity.Damageable target, double amount, Entity source, String damageType) {
        if (target == null || target.isDead()) {
            return;
        }
        if (damageType.equalsIgnoreCase("direct")) {
            double health = target.getHealth() - amount;
            target.setHealth(Math.max(health, 0.0));
            return;
        }
        if (damageType.equalsIgnoreCase("magic")) {
            this.magicDamage(target, amount, source);
            return;
        }
        net.minecraft.world.entity.Entity targetHandle = ((CraftEntity)target).getHandle();
        if (targetHandle == null) {
            return;
        }
        net.minecraft.world.entity.Entity sourceHandle = ((CraftEntity)source).getHandle();
        DamageSource damageSource = this.getDamageSource(damageType, sourceHandle, targetHandle.dQ());
        if (damageSource == null) {
            this.magicDamage(target, amount, source);
            return;
        }
        try (EnteredStateTracker.Touchable damaging = this.isDamaging.enter();){
            damaging.touch();
            targetHandle.a(damageSource, (float)amount);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean isReady(Chunk chunk) {
        return true;
    }

    @Override
    public boolean createExplosion(Entity entity, World world, double x, double y, double z, float power, boolean setFire, boolean breakBlocks) {
        return world.createExplosion(x, y, z, power, setFire, breakBlocks, entity);
    }

    public TileEntity getTileEntity(Location location) {
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        BlockPosition blockPos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        return world.getBlockEntity(blockPos, false);
    }

    public NBTTagCompound getTileEntityData(Location location) {
        if (location == null) {
            return null;
        }
        TileEntity tileEntity = this.getTileEntity(location);
        if (tileEntity == null) {
            return null;
        }
        NBTTagCompound tag = tileEntity.b((HolderLookup.a)tileEntity.i().H_());
        return tag;
    }

    @Override
    public void setTileEntityData(Location location, Object data) {
        if (location == null || data == null || !(data instanceof NBTTagCompound)) {
            return;
        }
        TileEntity tileEntity = this.getTileEntity(location);
        if (tileEntity == null) {
            return;
        }
        NBTTagCompound tag = (NBTTagCompound)data;
        tag = tag.i();
        tag.a("x", location.getBlockX());
        tag.a("y", location.getBlockY());
        tag.a("z", location.getBlockZ());
        tileEntity.c(tag, (HolderLookup.a)tileEntity.i().H_());
        tileEntity.e();
    }

    @Override
    public void clearItems(Location location) {
        TileEntity tileEntity;
        if (location == null) {
            return;
        }
        org.bukkit.block.Block block = location.getBlock();
        BlockState blockState = block.getState();
        if (blockState instanceof Lootable) {
            Lootable lootable = (Lootable)blockState;
            lootable.setLootTable(null);
            blockState.update();
        }
        if (blockState instanceof Lectern) {
            Lectern lectern = (Lectern)blockState;
            lectern.getInventory().setItem(0, new org.bukkit.inventory.ItemStack(Material.AIR));
            blockState.update();
        }
        if (blockState instanceof Jukebox) {
            ((Jukebox)blockState).setRecord(null);
            blockState.update();
        }
        if ((tileEntity = this.getTileEntity(location)) == null) {
            return;
        }
        NBTTagCompound tag = tileEntity.b((HolderLookup.a)tileEntity.i().H_());
        NBTTagList itemList = tag.c("Items", 10);
        if (itemList != null) {
            itemList.clear();
            tag.r("Items");
            tileEntity.c(tag, (HolderLookup.a)tileEntity.i().H_());
            tileEntity.e();
        }
    }

    @Override
    public void setEnvironment(World world, World.Environment environment) {
    }

    @Override
    public void playCustomSound(Player player, Location location, String sound, float volume, float pitch) {
        player.playSound(location, sound, volume, pitch);
    }

    @Override
    public List<Entity> selectEntities(CommandSender sender, String selector) {
        if (!selector.startsWith("@")) {
            return null;
        }
        try {
            return Bukkit.selectEntities((CommandSender)sender, (String)selector);
        }
        catch (IllegalArgumentException ex) {
            this.platform.getLogger().warning("Invalid selector: " + ex.getMessage());
            return null;
        }
    }

    @Override
    public MapView getMapById(int id) {
        return Bukkit.getMap((int)id);
    }

    @Override
    public <T> Map<String, T> getTypedMap(ConfigurationSection section) {
        if (section == null) {
            return null;
        }
        if (section instanceof MemorySection) {
            return (Map)ReflectionUtils.getPrivate(this.platform.getLogger(), section, MemorySection.class, "map");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set keys = section.getKeys(false);
        for (String key : keys) {
            map.put(key, section.get(key));
        }
        return map;
    }

    @Override
    public boolean setMap(ConfigurationSection section, Map<String, Object> map) {
        if (section == null) {
            return false;
        }
        if (section instanceof MemorySection) {
            return ReflectionUtils.setPrivate(this.platform.getLogger(), section, MemorySection.class, "map", map);
        }
        return true;
    }

    @Override
    public Vector getPosition(Object entityData, String tag) {
        if (entityData == null || !(entityData instanceof NBTTagCompound)) {
            return null;
        }
        NBTTagCompound data = (NBTTagCompound)entityData;
        NBTTagList list = data.c(tag, 6);
        double x = list.h(0);
        double y = list.h(1);
        double z = list.h(2);
        return new Vector(x, y, z);
    }

    @Override
    public BlockVector getBlockVector(Object entityData, String tag) {
        if (entityData == null || !(entityData instanceof NBTTagCompound)) {
            return null;
        }
        NBTTagCompound data = (NBTTagCompound)entityData;
        int[] coords = data.n(tag);
        if (coords == null || coords.length < 3) {
            return null;
        }
        return new BlockVector(coords[0], coords[1], coords[2]);
    }

    @Override
    public void setTNTSource(TNTPrimed tnt, LivingEntity source) {
        tnt.setSource((Entity)source);
    }

    @Override
    public void setEntityMotion(Entity entity, Vector motion) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        nms.h(new Vec3D(motion.getX(), motion.getY(), motion.getZ()));
    }

    @Override
    public boolean setLock(org.bukkit.block.Block block, String lockName) {
        BlockState blockData = block.getState();
        if (!(blockData instanceof Lockable)) {
            return false;
        }
        Lockable lockable = (Lockable)blockData;
        lockable.setLock(lockName);
        blockData.update();
        return true;
    }

    @Override
    public boolean clearLock(org.bukkit.block.Block block) {
        BlockState blockData = block.getState();
        if (!(blockData instanceof Lockable)) {
            return false;
        }
        Lockable lockable = (Lockable)blockData;
        lockable.setLock(null);
        blockData.update();
        return true;
    }

    @Override
    public boolean isLocked(org.bukkit.block.Block block) {
        BlockState blockData = block.getState();
        if (!(blockData instanceof Lockable)) {
            return false;
        }
        Lockable lockable = (Lockable)blockData;
        return lockable.isLocked();
    }

    @Override
    public String getLock(org.bukkit.block.Block block) {
        BlockState blockData = block.getState();
        if (!(blockData instanceof Lockable)) {
            return null;
        }
        Lockable lockable = (Lockable)blockData;
        return lockable.getLock();
    }

    @Override
    public void setFallingBlockDamage(FallingBlock entity, float fallHurtAmount, int fallHurtMax) {
        entity.setHurtEntities(true);
        EntityFallingBlock nms = (EntityFallingBlock)((CraftEntity)entity).getHandle();
        nms.j = fallHurtMax;
        nms.k = fallHurtAmount;
    }

    @Override
    public void setGravity(ArmorStand armorStand, boolean gravity) {
        armorStand.setGravity(gravity);
    }

    @Override
    public void setGravity(Entity entity, boolean gravity) {
        entity.setGravity(gravity);
    }

    @Override
    public void setDisabledSlots(ArmorStand armorStand, int disabledSlots) {
        EntityArmorStand nms = ((CraftArmorStand)armorStand).getHandle();
        nms.cf = disabledSlots;
    }

    @Override
    public int getDisabledSlots(ArmorStand armorStand) {
        EntityArmorStand nms = ((CraftArmorStand)armorStand).getHandle();
        return nms.cf;
    }

    @Override
    public void setInvisible(ArmorStand armorStand, boolean invisible) {
        armorStand.setInvisible(invisible);
    }

    @Override
    public void setInvisible(Entity entity, boolean invisible) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        nms.k(invisible);
    }

    @Override
    public Boolean isInvisible(Entity entity) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        return nms.ch();
    }

    @Override
    public boolean isPersistentInvisible(Entity entity) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        return nms.persistentInvisibility;
    }

    @Override
    public void setPersistentInvisible(Entity entity, boolean invisible) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        nms.persistentInvisibility = invisible;
    }

    @Override
    public void setYawPitch(Entity entity, float yaw, float pitch) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        nms.r(yaw % 360.0f);
        nms.s(pitch % 360.0f);
    }

    @Override
    public void setLocation(Entity entity, double x, double y, double z, float yaw, float pitch) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        nms.a(x, y, z, yaw, pitch);
    }

    @Override
    public void addFlightExemption(Player player, int ticks) {
        EntityPlayer nms = ((CraftPlayer)player).getHandle();
        ReflectionUtils.setPrivateNeedsFixing(this.platform.getLogger(), nms.c, PlayerConnection.class, "aboveGroundTickCount", "J", -ticks);
    }

    @Override
    public boolean isValidProjectileClass(Class<?> projectileType) {
        return projectileType != null && IProjectile.class.isAssignableFrom(projectileType);
    }

    @Override
    public Projectile spawnProjectile(Class<?> projectileType, Location location, Vector direction, ProjectileSource source, float speed, float spread, float spreadLocations, Random random) {
        Constructor<?> constructor = null;
        WorldServer nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        Projectile projectile = null;
        try {
            CraftEntity entity;
            EntityTypes<?> entityType = null;
            constructor = projectileType.getConstructor(EntityTypes.class, net.minecraft.world.level.World.class);
            entityType = this.projectileEntityTypes.get(projectileType.getSimpleName());
            if (entityType == null) {
                throw new Exception("Failed to find entity type for projectile class " + projectileType.getName());
            }
            Object nmsProjectile = null;
            try {
                nmsProjectile = constructor.newInstance(entityType, nmsWorld);
            }
            catch (Exception ex) {
                nmsProjectile = null;
                this.platform.getLogger().log(Level.WARNING, "Error spawning projectile of class " + projectileType.getName(), ex);
            }
            if (nmsProjectile == null || !(nmsProjectile instanceof net.minecraft.world.entity.Entity)) {
                throw new Exception("Failed to spawn projectile of class " + projectileType.getName());
            }
            if (nmsProjectile instanceof EntityFireball) {
                EntityFireball fireballIsh = nmsProjectile;
                double spreadWeight = Math.min((double)0.4f, (double)spread * (double)0.0075f);
                double dx = (double)speed * (direction.getX() + random.nextGaussian() * spreadWeight);
                double dy = (double)speed * (direction.getY() + random.nextGaussian() * spreadWeight);
                double dz = (double)speed * (direction.getZ() + random.nextGaussian() * spreadWeight);
                fireballIsh.d = dx * 0.1;
                fireballIsh.e = dy * 0.1;
                fireballIsh.f = dz * 0.1;
            }
            net.minecraft.world.entity.Entity nmsEntity = nmsProjectile;
            Vector modifiedLocation = location.toVector().clone();
            if (EntityFireballFireball.class.isAssignableFrom(projectileType) && spreadLocations > 0.0f) {
                modifiedLocation.setX(modifiedLocation.getX() + direction.getX() + random.nextGaussian() * (double)spread / 5.0);
                modifiedLocation.setY(modifiedLocation.getY() + direction.getY() + random.nextGaussian() * (double)spread / 5.0);
                modifiedLocation.setZ(modifiedLocation.getZ() + direction.getZ() + random.nextGaussian() * (double)spread / 5.0);
            }
            nmsEntity.b(modifiedLocation.getX(), modifiedLocation.getY(), modifiedLocation.getZ(), location.getYaw(), location.getPitch());
            if (nmsEntity instanceof IProjectile) {
                IProjectile nms = (IProjectile)nmsEntity;
                nms.c(direction.getX(), direction.getY(), direction.getZ(), speed, spread);
            }
            if ((entity = nmsEntity.getBukkitEntity()) == null || !(entity instanceof Projectile)) {
                throw new Exception("Got invalid bukkit entity from projectile of class " + projectileType.getName());
            }
            projectile = (Projectile)entity;
            if (source != null) {
                projectile.setShooter(source);
                nmsEntity.projectileSource = source;
            }
            nmsWorld.addFreshEntity(nmsEntity, CreatureSpawnEvent.SpawnReason.DEFAULT);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
        return projectile;
    }

    @Override
    public void setDamage(Projectile projectile, double damage) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)projectile).getHandle();
        if (!(nms instanceof EntityTippedArrow)) {
            return;
        }
        EntityTippedArrow arrow = (EntityTippedArrow)nms;
        arrow.h(damage);
    }

    @Override
    public void decreaseLifespan(Projectile projectile, int ticks) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)projectile).getHandle();
        if (!(nms instanceof EntityTippedArrow)) {
            return;
        }
        EntityTippedArrow arrow = (EntityTippedArrow)nms;
        arrow.m = ticks;
    }

    @Override
    public Entity spawnEntity(Location target, EntityType entityType, CreatureSpawnEvent.SpawnReason spawnReason) {
        CraftWorld craftWorld = (CraftWorld)target.getWorld();
        return craftWorld.spawn(target, entityType.getEntityClass(), null, spawnReason);
    }

    @Override
    public String getResourcePack(Server server) {
        Optional rpInfo = ((CraftServer)server).getServer().X();
        return rpInfo.isPresent() ? ((MinecraftServer.ServerResourcePackInfo)rpInfo.get()).b() : null;
    }

    @Override
    public boolean setResourcePack(Player player, String rp, byte[] hash) {
        player.setResourcePack(rp, hash);
        return true;
    }

    @Override
    public boolean removeItemAttribute(org.bukkit.inventory.ItemStack item, Attribute attribute) {
        if (item == null) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        if (!meta.removeAttributeModifier(attribute)) {
            return false;
        }
        item.setItemMeta(meta);
        return true;
    }

    @Override
    public boolean removeItemAttributes(org.bukkit.inventory.ItemStack item) {
        if (item == null) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        Multimap modifiers = meta.getAttributeModifiers();
        if (modifiers == null || modifiers.isEmpty()) {
            return false;
        }
        for (Attribute attribute : modifiers.keySet()) {
            meta.removeAttributeModifier(attribute);
        }
        item.setItemMeta(meta);
        return true;
    }

    @Override
    public boolean setItemAttribute(org.bukkit.inventory.ItemStack item, Attribute attribute, double value, String slot, int attributeOperation, UUID attributeUUID) {
        if (item == null) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        try {
            AttributeModifier modifier;
            AttributeModifier.Operation operation;
            try {
                operation = AttributeModifier.Operation.values()[attributeOperation];
            }
            catch (Throwable ex) {
                this.platform.getLogger().warning("[Magic] invalid attribute operation ordinal: " + attributeOperation);
                return false;
            }
            if (slot != null && !slot.isEmpty()) {
                EquipmentSlot equipmentSlot;
                try {
                    equipmentSlot = slot.equalsIgnoreCase("mainhand") ? EquipmentSlot.HAND : (slot.equalsIgnoreCase("offhand") ? EquipmentSlot.OFF_HAND : EquipmentSlot.valueOf((String)slot.toUpperCase()));
                }
                catch (Throwable ex) {
                    this.platform.getLogger().warning("[Magic] invalid attribute slot: " + slot);
                    return false;
                }
                modifier = new AttributeModifier(attributeUUID, "Equipment Modifier", value, operation, equipmentSlot);
            } else {
                modifier = new AttributeModifier(attributeUUID, "Equipment Modifier", value, operation);
            }
            meta.addAttributeModifier(attribute, modifier);
            item.setItemMeta(meta);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void sendExperienceUpdate(Player player, float experience, int level) {
        player.sendExperienceChange(experience, level);
    }

    public NBTTagCompound getEntityData(Entity entity) {
        if (entity == null) {
            return null;
        }
        NBTTagCompound data = new NBTTagCompound();
        ((CraftEntity)entity).getHandle().e(data);
        return data;
    }

    @Override
    public String getEntityType(Entity entity) {
        if (entity == null) {
            return null;
        }
        return ((CraftEntity)entity).getHandle().bC();
    }

    @Override
    public void swingOffhand(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        ((LivingEntity)entity).swingOffHand();
    }

    @Override
    public void swingMainHand(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        ((LivingEntity)entity).swingMainHand();
    }

    @Override
    public float getDurability(Material material) {
        return CraftMagicNumbers.getBlock((Material)material).e();
    }

    protected void sendPacket(Server server, Location source, Collection<? extends Player> players, Packet<?> packet) throws Exception {
        players = players != null && players.size() > 0 ? players : server.getOnlinePlayers();
        int viewDistance = Bukkit.getServer().getViewDistance() * 16;
        int viewDistanceSquared = viewDistance * viewDistance;
        World sourceWorld = source.getWorld();
        for (Player player : players) {
            Location location = player.getLocation();
            if (!location.getWorld().equals((Object)sourceWorld) || !(location.distanceSquared(source) <= (double)viewDistanceSquared)) continue;
            this.sendPacket(player, packet);
        }
    }

    protected void sendPacket(Player player, Packet<?> packet) throws Exception {
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        nmsPlayer.c.b(packet);
    }

    @Override
    public void sendBreaking(Player player, long id, Location location, int breakAmount) {
        try {
            BlockPosition blockPosition = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            PacketPlayOutBlockBreakAnimation packet = new PacketPlayOutBlockBreakAnimation((int)id, blockPosition, breakAmount);
            this.sendPacket(player, (Packet<?>)packet);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public Set<String> getTags(Entity entity) {
        return entity.getScoreboardTags();
    }

    @Override
    public boolean isJumping(LivingEntity entity) {
        EntityLiving living = ((CraftLivingEntity)entity).getHandle();
        return (Boolean)ReflectionUtils.getPrivateNeedsFixing(this.platform.getLogger(), living, EntityLiving.class, "jumping", "bn");
    }

    @Override
    public float getForwardMovement(LivingEntity entity) {
        EntityLiving living = ((CraftLivingEntity)entity).getHandle();
        return living.bq;
    }

    @Override
    public float getStrafeMovement(LivingEntity entity) {
        EntityLiving living = ((CraftLivingEntity)entity).getHandle();
        return living.bo;
    }

    @Override
    public boolean setBlockFast(Chunk chunk, int x, int y, int z, Material material, int data) {
        chunk.getBlock(x, y, z).setType(material);
        return true;
    }

    @Override
    public boolean setPickupStatus(Projectile projectile, String pickupStatus) {
        AbstractArrow.PickupStatus status;
        if (!(projectile instanceof AbstractArrow)) {
            return false;
        }
        try {
            status = AbstractArrow.PickupStatus.valueOf((String)pickupStatus.toUpperCase());
        }
        catch (Throwable ex) {
            this.platform.getLogger().warning("Invalid pickup status: " + pickupStatus);
            return false;
        }
        ((AbstractArrow)projectile).setPickupStatus(status);
        return true;
    }

    @Override
    public org.bukkit.block.Block getHitBlock(ProjectileHitEvent event) {
        return event.getHitBlock();
    }

    @Override
    public Entity getEntity(World world, UUID uuid) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftWorld)world).getHandle().a(uuid);
        return nmsEntity == null ? null : nmsEntity.getBukkitEntity();
    }

    @Override
    public Entity getEntity(UUID uuid) {
        return Bukkit.getEntity((UUID)uuid);
    }

    @Override
    public boolean canRemoveRecipes() {
        return true;
    }

    @Override
    public boolean removeRecipe(Recipe recipe) {
        if (!(recipe instanceof Keyed)) {
            return false;
        }
        Keyed keyed = (Keyed)recipe;
        return this.platform.getPlugin().getServer().removeRecipe(keyed.getKey());
    }

    @Override
    public boolean removeRecipe(String key) {
        NamespacedKey namespacedKey = new NamespacedKey(this.platform.getPlugin(), key.toLowerCase());
        return this.platform.getPlugin().getServer().removeRecipe(namespacedKey);
    }

    @Override
    public ShapedRecipe createShapedRecipe(String key, org.bukkit.inventory.ItemStack item) {
        NamespacedKey namespacedKey = new NamespacedKey(this.platform.getPlugin(), key.toLowerCase());
        return new ShapedRecipe(namespacedKey, item);
    }

    @Override
    public boolean discoverRecipe(HumanEntity entity, String key) {
        NamespacedKey namespacedKey = new NamespacedKey(this.platform.getPlugin(), key.toLowerCase());
        return entity.discoverRecipe(namespacedKey);
    }

    @Override
    public boolean undiscoverRecipe(HumanEntity entity, String key) {
        NamespacedKey namespacedKey = new NamespacedKey(this.platform.getPlugin(), key.toLowerCase());
        return entity.undiscoverRecipe(namespacedKey);
    }

    @Override
    public double getMaxHealth(org.bukkit.entity.Damageable li) {
        if (li instanceof LivingEntity) {
            return ((LivingEntity)li).getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
        }
        return 0.0;
    }

    @Override
    public void setMaxHealth(org.bukkit.entity.Damageable li, double maxHealth) {
        if (li instanceof LivingEntity) {
            ((LivingEntity)li).getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(maxHealth);
        }
    }

    @Override
    public Material fromLegacy(MaterialData materialData) {
        Material converted = Bukkit.getUnsafe().fromLegacy(materialData);
        if (converted == Material.AIR) {
            materialData.setData((byte)0);
            converted = Bukkit.getUnsafe().fromLegacy(materialData);
        }
        return converted;
    }

    @Override
    public boolean hasLegacyMaterials() {
        return true;
    }

    @Override
    public boolean isLegacy(Material material) {
        return material.isLegacy();
    }

    @Override
    public Material getLegacyMaterial(String materialName) {
        return Material.getMaterial((String)materialName, (boolean)true);
    }

    @Override
    public boolean applyBonemeal(Location location) {
        if (this.dummyItem == null) {
            this.dummyItem = new org.bukkit.inventory.ItemStack(Material.DIRT, 64);
            this.dummyItem = this.platform.getItemUtils().makeReal(this.dummyItem);
        }
        this.dummyItem.setAmount(64);
        WorldServer nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        ItemStack itemStack = (ItemStack)this.platform.getItemUtils().getHandle(this.dummyItem);
        BlockPosition blockPosition = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        return ItemBoneMeal.a((ItemStack)itemStack, (net.minecraft.world.level.World)nmsWorld, (BlockPosition)blockPosition);
    }

    @Override
    public Color getColor(PotionMeta meta) {
        return meta.getColor();
    }

    @Override
    public boolean setColor(PotionMeta meta, Color color) {
        meta.setColor(color);
        return true;
    }

    @Override
    public boolean hasBlockDataSupport() {
        return true;
    }

    @Override
    public byte getLegacyBlockData(FallingBlock falling) {
        return 0;
    }

    @Override
    public Material getMaterial(FallingBlock falling) {
        return falling.getBlockData().getMaterial();
    }

    @Override
    public String getBlockData(FallingBlock fallingBlock) {
        BlockData blockData = fallingBlock.getBlockData();
        return blockData.getAsString();
    }

    @Override
    public String getBlockData(Material material, byte data) {
        BlockData blockData = this.platform.getDeprecatedUtils().getUnsafe().fromLegacy(material, data);
        return blockData == null ? null : blockData.getAsString();
    }

    @Override
    public String getBlockData(org.bukkit.block.Block block) {
        BlockData blockData = block.getBlockData();
        return blockData == null ? null : blockData.getAsString();
    }

    @Override
    public boolean setBlockData(org.bukkit.block.Block block, String data) {
        BlockData blockData = this.platform.getPlugin().getServer().createBlockData(data);
        block.setBlockData(blockData, false);
        return true;
    }

    @Override
    public boolean applyPhysics(org.bukkit.block.Block block) {
        WorldServer nmsWorld = ((CraftWorld)block.getWorld()).getHandle();
        BlockPosition blockLocation = new BlockPosition(block.getX(), block.getY(), block.getZ());
        IBlockData blockState = nmsWorld.a_(blockLocation);
        this.clearItems(block.getLocation());
        this.platform.getDeprecatedUtils().setTypeAndData(block, Material.AIR, (byte)0, false);
        return nmsWorld.a(blockLocation, blockState, 3);
    }

    @Override
    public boolean addRecipeToBook(org.bukkit.inventory.ItemStack book, Plugin plugin, String recipeKey) {
        if (book == null) {
            return false;
        }
        ItemMeta meta = book.getItemMeta();
        if (!(meta instanceof KnowledgeBookMeta)) {
            return false;
        }
        KnowledgeBookMeta bookMeta = (KnowledgeBookMeta)meta;
        NamespacedKey key = new NamespacedKey(plugin, recipeKey.toLowerCase());
        bookMeta.addRecipe(new NamespacedKey[]{key});
        book.setItemMeta((ItemMeta)bookMeta);
        return true;
    }

    @Override
    public boolean stopSound(Player player, Sound sound) {
        player.stopSound(sound);
        return true;
    }

    @Override
    public boolean stopSound(Player player, String sound) {
        player.stopSound(sound);
        return true;
    }

    @Override
    public boolean lockChunk(Chunk chunk) {
        if (!this.platform.getPlugin().isEnabled()) {
            return false;
        }
        if (!chunk.isLoaded()) {
            this.platform.getLogger().info("Locking unloaded chunk");
        }
        chunk.addPluginChunkTicket(this.platform.getPlugin());
        return true;
    }

    @Override
    public boolean unlockChunk(Chunk chunk) {
        if (!this.platform.getPlugin().isEnabled()) {
            return false;
        }
        chunk.removePluginChunkTicket(this.platform.getPlugin());
        return true;
    }

    @Override
    public Location getHangingLocation(Entity entity) {
        Location location = entity.getLocation();
        if (!(entity instanceof Hanging)) {
            return location;
        }
        EntityHanging nms = ((CraftHanging)entity).getHandle();
        BlockPosition position = nms.dp();
        location.setX((double)position.u());
        location.setY((double)position.v());
        location.setZ((double)position.w());
        return location;
    }

    @Override
    public boolean isSameKey(Plugin plugin, String key, Object keyedObject) {
        if (!(keyedObject instanceof Keyed)) {
            return false;
        }
        String namespace = plugin.getName().toLowerCase(Locale.ROOT);
        key = key.toLowerCase(Locale.ROOT);
        Keyed keyed = (Keyed)keyedObject;
        NamespacedKey namespacedKey = keyed.getKey();
        String keyNamespace = namespacedKey.getNamespace();
        String keyKey = namespacedKey.getKey();
        return keyNamespace.equals(namespace) && keyKey.equals(key);
    }

    @Override
    public boolean isLegacyRecipes() {
        return false;
    }

    @Override
    public boolean setRecipeIngredient(ShapedRecipe recipe, char key, org.bukkit.inventory.ItemStack ingredient, boolean ignoreDamage) {
        if (ingredient == null) {
            return false;
        }
        try {
            short maxDurability = ingredient.getType().getMaxDurability();
            if (ignoreDamage && maxDurability > 0) {
                ItemMeta meta;
                ArrayList<org.bukkit.inventory.ItemStack> damaged = new ArrayList<org.bukkit.inventory.ItemStack>();
                for (short damage = 0; damage < maxDurability && (meta = (ingredient = ingredient.clone()).getItemMeta()) != null && meta instanceof Damageable; damage = (short)(damage + 1)) {
                    Damageable damageable = (Damageable)meta;
                    damageable.setDamage((int)damage);
                    ingredient.setItemMeta(meta);
                    damaged.add(ingredient);
                }
                RecipeChoice.ExactChoice exactChoice = new RecipeChoice.ExactChoice(damaged);
                recipe.setIngredient(key, (RecipeChoice)exactChoice);
                return true;
            }
            RecipeChoice.ExactChoice exactChoice = new RecipeChoice.ExactChoice(ingredient);
            recipe.setIngredient(key, (RecipeChoice)exactChoice);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setAutoBlockState(org.bukkit.block.Block block, Location target, BlockFace facing, boolean physics, Player originator) {
        EnumDirection direction;
        if (block == null || facing == null || target == null) {
            return false;
        }
        IBlockData blockState = ((CraftBlock)block).getNMS();
        if (blockState == null) {
            return false;
        }
        Block nmsBlock = blockState.b();
        org.bukkit.inventory.ItemStack blockItem = new org.bukkit.inventory.ItemStack(block.getType());
        EntityPlayer originatorHandle = ((CraftPlayer)originator).getHandle();
        WorldServer world = ((CraftWorld)block.getWorld()).getHandle();
        Object item = this.platform.getItemUtils().getHandle(this.platform.getItemUtils().makeReal(blockItem));
        if (originatorHandle == null || world == null || item == null) {
            return false;
        }
        BlockPosition blockPosition = new BlockPosition(block.getX(), block.getY(), block.getZ());
        Vec3D vec3D = new Vec3D(target.getX(), target.getY(), target.getZ());
        try {
            direction = EnumDirection.valueOf((String)facing.name());
        }
        catch (Exception ex) {
            this.platform.getLogger().log(Level.SEVERE, "Could not translate to NMS direction: " + facing);
            return false;
        }
        MovingObjectPositionBlock hitResult = new MovingObjectPositionBlock(vec3D, direction, blockPosition, false);
        BlockActionContext actionContext = new BlockActionContext((EntityHuman)originatorHandle, EnumHand.a, (ItemStack)item, hitResult);
        IBlockData state = nmsBlock.a(actionContext);
        if (state == null) {
            return false;
        }
        CraftBlock cBlock = (CraftBlock)block;
        CraftBlock.setTypeAndData((GeneratorAccess)cBlock.getHandle(), (BlockPosition)cBlock.getPosition(), (IBlockData)cBlock.getNMS(), (IBlockData)state, (boolean)physics);
        return true;
    }

    @Override
    public boolean forceUpdate(org.bukkit.block.Block block, boolean physics) {
        if (block == null) {
            return false;
        }
        IBlockData blockState = ((CraftBlock)block).getNMS();
        if (blockState == null) {
            return false;
        }
        Block nmsBlock = blockState.b();
        IBlockData blockData = nmsBlock.o();
        WorldServer world = ((CraftWorld)block.getWorld()).getHandle();
        BlockPosition blockPosition = new BlockPosition(block.getX(), block.getY(), block.getZ());
        world.a(blockPosition, blockData, 11);
        return false;
    }

    @Override
    public int getPhantomSize(Entity entity) {
        if (entity == null || !(entity instanceof Phantom)) {
            return 0;
        }
        return ((Phantom)entity).getSize();
    }

    @Override
    public boolean setPhantomSize(Entity entity, int size) {
        if (entity == null || !(entity instanceof Phantom)) {
            return false;
        }
        ((Phantom)entity).setSize(size);
        return true;
    }

    @Override
    public Location getBedSpawnLocation(Player player) {
        if (player == null) {
            return null;
        }
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        BlockPosition bedLocation = nmsPlayer.R();
        ResourceKey bedDimension = nmsPlayer.T();
        if (bedLocation != null && bedDimension != null) {
            CraftWorld world;
            MinecraftServer server = nmsPlayer.cO();
            WorldServer worldServer = server != null ? server.a(bedDimension) : null;
            CraftWorld craftWorld = world = worldServer != null ? worldServer.getWorld() : null;
            if (world != null) {
                return new Location((World)world, (double)bedLocation.u(), (double)bedLocation.v(), (double)bedLocation.w());
            }
        }
        return player.getBedSpawnLocation();
    }

    @Override
    public void addPassenger(Entity vehicle, Entity passenger) {
        vehicle.addPassenger(passenger);
    }

    @Override
    public List<Entity> getPassengers(Entity entity) {
        return entity.getPassengers();
    }

    @Override
    public boolean openBook(Player player, org.bukkit.inventory.ItemStack itemStack) {
        player.openBook(itemStack);
        return true;
    }

    @Override
    public boolean isHandRaised(Player player) {
        return player.isHandRaised();
    }

    @Override
    public Class<?> getProjectileClass(String projectileTypeName) {
        return this.projectileClasses.get(projectileTypeName.toLowerCase());
    }

    @Override
    public Entity spawnFireworkEffect(Material fireworkMaterial, Server server, Location location, FireworkEffect effect, int power, Vector direction, Integer expectedLifespan, Integer ticksFlown, boolean silent) {
        CraftEntity entity = null;
        try {
            if (fireworkMaterial == null) {
                return null;
            }
            WorldServer level = ((CraftWorld)location.getWorld()).getHandle();
            org.bukkit.inventory.ItemStack itemStack = new org.bukkit.inventory.ItemStack(fireworkMaterial);
            FireworkMeta meta = (FireworkMeta)itemStack.getItemMeta();
            meta.addEffect(effect);
            meta.setPower(power);
            itemStack.setItemMeta((ItemMeta)meta);
            Object item = this.platform.getItemUtils().getHandle(this.platform.getItemUtils().makeReal(itemStack));
            EntityFireworks fireworkHandle = new EntityFireworks((net.minecraft.world.level.World)level, location.getX(), location.getY(), location.getZ(), (ItemStack)item);
            fireworkHandle.e(silent);
            if (direction != null) {
                fireworkHandle.h(new Vec3D(direction.getX(), direction.getY(), direction.getZ()));
            }
            if (ticksFlown != null) {
                fireworkHandle.e = ticksFlown;
            }
            if (expectedLifespan != null) {
                fireworkHandle.f = expectedLifespan;
            }
            if (direction == null) {
                PacketPlayOutSpawnEntity fireworkPacket = new PacketPlayOutSpawnEntity((net.minecraft.world.entity.Entity)fireworkHandle, 76);
                int fireworkId = fireworkHandle.al();
                DataWatcher watcher = fireworkHandle.ap();
                PacketPlayOutEntityMetadata metadataPacket = new PacketPlayOutEntityMetadata(fireworkId, watcher.b());
                PacketPlayOutEntityStatus statusPacket = new PacketPlayOutEntityStatus((net.minecraft.world.entity.Entity)fireworkHandle, 17);
                PacketPlayOutEntityDestroy destroyPacket = new PacketPlayOutEntityDestroy(new int[]{fireworkId});
                Collection players = server.getOnlinePlayers();
                this.sendPacket(server, location, players, (Packet<?>)fireworkPacket);
                this.sendPacket(server, location, players, (Packet<?>)metadataPacket);
                this.sendPacket(server, location, players, (Packet<?>)statusPacket);
                this.sendPacket(server, location, players, (Packet<?>)destroyPacket);
                return null;
            }
            level.addFreshEntity((net.minecraft.world.entity.Entity)fireworkHandle, CreatureSpawnEvent.SpawnReason.CUSTOM);
            entity = fireworkHandle.getBukkitEntity();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return entity;
    }

    @Override
    public boolean loadAllTagsFromNBT(ConfigurationSection tags, Object tag) {
        if (!(tag instanceof NBTTagCompound)) {
            return false;
        }
        NBTTagCompound compoundTag = (NBTTagCompound)tag;
        Set<String> keys = this.platform.getInventoryUtils().getTagKeys(tag);
        if (keys == null) {
            return false;
        }
        for (String tagName : keys) {
            NBTBase metaBase = compoundTag.c(tagName);
            if (metaBase == null) continue;
            if (metaBase instanceof NBTTagCompound) {
                ConfigurationSection newSection = tags.createSection(tagName);
                this.loadAllTagsFromNBT(newSection, metaBase);
                continue;
            }
            try {
                tags.set(tagName, this.platform.getInventoryUtils().getTagValue(metaBase));
            }
            catch (Exception ex) {
                this.platform.getLogger().log(Level.SEVERE, "Failed to load NBT tags", ex);
                return false;
            }
        }
        return true;
    }

    @Override
    public BoundingBox getHitbox(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        AxisAlignedBB aabb = nmsEntity.cK();
        if (aabb == null) {
            return null;
        }
        return new BoundingBox(aabb.a, aabb.d, aabb.b, aabb.e, aabb.c, aabb.f);
    }

    @Override
    public boolean isPrimaryThread() {
        return Bukkit.isPrimaryThread();
    }

    @Override
    public String getEnchantmentKey(Enchantment enchantment) {
        return enchantment.getKey().getNamespace() + ":" + enchantment.getKey().getKey();
    }

    @Override
    public Enchantment getEnchantmentByKey(String key) {
        String namespace = "minecraft";
        Enchantment enchantment = null;
        if (key.contains(":")) {
            String[] pieces = StringUtils.split((String)key, (String)":", (int)2);
            namespace = pieces[0];
            key = pieces[1];
        } else {
            enchantment = Enchantment.getByName((String)key.toUpperCase());
            if (enchantment != null) {
                return enchantment;
            }
        }
        try {
            NamespacedKey namespacedKey = new NamespacedKey(namespace, key.toLowerCase());
            enchantment = Enchantment.getByKey((NamespacedKey)namespacedKey);
            if (enchantment == null) {
                enchantment = Enchantment.getByName((String)key.toUpperCase());
            }
        }
        catch (Exception ex) {
            this.platform.getLogger().log(Level.WARNING, "Unexpected error parsing enchantment key", ex);
        }
        return enchantment;
    }

    @Override
    public boolean isAdult(Zombie zombie) {
        return zombie.isAdult();
    }

    @Override
    public void setBaby(Zombie zombie) {
        zombie.setBaby();
    }

    @Override
    public void setAdult(Zombie zombie) {
        zombie.setAdult();
    }

    @Override
    public int getMinHeight(World world) {
        return world.getMinHeight();
    }

    @Override
    public BlockFace getSignFacing(org.bukkit.block.Block signBlock) {
        BlockData blockData = signBlock.getBlockData();
        if (!(blockData instanceof WallSign)) {
            return null;
        }
        WallSign sign = (WallSign)blockData;
        return sign.getFacing();
    }

    @Override
    public boolean setCompassTarget(ItemMeta meta, Location targetLocation, boolean trackLocation) {
        if (meta == null || !(meta instanceof CompassMeta)) {
            return false;
        }
        CompassMeta compassMeta = (CompassMeta)meta;
        compassMeta.setLodestoneTracked(trackLocation);
        compassMeta.setLodestone(targetLocation);
        return true;
    }

    @Override
    public boolean isAware(Entity entity) {
        if (!(entity instanceof Mob)) {
            return true;
        }
        return ((Mob)entity).isAware();
    }

    @Override
    public void setAware(Entity entity, boolean aware) {
        if (!(entity instanceof Mob)) {
            return;
        }
        ((Mob)entity).setAware(aware);
    }

    @Override
    public Object getProfile(Player player) {
        return ((CraftPlayer)player).getProfile();
    }

    @Override
    public void openSign(Player player, Location signBlock) {
        try {
            Object tileEntity = this.platform.getCompatibilityUtils().getTileEntity(signBlock);
            EntityPlayer playerHandle = ((CraftPlayer)player).getHandle();
            if (tileEntity != null && playerHandle != null && tileEntity instanceof TileEntitySign) {
                playerHandle.a((TileEntitySign)tileEntity, true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean setLore(org.bukkit.inventory.ItemStack itemStack, List<String> lore) {
        SpigotUtils spigot = this.platform.getSpigotUtils();
        if (spigot == null) {
            return super.setLore(itemStack, lore);
        }
        List<String> serializedLore = spigot.serializeLore(lore);
        return this.setRawLore(itemStack, serializedLore);
    }

    @Override
    public boolean setRawLore(org.bukkit.inventory.ItemStack itemStack, List<String> lore) {
        ItemUtils itemUtils = this.platform.getItemUtils();
        ItemStack mcItemStack = (ItemStack)itemUtils.getHandle(itemStack);
        if (mcItemStack == null) {
            return false;
        }
        ArrayList<IChatBaseComponent> components = new ArrayList<IChatBaseComponent>();
        for (String line : lore) {
            components.add(this.toNMSComponent(line));
        }
        ItemLore loreComponent = new ItemLore(components);
        mcItemStack.b(DataComponents.i, (Object)loreComponent);
        return true;
    }

    @Override
    public List<String> getRawLore(org.bukkit.inventory.ItemStack itemStack) {
        ArrayList<String> lines = new ArrayList<String>();
        ItemUtils itemUtils = this.platform.getItemUtils();
        ItemStack mcItemStack = (ItemStack)itemUtils.getHandle(itemStack);
        if (mcItemStack == null) {
            return lines;
        }
        ItemLore itemLore = (ItemLore)mcItemStack.a(DataComponents.i);
        for (IChatBaseComponent component : itemLore.a()) {
            lines.add(this.fromNMSComponent(component));
        }
        return lines;
    }

    @Override
    protected boolean sendActionBarPackets(Player player, String message) {
        IChatMutableComponent component = IChatBaseComponent.b((String)message);
        ClientboundSystemChatPacket packet = new ClientboundSystemChatPacket((IChatBaseComponent)component, true);
        try {
            this.sendPacket(player, (Packet<?>)packet);
        }
        catch (Exception ex) {
            this.platform.getLogger().log(Level.SEVERE, "Error updating action bar", ex);
            return false;
        }
        return true;
    }

    @Override
    public void setBossBarTitle(BossBar bossBar, String title) {
        if (ChatUtils.hasJSON(title)) {
            SpigotUtils spigot = this.platform.getSpigotUtils();
            if (spigot != null) {
                this.setBossBarTitleComponents(bossBar, spigot.serializeBossBar(title), title);
            } else {
                bossBar.setTitle(ChatUtils.getSimpleMessage(title));
            }
        } else {
            bossBar.setTitle(title);
        }
    }

    @Override
    public boolean setBossBarTitle(BossBar bossBar, String title, String font) {
        if (ChatUtils.isDefaultFont(font)) {
            this.setBossBarTitle(bossBar, title);
            return true;
        }
        SpigotUtils spigot = this.platform.getSpigotUtils();
        if (spigot == null) {
            return false;
        }
        this.setBossBarTitleComponents(bossBar, spigot.serializeBossBar(title, font), title);
        return true;
    }

    private void setBossBarTitleComponents(BossBar bossBar, String serialized, String fallback) {
        Object handle = ReflectionUtils.getHandle(this.platform.getLogger(), bossBar);
        if (handle == null || !(handle instanceof BossBattleServer)) {
            bossBar.setTitle(fallback);
            return;
        }
        BossBattleServer bossEvent = (BossBattleServer)handle;
        IChatBaseComponent component = this.toNMSComponent(serialized);
        if (component == null) {
            bossBar.setTitle(fallback);
        } else {
            bossEvent.a(component);
        }
    }

    private IChatBaseComponent toNMSComponent(String serialized) {
        Object component;
        if (serialized == null || serialized.isEmpty()) {
            return null;
        }
        try {
            component = serialized.isEmpty() ? CommonComponents.a : (serialized.startsWith("{") ? CraftChatMessage.fromJSON((String)serialized) : IChatBaseComponent.b((String)serialized));
        }
        catch (Exception ex) {
            this.platform.getLogger().log(Level.WARNING, "Invalid JSON message: " + serialized, ex);
            component = CommonComponents.a;
        }
        return component;
    }

    private String fromNMSComponent(IChatBaseComponent component) {
        return CraftChatMessage.toJSON((IChatBaseComponent)component);
    }

    @Override
    public Runnable getTaskRunnable(BukkitTask task) {
        return (Runnable)ReflectionUtils.getPrivate(this.platform.getLogger(), task, CraftTask.class, "rTask");
    }

    @Override
    public boolean isSwingingArm(Entity entity) {
        if (entity == null) {
            return false;
        }
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        if (nms == null || !(nms instanceof EntityLiving)) {
            return false;
        }
        return ((EntityLiving)nms).aJ;
    }

    @Override
    public boolean setLastDamaged(Entity damaged, Entity damager) {
        if (damager == null) {
            return false;
        }
        net.minecraft.world.entity.Entity nmsDamager = ((CraftEntity)damager).getHandle();
        if (nmsDamager == null || !(nmsDamager instanceof EntityLiving)) {
            return false;
        }
        EntityLiving livingDamager = (EntityLiving)nmsDamager;
        net.minecraft.world.entity.Entity nmsDamaged = damaged == null ? null : ((CraftEntity)damaged).getHandle();
        livingDamager.A(nmsDamaged);
        return true;
    }

    @Override
    public boolean setLastDamagedBy(Entity damaged, Entity damager) {
        if (damager == null) {
            return false;
        }
        net.minecraft.world.entity.Entity nmsDamaged = ((CraftEntity)damager).getHandle();
        if (nmsDamaged == null || !(nmsDamaged instanceof EntityLiving)) {
            return false;
        }
        EntityLiving livingDamaged = (EntityLiving)nmsDamaged;
        net.minecraft.world.entity.Entity nmsDamager = ((CraftEntity)damager).getHandle();
        EntityLiving livingDamager = nmsDamager instanceof EntityLiving ? (EntityLiving)nmsDamaged : null;
        livingDamaged.a(livingDamager);
        return true;
    }

    @Override
    @Nullable
    public BlockPopulator createOutOfBoundsPopulator(Logger logger) {
        return new OutOfBoundsEntityCleanup(logger);
    }

    @Override
    public Enchantment getInfinityEnchantment() {
        return Enchantment.INFINITY;
    }

    @Override
    public Enchantment getPowerEnchantment() {
        return Enchantment.POWER;
    }

    @Override
    public PotionEffectType getJumpPotionEffectType() {
        return PotionEffectType.JUMP_BOOST;
    }
}

