/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_11.entity;

import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.utility.platform.v1_11.entity.EntityAbstractHorseData;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.ItemStack;

public class EntityHorseData
extends EntityAbstractHorseData {
    public Horse.Color color;
    public Horse.Style style;
    public ItemData armor;
    public ItemData saddle;
    protected boolean temporarySaddle;
    protected boolean temporaryArmor;

    public EntityHorseData(ConfigurationSection parameters, MageController controller) {
        super(parameters, controller);
        String styleString;
        Logger log = controller.getLogger();
        String horseColorKey = parameters.getString("horse_color");
        if (horseColorKey != null && !horseColorKey.isEmpty()) {
            try {
                this.color = Horse.Color.valueOf((String)horseColorKey.toUpperCase());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid horse_color: " + horseColorKey);
            }
        }
        if ((styleString = parameters.getString("horse_style")) != null && !styleString.isEmpty()) {
            try {
                this.style = Horse.Style.valueOf((String)styleString.toUpperCase());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid horse_style: " + parameters.getString("horse_style"));
            }
        }
        if (parameters.contains("horse_jump_strength")) {
            this.jumpStrength = parameters.getDouble("horse_jump_strength");
        }
        this.armor = controller.getOrCreateItem(parameters.getString("armor"));
        this.temporaryArmor = parameters.getBoolean("armor_temporary");
        this.saddle = controller.getOrCreateItem(parameters.getString("saddle"));
        this.temporarySaddle = parameters.getBoolean("saddle_temporary");
    }

    public EntityHorseData(Entity entity, MageController controller) {
        super(entity);
        if (entity instanceof Horse) {
            Horse horse = (Horse)entity;
            this.color = horse.getColor();
            this.style = horse.getStyle();
            this.armor = this.getItem(horse.getInventory().getArmor(), controller);
            this.saddle = this.getItem(horse.getInventory().getSaddle(), controller);
        }
    }

    @Override
    public void apply(Entity entity) {
        super.apply(entity);
        if (!(entity instanceof Horse)) {
            return;
        }
        Horse horse = (Horse)entity;
        if (this.armor != null) {
            ItemStack armorItem = this.armor.getItemStack(1);
            if (this.temporaryArmor) {
                armorItem = EntityHorseData.getPlatform().getItemUtils().makeReal(armorItem);
                EntityHorseData.getPlatform().getItemUtils().makeTemporary(armorItem, "");
            }
            horse.getInventory().setArmor(armorItem);
        }
        if (this.saddle != null) {
            ItemStack saddleItem = this.saddle.getItemStack(1);
            if (this.temporarySaddle) {
                saddleItem = EntityHorseData.getPlatform().getItemUtils().makeReal(saddleItem);
                EntityHorseData.getPlatform().getItemUtils().makeTemporary(saddleItem, "");
            }
            horse.getInventory().setSaddle(saddleItem);
        }
        if (this.color != null) {
            horse.setColor(this.color);
        }
        if (this.style != null) {
            horse.setStyle(this.style);
        }
    }
}

