/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.api.entity;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.item.Cost;
import com.elmakers.mine.bukkit.api.magic.MageController;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Art;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;

public interface EntityData
extends Cloneable {
    public String getKey();

    public Location getLocation();

    public EntityType getType();

    public String getName();

    @Deprecated
    public Art getArt();

    @Deprecated
    public BlockFace getFacing();

    @Deprecated
    public ItemStack getItem();

    public double getHealth();

    public void setHasMoved(boolean var1);

    public void setDamaged(boolean var1);

    public boolean isDocile();

    public boolean isRelentless();

    public boolean isPreventProjectiles();

    public boolean isPreventMelee();

    public boolean isPreventDismount();

    public boolean isPreventTeleport();

    public boolean isTransformable();

    public boolean isCombustible();

    public boolean isOwnable();

    public boolean isPersistent();

    public boolean isNPC();

    public boolean isHidden();

    public boolean isSuperProtected();

    public boolean canTarget(Entity var1);

    public boolean isFriendly(Entity var1);

    public boolean hasPermission(String var1);

    @Nullable
    public Entity spawn();

    @Nullable
    public Entity spawn(Location var1, CreatureSpawnEvent.SpawnReason var2);

    @Nullable
    public Entity spawn(Location var1);

    @Deprecated
    @Nullable
    public Entity spawn(MageController var1, Location var2);

    @Deprecated
    @Nullable
    public Entity spawn(MageController var1);

    @Deprecated
    @Nullable
    public Entity spawn(MageController var1, Location var2, CreatureSpawnEvent.SpawnReason var3);

    @Nullable
    public Entity undo();

    @Deprecated
    public boolean modify(MageController var1, Entity var2);

    public boolean modify(Entity var1);

    public boolean respawned(Entity var1);

    @Nullable
    public EntityData getRelativeTo(Location var1);

    public String describe();

    @Nullable
    public String getInteractSpell();

    public SourceType getInteractSpellSource();

    public TargetType getInteractSpellTarget();

    @Nullable
    public ConfigurationSection getInteractSpellParameters();

    public SourceType getInteractCommandSource();

    public List<String> getInteractCommands();

    @Nullable
    public Collection<Cost> getInteractCosts();

    public boolean hasInteract();

    public void setMaterial(@Nonnull MaterialAndData var1);

    @Nullable
    public String getInteractPermission();

    public boolean getInteractRequiresOwner();

    @Nullable
    public MaterialAndData getMaterial();

    @Nullable
    public ConfigurationSection getConfiguration();

    @Deprecated
    public void load(@Nonnull MageController var1, ConfigurationSection var2);

    public void load(ConfigurationSection var1);

    public void attach(@Nonnull Entity var1);

    @Deprecated
    public void attach(@Nonnull MageController var1, @Nonnull Entity var2);

    @Nonnull
    public EntityData clone();

    public Entity getOwner();

    public long getTickInterval();

    public EntityData createVariant(ConfigurationSection var1);

    public static enum SourceType {
        PLAYER,
        MOB,
        CONSOLE,
        OPPED_PLAYER,
        BLOCK;

    }

    public static enum TargetType {
        NONE,
        PLAYER,
        MOB,
        BLOCK;

    }
}

