/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world.block.builtin;

import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.random.RandomUtils;
import com.elmakers.mine.bukkit.utility.random.WeightedPair;
import com.elmakers.mine.bukkit.world.BlockResult;
import com.elmakers.mine.bukkit.world.block.BlockRule;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Random;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class DropRule
extends BlockRule {
    protected Deque<WeightedPair<String>> dropProbability;

    @Override
    public boolean onLoad(ConfigurationSection parameters) {
        this.dropProbability = new ArrayDeque<WeightedPair<String>>();
        RandomUtils.populateStringProbabilityMap(this.dropProbability, parameters, "items");
        this.logBlockRule("Dropping one of " + StringUtils.join(this.dropProbability, (String)","));
        return !this.dropProbability.isEmpty();
    }

    @Override
    @Nonnull
    public BlockResult onHandle(Block block, Random random, Player player) {
        String itemKey = (String)RandomUtils.weightedRandom(this.dropProbability);
        if (itemKey.isEmpty() || itemKey.equals("none")) {
            return BlockResult.REMOVE_DROPS;
        }
        try {
            return BlockResult.valueOf(itemKey.toUpperCase());
        }
        catch (Exception exception) {
            ItemStack itemStack;
            ItemData itemData = this.controller.getOrCreateItem(itemKey);
            ItemStack itemStack2 = itemStack = itemData == null ? null : itemData.getItemStack();
            if (CompatibilityLib.getItemUtils().isEmpty(itemStack)) {
                this.controller.getLogger().warning("Invalid item key in drop rule: " + itemKey);
                return BlockResult.SKIP;
            }
            player.getWorld().dropItemNaturally(block.getLocation(), itemStack);
            return BlockResult.REPLACED_DROPS;
        }
    }
}

