/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_20_4.goal;

import com.elmakers.mine.bukkit.utility.platform.Platform;
import com.elmakers.mine.bukkit.utility.platform.v1_20_4.goal.MagicOwnerGoal;
import com.elmakers.mine.bukkit.utility.random.RandomUtils;
import java.util.EnumSet;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import org.bukkit.configuration.ConfigurationSection;

public class MagicFollowOwnerGoal
extends MagicOwnerGoal {
    private final double speedModifier;
    private final NavigationAbstract navigation;
    private final int interval;
    private final double stopDistanceSquared;
    private final double startDistanceSquared;
    private final double teleportDistanceSquared;
    private int ticksRemaining = 0;

    public MagicFollowOwnerGoal(Platform platform, EntityInsentient tamed, double speedModifier, float startDistance, float stopDistance, int interval, ConfigurationSection config) {
        super(platform, tamed);
        this.speedModifier = speedModifier;
        this.navigation = tamed.N();
        this.startDistanceSquared = startDistance * startDistance;
        this.stopDistanceSquared = stopDistance * stopDistance;
        float teleportDistance = (float)config.getDouble("teleport_distance", 12.0);
        if (!config.getBoolean("teleport", true)) {
            teleportDistance = 0.0f;
        }
        this.teleportDistanceSquared = teleportDistance * teleportDistance;
        this.interval = interval;
        this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
    }

    @Override
    public boolean a() {
        if (!super.a()) {
            return false;
        }
        return !(this.mob.f((Entity)this.tamed.getOwner()) < this.startDistanceSquared);
    }

    public boolean b() {
        if (this.navigation.l()) {
            return false;
        }
        if (this.tamed.isStay()) {
            return false;
        }
        return this.mob.f((Entity)this.tamed.getOwner()) > this.stopDistanceSquared;
    }

    public void c() {
        this.ticksRemaining = 0;
    }

    @Override
    public void d() {
        super.d();
        this.navigation.n();
    }

    public void e() {
        this.mob.I().a((Entity)this.tamed.getOwner(), 10.0f, (float)this.mob.aa());
        if (this.ticksRemaining-- <= 0) {
            this.ticksRemaining = this.interval;
            if (!this.mob.fS() && !this.mob.bO()) {
                if (this.teleportDistanceSquared > 0.0 && this.mob.f((Entity)this.tamed.getOwner()) >= this.teleportDistanceSquared) {
                    this.teleportToOwner();
                } else {
                    this.navigation.a((Entity)this.tamed.getOwner(), this.speedModifier);
                }
            }
        }
    }

    private void teleportToOwner() {
        BlockPosition blockPosition = this.tamed.getOwner().dm();
        for (int i = 0; i < 10; ++i) {
            int dx = RandomUtils.getRandomIntInclusive(-3, 3);
            int dy = RandomUtils.getRandomIntInclusive(-1, 1);
            int dz = RandomUtils.getRandomIntInclusive(-3, 3);
            if (this.tryTeleportTo(blockPosition.u() + dx, blockPosition.v() + dy, blockPosition.w() + dz)) break;
        }
    }

    private boolean tryTeleportTo(int x, int y, int z) {
        EntityLiving owner = this.tamed.getOwner();
        if (Math.abs((double)x - owner.dr()) < 2.0 && Math.abs((double)z - owner.dx()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPosition(x, y, z))) {
            return false;
        }
        this.mob.b((double)x + 0.5, (double)y, (double)z + 0.5, this.mob.dC(), this.mob.dE());
        this.navigation.n();
        return true;
    }

    private boolean canTeleportTo(BlockPosition blockPosition) {
        PathType pathType = PathfinderNormal.a((IBlockAccess)this.mob.dM(), (BlockPosition.MutableBlockPosition)blockPosition.j());
        if (pathType != PathType.c) {
            return false;
        }
        blockPosition = blockPosition.b((BaseBlockPosition)this.mob.dm());
        return this.mob.dM().a((Entity)this.mob, this.mob.cH().a(blockPosition));
    }
}

