/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_20_3;

import com.elmakers.mine.bukkit.utility.ReflectionUtils;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import com.elmakers.mine.bukkit.utility.platform.base.ItemUtilsBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemUtils
extends ItemUtilsBase {
    public ItemUtils(Platform platform) {
        super(platform);
    }

    @Override
    public Object getHandle(ItemStack stack) {
        if (stack == null || !(stack instanceof CraftItemStack)) {
            return null;
        }
        return ReflectionUtils.getHandle(this.platform.getLogger(), stack, CraftItemStack.class);
    }

    public NBTTagCompound getTag(Object mcItemStack) {
        if (mcItemStack == null || !(mcItemStack instanceof net.minecraft.world.item.ItemStack)) {
            return null;
        }
        net.minecraft.world.item.ItemStack itemStack = (net.minecraft.world.item.ItemStack)mcItemStack;
        return itemStack.v();
    }

    @Override
    public Object getTag(ItemStack itemStack) {
        NBTTagCompound tag = null;
        try {
            Object mcItemStack = this.getHandle(itemStack);
            if (mcItemStack == null && itemStack.hasItemMeta()) {
                itemStack = this.makeReal(itemStack);
                mcItemStack = this.getHandle(itemStack);
            }
            if (mcItemStack == null) {
                return null;
            }
            net.minecraft.world.item.ItemStack stack = (net.minecraft.world.item.ItemStack)mcItemStack;
            tag = stack.v();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return tag;
    }

    protected net.minecraft.world.item.ItemStack getNMSCopy(ItemStack stack) {
        net.minecraft.world.item.ItemStack nms = null;
        try {
            nms = CraftItemStack.asNMSCopy((ItemStack)stack);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return nms;
    }

    @Override
    public ItemStack getCopy(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        net.minecraft.world.item.ItemStack craft = this.getNMSCopy(stack);
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)craft);
    }

    @Override
    public ItemStack makeReal(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        Object nmsStack = this.getHandle(stack);
        if (nmsStack == null) {
            stack = this.getCopy(stack);
            nmsStack = this.getHandle(stack);
        }
        if (nmsStack == null) {
            return null;
        }
        net.minecraft.world.item.ItemStack itemStack = (net.minecraft.world.item.ItemStack)nmsStack;
        NBTTagCompound tag = itemStack.v();
        if (tag == null) {
            itemStack.c(new NBTTagCompound());
        }
        return stack;
    }

    @Override
    public boolean isUnbreakable(ItemStack stack) {
        if (this.isEmpty(stack)) {
            return false;
        }
        ItemMeta meta = stack.getItemMeta();
        return meta.isUnbreakable();
    }

    @Override
    public void makeUnbreakable(ItemStack stack) {
        if (this.isEmpty(stack)) {
            return;
        }
        ItemMeta meta = stack.getItemMeta();
        meta.setUnbreakable(true);
        stack.setItemMeta(meta);
    }

    @Override
    public void removeUnbreakable(ItemStack stack) {
        if (this.isEmpty(stack)) {
            return;
        }
        ItemMeta meta = stack.getItemMeta();
        meta.setUnbreakable(false);
        stack.setItemMeta(meta);
    }

    @Override
    public void hideFlags(ItemStack stack, int flags) {
        if (this.isEmpty(stack)) {
            return;
        }
        try {
            Object craft = this.getHandle(stack);
            if (craft == null) {
                return;
            }
            NBTTagCompound tagObject = this.getTag(craft);
            if (tagObject == null) {
                return;
            }
            NBTTagInt hideFlag = NBTTagInt.a((int)flags);
            tagObject.a("HideFlags", (NBTBase)hideFlag);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean isEmpty(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return true;
        }
        Object handle = this.getHandle(itemStack);
        if (handle == null || !(handle instanceof net.minecraft.world.item.ItemStack)) {
            return false;
        }
        net.minecraft.world.item.ItemStack mcItem = (net.minecraft.world.item.ItemStack)handle;
        return mcItem.b();
    }

    protected NBTTagString getTagString(String value) {
        return NBTTagString.a((String)value);
    }

    @Override
    public Object setStringList(Object nbtBase, String tag, Collection<String> values) {
        if (nbtBase == null || !(nbtBase instanceof NBTTagCompound)) {
            return null;
        }
        NBTTagCompound compoundTag = (NBTTagCompound)nbtBase;
        NBTTagList listTag = new NBTTagList();
        for (String value : values) {
            NBTTagString nbtString = this.getTagString(value);
            listTag.add((Object)nbtString);
        }
        compoundTag.a(tag, (NBTBase)listTag);
        return listTag;
    }

    @Override
    public List<String> getStringList(Object nbtBase, String key) {
        ArrayList<String> list = new ArrayList<String>();
        if (nbtBase == null || !(nbtBase instanceof NBTTagCompound)) {
            return list;
        }
        NBTTagCompound compoundTag = (NBTTagCompound)nbtBase;
        NBTTagList listTag = compoundTag.c(key, 8);
        if (listTag != null) {
            Logger logger = this.platform.getLogger();
            int size = listTag.size();
            for (int i = 0; i < size; ++i) {
                NBTBase entry = (NBTBase)ReflectionUtils.getListItem(logger, listTag, i);
                list.add(entry.t_());
            }
        }
        return list;
    }

    @Override
    public ItemStack getItem(Object itemTag) {
        if (itemTag == null || !(itemTag instanceof NBTTagCompound)) {
            return null;
        }
        CraftItemStack item = null;
        try {
            net.minecraft.world.item.ItemStack nmsStack = net.minecraft.world.item.ItemStack.a((NBTTagCompound)((NBTTagCompound)itemTag));
            item = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)nmsStack);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return item;
    }

    @Override
    public ItemStack[] getItems(Object rootTag, String tagName) {
        if (rootTag == null || !(rootTag instanceof NBTTagCompound)) {
            return null;
        }
        NBTTagCompound compoundTag = (NBTTagCompound)rootTag;
        try {
            NBTTagList itemList = compoundTag.c(tagName, 10);
            int size = itemList.size();
            ItemStack[] items = new ItemStack[size];
            for (int i = 0; i < size; ++i) {
                try {
                    NBTBase itemData = itemList.k(i);
                    if (itemData == null) continue;
                    items[i] = this.getItem(itemData);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return items;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

