/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import org.bukkit.Chunk;
import org.bukkit.World;

public class LoadingChunk {
    private final String worldName;
    private final int chunkX;
    private final int chunkZ;

    public LoadingChunk(Chunk chunk) {
        this(chunk.getWorld().getName(), chunk.getX(), chunk.getX());
    }

    public LoadingChunk(World world, int chunkX, int chunkZ) {
        this(world.getName(), chunkX, chunkZ);
    }

    public LoadingChunk(String worldName, int chunkX, int chunkZ) {
        this.worldName = worldName;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
    }

    public int hashCode() {
        int worldHashCode = this.worldName.hashCode();
        return (worldHashCode & 0xFF) << 24 | (this.chunkX & 0xFFF) << 12 | this.chunkX & 0xFFF;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LoadingChunk)) {
            return false;
        }
        LoadingChunk other = (LoadingChunk)o;
        return this.worldName.equals(other.worldName) && this.chunkX == other.chunkX && this.chunkZ == other.chunkZ;
    }

    public String toString() {
        return this.worldName + ":" + this.chunkX + "," + this.chunkZ;
    }
}

