/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.wand.WandTemplate;
import com.elmakers.mine.bukkit.magic.command.Paginator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;

public class WandPaginator
extends Paginator<WandTemplate> {
    private final MageController controller;

    public WandPaginator(MageController controller) {
        this.controller = controller;
    }

    @Override
    @Nonnull
    protected List<WandTemplate> getList(CommandSender sender) {
        ArrayList<WandTemplate> templates = new ArrayList<WandTemplate>(this.controller.getWandTemplates());
        Collections.sort(templates, new Comparator<WandTemplate>(this){

            @Override
            public int compare(WandTemplate wand1, WandTemplate wand2) {
                return wand1.getKey().compareTo(wand2.getKey());
            }
        });
        if (!sender.hasPermission("magic.bypass_hidden")) {
            Iterator it = templates.iterator();
            while (it.hasNext()) {
                ConfigurationSection configuration = ((WandTemplate)it.next()).getConfiguration();
                if (!configuration.getBoolean("hidden", false)) continue;
                it.remove();
            }
        }
        return templates;
    }

    @Override
    @Nonnull
    protected String describe(WandTemplate template) {
        String key = template.getKey();
        String name = this.controller.getMessages().get("wands." + key + ".name", this.controller.getMessages().get("wand.default_name"));
        Object description = this.controller.getMessages().get("wands." + key + ".description", "");
        String[] pieces = StringUtils.split((String)description, (String)"\n");
        if (pieces.length > 0) {
            description = pieces[0];
        }
        if (((String)description).length() > 30) {
            description = ((String)description).substring(0, 27) + "...";
        }
        description = String.valueOf(ChatColor.YELLOW) + (String)description;
        if (!name.equals(key)) {
            description = String.valueOf(ChatColor.DARK_AQUA) + name + String.valueOf(ChatColor.WHITE) + " : " + (String)description;
        }
        return String.valueOf(ChatColor.AQUA) + key + String.valueOf(ChatColor.WHITE) + " : " + (String)description;
    }

    @Override
    @Nonnull
    protected String getTypeNamePlural() {
        return "wands";
    }
}

