/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.batch;

import com.elmakers.mine.bukkit.api.block.BlockData;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.batch.SpellBatch;
import com.elmakers.mine.bukkit.block.BoundingBox;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;

public class RegenerateBatch
extends SpellBatch {
    private static final BlockData[] template = new BlockData[0];
    private final UndoList restoredBlocks;
    private final World world;
    private final int absx;
    private final int absz;
    private final int dx;
    private final int dz;
    private final int x;
    private final int z;
    private int ix = 0;
    private int iz = 0;
    private int blockY = 0;
    private int blockX = 0;
    private int blockZ = 0;
    private BlockData[] restoreBlocks;
    private int restoringIndex = 0;
    private boolean expand = false;
    private final BoundingBox bounds;
    private RegenerateState state;

    public RegenerateBatch(UndoableSpell spell, Location p1, Location p2) {
        super(spell);
        this.restoredBlocks = new com.elmakers.mine.bukkit.block.UndoList(this.mage, spell.getName());
        this.restoredBlocks.setSpell(spell);
        this.restoredBlocks.setBatch(this);
        this.world = this.mage.getLocation().getWorld();
        this.state = RegenerateState.SAVING;
        int deltax = p2.getBlock().getChunk().getX() - p1.getChunk().getX();
        int deltaz = p2.getChunk().getZ() - p1.getChunk().getZ();
        this.absx = Math.abs(deltax) + 1;
        this.absz = Math.abs(deltaz) + 1;
        this.dx = (int)Math.signum(deltax);
        this.dz = (int)Math.signum(deltaz);
        this.x = p1.getChunk().getX();
        this.z = p1.getChunk().getZ();
        this.bounds = new BoundingBox(p1.toVector(), p2.toVector());
    }

    @Override
    public int size() {
        return this.absx * this.absz * 16 * 16 * 256;
    }

    @Override
    public int remaining() {
        return (this.absx - this.ix) * (this.absz - this.iz) * 16 * 16 * 256;
    }

    public boolean checkDimension(int maxDimension) {
        return maxDimension <= 0 || this.absx * 16 <= maxDimension && this.absz * 16 <= maxDimension;
    }

    @Override
    public int process(int maxBlocks) {
        int processedBlocks = 0;
        if (this.state == RegenerateState.SAVING && this.expand && !this.spell.isUndoable()) {
            this.state = RegenerateState.REGENERATING;
        }
        switch (this.state.ordinal()) {
            case 0: {
                while (processedBlocks <= maxBlocks && this.ix < this.absx) {
                    while (processedBlocks <= maxBlocks && this.blockY < 256) {
                        int chunkX = this.x + this.ix * this.dx;
                        int chunkZ = this.z + this.iz * this.dz;
                        if (!CompatibilityLib.getCompatibilityUtils().checkChunk(this.world, chunkX, chunkZ)) {
                            return processedBlocks;
                        }
                        Chunk chunk = this.world.getChunkAt(chunkX, chunkZ);
                        Block block = chunk.getBlock(this.blockX, this.blockY, this.blockZ);
                        if (!this.spell.hasBuildPermission(block) || !this.spell.hasBreakPermission(block)) {
                            this.spell.sendMessageKey("insufficient_permission");
                            this.finish();
                            return processedBlocks;
                        }
                        if (!this.expand && !this.bounds.contains(block.getLocation().toVector())) {
                            this.restoredBlocks.add(block);
                        } else {
                            this.registerForUndo(block);
                        }
                        ++processedBlocks;
                        ++this.blockX;
                        if (this.blockX <= 15) continue;
                        this.blockX = 0;
                        ++this.blockZ;
                        if (this.blockZ <= 15) continue;
                        this.blockZ = 0;
                        ++this.blockY;
                    }
                    if (this.blockY < 256) continue;
                    this.blockX = 0;
                    this.blockZ = 0;
                    this.blockY = 0;
                    ++this.iz;
                    if (this.iz < this.absz) continue;
                    this.iz = 0;
                    ++this.ix;
                }
                if (this.ix < this.absx) break;
                this.state = RegenerateState.REGENERATING;
                this.ix = 0;
                this.iz = 0;
                break;
            }
            case 1: {
                while (processedBlocks <= maxBlocks && this.ix < this.absx) {
                    int chunkX = this.x + this.ix * this.dx;
                    int chunkZ = this.z + this.iz * this.dz;
                    if (!CompatibilityLib.getCompatibilityUtils().checkChunk(this.world, chunkX, chunkZ)) {
                        return processedBlocks;
                    }
                    Chunk chunk = this.world.getChunkAt(chunkX, chunkZ);
                    processedBlocks += 65536;
                    this.world.regenerateChunk(chunk.getX(), chunk.getZ());
                    ++this.iz;
                    if (this.iz < this.absz) continue;
                    this.iz = 0;
                    ++this.ix;
                }
                if (this.ix < this.absx) break;
                this.restoreBlocks = this.restoredBlocks.toArray(template);
                if (this.expand && !this.spell.isUndoable()) {
                    this.finish();
                    break;
                }
                this.state = RegenerateState.RESTORING;
                break;
            }
            case 2: {
                while (this.restoreBlocks != null && processedBlocks < maxBlocks && this.restoringIndex < this.restoreBlocks.length) {
                    this.restoreBlocks[this.restoringIndex].restore();
                    ++this.restoringIndex;
                    ++processedBlocks;
                }
                if (this.restoreBlocks != null && this.restoringIndex < this.restoredBlocks.size()) break;
                this.finish();
            }
        }
        return processedBlocks;
    }

    public int getXSize() {
        return this.absx;
    }

    public int getZSize() {
        return this.absz;
    }

    public void setExpand(boolean expand) {
        this.expand = expand;
    }

    @Override
    public void finish() {
        if (!this.finished) {
            UndoList modified = this.spell.getUndoList();
            modified.prune();
            this.restoredBlocks.setBatch(null);
            super.finish();
        }
    }

    private static enum RegenerateState {
        SAVING,
        REGENERATING,
        RESTORING;

    }
}

