/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_20_6;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.utility.platform.ItemUtils;
import com.elmakers.mine.bukkit.utility.platform.NBTUtils;
import com.elmakers.mine.bukkit.utility.platform.modern.ModernPlatform;
import com.elmakers.mine.bukkit.utility.platform.v1_20_6.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.platform.v1_20_6.EntityUtils;
import com.elmakers.mine.bukkit.utility.platform.v1_20_6.InventoryUtils;
import com.elmakers.mine.bukkit.utility.platform.v1_20_6.MobUtils;
import com.elmakers.mine.bukkit.utility.platform.v1_20_6.SkinUtils;
import com.elmakers.mine.bukkit.utility.platform.v1_20_6.event.EntityLoadEventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.PluginManager;

public class Platform
extends ModernPlatform {
    private Boolean hasEntityLoadEvent;

    public Platform(MageController controller) {
        super(controller);
    }

    @Override
    protected NBTUtils createNBTUtils() {
        return new com.elmakers.mine.bukkit.utility.platform.v1_20_6.NBTUtils(this);
    }

    @Override
    protected ItemUtils createItemUtils() {
        return new com.elmakers.mine.bukkit.utility.platform.v1_20_6.ItemUtils(this);
    }

    @Override
    protected com.elmakers.mine.bukkit.utility.platform.InventoryUtils createInventoryUtils() {
        return new InventoryUtils(this);
    }

    @Override
    protected com.elmakers.mine.bukkit.utility.platform.CompatibilityUtils createCompatibilityUtils() {
        return new CompatibilityUtils(this);
    }

    @Override
    protected com.elmakers.mine.bukkit.utility.platform.EntityUtils createEntityUtils() {
        return new EntityUtils(this);
    }

    @Override
    protected com.elmakers.mine.bukkit.utility.platform.MobUtils createMobUtils() {
        return new MobUtils(this);
    }

    @Override
    public boolean hasEntityLoadEvent() {
        if (this.hasEntityLoadEvent == null) {
            try {
                Class.forName("org.bukkit.event.world.EntitiesLoadEvent");
                this.hasEntityLoadEvent = true;
            }
            catch (Exception ex) {
                this.hasEntityLoadEvent = false;
                this.getLogger().warning("EntitiesLoadEvent not found, it is recommended that you update your server software");
            }
        }
        return this.hasEntityLoadEvent;
    }

    @Override
    protected com.elmakers.mine.bukkit.utility.platform.SkinUtils createSkinUtils() {
        return new SkinUtils(this);
    }

    @Override
    public boolean hasDeferredEntityLoad() {
        return true;
    }

    @Override
    public void registerEvents(PluginManager pm) {
        super.registerEvents(pm);
        if (this.hasEntityLoadEvent()) {
            pm.registerEvents((Listener)new EntityLoadEventHandler(this.controller), this.controller.getPlugin());
        }
    }
}

