/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.help;

import com.elmakers.mine.bukkit.ChatUtils;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.utility.help.Help;
import com.elmakers.mine.bukkit.utility.help.HelpTopic;
import com.elmakers.mine.bukkit.utility.help.HelpTopicKeywordMatch;
import com.elmakers.mine.bukkit.utility.help.HelpTopicMatch;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;

public class ShowTopicsTask
implements Runnable {
    private static final int DEBUG_PADDING = 2;
    private static final int DEBUG_KEY_WIDTH = 8;
    private static final int DEBUG_NUMERIC_WIDTH = 6;
    private static final String DEBUG_NUMERIC_FORMAT = "%.2f";
    private final List<HelpTopicMatch> matches;
    private final Mage mage;
    private final Help help;
    private final List<String> keywords;
    private final int maxTopics;

    public ShowTopicsTask(Help help, Mage mage, List<String> keywords, List<HelpTopicMatch> matches, int maxTopics) {
        this.help = help;
        this.keywords = keywords;
        this.mage = mage;
        this.matches = matches;
        this.maxTopics = maxTopics;
    }

    @Override
    public void run() {
        Messages messages = this.mage.getController().getMessages();
        if (this.matches.isEmpty()) {
            String topic = StringUtils.join(this.keywords, (String)" ");
            String unknownMessage = messages.get("commands.mhelp.unknown");
            this.mage.sendMessage(unknownMessage.replace("$topic", topic));
        } else {
            int size = this.matches.size();
            if (size == 1) {
                String foundMessage = messages.get("commands.mhelp.found_single");
                this.mage.sendMessage(foundMessage);
                HelpTopic topic = this.matches.get(0).getTopic();
                this.mage.sendMessage(topic.getText());
                return;
            }
            if (size > this.maxTopics) {
                foundMessage = messages.get("commands.mhelp.found_limit");
                this.mage.sendMessage(foundMessage.replace("$count", Integer.toString(size)).replace("$limit", Integer.toString(this.maxTopics)));
            } else {
                foundMessage = messages.get("commands.mhelp.found");
                this.mage.sendMessage(foundMessage.replace("$count", Integer.toString(size)));
            }
            int shown = 0;
            String template = messages.get("commands.mhelp.match");
            for (HelpTopicMatch topicMatch : this.matches) {
                String title = topicMatch.getTopic().getTitle();
                String summary = topicMatch.getSummary(!this.mage.isPlayer());
                String message = template.replace("$title", title).replace("$topic", topicMatch.getTopic().getKey()).replace("$summary", summary);
                this.mage.sendMessage(message);
                if (++shown < this.maxTopics) continue;
                break;
            }
            if (this.mage.getDebugLevel() >= 1000) {
                String debugTooltip = messages.get("commands.mhelp.debug_tooltip");
                this.mage.sendMessage(messages.get("commands.mhelp.separator"));
                int matchCount = Math.min(this.maxTopics, this.matches.size());
                if (this.mage.isPlayer()) {
                    matchCount = Math.min(matchCount, 5);
                }
                String header = String.valueOf(ChatColor.GRAY) + ChatUtils.getFixedWidth("", 8) + StringUtils.repeat((String)" ", (int)2);
                header = header + ChatUtils.getFixedWidth("*", 6) + StringUtils.repeat((String)" ", (int)2);
                for (int i = 0; i < matchCount; ++i) {
                    HelpTopicMatch topicMatch = this.matches.get(i);
                    String topicHeader = debugTooltip.replace("$debug", topicMatch.getTopic().getKey()).replace("$text", Integer.toString(i + 1));
                    header = header + ChatUtils.getFixedWidth(topicHeader, 6);
                    header = header + StringUtils.repeat((String)" ", (int)2);
                }
                this.mage.sendMessage(header);
                int totalWidth = 10 + (matchCount + 1) * 8;
                this.mage.sendMessage(StringUtils.repeat((String)"_", (int)totalWidth));
                String row = String.valueOf(ChatColor.GRAY) + ChatUtils.getFixedWidth("*", 8) + StringUtils.repeat((String)" ", (int)2);
                row = row + ChatUtils.getFixedWidth("", 6) + StringUtils.repeat((String)" ", (int)2);
                for (int i = 0; i < matchCount; ++i) {
                    HelpTopicMatch topicMatch = this.matches.get(i);
                    double relevance = topicMatch.getRelevance() * 100.0;
                    String value = relevance > 0.0 ? String.format(DEBUG_NUMERIC_FORMAT, relevance) : "";
                    value = debugTooltip.replace("$text", value);
                    value = value.replace("$debug", topicMatch.getDebugText());
                    row = row + String.valueOf(ChatColor.DARK_AQUA) + ChatUtils.getFixedWidth(value, 6);
                    row = row + StringUtils.repeat((String)" ", (int)2);
                }
                this.mage.sendMessage(row);
                for (String keyword : this.keywords) {
                    row = String.valueOf(ChatColor.WHITE) + ChatUtils.getFixedWidth(keyword, 8) + StringUtils.repeat((String)" ", (int)2);
                    String overallWeight = String.format(DEBUG_NUMERIC_FORMAT, 100.0 * this.help.getWeight(keyword));
                    overallWeight = debugTooltip.replace("$text", overallWeight);
                    overallWeight = overallWeight.replace("$debug", this.help.getDebugText(keyword));
                    row = row + String.valueOf(ChatColor.BLUE) + ChatUtils.getFixedWidth(overallWeight, 6) + StringUtils.repeat((String)" ", (int)2);
                    for (int i = 0; i < matchCount; ++i) {
                        String value;
                        HelpTopicMatch topicMatch = this.matches.get(i);
                        HelpTopicKeywordMatch keyWordMatch = topicMatch.getKeywordMatch(keyword);
                        double relevance = keyWordMatch == null ? 0.0 : keyWordMatch.getRelevance();
                        String string = value = relevance > 0.0 ? String.format(DEBUG_NUMERIC_FORMAT, 100.0 * relevance) : "";
                        if (keyWordMatch != null) {
                            value = debugTooltip.replace("$text", value);
                            value = value.replace("$debug", keyWordMatch.getDebugText(this.help));
                        }
                        row = row + String.valueOf(ChatColor.AQUA) + ChatUtils.getFixedWidth(value, 6);
                        row = row + StringUtils.repeat((String)" ", (int)2);
                    }
                    this.mage.sendMessage(row);
                }
            }
        }
        this.mage.sendMessage(messages.get("commands.mhelp.separator"));
    }
}

