/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.magic.MaterialSetManager;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.magic.MagicMetaKeys;
import com.elmakers.mine.bukkit.materials.MaterialSets;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.tasks.PlaySpellEffectsTask;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.Target;
import com.elmakers.mine.bukkit.utility.Targeting;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class TargetingSpell
extends BaseSpell {
    private static final int MAX_RANGE = 511;
    private static Set<GameMode> defaultTargetGameModes = new HashSet<GameMode>(Arrays.asList(GameMode.SURVIVAL, GameMode.ADVENTURE));
    public static Plugin HOLOGRAM_PLUGIN = null;
    private Targeting targeting = new Targeting();
    private Location targetLocation = null;
    protected Location targetLocation2 = null;
    private Location selectedLocation = null;
    private Entity targetEntity = null;
    private boolean targetNPCs = false;
    private boolean targetPets = false;
    private boolean targetArmorStands = false;
    private boolean targetInvisible = true;
    private boolean targetVanished = false;
    private boolean targetUnknown = true;
    private boolean targetNoDamageTicks = true;
    private String targetPermission = null;
    private Set<GameMode> targetGameModes = null;
    private boolean targetTamed = true;
    private boolean targetMount = false;
    private String targetDisplayName = null;
    private String ignoreDisplayName = null;
    protected Class<?> targetEntityType = null;
    protected Set<EntityType> targetEntityTypes = null;
    protected Set<EntityType> ignoreEntityTypes = null;
    protected Set<PotionEffectType> targetPotionEffectTypes = null;
    protected Set<PotionEffectType> ignorePotionEffectTypes = null;
    protected Material targetContents = null;
    protected double targetBreakables = 0.0;
    protected boolean instantBlockEffects = false;
    private double range = 0.0;
    private boolean checkProtection = false;
    private int damageResistanceProtection = 0;
    private boolean allowMaxRange = false;
    @Nonnull
    private MaterialSet targetThroughMaterials = MaterialSets.empty();
    @Nonnull
    private MaterialSet targetableMaterials = MaterialSets.wildcard();
    @Nonnull
    private MaterialSet reflectiveMaterials = MaterialSets.empty();
    private boolean reverseTargeting = false;
    private boolean originAtTarget = false;

    protected void initializeTargeting() {
        this.targeting.reset();
        this.reverseTargeting = false;
        this.targetLocation = null;
        this.targetLocation2 = null;
    }

    @Override
    public String getMessage(String messageKey, String def) {
        String message = super.getMessage(messageKey, def);
        if (!this.getVariables().contains("target") && !this.mage.getVariables().contains("target") && message.contains("$target")) {
            Target target;
            String useTargetName = null;
            if (this.currentCast != null) {
                useTargetName = this.currentCast.getTargetName();
            }
            if (useTargetName == null && (target = this.targeting.getTarget()) != null) {
                com.elmakers.mine.bukkit.block.MaterialAndData material;
                if (target.hasEntity() && this.getTargetType() != TargetType.BLOCK) {
                    useTargetName = this.controller.getEntityDisplayName(target.getEntity());
                } else if (target.isValid() && this.getTargetType() != TargetType.OTHER_ENTITY && this.getTargetType() != TargetType.ANY_ENTITY && (material = target.getTargetedMaterial()) != null) {
                    useTargetName = material.getName(this.controller.getMessages());
                }
            }
            message = useTargetName == null ? message.replaceAll("\\$target(?!_)", "Nothing") : message.replaceAll("\\$target(?!_)", useTargetName);
        }
        return message;
    }

    @Deprecated
    public boolean isReflective(Material mat) {
        return this.reflectiveMaterials.testMaterial(mat);
    }

    public boolean isReflective(Block block) {
        return this.reflectiveMaterials.testBlock(block);
    }

    public boolean isTargetable(CastContext context, Block block) {
        if (this.targetBreakables > 0.0 && context.isBreakable(block)) {
            return true;
        }
        return this.isTargetable(block);
    }

    public boolean isTargetable(Block block) {
        if (!this.allowPassThrough(block)) {
            return true;
        }
        boolean targetThrough = this.targetThroughMaterials.testBlock(block);
        if (this.reverseTargeting) {
            return targetThrough;
        }
        return !targetThrough && this.targetableMaterials.testBlock(block);
    }

    public void setReverseTargeting(boolean reverse) {
        this.reverseTargeting = reverse;
    }

    public void setTargetSpaceRequired() {
        this.targeting.setTargetSpaceRequired(true);
    }

    public void setTargetMinOffset(int offset) {
        this.targeting.setTargetMinOffset(offset);
    }

    public void setTarget(Location location) {
        this.targeting.targetBlock(this.getEyeLocation(), location == null ? null : location.getBlock());
    }

    public void setTargetingHeight(int offset) {
        this.targeting.setYOffset(offset);
    }

    public TargetType getTargetType() {
        return this.targeting.getTargetType();
    }

    public Block getPreviousBlock() {
        return this.targeting.getPreviousBlock();
    }

    public Block getPreviousPreviousBlock() {
        return this.targeting.getPreviousPreviousBlock();
    }

    public void retarget(double range, double fov, double closeRange, double closeFOV, boolean useHitbox, int yOffset, boolean targetSpaceRequired, int targetMinOffset) {
        this.initializeTargeting();
        this.range = range;
        this.targeting.setYOffset(yOffset);
        this.targeting.setTargetSpaceRequired(targetSpaceRequired);
        this.targeting.setTargetMinOffset(targetMinOffset);
        this.targeting.setFOV(fov);
        this.targeting.setCloseRange(closeFOV);
        this.targeting.setCloseFOV(closeRange);
        this.targeting.setUseHitbox(useHitbox);
        this.target();
    }

    public void retarget(CastContext context, double range, double fov, double closeRange, double closeFOV, boolean useHitbox) {
        this.initializeTargeting();
        this.range = range;
        this.targeting.setFOV(fov);
        this.targeting.setCloseRange(closeFOV);
        this.targeting.setCloseFOV(closeRange);
        this.targeting.setUseHitbox(useHitbox);
        this.target(context);
    }

    public void target(CastContext castContext) {
        if (!this.targeting.hasTarget()) {
            this.getTarget(castContext);
        }
    }

    @Override
    public void target() {
        this.target(this.currentCast);
    }

    protected Target processBlockEffects() {
        Target target;
        Target originalTarget = target = this.targeting.getTarget();
        Block block = target.getBlock();
        Double backfireAmount = this.currentCast.getReflective(block);
        if (backfireAmount != null && random.nextDouble() < backfireAmount) {
            Entity mageEntity = this.mage.getEntity();
            Location location = this.getLocation();
            Location originLocation = block.getLocation();
            Vector direction = location.getDirection();
            originLocation.setDirection(direction.multiply(-1));
            this.location = originLocation;
            this.backfire();
            Collection<EffectPlayer> effects = this.getEffects("cast");
            if (effects.size() > 0) {
                Bukkit.getScheduler().runTaskLater(this.controller.getPlugin(), (Runnable)new PlaySpellEffectsTask(effects, originLocation, this, this.mage), 5L);
            }
            target = new Target(this.getEyeLocation(), mageEntity);
        }
        if (this.targetBreakables > 0.0 && originalTarget.isValid() && block != null && this.currentCast.isBreakable(block)) {
            this.targeting.breakBlock(this.currentCast, block, this.targetBreakables);
        }
        return target;
    }

    protected Target findTarget(CastContext context) {
        boolean isBlock;
        Location source = this.getEyeLocation();
        TargetType targetType = this.targeting.getTargetType();
        boolean bl = isBlock = targetType == TargetType.BLOCK || targetType == TargetType.SELECT;
        if (!isBlock && this.targetEntity != null) {
            return this.targeting.overrideTarget(context, new Target(source, this.targetEntity));
        }
        if (targetType == TargetType.LAST_DAMAGER) {
            return this.targeting.overrideTarget(context, new Target(source, this.mage.getLastDamager()));
        }
        if (targetType == TargetType.TOP_DAMAGER) {
            return this.targeting.overrideTarget(context, new Target(source, this.mage.getTopDamager()));
        }
        if (targetType == TargetType.DAMAGE_TARGET) {
            return this.targeting.overrideTarget(context, new Target(source, this.mage.getLastDamageTarget()));
        }
        if (targetType == TargetType.BLOCK_BROKEN) {
            return this.targeting.overrideTarget(context, new Target(source, this.mage.getLastBlockBroken()));
        }
        if (targetType != TargetType.SELF && this.targetLocation != null) {
            return this.targeting.overrideTarget(context, new Target(source, this.targetLocation.getBlock()));
        }
        Target target = this.targeting.target(context, this.getMaxRange());
        return this.targeting.getResult() == Targeting.TargetingResult.MISS && !this.allowMaxRange ? new Target(source) : target;
    }

    protected Target getTarget() {
        return this.getTarget(this.currentCast);
    }

    protected Target getTarget(CastContext context) {
        Target target = this.findTarget(context);
        if (this.instantBlockEffects) {
            target = this.processBlockEffects();
        }
        if (this.originAtTarget && target.isValid()) {
            Location previous = this.location;
            if (previous == null && this.mage != null) {
                previous = this.mage.getLocation();
            }
            this.location = target.getLocation().clone();
            if (previous != null) {
                this.location.setPitch(previous.getPitch());
                this.location.setYaw(previous.getYaw());
            }
        }
        Entity targetEntity = target != null ? target.getEntity() : null;
        Location targetLocation = target != null ? target.getLocation() : null;
        context.setTargetLocation(targetLocation);
        context.setTargetEntity(targetEntity);
        return target;
    }

    public Target getCurrentTarget() {
        return this.targeting.getOrCreateTarget(this.getEyeLocation());
    }

    @Nullable
    public Block getTargetBlock() {
        return this.getTarget().getBlock();
    }

    public List<Target> getAllTargetEntities() {
        this.targeting.start(this.currentCast.getEyeLocation());
        return this.targeting.getAllTargetEntities(this.currentCast, this.getMaxRange());
    }

    @Override
    public boolean canTarget(Entity entity) {
        return this.canTarget(entity, null);
    }

    public boolean canTarget(Entity entity, Class<?> targetType) {
        ItemFrame itemFrame;
        ItemStack item;
        LivingEntity living;
        LivingEntity li;
        if (!entity.isValid() || entity.isDead()) {
            return false;
        }
        if (this.targetEntity != null && !this.targetEntity.getUniqueId().equals(entity.getUniqueId())) {
            return false;
        }
        if (!this.targetUnknown && entity.getType() == EntityType.UNKNOWN) {
            this.mage.sendDebugMessage("Entity is unknown type", 30);
            return false;
        }
        if (!this.targetMount) {
            Entity mounted = CompatibilityLib.getDeprecatedUtils().getPassenger(entity);
            Entity mageEntity = this.mage.getEntity();
            if (mounted != null && mageEntity != null && mounted.equals((Object)mageEntity)) {
                this.mage.sendDebugMessage("Entity skipped, can't target your own mount", 30);
                return false;
            }
        }
        if (!this.targetTamed && entity instanceof Tameable && ((Tameable)entity).isTamed()) {
            this.mage.sendDebugMessage("Entity skipped, is tamed", 30);
            return false;
        }
        if (HOLOGRAM_PLUGIN != null && CompatibilityLib.getEntityMetadataUtils().hasString(entity, "hologram", HOLOGRAM_PLUGIN)) {
            this.mage.sendDebugMessage("Entity skipped, is hologram entity", 30);
            return false;
        }
        if (CompatibilityLib.getEntityMetadataUtils().getBoolean(entity, MagicMetaKeys.NO_TARGET)) {
            this.mage.sendDebugMessage("Entity skipped, has notarget metadata", 30);
            return false;
        }
        if (!this.targetNPCs && this.controller.isStaticNPC(entity)) {
            this.mage.sendDebugMessage("Entity skipped, is npc", 30);
            return false;
        }
        if (!this.targetPets && this.controller.isPet(entity)) {
            this.mage.sendDebugMessage("Entity skipped, is pet", 30);
            return false;
        }
        if (!this.targetArmorStands && entity instanceof ArmorStand) {
            this.mage.sendDebugMessage("Entity is armor stand, so no", 30);
            return false;
        }
        if (this.ignoreEntityTypes != null && this.ignoreEntityTypes.contains(entity.getType())) {
            this.mage.sendDebugMessage("Entity is in ignored types list, so no", 30);
            return false;
        }
        if (!(this.targetDisplayName == null || entity.getCustomName() != null && entity.getCustomName().equals(this.targetDisplayName))) {
            this.mage.sendDebugMessage("Entity is not the specific display name we're looking for", 30);
            return false;
        }
        if (this.ignoreDisplayName != null && entity.getCustomName() != null && entity.getCustomName().equals(this.ignoreDisplayName)) {
            this.mage.sendDebugMessage("Entity has an ignored display name", 30);
            return false;
        }
        if (this.targetPermission != null && !this.controller.hasPermission(entity, this.targetPermission)) {
            this.mage.sendDebugMessage("Entity does not have specific permission required", 30);
            return false;
        }
        if (this.targetPotionEffectTypes != null) {
            if (!(entity instanceof LivingEntity)) {
                this.mage.sendDebugMessage("Entity not a living entity and looking for potion effects", 30);
                return false;
            }
            li = (LivingEntity)entity;
            boolean has = false;
            for (PotionEffectType type : this.targetPotionEffectTypes) {
                if (!li.hasPotionEffect(type)) continue;
                has = true;
                break;
            }
            if (!has) {
                this.mage.sendDebugMessage("Entity does not have the specific potion effect we're looking for", 30);
                return false;
            }
        }
        if (this.ignorePotionEffectTypes != null && entity instanceof LivingEntity) {
            li = (LivingEntity)entity;
            for (PotionEffectType type : this.targetPotionEffectTypes) {
                if (!li.hasPotionEffect(type)) continue;
                this.mage.sendDebugMessage("Entity has one of the ignored potion effects", 30);
                return false;
            }
        }
        if (this.damageResistanceProtection > 0 && entity instanceof LivingEntity && (living = (LivingEntity)entity).hasPotionEffect(PotionEffectType.DAMAGE_RESISTANCE)) {
            Collection effects = living.getActivePotionEffects();
            for (PotionEffect effect : effects) {
                if (!effect.getType().equals((Object)PotionEffectType.DAMAGE_RESISTANCE) || effect.getAmplifier() < this.damageResistanceProtection) continue;
                this.mage.sendDebugMessage("Entity skipped due to damage resistance", 30);
                return false;
            }
        }
        if (this.isSuperProtected(entity)) {
            this.mage.sendDebugMessage("Entity is superprotected", 30);
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.checkProtection && player.hasPermission("magic.protected." + this.getKey())) {
                this.mage.sendDebugMessage("Entity has Magic.protected perm", 30);
                return false;
            }
            if (this.targetGameModes != null && !this.targetGameModes.contains(player.getGameMode())) {
                this.mage.sendDebugMessage("Entity has one of the ignored game modes", 30);
                return false;
            }
        }
        if (!this.targetInvisible && entity instanceof LivingEntity && ((LivingEntity)entity).hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            this.mage.sendDebugMessage("Entity skipped, is invisible", 30);
            return false;
        }
        if (!this.targetVanished && entity instanceof Player && this.controller.isVanished(entity)) {
            this.mage.sendDebugMessage("Entity skipped, is vanished", 30);
            return false;
        }
        if (!this.targetNoDamageTicks && entity instanceof LivingEntity && ((LivingEntity)entity).getNoDamageTicks() > 0) {
            this.mage.sendDebugMessage("Entity skipped, has no damage ticks", 30);
            return false;
        }
        if (this.targetContents != null && entity instanceof ItemFrame && ((item = (itemFrame = (ItemFrame)entity).getItem()) == null || item.getType() != this.targetContents)) {
            this.mage.sendDebugMessage("Entity missing item frame contents", 30);
            return false;
        }
        if (targetType != null) {
            boolean isTargetType = targetType.isAssignableFrom(entity.getClass());
            if (!isTargetType) {
                this.mage.sendDebugMessage("Entity is not the right target type", 30);
            }
            return isTargetType && super.canTarget(entity);
        }
        if (this.targetEntityType == null && this.targetEntityTypes == null) {
            return super.canTarget(entity);
        }
        if (this.targetEntityTypes != null) {
            boolean isTargetType = this.targetEntityTypes.contains(entity.getType());
            if (!isTargetType) {
                this.mage.sendDebugMessage("Entity is not the right target type", 30);
            }
            return isTargetType && super.canTarget(entity);
        }
        boolean isTargetType = this.targetEntityType.isAssignableFrom(entity.getClass());
        if (!isTargetType) {
            this.mage.sendDebugMessage("Entity is not the right target type", 30);
        }
        return isTargetType && super.canTarget(entity);
    }

    public boolean isSuperProtected(Entity entity) {
        if (this.bypassAll || this.bypassProtection) {
            return false;
        }
        Mage mage = this.controller.getRegisteredMage(entity);
        if (mage != null && mage.isSuperProtected()) {
            return true;
        }
        EntityData mob = this.controller.getMob(entity);
        return mob != null && mob.isSuperProtected();
    }

    protected double getMaxRange() {
        if (this.allowMaxRange) {
            return Math.min(511.0, this.range);
        }
        float multiplier = this.mage == null ? 1.0f : this.mage.getRangeMultiplier();
        return Math.min(511.0, (double)multiplier * this.range);
    }

    @Override
    public double getRange() {
        TargetType targetType = this.targeting.getTargetType();
        if (!targetType.isRanged()) {
            return 0.0;
        }
        return this.getMaxRange();
    }

    protected double getMaxRangeSquared() {
        double maxRange = this.getMaxRange();
        return maxRange * maxRange;
    }

    protected void setMaxRange(double range) {
        this.range = range;
    }

    @Deprecated
    public boolean isTransparent(Material material) {
        return this.targetThroughMaterials.testMaterial(material);
    }

    public boolean isTransparent(Block block) {
        return this.targetThroughMaterials.testBlock(block);
    }

    @Nullable
    public Block getInteractBlock() {
        Location location = this.getEyeLocation();
        if (location == null) {
            return null;
        }
        Block playerBlock = location.getBlock();
        if (this.isTargetable(playerBlock)) {
            return playerBlock;
        }
        Vector direction = location.getDirection().normalize();
        return location.add(direction).getBlock();
    }

    public Block findBlockUnder(Block block) {
        int depth = 0;
        if (this.targetThroughMaterials.testBlock(block)) {
            while (depth < this.verticalSearchDistance && this.targetThroughMaterials.testBlock(block)) {
                ++depth;
                block = block.getRelative(BlockFace.DOWN);
            }
        } else {
            while (depth < this.verticalSearchDistance && !this.targetThroughMaterials.testBlock(block)) {
                ++depth;
                block = block.getRelative(BlockFace.UP);
            }
            block = block.getRelative(BlockFace.DOWN);
        }
        return block;
    }

    public Block findSpaceAbove(Block block) {
        int depth = 0;
        while (depth < this.verticalSearchDistance && !this.targetThroughMaterials.testBlock(block)) {
            ++depth;
            block = block.getRelative(BlockFace.UP);
        }
        return block;
    }

    @Override
    protected void reset() {
        super.reset();
        this.initializeTargeting();
    }

    @Override
    public void processTemplateParameters(ConfigurationSection parameters) {
        TargetType targetType;
        super.processTemplateParameters(parameters);
        this.range = parameters.getDouble("range", 0.0);
        boolean hasTargeting = parameters.contains("target");
        this.targeting.parseTargetType(parameters.getString("target"));
        if (this.range > 0.0 && !hasTargeting) {
            this.targeting.setTargetType(TargetType.OTHER);
        }
        if ((targetType = this.targeting.getTargetType()) != TargetType.NONE && targetType != TargetType.SELF && !parameters.contains("range")) {
            this.range = 32.0;
        }
        this.targetSelf = targetType == TargetType.SELF;
        this.targetSelf = parameters.getBoolean("target_self", this.targetSelf);
    }

    @Override
    public void processParameters(ConfigurationSection parameters) {
        EntityType entityType;
        List<String> typeKeys;
        String reflectiveKey;
        this.targeting.processParameters(parameters);
        super.processParameters(parameters);
        this.allowMaxRange = parameters.getBoolean("allow_max_range", false);
        this.checkProtection = parameters.getBoolean("check_protection", false);
        this.damageResistanceProtection = parameters.getInt("damage_resistance_protection", 0);
        this.targetBreakables = parameters.getDouble("target_breakables", 1.0);
        this.reverseTargeting = parameters.getBoolean("reverse_targeting", false);
        this.instantBlockEffects = parameters.getBoolean("instant_block_effects", false);
        MaterialSetManager materials = this.controller.getMaterialSetManager();
        this.targetThroughMaterials = MaterialSets.empty();
        this.targetThroughMaterials = materials.getMaterialSet("transparent", this.targetThroughMaterials);
        this.targetThroughMaterials = materials.fromConfig(parameters.getString("transparent"), this.targetThroughMaterials);
        this.targetableMaterials = MaterialSets.wildcard();
        this.targetableMaterials = materials.fromConfig(parameters.getString("targetable"), this.targetableMaterials);
        this.reflectiveMaterials = MaterialSets.empty();
        this.reflectiveMaterials = materials.fromConfig(parameters.getString("reflective"), this.reflectiveMaterials);
        if (parameters.getBoolean("reflective_override", true) && (reflectiveKey = this.controller.getReflectiveMaterials(this.mage, this.mage.getLocation())) != null) {
            this.reflectiveMaterials = MaterialSets.union(materials.fromConfigEmpty(reflectiveKey), this.reflectiveMaterials);
        }
        this.targetPotionEffectTypes = this.parsePotionEffectTypes(parameters, "target_potion_effects");
        this.ignorePotionEffectTypes = this.parsePotionEffectTypes(parameters, "ignore_potion_effects");
        this.targetNPCs = parameters.getBoolean("target_npc", false);
        this.targetPets = parameters.getBoolean("target_pet", false);
        this.targetArmorStands = parameters.getBoolean("target_armor_stand", false);
        this.targetInvisible = parameters.getBoolean("target_invisible", true);
        this.targetVanished = parameters.getBoolean("target_vanished", false);
        this.targetUnknown = parameters.getBoolean("target_unknown", true);
        this.targetTamed = parameters.getBoolean("target_tamed", true);
        this.targetMount = parameters.getBoolean("target_mount", false);
        this.targetNoDamageTicks = parameters.getBoolean("target_no_damage_ticks", true);
        this.targetPermission = parameters.getString("target_permission");
        this.targetGameModes = defaultTargetGameModes;
        List<String> gameModes = ConfigurationUtils.getStringList(parameters, "target_game_modes");
        if (gameModes != null && !gameModes.isEmpty()) {
            if (gameModes.get(0).equalsIgnoreCase("all")) {
                this.targetGameModes = null;
            } else {
                this.targetGameModes = new HashSet<GameMode>();
                for (String gameMode : gameModes) {
                    try {
                        GameMode mode = GameMode.valueOf((String)gameMode.toUpperCase());
                        this.targetGameModes.add(mode);
                    }
                    catch (Exception ex) {
                        this.controller.getLogger().warning("Invalid game mode: " + gameMode);
                    }
                }
            }
        }
        if (parameters.contains("target_type")) {
            String entityTypeName = parameters.getString("target_type");
            try {
                this.targetEntityType = Class.forName("org.bukkit.entity." + entityTypeName);
            }
            catch (Throwable ex) {
                this.controller.getLogger().warning("Unknown entity class in target_type of " + this.getKey() + ": " + entityTypeName);
                this.targetEntityType = null;
            }
        } else if (parameters.contains("target_types")) {
            this.targetEntityType = null;
            this.targetEntityTypes = new HashSet<EntityType>();
            typeKeys = ConfigurationUtils.getStringList(parameters, "target_types");
            for (String typeKey : typeKeys) {
                try {
                    entityType = EntityType.valueOf((String)typeKey.toUpperCase());
                    this.targetEntityTypes.add(entityType);
                }
                catch (Throwable ex) {
                    this.controller.getLogger().warning("Unknown entity type in target_types of " + this.getKey() + ": " + typeKey);
                }
            }
        } else {
            this.targetEntityType = null;
            this.targetEntityTypes = null;
        }
        if (parameters.contains("ignore_types")) {
            this.ignoreEntityTypes = new HashSet<EntityType>();
            typeKeys = ConfigurationUtils.getStringList(parameters, "ignore_types");
            for (String typeKey : typeKeys) {
                try {
                    entityType = EntityType.valueOf((String)typeKey.toUpperCase());
                    this.ignoreEntityTypes.add(entityType);
                }
                catch (Throwable ex) {
                    this.controller.getLogger().warning("Unknown entity type in ignore_types of " + this.getKey() + ": " + typeKey);
                }
            }
        } else {
            this.ignoreEntityTypes = null;
        }
        this.targetDisplayName = parameters.getString("target_name", null);
        this.ignoreDisplayName = parameters.getString("ignore_name", null);
        this.targetContents = ConfigurationUtils.getMaterial(parameters, "target_contents", null);
        this.originAtTarget = parameters.getBoolean("origin_at_target", false);
        Location defaultLocation = this.getLocation();
        this.targetLocation = ConfigurationUtils.overrideLocation(this.controller, parameters, "t", defaultLocation, this.controller.canCreateWorlds());
        defaultLocation = this.targetLocation == null ? defaultLocation : this.targetLocation;
        this.targetLocation2 = ConfigurationUtils.overrideLocation(this.controller, parameters, "t2", defaultLocation, this.controller.canCreateWorlds());
        String uuid = parameters.getString("entity", "");
        String playerName = parameters.getString("player", "");
        if (!uuid.isEmpty()) {
            Entity entity = CompatibilityLib.getCompatibilityUtils().getEntity(UUID.fromString(uuid));
            if (entity != null) {
                this.targetLocation = entity.getLocation();
                this.targetEntity = entity;
            }
        } else if (!playerName.isEmpty()) {
            Player player = CompatibilityLib.getDeprecatedUtils().getPlayer(playerName);
            if (player != null) {
                this.targetLocation = player.getLocation();
                this.targetEntity = player;
            }
        } else {
            this.targetEntity = null;
        }
        boolean targetUnderwater = parameters.getBoolean("target_underwater", true);
        if (targetUnderwater && this.isUnderwater()) {
            this.targetThroughMaterials = MaterialSets.union(this.targetThroughMaterials, DefaultMaterials.getWaterSet());
        }
    }

    @Nullable
    protected Set<PotionEffectType> parsePotionEffectTypes(ConfigurationSection parameters, String key) {
        HashSet<PotionEffectType> types = null;
        List<String> potionEffects = ConfigurationUtils.getStringList(parameters, key);
        if (potionEffects != null && !potionEffects.isEmpty()) {
            types = new HashSet<PotionEffectType>();
            for (String effectType : potionEffects) {
                PotionEffectType effect = PotionEffectType.getByName((String)effectType);
                if (effect == null) {
                    this.controller.getLogger().warning("Invalid potion effect type: " + effectType + " in target/ignore parameters of " + this.getKey());
                    continue;
                }
                types.add(effect);
            }
        }
        return types;
    }

    @Override
    protected String getDisplayMaterialName() {
        Target target = this.targeting.getTarget();
        if (target != null && target.isValid()) {
            return MaterialBrush.getMaterialName(target.getBlock(), this.controller.getMessages());
        }
        return super.getDisplayMaterialName();
    }

    @Override
    protected void onBackfire() {
        this.targeting.setTargetType(TargetType.SELF);
    }

    @Nullable
    public Location getSelectedLocation() {
        return this.selectedLocation;
    }

    public void setSelectedLocation(Location location) {
        this.selectedLocation = location;
    }

    @Override
    @Nullable
    public Location getTargetLocation() {
        Target target = this.targeting.getTarget();
        if (target != null && target.isValid()) {
            return target.getLocation();
        }
        return null;
    }

    @Override
    @Nullable
    public Entity getTargetEntity() {
        Target target = this.targeting.getTarget();
        if (target != null && target.isValid()) {
            return target.getEntity();
        }
        return null;
    }

    @Override
    @Nullable
    public MaterialAndData getEffectMaterial() {
        Target target = this.targeting.getTarget();
        if (target != null && target.isValid()) {
            Block block = target.getBlock();
            if (!CompatibilityLib.getCompatibilityUtils().isChunkLoaded(block)) {
                return super.getEffectMaterial();
            }
            com.elmakers.mine.bukkit.block.MaterialAndData targetMaterial = new com.elmakers.mine.bukkit.block.MaterialAndData(block);
            if (targetMaterial.getMaterial() == Material.AIR) {
                targetMaterial.setMaterial(DEFAULT_EFFECT_MATERIAL);
            }
            return targetMaterial;
        }
        return super.getEffectMaterial();
    }

    public Class<?> getTargetEntityType() {
        return this.targetEntityType;
    }
}

