/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.resourcepack;

import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.resourcepack.ResourcePack;
import com.elmakers.mine.bukkit.resourcepack.ResourcePackManager;
import com.elmakers.mine.bukkit.resourcepack.ResourcePackResponse;
import com.google.common.io.BaseEncoding;
import java.io.BufferedInputStream;
import java.lang.invoke.CallSite;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;

public class ResourcePackUpdateRunnable
implements Runnable {
    private final ResourcePackManager manager;
    private final ResourcePackResponse callback;
    private final ResourcePack resourcePack;
    private final boolean force;
    private final boolean filenameChanged;

    public ResourcePackUpdateRunnable(ResourcePackManager manager, ResourcePack resourcePack, ResourcePackResponse callback, boolean force, boolean filenameChanged) {
        this.manager = manager;
        this.resourcePack = resourcePack;
        this.callback = callback;
        this.force = force;
        this.filenameChanged = filenameChanged;
    }

    @Override
    public void run() {
        ArrayList<CallSite> responses;
        Server server;
        Plugin plugin;
        boolean hasModifiedTime;
        boolean success;
        block30: {
            success = true;
            hasModifiedTime = false;
            MagicController controller = this.manager.getController();
            plugin = controller.getPlugin();
            server = plugin.getServer();
            boolean initialLoad = !this.resourcePack.isChecked();
            this.resourcePack.setChecked(true);
            String finalResourcePack = this.resourcePack.getUrl();
            long modifiedTimestamp = this.resourcePack.getModified().getTime();
            byte[] resourcePackHash = this.resourcePack.getHash();
            String currentHashString = this.resourcePack.getHashString();
            responses = new ArrayList<CallSite>();
            try {
                URL rpURL = new URL(finalResourcePack);
                HttpURLConnection connection = (HttpURLConnection)rpURL.openConnection();
                connection.setInstanceFollowRedirects(true);
                connection.setRequestMethod("HEAD");
                if (connection.getResponseCode() == 200) {
                    SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
                    Date tryParseDate = new Date(1L);
                    String lastModified = connection.getHeaderField("Last-Modified");
                    if (lastModified == null || lastModified.isEmpty()) {
                        responses.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Server did not return a Last-Modified field")));
                    } else {
                        try {
                            tryParseDate = format.parse(lastModified);
                            hasModifiedTime = true;
                        }
                        catch (ParseException dateFormat) {
                            success = false;
                            responses.add((CallSite)((Object)("Error parsing resource pack modified time: " + lastModified)));
                        }
                    }
                    Date modifiedDate = tryParseDate;
                    if (modifiedDate.getTime() > modifiedTimestamp || resourcePackHash == null || this.force && !hasModifiedTime) {
                        boolean isUnset;
                        boolean bl = isUnset = resourcePackHash == null;
                        if (this.filenameChanged) {
                            responses.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Resource pack changed, checking " + finalResourcePack + " for updated hash")));
                        } else if (modifiedTimestamp <= 0L) {
                            responses.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Checking resource pack for the first time")));
                        } else if (isUnset) {
                            responses.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Resource pack hash format changed, downloading for one-time update")));
                        } else if (!hasModifiedTime && this.force) {
                            responses.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Forcing resource pack check with missing modified time, redownloading")));
                        } else {
                            responses.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Resource pack modified, redownloading (" + modifiedDate.getTime() + " > " + modifiedTimestamp + ")")));
                        }
                        MessageDigest digest = MessageDigest.getInstance("SHA1");
                        try (BufferedInputStream in = new BufferedInputStream(rpURL.openStream());){
                            int count;
                            byte[] data = new byte[1024];
                            while ((count = in.read(data, 0, 1024)) != -1) {
                                digest.update(data, 0, count);
                            }
                        }
                        resourcePackHash = digest.digest();
                        String newSourcePackHashString = BaseEncoding.base64().encode(resourcePackHash);
                        if (initialLoad) {
                            responses.add((CallSite)((Object)(String.valueOf(ChatColor.GREEN) + "Resource pack hash set to " + String.valueOf(ChatColor.GRAY) + newSourcePackHashString)));
                        } else if (currentHashString != null && currentHashString.equals(newSourcePackHashString)) {
                            responses.add((CallSite)((Object)(String.valueOf(ChatColor.GREEN) + "Resource pack hash has not changed")));
                        } else {
                            responses.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Resource pack hash changed, use " + String.valueOf(ChatColor.AQUA) + "/magic rpsend" + String.valueOf(ChatColor.YELLOW) + " to update connected players")));
                        }
                        this.resourcePack.update(resourcePackHash, modifiedDate);
                        this.manager.saveResourcePacks();
                        break block30;
                    }
                    if (this.filenameChanged) {
                        responses.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Resource pack changed, use " + String.valueOf(ChatColor.AQUA) + "/magic rpsend" + String.valueOf(ChatColor.YELLOW) + " to update connected players")));
                    } else {
                        responses.add((CallSite)((Object)(String.valueOf(ChatColor.GREEN) + "Resource pack has not changed, using hash " + currentHashString + " (" + modifiedDate.getTime() + " <= " + modifiedTimestamp + ")")));
                    }
                    break block30;
                }
                responses.add((CallSite)((Object)(String.valueOf(ChatColor.RED) + "Could not find resource pack at: " + String.valueOf(ChatColor.DARK_RED) + finalResourcePack)));
                success = false;
            }
            catch (Exception ex) {
                success = false;
                responses.add((CallSite)((Object)("An unexpected error occurred while checking your resource pack (see logs): " + String.valueOf(ChatColor.DARK_RED) + finalResourcePack)));
                controller.getLogger().log(Level.WARNING, "Error checking resource pack: " + ex.getClass().getSimpleName() + " : " + ex.getMessage());
            }
        }
        if (plugin.isEnabled() && this.callback != null) {
            final boolean finalSuccess = success;
            final boolean finalHasModified = hasModifiedTime;
            server.getScheduler().runTask(plugin, new Runnable(){

                @Override
                public void run() {
                    ResourcePackUpdateRunnable.this.callback.finished(finalSuccess, finalHasModified, responses, ResourcePackUpdateRunnable.this.resourcePack);
                }
            });
        }
    }
}

