/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.magic.Mage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;

public class MageTargeting {
    private final Mage mage;
    private final EntityData entityData;
    private final Map<UUID, DamagedBy> damagedBy = new HashMap<UUID, DamagedBy>();
    private DamagedBy topDamager;
    private DamagedBy lastDamager;

    public MageTargeting(Mage mage) {
        this.mage = mage;
        this.entityData = mage.getEntityData();
    }

    @Nullable
    public Collection<Entity> getDamagers() {
        if (this.damagedBy == null) {
            return null;
        }
        ArrayList<Entity> damagers = new ArrayList<Entity>();
        for (DamagedBy damager : this.damagedBy.values()) {
            Entity entity = damager.getEntity();
            if (entity == null) continue;
            damagers.add(entity);
        }
        return damagers;
    }

    private boolean withinRange(Entity entity) {
        double rangeSquared;
        boolean withinRange = this.mage.getLocation().getWorld() == entity.getLocation().getWorld();
        double d = rangeSquared = this.entityData == null ? 0.0 : this.entityData.getTrackRadiusSquared();
        if (rangeSquared > 0.0 && withinRange) {
            withinRange = this.mage.getLocation().distanceSquared(entity.getLocation()) <= rangeSquared;
        }
        return withinRange;
    }

    @Nullable
    public Entity getTopDamager() {
        if (this.topDamager == null) {
            return null;
        }
        Entity topEntity = this.topDamager.getEntity();
        if (topEntity == null && this.damagedBy != null) {
            double topDamage = 0.0;
            Iterator<Map.Entry<UUID, DamagedBy>> it = this.damagedBy.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<UUID, DamagedBy> entry = it.next();
                DamagedBy damaged = entry.getValue();
                Entity entity = damaged.getEntity();
                if (entity != null && entity.isValid() && !entity.isDead()) {
                    boolean withinRange = this.withinRange(entity);
                    if (!withinRange || !(damaged.damage > topDamage)) continue;
                    topEntity = entity;
                    topDamage = damaged.damage;
                    this.topDamager = damaged;
                    continue;
                }
                it.remove();
            }
        }
        return topEntity;
    }

    public void damagedBy(@Nonnull Entity damager, double damage) {
        Entity lastDamagerEntity;
        Entity entity = lastDamagerEntity = this.lastDamager == null ? null : this.lastDamager.getEntity();
        if (lastDamagerEntity == damager) {
            this.lastDamager.damage += damage;
        } else {
            this.lastDamager = this.damagedBy != null ? this.damagedBy.get(damager.getUniqueId()) : null;
            if (this.lastDamager == null) {
                this.lastDamager = new DamagedBy(damager, damage);
                if (this.damagedBy != null) {
                    this.damagedBy.put(damager.getUniqueId(), this.lastDamager);
                }
            } else {
                this.lastDamager.damage += damage;
            }
        }
        Mage damagerMage = this.mage.getController().getRegisteredMage(damager);
        if (damagerMage != null && damagerMage.isIgnoredByMobs()) {
            return;
        }
        if (this.topDamager != null) {
            if (this.topDamager.getEntity() == null || this.topDamager.damage < this.lastDamager.damage || !this.withinRange(this.topDamager.getEntity())) {
                this.topDamager = this.lastDamager;
                if (this.entityData != null && this.entityData.shouldFocusOnDamager()) {
                    this.mage.setTarget(damager);
                }
            }
        } else {
            this.topDamager = this.lastDamager;
            if (this.entityData != null && this.entityData.shouldFocusOnDamager()) {
                this.mage.setTarget(damager);
            }
        }
    }

    private static class DamagedBy {
        public double damage;
        private WeakReference<Entity> player;

        public DamagedBy(Entity entity, double damage) {
            this.player = new WeakReference<Entity>(entity);
            this.damage = damage;
        }

        public Entity getEntity() {
            return (Entity)this.player.get();
        }
    }
}

