/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import com.elmakers.mine.bukkit.api.event.PreCastEvent;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;

public class EvtPreCast
extends SkriptEvent {
    private Literal<String> spells;

    public static void register() {
        Skript.registerEvent((String)"Casting Spell", EvtPreCast.class, PreCastEvent.class, (String[])new String[]{"casting [[of] [spell] %-string%]"}).description(new String[]{"Called when a player or magic mob is about to cast a spell"}).examples(new String[]{"on casting", "on casting of missile", "on casting of spell blink"});
    }

    public boolean init(Literal<?>[] args, int i, SkriptParser.ParseResult parseResult) {
        this.spells = args[0];
        return true;
    }

    public boolean check(Event event) {
        if (!(event instanceof PreCastEvent)) {
            return false;
        }
        PreCastEvent spellCast = (PreCastEvent)event;
        if (this.spells != null) {
            String spellKey = spellCast.getSpell().getKey();
            String spellName = ChatColor.stripColor((String)spellCast.getSpell().getName());
            for (String spell : (String[])this.spells.getAll()) {
                if (spellKey.equalsIgnoreCase(spell)) {
                    return true;
                }
                if (!spellName.equalsIgnoreCase(spell)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public String toString(Event event, boolean debug) {
        return "casting" + (String)(this.spells != null ? " of " + this.spells.toString(event, debug) : "");
    }
}

