/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.citizens;

import com.elmakers.mine.bukkit.citizens.CitizensTrait;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.util.DataKey;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class MagicCitizensTrait
extends CitizensTrait {
    private String spellKey;
    private boolean npcCaster = false;
    private boolean targetPlayer = true;
    private boolean messagePlayer = false;
    private YamlConfiguration parameters = null;
    private List<UUID> observers = null;

    public MagicCitizensTrait() {
        super("magic");
    }

    @Override
    public void load(DataKey data) {
        super.load(data);
        this.spellKey = data.getString("spell", null);
        this.npcCaster = data.getBoolean("caster", false);
        this.targetPlayer = data.getBoolean("target_player", true);
        this.messagePlayer = data.getBoolean("message_player", false);
        String parameterString = data.getString("parameters", null);
        this.parameters = new YamlConfiguration();
        if (parameterString != null && !parameterString.isEmpty()) {
            if (!parameterString.contains(":")) {
                String[] simple = StringUtils.split((String)parameterString, (char)' ');
                if (simple.length > 0) {
                    ConfigurationUtils.addParameters(simple, (ConfigurationSection)this.parameters);
                }
            } else {
                try {
                    this.parameters.loadFromString(parameterString);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public void save(DataKey data) {
        super.save(data);
        data.setString("spell", this.spellKey);
        data.setBoolean("caster", this.npcCaster);
        data.setBoolean("target_player", this.targetPlayer);
        data.setBoolean("message_player", this.messagePlayer);
        String parameterString = this.parameters == null ? null : this.parameters.saveToString();
        data.setString("parameters", parameterString);
    }

    public String getSpell() {
        return this.spellKey;
    }

    public ConfigurationSection getSpellParameters() {
        return this.parameters;
    }

    public boolean isCaster() {
        return this.npcCaster;
    }

    public boolean isTargetPlayer() {
        return this.targetPlayer;
    }

    @Override
    public boolean perform(NPCRightClickEvent event) {
        if (this.spellKey == null || this.spellKey.isEmpty()) {
            return false;
        }
        Player sender = event.getClicker();
        Player entity = event.getClicker();
        YamlConfiguration config = this.parameters;
        if (this.npcCaster && event.getNPC().isSpawned()) {
            entity = event.getNPC().getEntity();
            if (!this.messagePlayer) {
                sender = null;
            }
            if (this.targetPlayer) {
                config = ConfigurationUtils.newConfigurationSection();
                ConfigurationUtils.addConfigurations((ConfigurationSection)config, (ConfigurationSection)this.parameters);
                config.set("player", (Object)event.getClicker().getName());
            }
        }
        return this.api.getController().cast(this.spellKey, (ConfigurationSection)config, (CommandSender)sender, (Entity)entity, this.observers);
    }

    @Override
    public void describe(CommandSender sender) {
        super.describe(sender);
        String spellDescription = this.spellKey == null ? String.valueOf(ChatColor.RED) + "(None)" : String.valueOf(ChatColor.LIGHT_PURPLE) + this.spellKey;
        sender.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "Spell: " + spellDescription);
        String casterDescription = this.npcCaster ? String.valueOf(ChatColor.GRAY) + "NPC" : String.valueOf(ChatColor.LIGHT_PURPLE) + "Player";
        sender.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "Caster: " + casterDescription);
        if (this.npcCaster) {
            if (this.targetPlayer) {
                sender.sendMessage(" " + String.valueOf(ChatColor.YELLOW) + "Will auto-target player");
            }
            if (this.messagePlayer) {
                sender.sendMessage(" " + String.valueOf(ChatColor.YELLOW) + "Will relay cast messages to player");
            }
        }
        sender.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "Parameters: ");
        if (this.observers != null) {
            sender.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "Observers: ");
            for (UUID playerId : this.observers) {
                Player player = this.api.getPlugin().getServer().getPlayer(playerId);
                if (player == null) {
                    sender.sendMessage(String.valueOf(ChatColor.GRAY) + " (Offline)");
                    continue;
                }
                sender.sendMessage(String.valueOf(ChatColor.LIGHT_PURPLE) + " " + player.getName());
            }
        }
        this.describeParameters(sender);
    }

    protected void describeParameters(CommandSender sender) {
        Set keys = this.parameters.getKeys(false);
        if (keys.size() == 0) {
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + " (None)");
        }
        for (String key : keys) {
            Object value = null;
            if (this.parameters.isConfigurationSection(key)) {
                ConfigurationSection child = this.parameters.getConfigurationSection(key);
                value = "(" + child.getKeys(false).size() + " values)";
            } else {
                value = this.parameters.getString(key);
            }
            sender.sendMessage(String.valueOf(ChatColor.LIGHT_PURPLE) + " " + key + ": " + (String)value);
        }
    }

    @Override
    public void configure(CommandSender sender, String key, String value) {
        if (key == null) {
            return;
        }
        if (key.equalsIgnoreCase("spell") || key.equalsIgnoreCase("cast")) {
            this.spellKey = value;
            if (value == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Cleared spell");
            } else {
                sender.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "Set spell to: " + String.valueOf(ChatColor.LIGHT_PURPLE) + this.spellKey);
            }
        } else if (key.equalsIgnoreCase("parameters") || key.equalsIgnoreCase("parameter")) {
            if (value == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Cleared parameters");
                this.parameters = new YamlConfiguration();
            } else {
                String[] params = StringUtils.split((String)value, (char)' ');
                if (params.length == 1) {
                    this.parameters.set(params[0], null);
                    sender.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "Cleared " + String.valueOf(ChatColor.LIGHT_PURPLE) + params[0] + String.valueOf(ChatColor.DARK_PURPLE) + ", parameters now: ");
                    this.describeParameters(sender);
                } else {
                    ConfigurationUtils.addParameters(params, (ConfigurationSection)this.parameters);
                    sender.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "Set parameters to: ");
                    this.describeParameters(sender);
                }
            }
        } else if (key.equalsIgnoreCase("caster")) {
            if (value == null || !value.equalsIgnoreCase("true")) {
                sender.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "Set caster as player");
                this.npcCaster = false;
            } else {
                this.npcCaster = true;
                sender.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "Set caster as NPC");
            }
        } else if (key.equalsIgnoreCase("target_player")) {
            if (value == null || !value.equalsIgnoreCase("true")) {
                sender.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "Will not auto-target the clicking player");
                this.targetPlayer = false;
            } else {
                this.targetPlayer = true;
                sender.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "Will auto-target the clicking player");
            }
            if (!this.npcCaster) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "NOTE: " + String.valueOf(ChatColor.YELLOW) + "Has no effect unless you also set " + String.valueOf(ChatColor.AQUA) + "caster true");
            }
        } else if (key.equalsIgnoreCase("message_player")) {
            if (value == null || !value.equalsIgnoreCase("true")) {
                sender.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "Will not relay messages to the clicking player");
                this.messagePlayer = false;
            } else {
                this.messagePlayer = true;
                sender.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "Will relay messages to the clicking player");
            }
            if (!this.npcCaster) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "NOTE: " + String.valueOf(ChatColor.YELLOW) + "Has no effect unless you also set " + String.valueOf(ChatColor.AQUA) + "caster true");
            }
        } else if (key.equalsIgnoreCase("observers")) {
            if (value == null || value.equalsIgnoreCase("clear")) {
                sender.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "Cleared observers list");
                this.clearObservers();
            } else if (value != null && value.equalsIgnoreCase("none")) {
                sender.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "Set spell visibility to no one");
                this.observers = new ArrayList<UUID>();
            } else {
                String[] players;
                for (String playerName : players = StringUtils.split((String)value, (char)' ')) {
                    Player player = this.api.getPlugin().getServer().getPlayer(playerName);
                    if (player == null) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown or offline player: " + playerName);
                        continue;
                    }
                    this.addObserver(player);
                    sender.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "Added to observer list: " + player.getName());
                }
            }
        } else if ((value == null || value.isEmpty()) && !baseParameters.contains(key)) {
            this.spellKey = key;
            sender.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "Set spell to: " + String.valueOf(ChatColor.LIGHT_PURPLE) + this.spellKey);
        } else {
            super.configure(sender, key, value);
        }
    }

    public void setObservers(@Nonnull Collection<Player> players) {
        this.observers = new ArrayList<UUID>();
        for (Player player : players) {
            this.observers.add(player.getUniqueId());
        }
    }

    public void addObserver(@Nonnull Player player) {
        if (this.observers == null) {
            this.observers = new ArrayList<UUID>();
        }
        this.observers.add(player.getUniqueId());
    }

    public void clearObservers() {
        this.observers = null;
    }
}

