/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.economy.Currency;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class LedgerAction
extends BaseSpellAction {
    private Set<String> ignoreTypes;
    private Set<String> showTypes;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        List<String> showList;
        super.prepare(context, parameters);
        List<String> ignoreList = ConfigurationUtils.getStringList(parameters, "ignore_currencies");
        if (ignoreList != null) {
            this.ignoreTypes = new HashSet<String>(ignoreList);
        }
        if ((showList = ConfigurationUtils.getStringList(parameters, "show_currencies")) != null) {
            this.showTypes = new HashSet<String>(showList);
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        Wand wand = context.getWand();
        if (wand == null || wand.getItem().getType() != Material.WRITTEN_BOOK) {
            return SpellResult.NO_TARGET;
        }
        Mage mage = context.getMage();
        BookMeta book = (BookMeta)wand.getItem().getItemMeta();
        book.setTitle(context.getMessage("title"));
        book.setAuthor(context.getMage().getName());
        MageController controller = context.getController();
        Set<String> currencyKeys = controller.getCurrencyKeys();
        String header = context.getMessage("header");
        String currencyPrefix = context.getMessage("currency_prefix");
        String valuePrefix = context.getMessage("value_prefix");
        ArrayList<CallSite> pages = new ArrayList<CallSite>();
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        for (String key : currencyKeys) {
            Currency currency = controller.getCurrency(key);
            if (currency == null) continue;
            double amount = currency.getBalance(mage, wand);
            if (this.showTypes != null && !this.showTypes.contains(key) || !(amount > 0.0) || this.ignoreTypes != null && this.ignoreTypes.contains(key)) continue;
            if (lines.size() >= 12) {
                pages.add((CallSite)((Object)(header + "\n" + StringUtils.join(lines, (String)"\n"))));
                lines.clear();
            }
            lines.add((CallSite)((Object)(currencyPrefix + currency.getName(controller.getMessages()))));
            lines.add((CallSite)((Object)(valuePrefix + currency.formatAmount(amount, controller.getMessages()))));
        }
        if (!lines.isEmpty()) {
            pages.add((CallSite)((Object)(header + "\n" + StringUtils.join(lines, (String)"\n"))));
        }
        book.setPages(pages);
        wand.getItem().setItemMeta((ItemMeta)book);
        if (wand == mage.getActiveWand()) {
            mage.getPlayer().getInventory().setItemInMainHand(wand.getItem());
        } else if (wand == mage.getOffhandWand()) {
            mage.getPlayer().getInventory().setItemInOffHand(wand.getItem());
        }
        return SpellResult.CAST;
    }
}

