/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.CastingCost;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.TextUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandDisplayMode;
import com.elmakers.mine.bukkit.wand.WandInventory;
import org.bukkit.Color;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class GlyphHotbar {
    private final Wand wand;
    private boolean skipEmpty;
    private int hotbarSlotWidth;
    private int hotbarActiveSlotWidth;
    private int iconWidth;
    private int slotSpacingWidth;
    private int barWidth;
    private int barSteps;
    private int flashTime;
    private int collapsedWidth;
    private int collapsedFinalSpacing;
    private int collapsedMaxMessageLength;
    private WandDisplayMode barMode;
    private int barSlotPadding;
    private boolean showCooldown;
    private String barTemplate;
    private String hotbarPrefix;
    protected String extraMessage;
    protected long lastExtraMessage;
    protected int extraMessageDelay;
    protected int extraAnimationTime;
    protected long lastInsufficientResource;
    protected long lastInsufficientCharges;
    protected long lastCooldown;
    protected Spell lastCooldownSpell;

    public GlyphHotbar(Wand wand) {
        this.wand = wand;
    }

    public void load(ConfigurationSection configuration) {
        if (configuration == null) {
            configuration = ConfigurationUtils.newConfigurationSection();
        }
        this.skipEmpty = configuration.getBoolean("skip_empty", true);
        this.hotbarSlotWidth = configuration.getInt("slot_width", 22);
        this.hotbarActiveSlotWidth = configuration.getInt("active_slot_width", 22);
        this.iconWidth = configuration.getInt("icon_width", 16);
        this.slotSpacingWidth = configuration.getInt("slot_spacing", -1);
        this.barWidth = configuration.getInt("bar_width", 128);
        this.barSteps = configuration.getInt("bar_steps", 32);
        this.barSlotPadding = configuration.getInt("bar_slot_padding", 1);
        this.flashTime = configuration.getInt("flash_duration", 300);
        this.extraMessageDelay = configuration.getInt("extra_display_time", 2000);
        this.extraAnimationTime = configuration.getInt("extra_animate_time", 500);
        this.collapsedWidth = configuration.getInt("collapsed_slot_width", 6);
        this.collapsedFinalSpacing = configuration.getInt("collapsed_spacing", 12);
        this.showCooldown = configuration.getBoolean("show_cooldown", true);
        this.collapsedMaxMessageLength = configuration.getInt("collapsed_message_max_length", 20);
        this.hotbarPrefix = configuration.getString("hotbar_prefix", "&f");
        this.barTemplate = configuration.getString("bar_template", "`{\"text\": \"$glyph\", \"color\":\"#$color\"}`");
        this.barMode = WandDisplayMode.parse(this.wand.getController(), configuration, "bar_mode", WandDisplayMode.MANA);
    }

    public String getGlyphs() {
        boolean hasExtraMessage;
        MageController controller = this.wand.getController();
        Messages messages = controller.getMessages();
        WandInventory hotbar = this.wand.getActiveHotbar();
        Mage mage = this.wand.getMage();
        if (hotbar == null || mage == null) {
            return "";
        }
        int hotbarActivePaddingLeft = (this.hotbarActiveSlotWidth - this.hotbarSlotWidth) / 2;
        int iconPaddingLeft = (this.hotbarSlotWidth - this.iconWidth) / 2;
        int iconPaddingRight = this.hotbarSlotWidth - this.iconWidth - iconPaddingLeft;
        int collapseSpace = 0;
        int finalSpace = 0;
        long now = System.currentTimeMillis();
        boolean bl = hasExtraMessage = this.extraMessage != null && this.extraAnimationTime > 0;
        if (hasExtraMessage) {
            int useCollapsedWidth = this.collapsedWidth;
            int messageLength = this.extraMessage.length();
            if (messageLength < this.collapsedMaxMessageLength) {
                int widthDelta = this.hotbarSlotWidth - this.collapsedWidth;
                useCollapsedWidth = this.hotbarSlotWidth - (int)Math.ceil((double)widthDelta * (double)messageLength / (double)this.collapsedMaxMessageLength);
            }
            if (now < this.lastExtraMessage + (long)this.extraAnimationTime) {
                collapseSpace = (int)Math.ceil((long)(this.hotbarSlotWidth - useCollapsedWidth) * (now - this.lastExtraMessage) / (long)this.extraAnimationTime);
                finalSpace = (int)Math.ceil((long)this.collapsedFinalSpacing * (now - this.lastExtraMessage) / (long)this.extraAnimationTime);
            } else {
                collapseSpace = this.hotbarSlotWidth - useCollapsedWidth;
                finalSpace = this.collapsedFinalSpacing;
            }
        }
        String collapseReverse = messages.getSpace(-collapseSpace);
        String finalPadding = messages.getSpace(finalSpace);
        String iconReverse = messages.getSpace(-(this.iconWidth + 1));
        String hotbarSlotReverse = messages.getSpace(-(this.hotbarSlotWidth + 1));
        String hotbarIconPaddingLeft = messages.getSpace(iconPaddingLeft);
        String hotbarIconPaddingRight = messages.getSpace(iconPaddingRight);
        String hotbarActiveSlotStart = messages.getSpace(-hotbarActivePaddingLeft);
        String hotbarActiveSlotEnd = messages.getSpace(-(1 + this.hotbarActiveSlotWidth + hotbarActivePaddingLeft));
        String slotSpacing = messages.getSpace(this.slotSpacingWidth);
        Object glyphs = "";
        int hotbarSlots = 0;
        String hotbarSlot = messages.get("glyphs.hotbar.hotbar_slot");
        String hotbarSlotActive = messages.get("glyphs.hotbar.hotbar_slot_active");
        String emptyIcon = messages.get("glyphs.icons.empty");
        for (ItemStack hotbarItem : hotbar.items) {
            String icon;
            Spell spell = this.wand.getSpell(Wand.getSpell(hotbarItem));
            String spellKey = null;
            if (spell == null) {
                if (this.skipEmpty) continue;
                icon = emptyIcon;
            } else {
                icon = spell.getGlyph();
                spellKey = spell.getSpellKey().getBaseKey();
            }
            glyphs = (String)glyphs + hotbarSlot;
            glyphs = (String)glyphs + hotbarSlotReverse;
            String activeSpell = this.wand.getBaseActiveSpell();
            if (spellKey != null && activeSpell != null && spellKey.equals(activeSpell) && !hotbarSlotActive.isEmpty()) {
                glyphs = (String)glyphs + hotbarActiveSlotStart;
                glyphs = (String)glyphs + hotbarSlotActive;
                glyphs = (String)glyphs + hotbarActiveSlotEnd;
            }
            glyphs = (String)glyphs + hotbarIconPaddingLeft;
            glyphs = (String)glyphs + icon;
            if (this.showCooldown) {
                if (this.flashTime > 0 && now < this.lastCooldown + (long)this.flashTime && this.lastCooldownSpell != null && this.lastCooldownSpell.getSpellKey().equals(spell.getSpellKey())) {
                    String cooldownIcon = messages.get("glyphs.cooldown.wait", "");
                    if (!cooldownIcon.isEmpty()) {
                        glyphs = (String)glyphs + iconReverse;
                        glyphs = (String)glyphs + cooldownIcon;
                    }
                } else {
                    String cooldownIcon;
                    Long maxTimeToCast;
                    int cooldownLevel = 0;
                    Long timeToCast = spell != null && spell instanceof MageSpell ? ((MageSpell)spell).getTimeToCast() : null;
                    Long l = maxTimeToCast = spell != null && spell instanceof MageSpell ? Long.valueOf(((MageSpell)spell).getMaxTimeToCast()) : null;
                    if (timeToCast == null || maxTimeToCast == null) {
                        cooldownLevel = 16;
                    } else if (maxTimeToCast > 0L) {
                        cooldownLevel = (int)Math.ceil(16.0 * (double)timeToCast.longValue() / (double)maxTimeToCast.longValue());
                    }
                    if (cooldownLevel > 0 && !(cooldownIcon = messages.get("glyphs.cooldown." + cooldownLevel, "")).isEmpty()) {
                        glyphs = (String)glyphs + iconReverse;
                        glyphs = (String)glyphs + cooldownIcon;
                    }
                }
            }
            glyphs = (String)glyphs + hotbarIconPaddingRight;
            if (collapseSpace != 0) {
                glyphs = (String)glyphs + collapseReverse;
            }
            glyphs = (String)glyphs + slotSpacing;
            ++hotbarSlots;
        }
        if (this.barWidth > 0 && !hasExtraMessage && this.barMode != WandDisplayMode.NONE) {
            int hotbarWidth;
            String hotbarPart = this.hotbarPrefix + (String)glyphs;
            Object barPart = "";
            int barProgress = (int)Math.floor(this.barMode.getProgress(this.wand) * (double)this.barSteps);
            String barGlyph = messages.get("glyphs.bar." + barProgress);
            Color wandColor = this.wand.getEffectColor();
            if (wandColor == null) {
                wandColor = Color.WHITE;
            }
            barPart = (String)barPart + this.barTemplate.replace("$glyph", barGlyph).replace("$color", TextUtils.toHexString(wandColor.asRGB()));
            if (this.flashTime > 0 && (now < this.lastInsufficientResource + (long)this.flashTime || now < this.lastInsufficientCharges + (long)this.flashTime)) {
                barPart = (String)barPart + messages.getSpace(-(this.barWidth + 1));
                barPart = (String)barPart + messages.get("glyphs.bar.insufficient");
            }
            if (this.barWidth > (hotbarWidth = hotbarSlots * (this.hotbarSlotWidth + this.slotSpacingWidth + this.barSlotPadding))) {
                glyphs = barPart;
                int barPaddingLeft = (this.barWidth - hotbarWidth) / 2;
                glyphs = (String)glyphs + messages.getSpace(-(1 + this.barWidth - barPaddingLeft));
                glyphs = (String)glyphs + hotbarPart;
                int barPaddingRight = this.barWidth - hotbarWidth - barPaddingLeft;
                glyphs = (String)glyphs + messages.getSpace(barPaddingRight);
            } else {
                int barPaddingLeft = (hotbarWidth - this.barWidth) / 2;
                glyphs = (String)glyphs + messages.getSpace(-(1 + hotbarWidth - barPaddingLeft));
                glyphs = (String)glyphs + (String)barPart;
                int barPaddingRight = hotbarWidth - this.barWidth - barPaddingLeft;
                glyphs = (String)glyphs + messages.getSpace(barPaddingRight);
            }
        }
        if (finalSpace != 0) {
            glyphs = (String)glyphs + finalPadding;
        }
        return glyphs;
    }

    public String getExtraMessage() {
        long now;
        if (this.extraMessage != null && (now = System.currentTimeMillis()) < this.lastExtraMessage + (long)this.extraMessageDelay) {
            if (now < this.lastExtraMessage + (long)this.extraAnimationTime) {
                int length = (int)Math.floor((long)this.extraMessage.length() * (now - this.lastExtraMessage) / (long)this.extraAnimationTime);
                return this.extraMessage.substring(0, length);
            }
            return this.extraMessage;
        }
        this.extraMessage = null;
        return "";
    }

    public boolean handleActionBar(String message) {
        if (this.extraMessage == null) {
            this.lastExtraMessage = System.currentTimeMillis();
        }
        this.extraMessage = message;
        return true;
    }

    public boolean handleInsufficientResources(Spell spell, CastingCost cost) {
        this.lastInsufficientResource = System.currentTimeMillis();
        return true;
    }

    public boolean handleCooldown(Spell spell) {
        this.lastCooldown = System.currentTimeMillis();
        this.lastCooldownSpell = spell;
        return true;
    }

    public boolean handleInsufficientCharges(Spell spell) {
        this.lastInsufficientCharges = System.currentTimeMillis();
        return true;
    }

    public boolean isAnimating() {
        return this.extraMessage != null && System.currentTimeMillis() <= this.lastExtraMessage + (long)this.extraAnimationTime;
    }
}

