/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_21_0;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.utility.platform.EntityUtils;
import com.elmakers.mine.bukkit.utility.platform.InventoryUtils;
import com.elmakers.mine.bukkit.utility.platform.modern.ModernPlatform;
import com.elmakers.mine.bukkit.utility.platform.v1_21_0.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.platform.v1_21_0.ItemUtils;
import com.elmakers.mine.bukkit.utility.platform.v1_21_0.MobUtils;
import com.elmakers.mine.bukkit.utility.platform.v1_21_0.NBTUtils;
import com.elmakers.mine.bukkit.utility.platform.v1_21_0.SkinUtils;
import com.elmakers.mine.bukkit.utility.platform.v1_21_0.event.EntityLoadEventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.PluginManager;

public class Platform
extends ModernPlatform {
    private Boolean hasEntityLoadEvent;

    public Platform(MageController controller) {
        super(controller);
    }

    @Override
    protected com.elmakers.mine.bukkit.utility.platform.NBTUtils createNBTUtils() {
        return new NBTUtils(this);
    }

    @Override
    protected com.elmakers.mine.bukkit.utility.platform.ItemUtils createItemUtils() {
        return new ItemUtils(this);
    }

    @Override
    protected InventoryUtils createInventoryUtils() {
        return new com.elmakers.mine.bukkit.utility.platform.v1_21_0.InventoryUtils(this);
    }

    @Override
    protected com.elmakers.mine.bukkit.utility.platform.CompatibilityUtils createCompatibilityUtils() {
        return new CompatibilityUtils(this);
    }

    @Override
    protected EntityUtils createEntityUtils() {
        return new com.elmakers.mine.bukkit.utility.platform.v1_21_0.EntityUtils(this);
    }

    @Override
    protected com.elmakers.mine.bukkit.utility.platform.MobUtils createMobUtils() {
        return new MobUtils(this);
    }

    @Override
    public boolean hasEntityLoadEvent() {
        if (this.hasEntityLoadEvent == null) {
            try {
                Class.forName("org.bukkit.event.world.EntitiesLoadEvent");
                this.hasEntityLoadEvent = true;
            }
            catch (Exception ex) {
                this.hasEntityLoadEvent = false;
                this.getLogger().warning("EntitiesLoadEvent not found, it is recommended that you update your server software");
            }
        }
        return this.hasEntityLoadEvent;
    }

    @Override
    protected com.elmakers.mine.bukkit.utility.platform.SkinUtils createSkinUtils() {
        return new SkinUtils(this);
    }

    @Override
    public boolean hasDeferredEntityLoad() {
        return true;
    }

    @Override
    public void registerEvents(PluginManager pm) {
        super.registerEvents(pm);
        if (this.hasEntityLoadEvent()) {
            pm.registerEvents((Listener)new EntityLoadEventHandler(this.controller), this.controller.getPlugin());
        }
    }
}

