/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_19_3.goal;

import com.elmakers.mine.bukkit.magic.MagicMetaKeys;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import java.util.UUID;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import org.bukkit.GameMode;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class MagicTamed {
    protected final Platform platform;
    protected final EntityInsentient mob;
    protected EntityLiving owner;

    public MagicTamed(Platform platform, EntityInsentient tamed) {
        this.platform = platform;
        this.mob = tamed;
    }

    protected void checkOwner() {
        CraftEntity bukkitEntity;
        UUID ownerUUID;
        if (this.owner == null && (ownerUUID = this.platform.getCompatibilityUtils().getOwnerId((Entity)this.mob.getBukkitEntity())) != null && (bukkitEntity = (CraftEntity)this.platform.getCompatibilityUtils().getEntity(ownerUUID)) != null && bukkitEntity.getHandle() instanceof EntityLiving) {
            this.owner = (EntityLiving)bukkitEntity.getHandle();
        }
    }

    public void setOwner(EntityLiving owner) {
        this.owner = owner;
        this.platform.getCompatibilityUtils().setOwner((Entity)this.mob.getBukkitEntity(), (Entity)(owner == null ? null : owner.getBukkitEntity()));
    }

    public boolean isStay() {
        return this.platform.getEnityMetadataUtils().getBoolean((Entity)this.mob.getBukkitEntity(), MagicMetaKeys.STAY);
    }

    public boolean canUse() {
        this.checkOwner();
        if (this.owner == null || this.owner instanceof Player && ((Player)this.owner).getGameMode() == GameMode.SPECTATOR) {
            return false;
        }
        return !this.isStay();
    }

    public void stop() {
        this.owner = null;
    }

    public EntityLiving getOwner() {
        return this.owner;
    }
}

