/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import com.elmakers.mine.bukkit.api.protection.PVPManager;
import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MVWorldManager;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MultiverseManager
implements PVPManager {
    private boolean enabled = false;
    private MultiverseCore mv = null;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled && this.mv != null;
    }

    public void initialize(Plugin plugin) {
        if (this.enabled) {
            try {
                Plugin mvPlugin = plugin.getServer().getPluginManager().getPlugin("Multiverse-Core");
                if (mvPlugin instanceof MultiverseCore) {
                    this.mv = (MultiverseCore)mvPlugin;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.mv != null) {
                plugin.getLogger().info("Multiverse-Core found, will respect PVP settings");
            }
        } else {
            this.mv = null;
        }
    }

    @Override
    public boolean isPVPAllowed(Player player, Location location) {
        if (!this.enabled || this.mv == null || location == null) {
            return true;
        }
        World world = location.getWorld();
        if (world == null) {
            return true;
        }
        MVWorldManager manager = this.mv.getMVWorldManager();
        if (manager == null) {
            return true;
        }
        MultiverseWorld mvWorld = manager.getMVWorld(world);
        if (mvWorld == null) {
            return true;
        }
        return mvWorld.isPVPEnabled();
    }
}

