/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.WandTemplate;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.magic.BaseMagicProperties;
import com.elmakers.mine.bukkit.magic.command.MagicConfigurableExecutor;
import com.elmakers.mine.bukkit.magic.command.WandPaginator;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class WandCommandExecutor
extends MagicConfigurableExecutor {
    public static boolean CONSOLE_BYPASS_MODIFIABLE = true;
    private final WandPaginator wandPaginator;

    public WandCommandExecutor(MagicAPI api) {
        super(api, new String[]{"wand", "wandp"});
        this.wandPaginator = new WandPaginator(api.getController());
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        String commandName = command.getName();
        if (commandName.equalsIgnoreCase("wandp")) {
            if (args.length == 0) {
                sender.sendMessage("Usage: /wandp [player] [wand name/command]");
                return true;
            }
            String[] args2 = Arrays.copyOfRange(args, 1, args.length);
            String playerName = args[0];
            List<Entity> targets = CompatibilityLib.getCompatibilityUtils().selectEntities(sender, playerName);
            if (targets != null) {
                for (Entity target : targets) {
                    if (!(target instanceof Player)) continue;
                    this.processWandCommand("wandp", sender, (Player)target, args2);
                }
                return true;
            }
            Player player = CompatibilityLib.getDeprecatedUtils().getPlayer(playerName);
            if (player == null) {
                sender.sendMessage("Can't find player " + playerName);
                return true;
            }
            if (!player.isOnline()) {
                sender.sendMessage("Player " + playerName + " is not online");
                return true;
            }
            return this.processWandCommand("wandp", sender, player, args2);
        }
        if (commandName.equalsIgnoreCase("wand") && args.length > 0 && args[0].equalsIgnoreCase("list")) {
            if (!this.api.hasPermission(sender, "magic.commands.wand.list")) {
                this.sendNoPermission(sender);
                return true;
            }
            String[] args2 = Arrays.copyOfRange(args, 1, args.length);
            this.onWandList(sender, args2);
            return true;
        }
        if (commandName.equalsIgnoreCase("wand") && args.length > 0 && args[0].equalsIgnoreCase("delete")) {
            if (!this.api.hasPermission(sender, "magic.commands.wand.delete")) {
                this.sendNoPermission(sender);
                return true;
            }
            if (args.length < 2) {
                sender.sendMessage("Usage: /wand delete <wandkey>");
                return true;
            }
            this.onWandDelete(sender, args[1]);
            return true;
        }
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (commandName.equalsIgnoreCase("wand")) {
            return this.processWandCommand("wand", sender, player, args);
        }
        return false;
    }

    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        SpellTemplate spell;
        String subCommand;
        ArrayList<String> options = new ArrayList<String>();
        Player player = sender instanceof Player ? (Player)sender : null;
        String permissionKey = "wand";
        if (commandName.contains("wandp")) {
            permissionKey = "wandp";
            if (args.length > 0) {
                player = CompatibilityLib.getDeprecatedUtils().getPlayer(args[0]);
            }
            if (args.length == 1) {
                options.addAll(this.api.getPlayerNames());
                return options;
            }
            if (args.length > 1) {
                args = Arrays.copyOfRange(args, 1, args.length);
            }
        }
        if (args.length == 1) {
            this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".", "add");
            this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".", "remove");
            this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".", "name");
            this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".", "fill");
            this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".", "configure");
            this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".", "override");
            this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".", "organize");
            this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".", "alphabetize");
            this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".", "combine");
            this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".", "upgrade");
            this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".", "describe");
            this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".", "desc");
            this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".", "enchant");
            this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".", "create");
            this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".", "destroy");
            this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".", "duplicate");
            this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".", "restore");
            this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".", "unlock");
            this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".", "bind");
            this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".", "unbind");
            this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".", "save");
            this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".", "delete");
            this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".", "levelspells");
            Collection<String> allWands = this.api.getWandKeys();
            for (String wandKey : allWands) {
                this.addIfPermissible(sender, options, "magic.create.", wandKey);
            }
        }
        if (args.length == 2) {
            File wandFolder;
            Object mage;
            com.elmakers.mine.bukkit.api.wand.Wand activeWand;
            Collection<SpellTemplate> spellList;
            subCommand = args[0];
            String subCommandPNode = "magic.commands." + permissionKey + "." + subCommand;
            if (!this.api.hasPermission(sender, subCommandPNode)) {
                return options;
            }
            subCommandPNode = subCommandPNode + ".";
            if (subCommand.equalsIgnoreCase("add")) {
                spellList = this.api.getSpellTemplates(sender.hasPermission("magic.bypass_hidden"));
                for (SpellTemplate spellTemplate : spellList) {
                    this.addIfPermissible(sender, options, subCommandPNode, spellTemplate.getKey());
                }
                this.addIfPermissible(sender, options, subCommandPNode, "brush");
            }
            if (subCommand.equalsIgnoreCase("configure") || subCommand.equalsIgnoreCase("describe") || subCommand.equalsIgnoreCase("desc") || subCommand.equalsIgnoreCase("upgrade")) {
                Wand.addParameterKeys(this.api.getController(), options);
            }
            if (subCommand.equalsIgnoreCase("override")) {
                spellList = this.api.getController().getSpellTemplates(true);
                String partial = args[1];
                if (partial.indexOf(46) > 0) {
                    String[] stringArray = StringUtils.split((String)partial, (char)'.');
                    String spellKey = stringArray[0];
                    spell = this.api.getController().getSpellTemplate(spellKey);
                    if (spell != null) {
                        ArrayList<String> spellOptions = new ArrayList<String>();
                        spell.getParameters(spellOptions);
                        for (String option : spellOptions) {
                            options.add(spellKey + "." + option);
                        }
                    }
                } else {
                    for (SpellTemplate spell3 : spellList) {
                        String spellKey = spell3.getKey();
                        if (!this.api.hasPermission(sender, subCommandPNode + spellKey)) continue;
                        options.add(spellKey + ".");
                    }
                }
            }
            if (subCommand.equalsIgnoreCase("remove")) {
                activeWand = null;
                if (player != null) {
                    mage = this.controller.getMage(player);
                    activeWand = mage.getActiveWand();
                }
                if (activeWand != null) {
                    Collection<String> spellNames = activeWand.getSpells();
                    for (String spellName : spellNames) {
                        options.add(spellName);
                    }
                    options.add("brush");
                }
            }
            if (subCommand.equalsIgnoreCase("remove") && args.length > 0 && args[0].equalsIgnoreCase("brush") && player != null) {
                activeWand = null;
                mage = this.controller.getMage(player);
                activeWand = mage.getActiveWand();
                if (activeWand != null) {
                    options.addAll(activeWand.getSpells());
                }
            }
            if (subCommand.equalsIgnoreCase("combine")) {
                Collection<String> allWands = this.api.getWandKeys();
                for (String string : allWands) {
                    this.addIfPermissible(sender, options, "magic.commands." + permissionKey + ".combine.", string);
                }
            }
            if (subCommand.equalsIgnoreCase("delete") && (wandFolder = new File(this.api.getController().getConfigFolder(), "wands")).exists()) {
                File[] files;
                for (File file : files = wandFolder.listFiles()) {
                    if (!file.getName().endsWith(".yml")) continue;
                    options.add(file.getName().replace(".yml", ""));
                }
            }
        }
        if (args.length == 3) {
            boolean bl;
            String subCommandPNode;
            String[] pieces;
            subCommand = args[0];
            String subCommand2 = args[1];
            String commandPNode = "magic.commands." + permissionKey + "." + subCommand;
            if (!this.api.hasPermission(sender, commandPNode)) {
                return options;
            }
            if (subCommand.equalsIgnoreCase("override") && (pieces = StringUtils.split((String)subCommand2, (char)'.')).length > 1) {
                String string = pieces[0];
                String argument = pieces[1];
                spell = this.api.getSpellTemplate(string);
                if (spell != null) {
                    spell.getParameterOptions(options, argument);
                }
            }
            if (subCommand.equalsIgnoreCase("configure") || subCommand.equalsIgnoreCase("upgrade")) {
                Wand.addParameterValues(this.api.getController(), subCommand2, options);
            }
            if (!this.api.hasPermission(sender, subCommandPNode = "magic.commands." + permissionKey + "." + subCommand + "." + subCommand2)) {
                return options;
            }
            boolean bl2 = bl = subCommand2.equalsIgnoreCase("material") || subCommand2.equalsIgnoreCase("brush");
            if (subCommand.equalsIgnoreCase("remove") && bl) {
                com.elmakers.mine.bukkit.api.wand.Wand activeWand = null;
                if (player != null) {
                    Mage mage = this.controller.getMage(player);
                    activeWand = mage.getActiveWand();
                }
                if (activeWand != null) {
                    Collection<String> materialNames = activeWand.getBrushes();
                    for (String materialName : materialNames) {
                        options.add(materialName);
                    }
                }
            }
            if (subCommand.equalsIgnoreCase("add") && bl) {
                options.addAll(this.api.getBrushes());
            }
        }
        return options;
    }

    protected boolean processWandCommand(String command, CommandSender sender, Player player, String[] args) {
        String subCommand = "";
        String[] args2 = args;
        if (args.length > 0) {
            subCommand = args[0];
            args2 = new String[args.length - 1];
            for (int i = 1; i < args.length; ++i) {
                args2[i - 1] = args[i];
            }
        }
        if (subCommand.equalsIgnoreCase("list")) {
            if (!this.api.hasPermission(sender, "magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandList(sender, args2);
            return true;
        }
        if (subCommand.equalsIgnoreCase("add")) {
            if (!this.api.hasPermission(sender, "magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandAdd(sender, player, args2);
            return true;
        }
        if (subCommand.equalsIgnoreCase("configure")) {
            if (!this.api.hasPermission(sender, "magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandConfigure(sender, player, args2, false);
            return true;
        }
        if (subCommand.equalsIgnoreCase("override")) {
            if (!this.api.hasPermission(sender, "magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandOverride(sender, player, args2);
            return true;
        }
        if (subCommand.equalsIgnoreCase("enchant")) {
            if (!this.api.hasPermission(sender, "magic.commands." + command + "." + subCommand)) {
                return true;
            }
            String levels = args2.length > 0 ? args2[0] : "1";
            this.onWandEnchant(sender, player, levels);
            return true;
        }
        if (subCommand.equalsIgnoreCase("create")) {
            if (!this.api.hasPermission(sender, "magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandCreate(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("destroy")) {
            if (!this.api.hasPermission(sender, "magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandDestroy(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("bind")) {
            if (!this.api.hasPermission(sender, "magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandBind(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("unbind")) {
            if (!this.api.hasPermission(sender, "magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandUnbind(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("duplicate")) {
            if (!this.api.hasPermission(sender, "magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandDuplicate(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("save")) {
            if (!this.api.hasPermission(sender, "magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandSave(sender, player, args2);
            return true;
        }
        if (subCommand.equalsIgnoreCase("restore")) {
            if (!this.api.hasPermission(sender, "magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandRestore(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("unlock")) {
            if (!this.api.hasPermission(sender, "magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandUnlock(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("organize")) {
            if (!this.api.hasPermission(sender, "magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandOrganize(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("alphabetize")) {
            if (!this.api.hasPermission(sender, "magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandAlphabetize(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("combine")) {
            if (!this.api.hasPermission(sender, "magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandCombine(sender, player, args2);
            return true;
        }
        if (subCommand.equalsIgnoreCase("describe") || subCommand.equalsIgnoreCase("desc")) {
            if (!this.api.hasPermission(sender, "magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandDescribe(sender, player, args2);
            return true;
        }
        if (subCommand.equalsIgnoreCase("upgrade")) {
            if (!this.api.hasPermission(sender, "magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandConfigure(sender, player, args2, true);
            return true;
        }
        if (subCommand.equalsIgnoreCase("organize")) {
            if (!this.api.hasPermission(sender, "magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandOrganize(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("levelspells")) {
            if (!this.api.hasPermission(sender, "magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandLevelSpells(sender, player, args2);
            return true;
        }
        if (subCommand.equalsIgnoreCase("fill")) {
            if (!this.api.hasPermission(sender, "magic.commands." + command + "." + subCommand)) {
                return true;
            }
            int maxLevel = this.api.getController().getMaxWandFillLevel();
            if (args2.length > 0) {
                if (args2[0].equalsIgnoreCase("max")) {
                    maxLevel = 0;
                } else {
                    try {
                        maxLevel = Integer.parseInt(args2[0]);
                    }
                    catch (Exception ex) {
                        sender.sendMessage("Invalid level: " + args2[0]);
                        return true;
                    }
                }
            }
            this.onWandFill(sender, player, maxLevel);
            return true;
        }
        if (subCommand.equalsIgnoreCase("remove")) {
            if (!this.api.hasPermission(sender, "magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandRemove(sender, player, args2);
            return true;
        }
        if (subCommand.equalsIgnoreCase("name")) {
            if (!this.api.hasPermission(sender, "magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandName(sender, player, args2);
            return true;
        }
        if (!this.api.hasPermission(sender, "magic.commands." + command)) {
            return true;
        }
        if (subCommand.length() == 0) {
            if (!(this.api.hasPermission(sender, "magic.create.default") || this.api.hasPermission(sender, "magic.create." + this.api.getController().getDefaultWandTemplate()) || this.api.hasPermission(sender, "magic.create.*"))) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to create the default wand");
                return true;
            }
        } else if (!this.api.hasPermission(sender, "magic.create." + subCommand) && !this.api.hasPermission(sender, "magic.create.*")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to create the wand \"" + subCommand + "\"");
            return true;
        }
        return this.onWand(sender, player, args);
    }

    public boolean onWandList(CommandSender sender, String[] args) {
        this.wandPaginator.list(sender, args);
        return true;
    }

    public boolean onWandDescribe(CommandSender sender, Player player, String[] parameters) {
        ItemStack itemInHand;
        Mage mage = this.controller.getMage(player);
        com.elmakers.mine.bukkit.api.wand.Wand activeWand = mage.getActiveWand();
        if (activeWand != null) {
            activeWand.saveState();
        }
        if ((itemInHand = player.getInventory().getItemInMainHand()) == null) {
            if (sender != player) {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.player_no_item", "$name", player.getName()));
            } else {
                player.sendMessage(this.api.getMessages().get("wand.no_item"));
            }
            return true;
        }
        if (this.api.isSpell(itemInHand)) {
            String spellKey = this.api.getSpell(itemInHand);
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Spell: " + spellKey);
            SpellTemplate spell = this.api.getSpellTemplate(spellKey);
            if (spell != null) {
                sender.sendMessage(" " + String.valueOf(ChatColor.GOLD) + spell.getName());
            } else {
                sender.sendMessage(String.valueOf(ChatColor.RED) + " (Unknown Spell)");
            }
        } else if (this.api.isBrush(itemInHand)) {
            String brushKey = this.api.getBrush(itemInHand);
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Brush: " + brushKey);
            MaterialAndData brush = new MaterialAndData(brushKey);
            sender.sendMessage(" " + String.valueOf(ChatColor.GRAY) + brush.getName(this.controller.getMessages()));
        } else if (this.api.isWand(itemInHand) || this.api.isUpgrade(itemInHand)) {
            com.elmakers.mine.bukkit.api.wand.Wand wand = this.api.getWand(itemInHand);
            if (parameters.length == 0) {
                sender.sendMessage(String.valueOf(ChatColor.BLUE) + "Use " + String.valueOf(ChatColor.AQUA) + "/wand describe <property>" + String.valueOf(ChatColor.BLUE) + " for specific properties");
                wand.describe(sender, (Set<String>)BaseMagicProperties.HIDDEN_PROPERTY_KEYS);
            } else {
                Object property = wand.getProperty(parameters[0]);
                if (property == null) {
                    sender.sendMessage(String.valueOf(ChatColor.DARK_AQUA) + parameters[0] + String.valueOf(ChatColor.GRAY) + ": " + String.valueOf(ChatColor.RED) + "(Not Set)");
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.DARK_AQUA) + parameters[0] + String.valueOf(ChatColor.GRAY) + ": " + String.valueOf(ChatColor.WHITE) + CompatibilityLib.getInventoryUtils().describeProperty(property));
                }
            }
        } else {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "That is not a magic item");
        }
        return true;
    }

    public boolean onWandOrganize(CommandSender sender, Player player) {
        com.elmakers.mine.bukkit.api.wand.Wand wand = this.checkWand(sender, player, true);
        if (wand == null) {
            return true;
        }
        Mage mage = this.controller.getMage(player);
        wand.organizeInventory(mage);
        wand.saveState();
        mage.sendMessage(this.api.getMessages().get("wand.reorganized").replace("$wand", wand.getName()));
        if (sender != player) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.player_reorganized", "$name", player.getName()).replace("$wand", wand.getName()));
        }
        return true;
    }

    public boolean onWandAlphabetize(CommandSender sender, Player player) {
        com.elmakers.mine.bukkit.api.wand.Wand wand = this.checkWand(sender, player, true);
        if (wand == null) {
            return true;
        }
        Mage mage = this.controller.getMage(player);
        wand.alphabetizeInventory();
        wand.saveState();
        mage.sendMessage(this.api.getMessages().get("wand.alphabetized").replace("$wand", wand.getName()));
        if (sender != player) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.player_alphabetized", "$name", player.getName()).replace("$wand", wand.getName()));
        }
        return true;
    }

    public boolean onWandEnchant(CommandSender sender, Player player, String levelString) {
        com.elmakers.mine.bukkit.api.wand.Wand wand = this.checkWand(sender, player);
        if (wand == null) {
            return false;
        }
        Mage mage = this.controller.getMage(player);
        int xpLevels = 0;
        boolean useXp = levelString.equalsIgnoreCase("xp");
        if (useXp) {
            xpLevels = mage.getLevel();
        } else {
            try {
                xpLevels = Integer.parseInt(levelString);
            }
            catch (Exception ex) {
                sender.sendMessage("Invalid parameter: " + levelString);
            }
        }
        int levels = wand.enchant(xpLevels);
        if (levels > 0 && useXp) {
            mage.setLevel(Math.max(0, mage.getLevel() - levels));
        }
        wand.saveState();
        if (sender != player) {
            if (levels > 0) {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.player_upgraded", "$name", player.getName()));
            } else {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.player_not_upgraded", "$name", player.getName()));
            }
        }
        return true;
    }

    public boolean onWandCreate(CommandSender sender, Player player) {
        Mage mage = this.controller.getMage(player);
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        if (heldItem == null || heldItem.getType() == Material.AIR) {
            mage.sendMessage(this.api.getMessages().get("wand.no_item"));
            if (sender != player) {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.player_no_item", "$name", player.getName()));
            }
            return false;
        }
        if (this.api.isWand(heldItem) || this.api.isSpell(heldItem) || this.api.isBrush(heldItem)) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.already_enchanted", "$item", MaterialAndData.getMaterialName(heldItem, this.controller.getMessages())));
            return false;
        }
        com.elmakers.mine.bukkit.api.wand.Wand wand = this.api.createWand(heldItem);
        player.getInventory().setItemInMainHand(wand.getItem());
        mage.checkWand();
        mage.sendMessage(this.api.getMessages().getParameterized("wand.enchanted", "$item", MaterialAndData.getMaterialName(heldItem, this.controller.getMessages())));
        if (sender != player) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.player_enchanted", "$item", MaterialAndData.getMaterialName(heldItem, this.controller.getMessages()), "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandBind(CommandSender sender, Player player) {
        com.elmakers.mine.bukkit.api.wand.Wand wand = this.checkWand(sender, player);
        if (wand == null) {
            return true;
        }
        Mage mage = this.controller.getMage(player);
        wand.bind();
        mage.sendMessage(this.api.getMessages().get("wand.setbound"));
        if (sender != player) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.player_setbound", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandUnbind(CommandSender sender, Player player) {
        com.elmakers.mine.bukkit.api.wand.Wand wand = this.checkWand(sender, player);
        if (wand == null) {
            return true;
        }
        Mage mage = this.controller.getMage(player);
        wand.unbind();
        mage.sendMessage(this.api.getMessages().get("wand.unbound"));
        if (sender != player) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.player_unbound", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandDestroy(CommandSender sender, Player player) {
        com.elmakers.mine.bukkit.api.wand.Wand wand = this.checkWand(sender, player);
        if (wand == null) {
            return true;
        }
        Mage mage = this.controller.getMage(player);
        wand.deactivate();
        wand.unenchant();
        player.getInventory().setItemInMainHand(wand.getItem());
        mage.sendMessage(this.api.getMessages().get("wand.unenchanted"));
        if (sender != player) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.player_unenchanted", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandDuplicate(CommandSender sender, Player player) {
        com.elmakers.mine.bukkit.api.wand.Wand wand = this.checkWand(sender, player, false, false);
        if (wand == null) {
            return true;
        }
        Mage mage = this.controller.getMage(player);
        com.elmakers.mine.bukkit.api.wand.Wand newWand = wand.duplicate();
        this.api.giveItemToPlayer(player, newWand.getItem());
        mage.sendMessage(this.api.getMessages().get("wand.duplicated"));
        if (sender != player) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.player_duplicated", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandRestore(CommandSender sender, Player player) {
        Mage mage = this.controller.getMage(player);
        if (mage.restoreWand()) {
            mage.sendMessage(this.api.getMessages().get("wand.restored"));
            if (sender != player) {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.player_restored", "$name", player.getName()));
            }
        } else {
            mage.sendMessage(this.api.getMessages().get("wand.not_restored"));
            if (sender != player) {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.player_not_restored", "$name", player.getName()));
            }
        }
        return true;
    }

    public boolean onWandUnlock(CommandSender sender, Player player) {
        com.elmakers.mine.bukkit.api.wand.Wand wand = this.checkWand(sender, player, true, true, false);
        if (wand == null) {
            return true;
        }
        Mage mage = this.controller.getMage(player);
        wand.makeModifiable();
        wand.saveState();
        mage.sendMessage(this.api.getMessages().get("wand.unlocked"));
        if (sender != player) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.player_unlocked", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandOverride(CommandSender sender, Player player, String[] parameters) {
        com.elmakers.mine.bukkit.api.wand.Wand wand = this.checkWand(sender, player, true, true, false);
        if (wand == null) {
            return true;
        }
        if (parameters.length == 0) {
            Map<String, String> overrides = wand.getOverrides();
            if (overrides.size() == 0) {
                sender.sendMessage(String.valueOf(ChatColor.DARK_AQUA) + "This wand has no overrides");
            } else {
                for (Map.Entry<String, String> override : overrides.entrySet()) {
                    sender.sendMessage(String.valueOf(ChatColor.AQUA) + override.getKey() + String.valueOf(ChatColor.WHITE) + " = " + String.valueOf(ChatColor.DARK_AQUA) + override.getValue());
                }
            }
            return true;
        }
        wand = this.checkWand(sender, player);
        if (wand == null) {
            return true;
        }
        if (parameters.length == 1) {
            wand.removeOverride(parameters[0]);
            wand.saveState();
            sender.sendMessage(String.valueOf(ChatColor.DARK_AQUA) + "Removed override " + parameters[0]);
            return true;
        }
        Object value = "";
        for (int i = 1; i < parameters.length; ++i) {
            if (i != 1) {
                value = (String)value + " ";
            }
            value = (String)value + parameters[i];
        }
        wand.setOverride(parameters[0], (String)value);
        wand.saveState();
        sender.sendMessage(String.valueOf(ChatColor.DARK_AQUA) + "Added override " + String.valueOf(ChatColor.AQUA) + parameters[0] + String.valueOf(ChatColor.WHITE) + " = " + String.valueOf(ChatColor.DARK_AQUA) + (String)value);
        return true;
    }

    public boolean onWandConfigure(CommandSender sender, Player player, String[] parameters, boolean safe) {
        com.elmakers.mine.bukkit.api.wand.Wand wand = this.checkWand(sender, player);
        if (wand == null) {
            return true;
        }
        wand.closeInventory();
        wand.saveState();
        boolean result = this.onConfigure("wand", wand, sender, player, parameters, safe);
        Mage mage = this.controller.getMage(player);
        wand.deactivate();
        mage.checkWand();
        return result;
    }

    @Nullable
    protected com.elmakers.mine.bukkit.api.wand.Wand checkWand(CommandSender sender, Player player) {
        return this.checkWand(sender, player, false, false);
    }

    @Nullable
    protected com.elmakers.mine.bukkit.api.wand.Wand checkWand(CommandSender sender, Player player, boolean skipModifiable) {
        return this.checkWand(sender, player, skipModifiable, false);
    }

    @Nullable
    protected com.elmakers.mine.bukkit.api.wand.Wand checkWand(CommandSender sender, Player player, boolean skipModifiable, boolean skipBound) {
        return this.checkWand(sender, player, skipModifiable, skipBound, false);
    }

    @Nullable
    protected com.elmakers.mine.bukkit.api.wand.Wand checkWand(CommandSender sender, Player player, boolean skipModifiable, boolean skipBound, boolean quiet) {
        Mage mage = this.controller.getMage(player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        boolean bypassModifiable = sender instanceof Player ? this.api.hasPermission(sender, "magic.wand.override_modifiable") : CONSOLE_BYPASS_MODIFIABLE;
        if (wand == null) {
            ItemStack item = player.getInventory().getItemInMainHand();
            if (this.api.isUpgrade(item)) {
                wand = this.api.getWand(item);
            } else if (bypassModifiable && this.api.isWand(item)) {
                wand = this.api.getWand(item);
            }
        }
        if (wand == null) {
            if (!quiet) {
                mage.sendMessage(this.api.getMessages().get("wand.no_wand"));
            }
            if (sender != player) {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.player_no_wand", "$name", player.getName()));
            }
            return null;
        }
        if (!(skipModifiable || wand.isModifiable() || bypassModifiable)) {
            if (!quiet) {
                mage.sendMessage(this.api.getMessages().get("wand.unmodifiable"));
            }
            if (sender != player) {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.player_unmodifiable", "$name", player.getName()));
            }
            return null;
        }
        if (!skipBound && !wand.canUse(mage.getPlayer())) {
            if (!quiet) {
                mage.sendMessage(this.api.getMessages().get("wand.bound_to_other"));
            }
            if (sender != player) {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.player_unmodifiable", "$name", player.getName()));
            }
            return null;
        }
        return wand;
    }

    public boolean onWandCombine(CommandSender sender, Player player, String[] parameters) {
        if (parameters.length < 1) {
            sender.sendMessage("Use: /wand combine <wandname>");
            return false;
        }
        com.elmakers.mine.bukkit.api.wand.Wand wand = this.checkWand(sender, player);
        if (wand == null) {
            return true;
        }
        Mage mage = this.controller.getMage(player);
        String wandName = parameters[0];
        com.elmakers.mine.bukkit.api.wand.Wand newWand = this.api.createWand(wandName);
        if (newWand == null) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.unknown_template", "$name", wandName));
            return false;
        }
        wand.deactivate();
        boolean result = wand.add(newWand);
        mage.checkWand();
        if (sender != player) {
            if (result) {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.player_upgraded", "$name", player.getName()));
            } else {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.player_not_upgraded", "$name", player.getName()));
            }
        }
        return true;
    }

    public boolean onWandFill(CommandSender sender, Player player, int maxLevel) {
        com.elmakers.mine.bukkit.api.wand.Wand wand = this.checkWand(sender, player);
        if (wand == null) {
            return true;
        }
        Mage mage = this.controller.getMage(player);
        wand.fill(player, maxLevel);
        mage.sendMessage(this.api.getMessages().get("wand.filled").replace("$wand", wand.getName()));
        if (sender != player) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.player_filled", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandDelete(CommandSender sender, String wandKey) {
        Player player;
        MageController controller = this.api.getController();
        WandTemplate existing = controller.getWandTemplate(wandKey);
        if (existing == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown wand: " + wandKey);
            return true;
        }
        boolean hasPermission = true;
        if (sender instanceof Player && !(player = (Player)sender).hasPermission("magic.wand.overwrite")) {
            String creatorId;
            hasPermission = player.hasPermission("magic.wand.overwrite_own") ? (creatorId = existing.getCreatorId()) != null && creatorId.equalsIgnoreCase(player.getUniqueId().toString()) : false;
        }
        if (!hasPermission) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to delete " + wandKey);
            return true;
        }
        File wandFolder = new File(controller.getConfigFolder(), "wands");
        File wandFile = new File(wandFolder, wandKey + ".yml");
        if (!wandFile.exists()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "File doesn't exist: " + wandFile.getName());
            return true;
        }
        wandFile.delete();
        controller.unloadWandTemplate(wandKey);
        sender.sendMessage("Deleted wand " + wandKey);
        return true;
    }

    public boolean onWandSave(CommandSender sender, Player player, String[] parameters) {
        WandTemplate inheritConfiguration;
        String template;
        if (parameters.length < 1) {
            sender.sendMessage("Use: /wand save <filename>");
            return true;
        }
        com.elmakers.mine.bukkit.api.wand.Wand wand = this.checkWand(sender, player);
        if (wand == null) {
            return true;
        }
        MageController controller = this.api.getController();
        WandTemplate existing = controller.getWandTemplate(template = parameters[0]);
        if (existing != null && !player.hasPermission("magic.wand.overwrite")) {
            boolean isCreator;
            String creatorId = existing.getCreatorId();
            boolean bl = isCreator = creatorId != null && creatorId.equalsIgnoreCase(player.getUniqueId().toString());
            if (!player.hasPermission("magic.wand.overwrite_own") || !isCreator) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "The " + template + " wand already exists and you don't have permission to overwrite it.");
                return true;
            }
        }
        String inheritTemplate = wand.getTemplateKey();
        YamlConfiguration wandConfig = new YamlConfiguration();
        ConfigurationSection wandSection = wandConfig.createSection(template);
        wand.save(wandSection, true);
        wandSection.set("creator_id", (Object)player.getUniqueId().toString());
        wandSection.set("creator", (Object)player.getName());
        if (inheritTemplate != null && inheritTemplate.equals(template)) {
            String oldTemplate = null;
            if (existing != null) {
                ConfigurationSection templateConfig = existing.getConfiguration();
                WandTemplate parent = existing.getParent();
                if (parent != null) {
                    oldTemplate = parent.getKey();
                    ConfigurationSection parentConfig = parent.getConfiguration();
                    templateConfig = ConfigurationUtils.subtractConfiguration(templateConfig, parentConfig);
                }
                ConfigurationUtils.addConfigurations(wandSection, templateConfig, false);
            }
            wandSection.set("inherit", oldTemplate);
        }
        File wandFolder = new File(controller.getConfigFolder(), "wands");
        File wandFile = new File(wandFolder, template + ".yml");
        wandFolder.mkdirs();
        try {
            wandConfig.save(wandFile);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Can't write to file " + wandFile.getName());
            return true;
        }
        String inherit = wandSection.getString("inherit", "");
        if (!inherit.isEmpty() && (inheritConfiguration = controller.getWandTemplate(inherit)) != null) {
            ConfigurationUtils.addConfigurations(wandSection, inheritConfiguration.getConfiguration(), false);
        }
        controller.loadWandTemplate(template, wandSection);
        String message = "Wand saved as " + template;
        if (existing != null) {
            message = message + String.valueOf(ChatColor.GOLD) + " (Replaced Existing)";
        }
        sender.sendMessage(message);
        return true;
    }

    public boolean onWandLevelSpells(CommandSender sender, Player player, String[] parameters) {
        com.elmakers.mine.bukkit.api.wand.Wand wand;
        Integer maxLevel = null;
        if (parameters.length > 0) {
            try {
                maxLevel = Integer.parseInt(parameters[0]);
            }
            catch (Exception ex) {
                sender.sendMessage("Usage: /wand levelspells <level>");
                return true;
            }
        }
        if ((wand = this.checkWand(sender, player)) == null) {
            return true;
        }
        return this.onLevelSpells("wand", sender, player, wand, maxLevel);
    }

    public boolean onWandAdd(CommandSender sender, Player player, String[] parameters) {
        if (parameters.length < 1) {
            sender.sendMessage("Usage: /wand add <spell|material> [material:data]");
            return true;
        }
        com.elmakers.mine.bukkit.api.wand.Wand wand = this.checkWand(sender, player);
        if (wand == null) {
            return true;
        }
        Mage mage = this.controller.getMage(player);
        String spellName = parameters[0];
        if (spellName.equals("material") || spellName.equals("brush")) {
            if (parameters.length < 2) {
                sender.sendMessage("Use: /wand add brush <material:data>");
                return true;
            }
            String materialKey = parameters[1];
            if (materialKey.equals("*")) {
                int added = 0;
                for (Material material : Material.values()) {
                    if (!material.isBlock() || !wand.addBrush(material.name().toLowerCase())) continue;
                    ++added;
                }
                if (sender != player) {
                    sender.sendMessage("Added " + added + " brushes to " + player.getName() + "'s wand");
                }
                return true;
            }
            if (!MaterialBrush.isValidMaterial(materialKey, false)) {
                sender.sendMessage(materialKey + " is not a valid brush");
                return true;
            }
            if (wand.addBrush(materialKey)) {
                wand.setActiveBrush(materialKey);
                if (sender != player) {
                    sender.sendMessage("Added brush '" + materialKey + "' to " + player.getName() + "'s wand");
                }
            } else {
                wand.setActiveBrush(materialKey);
                mage.sendMessage("Brush activated: " + materialKey);
                if (sender != player) {
                    sender.sendMessage(player.getName() + "'s wand already has brush " + materialKey);
                }
            }
            wand.saveState();
            return true;
        }
        MageSpell spell = mage.getSpell(spellName);
        if (spell == null) {
            sender.sendMessage("Spell '" + spellName + "' unknown, Use /spells for spell list");
            return true;
        }
        SpellTemplate currentSpell = wand.getBaseSpell(spellName);
        if (wand.addSpell(spellName)) {
            if (!spell.isPassive()) {
                wand.setActiveSpell(spellName);
            }
            if (currentSpell != null) {
                String levelDescription = spell.getLevelDescription();
                if (levelDescription == null || levelDescription.isEmpty()) {
                    levelDescription = spell.getName();
                }
                if (sender != player) {
                    sender.sendMessage(this.api.getMessages().get("wand.player_spell_upgraded").replace("$player", player.getName()).replace("$name", currentSpell.getName()).replace("$level", levelDescription));
                }
            } else if (sender != player) {
                sender.sendMessage("Added '" + spell.getName() + "' to " + player.getName() + "'s wand");
            }
        } else if (!spell.isPassive()) {
            wand.setActiveSpell(spellName);
            mage.sendMessage(spell.getName() + " activated");
            if (sender != player) {
                sender.sendMessage(player.getName() + "'s wand already has " + spell.getName());
            }
        } else {
            sender.sendMessage(player.getName() + "'s wand already has " + spell.getName());
        }
        wand.saveState();
        return true;
    }

    public boolean onWandRemove(CommandSender sender, Player player, String[] parameters) {
        if (parameters.length < 1) {
            sender.sendMessage("Use: /wand remove <spell|material> [material:data]");
            return true;
        }
        com.elmakers.mine.bukkit.api.wand.Wand wand = this.checkWand(sender, player);
        if (wand == null) {
            return true;
        }
        Mage mage = this.controller.getMage(player);
        String spellName = parameters[0];
        if (spellName.equals("material") || spellName.equals("brush")) {
            if (parameters.length < 2) {
                sender.sendMessage("Use: /wand remove brush <material:data>");
                return true;
            }
            String materialKey = parameters[1];
            if (wand.removeBrush(materialKey)) {
                mage.sendMessage("Brush '" + materialKey + "' has been removed from your wand");
                if (sender != player) {
                    sender.sendMessage("Removed brush '" + materialKey + "' from " + player.getName() + "'s wand");
                }
                wand.saveState();
            } else if (sender != player) {
                sender.sendMessage(player.getName() + "'s wand does not have brush " + materialKey);
            }
            return true;
        }
        if (wand.removeSpell(spellName)) {
            SpellTemplate template = this.api.getSpellTemplate(spellName);
            if (template != null) {
                spellName = template.getName();
            }
            mage.sendMessage("Spell '" + spellName + "' has been removed from your wand");
            if (sender != player) {
                sender.sendMessage("Removed '" + spellName + "' from " + player.getName() + "'s wand");
            }
            wand.saveState();
        } else if (sender != player) {
            sender.sendMessage(player.getName() + "'s wand does not have " + spellName);
        }
        return true;
    }

    public boolean onWandName(CommandSender sender, Player player, String[] parameters) {
        if (parameters.length < 1) {
            sender.sendMessage("Use: /wand name <name>");
            return true;
        }
        com.elmakers.mine.bukkit.api.wand.Wand wand = this.checkWand(sender, player);
        if (wand == null) {
            return true;
        }
        Mage mage = this.controller.getMage(player);
        wand.deactivate();
        wand.setName(StringUtils.join((Object[])parameters, (String)" "));
        wand.saveState();
        mage.checkWand();
        mage.sendMessage(this.api.getMessages().get("wand.renamed"));
        if (sender != player) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.player_renamed", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWand(CommandSender sender, Player player, String[] parameters) {
        String wandName = null;
        if (parameters.length > 0) {
            wandName = parameters[0];
        }
        return this.giveWand(sender, player, wandName, false, true, false, false);
    }
}

