/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.rp.ResourcePackPreference;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RPCommandExecutor
extends MagicTabExecutor {
    public RPCommandExecutor(MagicAPI api) {
        super(api, "getrp");
    }

    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        ArrayList<String> options = new ArrayList<String>();
        if (!this.api.hasPermission(sender, this.getPermissionNode())) {
            return options;
        }
        if (args.length == 1) {
            options.add("auto");
            options.add("default");
            options.add("manual");
            options.add("off");
            options.add("url");
            options.add("download");
            options.addAll(this.controller.getAlternateResourcePacks());
        }
        return options;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!this.api.hasPermission(sender, this.getPermissionNode())) {
            this.sendNoPermission(sender);
            return true;
        }
        Mage mage = (Mage)this.controller.getMage(sender);
        String string = subCommand = args.length > 0 ? args[0] : "";
        if (subCommand.equalsIgnoreCase("download")) {
            String message;
            if (!(sender instanceof Player)) {
                if (this.controller.isResourcePackEnabled()) {
                    mage.sendMessage(this.controller.getResourcePackURL(sender));
                } else if (this.controller.isResourcePackSetByServer()) {
                    mage.sendMessage(this.controller.getMessages().get("commands.getrp.disabled_server"));
                } else {
                    mage.sendMessage(this.controller.getMessages().get("commands.getrp.disabled"));
                }
                return true;
            }
            if (this.controller.isResourcePackEnabled()) {
                message = this.controller.getMessages().get("commands.getrp.download");
                message = message.replace("$url", this.controller.getResourcePackURL(sender));
            } else {
                message = this.controller.getMessages().get("commands.getrp.download_disabled");
            }
            mage.sendMessage(message);
            mage.setResourcePackPreference(ResourcePackPreference.DOWNLOADED);
            return true;
        }
        if (!this.controller.isResourcePackEnabled()) {
            List<String> resourcePackPlugins = this.controller.getResourcePackPlugins();
            if (this.controller.isResourcePackSetByServer()) {
                mage.sendMessage(this.controller.getMessages().get("commands.getrp.disabled_server"));
            } else if (!resourcePackPlugins.isEmpty()) {
                String message = this.controller.getMessages().get("commands.getrp.disabled_plugins");
                message = message.replace("$plugins", StringUtils.join(resourcePackPlugins, ","));
                mage.sendMessage(message);
            } else {
                mage.sendMessage(this.controller.getMessages().get("commands.getrp.disabled"));
            }
            return true;
        }
        if (subCommand.equalsIgnoreCase("url")) {
            mage.sendMessage(this.controller.getResourcePackURL(sender));
            return true;
        }
        if (!(sender instanceof Player)) {
            mage.sendMessage(this.controller.getMessages().get("commands.in_game"));
            return true;
        }
        if (subCommand.isEmpty()) {
            mage.sendMessage(this.controller.getMessages().get("commands.getrp.sending"));
            this.controller.sendResourcePack((Player)sender);
            return true;
        }
        if (subCommand.equalsIgnoreCase("auto")) {
            mage.setResourcePackPreference(ResourcePackPreference.AUTOMATIC);
            this.controller.sendResourcePack((Player)sender);
            mage.sendMessage(this.controller.getMessages().get("commands.getrp.auto"));
            return true;
        }
        if (subCommand.equalsIgnoreCase("off")) {
            mage.setResourcePackPreference(ResourcePackPreference.DISABLED);
            mage.sendMessage(this.controller.getMessages().get("commands.getrp.turnoff"));
            return true;
        }
        if (subCommand.equalsIgnoreCase("manual")) {
            mage.setResourcePackPreference(ResourcePackPreference.MANUAL);
            mage.sendMessage(this.controller.getMessages().get("commands.getrp.manual"));
            return true;
        }
        if (subCommand.equalsIgnoreCase("default")) {
            sender.sendMessage(this.controller.getMessages().get("commands.getrp.default"));
            mage.setResourcePackPreference(ResourcePackPreference.DEFAULT);
            mage.setPreferredResourcePack(null);
            this.controller.sendResourcePack((Player)sender);
            return true;
        }
        if (this.controller.getAlternateResourcePacks().contains(subCommand)) {
            mage.sendMessage(this.controller.getMessages().get("commands.getrp.preference").replace("$pack", subCommand));
            if (mage.getResourcePackPreference() != ResourcePackPreference.AUTOMATIC) {
                mage.sendMessage(this.controller.getMessages().get("commands.getrp.noauto"));
            }
            mage.setPreferredResourcePack(subCommand);
            this.controller.sendResourcePack((Player)sender);
            return true;
        }
        String message = this.controller.getMessages().get("commands.unknown_command");
        message = message.replace("$command", subCommand);
        mage.sendMessage(message);
        return true;
    }
}

