/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.Messages;
import com.elmakers.mine.bukkit.utility.help.Help;
import com.elmakers.mine.bukkit.utility.help.SearchHelpTask;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MagicHelpCommandExecutor
extends MagicTabExecutor {
    private static final int MAX_RESULTS = 10;
    protected final MagicController controller;
    protected final Help help;
    protected Map<String, String> helpTopics;

    protected MagicHelpCommandExecutor(MagicAPI api, String command) {
        super(api, command);
        this.controller = (MagicController)api.getController();
        this.help = this.controller.getMessages().getHelp();
    }

    public MagicHelpCommandExecutor(MagicAPI api) {
        this(api, "mhelp");
    }

    public boolean onCommand(CommandSender sender, Command command, String alias, String[] args) {
        if (!this.api.hasPermission(sender, "magic.commands.mhelp")) {
            this.sendNoPermission(sender);
            return true;
        }
        this.onMagicHelp(sender, args);
        return true;
    }

    protected void onMagicHelp(CommandSender sender, String[] args) {
        Messages messages = this.controller.getMessages();
        Mage mage = this.controller.getMage(sender);
        mage.setShownHelp();
        if (args.length == 0) {
            mage.sendMessage(messages.get("commands.mhelp.header"));
            if (!CompatibilityLib.hasChatComponents()) {
                mage.sendMessage(messages.get("commands.mhelp.unavailable"));
            } else if (sender instanceof Player) {
                mage.sendMessage(messages.get("commands.mhelp.player_header"));
            } else {
                mage.sendMessage(messages.get("commands.mhelp.console_header"));
            }
            this.help.showTopic(mage, "main");
            mage.sendMessage(messages.get("commands.mhelp.separator"));
            return;
        }
        if (args.length == 1) {
            String[] pieces;
            if (args[0].startsWith("instructions") && (pieces = StringUtils.split((String)args[0], (String)".")).length > 1) {
                if (pieces[1].equals("wand")) {
                    Wand wand = mage.getActiveWand();
                    if (wand != null) {
                        wand.showInstructions();
                    } else {
                        mage.sendMessage(messages.get("commands.mhelp.no_wand"));
                    }
                    return;
                }
                if (pieces[1].equals("example")) {
                    if (pieces.length > 2) {
                        this.controller.showExampleInstructions(sender, pieces[2]);
                    } else {
                        this.controller.showExampleInstructions(sender);
                    }
                    return;
                }
            }
            if (this.help.showTopic(mage, args[0])) {
                mage.sendMessage(messages.get("commands.mhelp.separator"));
                return;
            }
        }
        SearchHelpTask searchTask = new SearchHelpTask(this.help, mage, args, 10);
        Plugin plugin = this.controller.getPlugin();
        plugin.getServer().getScheduler().runTaskAsynchronously(plugin, (Runnable)searchTask);
    }

    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        HashSet<String> options = new HashSet<String>();
        if (!sender.hasPermission("magic.commands.mhelp")) {
            return options;
        }
        options.addAll(this.help.getWords());
        return options;
    }
}

