/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world.populator;

import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.world.populator.MagicChunkPopulator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;

public class MagicChunkHandler {
    public static final String BUILTIN_CLASSPATH = "com.elmakers.mine.bukkit.world.populator.builtin";
    private final MagicController controller;
    private final List<MagicChunkPopulator> chunkPopulators = new ArrayList<MagicChunkPopulator>();

    public MagicChunkHandler(MagicController controller) {
        this.controller = controller;
    }

    public void load(String worldName, ConfigurationSection config) {
        if (config == null) {
            return;
        }
        for (String key : config.getKeys(false)) {
            ConfigurationSection handlerConfig = config.getConfigurationSection(key);
            if (handlerConfig == null) {
                this.controller.getLogger().warning("Was expecting a properties section in world chunk_generate config for key '" + worldName + "', but got: " + String.valueOf(config.get(key)));
                continue;
            }
            if (!handlerConfig.getBoolean("enabled", true)) continue;
            String className = handlerConfig.getString("class");
            MagicChunkPopulator populator = this.createChunkPopulator(className);
            if (populator != null) {
                if (populator.load(handlerConfig, this.controller)) {
                    this.chunkPopulators.add(populator);
                    this.controller.info("Adding " + key + " populator to " + worldName);
                    continue;
                }
                this.controller.info("Skipping invalid " + key + " populator for " + worldName);
                continue;
            }
            this.controller.info("Skipping invalid " + key + " populator for " + worldName);
        }
    }

    public Collection<MagicChunkPopulator> getPopulators() {
        return this.chunkPopulators;
    }

    @Nullable
    protected MagicChunkPopulator createChunkPopulator(String className) {
        Object newObject;
        if (className == null) {
            return null;
        }
        if (((String)className).indexOf(46) <= 0 && !((String)(className = "com.elmakers.mine.bukkit.world.populator.builtin." + (String)className)).endsWith("Populator")) {
            className = (String)className + "Populator";
        }
        Class<?> handlerClass = null;
        try {
            handlerClass = Class.forName((String)className);
        }
        catch (Throwable ex) {
            this.controller.getLogger().log(Level.WARNING, "Error loading chunk populator: " + (String)className, ex);
            return null;
        }
        try {
            newObject = handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            this.controller.getLogger().log(Level.WARNING, "Error loading chunk populator: " + (String)className, ex);
            return null;
        }
        if (newObject == null || !(newObject instanceof MagicChunkPopulator)) {
            this.controller.getLogger().warning("Error loading chunk populator: " + (String)className + ", does it extend MagicChunkPopulator?");
            return null;
        }
        return (MagicChunkPopulator)((Object)newObject);
    }

    public boolean isEmpty() {
        return this.chunkPopulators.size() == 0;
    }
}

