/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.warp;

import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.warp.CommandBookWarps;
import com.elmakers.mine.bukkit.warp.EssentialsWarps;
import com.elmakers.mine.bukkit.warp.MagicWarp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class WarpController {
    private final MagicController controller;
    private CommandBookWarps commandBook;
    private EssentialsWarps essentials;
    private final Map<String, MagicWarp> warps = new HashMap<String, MagicWarp>();

    public WarpController(MagicController controller) {
        this.controller = controller;
    }

    public void load(ConfigurationSection warpData) {
        this.warps.clear();
        Set keys = warpData.getKeys(false);
        for (String key : keys) {
            MagicWarp warp = new MagicWarp(key, warpData);
            this.warps.put(key, warp);
            warp.checkMarker(this.controller);
        }
    }

    public void save(ConfigurationSection warpData) {
        for (MagicWarp warp : this.warps.values()) {
            warp.save(warpData);
        }
    }

    public Collection<String> getCustomWarps() {
        return this.warps.keySet();
    }

    public boolean hasCustomWarp(String warpName) {
        return this.warps.containsKey(warpName);
    }

    public void setWarp(String warpName, Location location) {
        MagicWarp warp = this.warps.get(warpName);
        if (warp == null) {
            this.warps.put(warpName, new MagicWarp(warpName, location));
        } else {
            warp.setLocation(location);
            warp.checkMarker(this.controller);
        }
    }

    public boolean removeWarp(String warpName) {
        return this.warps.remove(warpName) != null;
    }

    public int mapWarps(String markerIcon) {
        int count = 0;
        for (MagicWarp warp : this.warps.values()) {
            String existingIcon;
            String baseIcon = warp.getIcon();
            if (baseIcon == null || baseIcon.isEmpty() || (existingIcon = warp.getMarkerIcon()) != null && !existingIcon.isEmpty()) continue;
            warp.setMarkerIcon(markerIcon);
            warp.checkMarker(this.controller);
            ++count;
        }
        return count;
    }

    public int importWarps(CommandSender sender) {
        SpellTemplate recallSpell;
        ConfigurationSection parameters;
        ConfigurationSection recallWarps;
        String key;
        if (this.commandBook != null) {
            for (Map.Entry<String, Location> warpEntry : this.commandBook.getWarps().entrySet()) {
                key = warpEntry.getKey();
                this.warps.put(key, new MagicWarp(key, warpEntry.getValue()));
            }
        }
        if (this.essentials != null) {
            for (Map.Entry<String, Location> warpEntry : this.essentials.getWarps().entrySet()) {
                key = warpEntry.getKey();
                this.warps.put(key, new MagicWarp(key, warpEntry.getValue()));
            }
        }
        ConfigurationSection configurationSection = recallWarps = (parameters = (recallSpell = this.controller.getSpellTemplate("recall")).getConfiguration().getConfigurationSection("parameters")) == null ? null : parameters.getConfigurationSection("warps");
        if (recallWarps != null) {
            boolean imported = false;
            for (String key2 : recallWarps.getKeys(false)) {
                String iconUrl;
                MagicWarp warp = this.warps.get(key2);
                if (warp == null) continue;
                ConfigurationSection warpConfig = recallWarps.getConfigurationSection(key2);
                warp.setName(warpConfig.getString("name", warp.getName()));
                warp.setDescription(warpConfig.getString("description", warp.getDescription()));
                Object icon = warpConfig.getString("icon");
                if ((icon == null || ((String)icon).isEmpty()) && (iconUrl = warpConfig.getString("icon_url")) != null && !iconUrl.isEmpty()) {
                    icon = "skull:" + iconUrl;
                }
                if (icon == null || ((String)icon).isEmpty()) continue;
                String currentIcon = warp.getIcon();
                if (currentIcon == null || currentIcon.isEmpty()) {
                    imported = true;
                }
                warp.setIcon((String)icon);
            }
            if (imported && sender != null) {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Imported Recall Warps" + String.valueOf(ChatColor.WHITE) + ", you may want to remove your Recall customizations with " + String.valueOf(ChatColor.GOLD) + "/mconfig reset recall");
            }
        }
        return this.warps.size();
    }

    @Nullable
    public MagicWarp getMagicWarp(String warpName) {
        return this.warps.get(warpName);
    }

    @Nonnull
    public Collection<MagicWarp> getMagicWarps() {
        return this.warps.values();
    }

    @Nullable
    public Location getWarp(String warpName) {
        Location warp = null;
        MagicWarp customWarp = this.warps.get(warpName);
        if (customWarp != null) {
            warp = customWarp.getLocation();
        }
        if (warp == null && this.commandBook != null) {
            warp = this.commandBook.getWarp(warpName);
        }
        if (warp == null && this.essentials != null) {
            warp = this.essentials.getWarp(warpName);
        }
        return warp;
    }

    public boolean setCommandBook(Plugin plugin) {
        this.commandBook = CommandBookWarps.create(plugin);
        return this.commandBook != null;
    }

    public boolean setEssentials(Plugin plugin) {
        this.essentials = EssentialsWarps.create(plugin);
        return this.essentials != null;
    }

    public List<String> getWarps() {
        return new ArrayList<String>(this.warps.keySet());
    }
}

