/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.warp;

import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.warp.WarpDescription;
import java.util.Collection;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class MagicWarpDescription
implements WarpDescription {
    private final String key;
    private final boolean maintainDirection;
    private final MageController controller;
    @Nullable
    private Collection<EffectPlayer> effects;
    private String permission;

    public MagicWarpDescription(MageController controller, String key, boolean maintainDirection) {
        this.controller = controller;
        this.key = key;
        this.maintainDirection = maintainDirection;
    }

    public MagicWarpDescription(MageController controller, String key) {
        this(controller, key, true);
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    @Override
    public boolean isMaintainDirection() {
        return this.maintainDirection;
    }

    @Override
    public Collection<EffectPlayer> getEffects() {
        return this.effects;
    }

    public void setEffects(Collection<EffectPlayer> effects) {
        this.effects = effects;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    @Override
    public boolean hasPermission(Entity entity) {
        return this.permission == null || entity == null || this.controller.hasPermission(entity, this.permission);
    }
}

