/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_20_6;

import com.elmakers.mine.bukkit.utility.Base64Coder;
import com.elmakers.mine.bukkit.utility.ReflectionUtils;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import com.elmakers.mine.bukkit.utility.platform.base.InventoryUtilsBase;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import org.bukkit.block.Skull;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class InventoryUtils
extends InventoryUtilsBase {
    public InventoryUtils(Platform platform) {
        super(platform);
    }

    @Override
    public boolean addTagsToNBT(Map<String, Object> tags, Object node) {
        if (node == null) {
            this.platform.getLogger().warning("Trying to save tags to a null node");
            return false;
        }
        if (!(node instanceof NBTTagCompound)) {
            this.platform.getLogger().warning("Trying to save tags to a non-CompoundTag");
            return false;
        }
        NBTTagCompound compoundTag = (NBTTagCompound)node;
        for (Map.Entry<String, Object> tag : tags.entrySet()) {
            Object value = tag.getValue();
            try {
                NBTBase wrappedTag = this.wrapInTag(value);
                if (wrappedTag == null) continue;
                compoundTag.a(tag.getKey(), wrappedTag);
            }
            catch (Exception ex) {
                this.platform.getLogger().log(Level.WARNING, "Error saving item data tag " + tag.getKey(), ex);
            }
        }
        return true;
    }

    @Override
    public boolean saveTagsToNBT(Map<String, Object> tags, Object node, Set<String> tagNames) {
        Set<String> currentTags;
        if (node == null) {
            this.platform.getLogger().warning("Trying to save tags to a null node");
            return false;
        }
        if (!(node instanceof NBTTagCompound)) {
            this.platform.getLogger().warning("Trying to save tags to a non-CompoundTag");
            return false;
        }
        NBTTagCompound compoundTag = (NBTTagCompound)node;
        if (tagNames == null) {
            tagNames = tags.keySet();
        }
        currentTags = (currentTags = this.getTagKeys(node)) != null && !tagNames.containsAll(currentTags) ? new HashSet<String>(currentTags) : null;
        for (String tagName : tagNames) {
            if (currentTags != null) {
                currentTags.remove(tagName);
            }
            Object value = tags.get(tagName);
            try {
                NBTBase wrappedTag = this.wrapInTag(value);
                if (wrappedTag == null) continue;
                compoundTag.a(tagName, wrappedTag);
            }
            catch (Exception ex) {
                this.platform.getLogger().log(Level.WARNING, "Error saving item data tag " + tagName, ex);
            }
        }
        if (currentTags != null) {
            for (String currentTag : currentTags) {
                this.platform.getNBTUtils().removeMeta(node, currentTag);
            }
        }
        return true;
    }

    public NBTBase wrapInTag(Object value) {
        if (value == null) {
            return null;
        }
        NBTTagByte wrappedValue = null;
        if (value instanceof Boolean) {
            wrappedValue = NBTTagByte.a((byte)((byte)((Boolean)value != false ? 1 : 0)));
        } else if (value instanceof Double) {
            wrappedValue = NBTTagDouble.a((double)((Double)value));
        } else if (value instanceof Float) {
            wrappedValue = NBTTagFloat.a((float)((Float)value).floatValue());
        } else if (value instanceof Integer) {
            wrappedValue = NBTTagInt.a((int)((Integer)value));
        } else if (value instanceof Long) {
            wrappedValue = NBTTagLong.a((long)((Long)value));
        } else if (value instanceof ConfigurationSection) {
            wrappedValue = new NBTTagCompound();
            this.saveTagsToNBT((ConfigurationSection)value, (Object)wrappedValue, null);
        } else if (value instanceof Map) {
            wrappedValue = new NBTTagCompound();
            Map valueMap = (Map)value;
            this.addTagsToNBT(valueMap, wrappedValue);
        } else if (value instanceof Collection) {
            ArrayList<Number> list = (ArrayList<Number>)value;
            NBTTagList listMeta = new NBTTagList();
            if (list.size() > 1 && list instanceof List) {
                List checkList = (List)value;
                Object e = checkList.get(0);
                Object second = checkList.get(1);
                if (e instanceof String && !(second instanceof String)) {
                    list = new ArrayList<Number>();
                    for (int i = 1; i < checkList.size(); ++i) {
                        if (e.equals("I")) {
                            list.add(this.convertToInteger(checkList.get(i)));
                            continue;
                        }
                        if (e.equals("L")) {
                            list.add(this.convertToLong(checkList.get(i)));
                            continue;
                        }
                        if (e.equals("B")) {
                            list.add(this.convertToByte(checkList.get(i)));
                            continue;
                        }
                        list.add((Number)checkList.get(i));
                    }
                    if (e.equals("B")) {
                        wrappedValue = new NBTTagByteArray(this.makeByteArray((List<Object>)list));
                    } else if (e.equals("I")) {
                        wrappedValue = new NBTTagIntArray(this.makeIntArray((List<Object>)list));
                    } else if (e.equals("L")) {
                        wrappedValue = new NBTTagLongArray(this.makeLongArray((List<Object>)list));
                    }
                }
            }
            if (wrappedValue == null) {
                for (Object e : list) {
                    if (e == null) continue;
                    this.platform.getNBTUtils().addToList(listMeta, this.wrapInTag(e));
                }
                wrappedValue = listMeta;
            }
        } else {
            wrappedValue = NBTTagString.a((String)value.toString());
        }
        return wrappedValue;
    }

    @Override
    public Set<String> getTagKeys(Object tag) {
        if (tag == null || !(tag instanceof NBTTagCompound)) {
            return null;
        }
        return ((NBTTagCompound)tag).e();
    }

    @Override
    public Object getMetaObject(Object tag, String key) {
        if (tag == null || !(tag instanceof NBTTagCompound)) {
            return null;
        }
        try {
            NBTBase metaBase = ((NBTTagCompound)tag).c(key);
            return this.getTagValue(metaBase);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public Object getTagValue(Object tag) throws IllegalAccessException, InvocationTargetException {
        Serializable value;
        if (tag == null) {
            return null;
        }
        if (tag instanceof NBTTagDouble) {
            value = ((NBTTagDouble)tag).j();
        } else if (tag instanceof NBTTagInt) {
            value = ((NBTTagInt)tag).g();
        } else if (tag instanceof NBTTagLong) {
            value = ((NBTTagLong)tag).f();
        } else if (tag instanceof NBTTagFloat) {
            value = Float.valueOf(((NBTTagFloat)tag).k());
        } else if (tag instanceof NBTTagShort) {
            value = ((NBTTagShort)tag).h();
        } else if (tag instanceof NBTTagByte) {
            value = ((NBTTagByte)tag).i();
            if (((Object)value).equals((byte)0)) {
                value = false;
            } else if (((Object)value).equals((byte)1)) {
                value = true;
            }
        } else if (tag instanceof NBTTagList) {
            ArrayList<Object> converted = new ArrayList<Object>();
            for (NBTBase baseTag : (NBTTagList)tag) {
                Object convertedBase = this.getTagValue(baseTag);
                if (convertedBase == null) continue;
                converted.add(convertedBase);
            }
            value = converted;
        } else if (tag instanceof NBTTagString) {
            value = ((NBTTagString)tag).s_();
        } else if (tag instanceof NBTTagIntArray) {
            value = (Serializable)((NBTTagIntArray)tag).g();
        } else if (tag instanceof NBTTagByteArray) {
            value = (Serializable)((NBTTagByteArray)tag).e();
        } else if (tag instanceof NBTTagLongArray) {
            value = (Serializable)((NBTTagLongArray)tag).g();
        } else if (tag instanceof NBTTagCompound) {
            HashMap<String, Object> compoundMap = new HashMap<String, Object>();
            Set<String> keys = this.getTagKeys(tag);
            for (String key : keys) {
                NBTBase baseTag = ((NBTTagCompound)tag).c(key);
                Object convertedBase = this.getTagValue(baseTag);
                if (convertedBase == null) continue;
                compoundMap.put(key, convertedBase);
            }
            value = compoundMap;
        } else {
            value = null;
        }
        return value;
    }

    @Override
    public ItemStack setSkullURL(ItemStack itemStack, URL url, UUID id, String name) {
        try {
            if (this.platform.getItemUtils().isEmpty(itemStack)) {
                return itemStack;
            }
            GameProfile gameProfile = new GameProfile(id, name);
            PropertyMap properties = gameProfile.getProperties();
            if (properties == null) {
                return itemStack;
            }
            itemStack = this.platform.getItemUtils().makeReal(itemStack);
            if (this.platform.getItemUtils().isEmpty(itemStack)) {
                return itemStack;
            }
            String textureJSON = "{textures:{SKIN:{url:\"" + url + "\"}}}";
            String encoded = Base64Coder.encodeString(textureJSON);
            Property newProperty = new Property("textures", encoded);
            properties.put((Object)"textures", (Object)newProperty);
            ItemMeta skullMeta = itemStack.getItemMeta();
            this.setSkullProfile(skullMeta, (Object)gameProfile);
            itemStack.setItemMeta(skullMeta);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return itemStack;
    }

    @Override
    public boolean isSkull(ItemStack item) {
        if (item == null) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        return meta instanceof SkullMeta;
    }

    @Override
    public Object getSkullProfile(ItemMeta itemMeta) {
        if (itemMeta == null || !(itemMeta instanceof SkullMeta)) {
            return null;
        }
        return ReflectionUtils.getPrivate(this.platform.getLogger(), itemMeta, itemMeta.getClass(), "profile");
    }

    @Override
    public Object getSkullProfile(Skull state) {
        return ReflectionUtils.getPrivate(this.platform.getLogger(), state, state.getClass(), "profile");
    }

    @Override
    public boolean setSkullProfile(ItemMeta itemMeta, Object data) {
        if (itemMeta == null || !(itemMeta instanceof SkullMeta)) {
            return false;
        }
        Class[] parameters = new Class[]{GameProfile.class};
        Object[] values = new Object[]{data};
        return ReflectionUtils.callPrivate(this.platform.getLogger(), itemMeta, itemMeta.getClass(), "setProfile", parameters, values);
    }

    @Override
    public boolean setSkullProfile(Skull state, Object data) {
        return ReflectionUtils.setPrivate(this.platform.getLogger(), state, state.getClass(), "profile", data);
    }
}

