/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.help;

import com.elmakers.mine.bukkit.ChatUtils;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.MacroExpansion;
import com.elmakers.mine.bukkit.utility.Messages;
import com.elmakers.mine.bukkit.utility.help.Help;
import com.elmakers.mine.bukkit.utility.help.HelpTopicMatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;

public class HelpTopic {
    private final String key;
    private final String title;
    private final String text;
    private final String extraText;
    private final String topicType;
    private final String[] lines;
    private final double weight;
    protected final Map<String, Integer> words;
    protected final Set<String> titleWords;
    protected final Set<String> tagWords;
    protected final Set<String> extraWords;
    protected final int maxCount;

    public HelpTopic(Messages messages, String key, String text, String extraText, String tags, String topicType, double weight) {
        this.key = key;
        this.topicType = topicType;
        this.weight = weight;
        MacroExpansion expansion = messages.expandMacros(text);
        text = expansion.getText();
        this.text = text = CompatibilityLib.getCompatibilityUtils().translateColors(StringEscapeUtils.unescapeHtml((String)text));
        String simpleText = ChatColor.stripColor((String)ChatUtils.getSimpleMessage(text, true));
        String searchText = simpleText.toLowerCase();
        this.title = expansion.getTitle();
        MacroExpansion extraExpansion = messages.expandMacros(extraText);
        extraText = extraExpansion.getText();
        this.extraText = extraText = CompatibilityLib.getCompatibilityUtils().translateColors(StringEscapeUtils.unescapeHtml((String)extraText));
        String[] allLines = StringUtils.split((String)simpleText, (String)"\n");
        this.lines = !this.title.isEmpty() && allLines.length > 1 ? Arrays.copyOfRange(allLines, 1, allLines.length) : allLines;
        this.words = new HashMap<String, Integer>();
        int maxCount = 0;
        this.titleWords = new HashSet<String>();
        this.tagWords = new HashSet<String>();
        this.extraWords = new HashSet<String>();
        List<String> otherWordList = Arrays.asList(ChatUtils.getWords(extraText.toLowerCase()));
        for (String otherWord : otherWordList) {
            if (otherWord.length() < 2) continue;
            this.extraWords.add(otherWord);
        }
        ArrayList<String> helpTopicWords = new ArrayList<String>();
        helpTopicWords.addAll(Arrays.asList(ChatUtils.getWords(searchText)));
        List<String> titleWordList = Arrays.asList(ChatUtils.getWords(this.title.toLowerCase()));
        for (String string : titleWordList) {
            if (string.length() < 2) continue;
            this.titleWords.add(string);
        }
        helpTopicWords.addAll(titleWordList);
        List<String> keyWordList = Arrays.asList(ChatUtils.getWords(key));
        for (String string : keyWordList) {
            if (string.length() < 2) continue;
            this.titleWords.add(string);
        }
        helpTopicWords.addAll(keyWordList);
        tags = (String)tags + " " + expansion.getTags();
        List<String> list = Arrays.asList(ChatUtils.getWords(((String)tags).toLowerCase()));
        helpTopicWords.addAll(list);
        for (String tagWord : list) {
            if (tagWord.length() < 2) continue;
            this.tagWords.add(tagWord);
        }
        List<String> list2 = Arrays.asList(ChatUtils.getWords(topicType.toLowerCase()));
        for (String topicWord : list2) {
            if (topicWord.length() < 2) continue;
            this.tagWords.add(topicWord);
        }
        helpTopicWords.addAll(list2);
        for (String word : helpTopicWords) {
            if ((word = word.trim()).length() < 2) continue;
            Integer count = this.words.get(word);
            if (count == null) {
                count = 1;
            } else {
                Integer n = count;
                count = count + 1;
            }
            this.words.put(word, count);
            maxCount = Math.max(maxCount, count);
        }
        this.maxCount = maxCount;
    }

    @Nonnull
    public String getTitle() {
        if (this.title.isEmpty()) {
            String[] pieces = StringUtils.split((String)this.key, (String)".");
            return pieces.length > 1 ? pieces[pieces.length - 1] : this.key;
        }
        return this.title;
    }

    @Nonnull
    public String getText() {
        return this.text + this.extraText;
    }

    @Nonnull
    public HelpTopicMatch match(Help help, Collection<String> keywords) {
        return HelpTopicMatch.match(help, this, keywords);
    }

    public Map<String, Integer> getWordCounts() {
        return this.words;
    }

    public String[] getLines() {
        return this.lines;
    }

    public String getKey() {
        return this.key;
    }

    public String getTopicType() {
        return this.topicType;
    }

    public double getWeight() {
        return this.weight;
    }
}

