/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_16.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.utility.ConfigUtils;
import com.elmakers.mine.bukkit.utility.platform.v1_14.entity.EntityFoxData;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.PiglinAbstract;

public class EntityAbstractPiglinData
extends EntityFoxData {
    private Boolean transformable;

    public EntityAbstractPiglinData(ConfigurationSection parameters, MageController controller) {
        super(parameters, controller);
        this.transformable = ConfigUtils.getOptionalBoolean(parameters, "transformable");
    }

    public EntityAbstractPiglinData(Entity entity) {
        super(entity);
        if (entity instanceof PiglinAbstract) {
            PiglinAbstract piglin = (PiglinAbstract)entity;
            this.transformable = !piglin.isImmuneToZombification();
        }
    }

    @Override
    public void apply(Entity entity) {
        super.apply(entity);
        if (entity instanceof PiglinAbstract) {
            PiglinAbstract piglin = (PiglinAbstract)entity;
            if (this.transformable != null) {
                piglin.setImmuneToZombification(this.transformable == false);
            }
        }
    }
}

