/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.VariableScope;
import com.elmakers.mine.bukkit.api.requirements.Requirement;
import com.elmakers.mine.bukkit.api.spell.PrerequisiteSpell;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.configuration.MageParameters;
import com.elmakers.mine.bukkit.configuration.MagicConfiguration;
import com.elmakers.mine.bukkit.configuration.ParameterizedConfigurationSection;
import com.elmakers.mine.bukkit.configuration.SpellParameters;
import com.elmakers.mine.bukkit.configuration.TranslatingConfiguration;
import com.elmakers.mine.bukkit.configuration.TranslatingConfigurationSection;
import com.elmakers.mine.bukkit.effect.SoundEffect;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Biome;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ConfigurationUtils
extends ConfigUtils {
    private static MagicController controller;

    public static void setMagicController(MagicController controller) {
        ConfigurationUtils.controller = controller;
    }

    @Nullable
    public static MaterialAndData getMaterialAndData(ConfigurationSection node, String path) {
        return ConfigurationUtils.getMaterialAndData(node, path, null);
    }

    @Nullable
    public static MaterialAndData getMaterialAndData(ConfigurationSection node, String path, MaterialAndData def) {
        String stringData = node.getString(path);
        if (stringData == null) {
            return def;
        }
        return ConfigurationUtils.toMaterialAndData(stringData);
    }

    @Nullable
    public static MaterialAndData getIconMaterialAndData(ConfigurationSection node, String path, boolean legacy, MaterialAndData def) {
        String stringData;
        if (legacy) {
            path = "legacy_" + path;
        }
        if ((stringData = node.getString(path)) == null) {
            return def;
        }
        return ConfigurationUtils.toMaterialAndData(stringData);
    }

    @Nullable
    public static MaterialAndData toMaterialAndData(Object o) {
        if (o instanceof MaterialAndData) {
            return (MaterialAndData)o;
        }
        if (o instanceof String) {
            String matName = (String)o;
            return new MaterialAndData(matName);
        }
        return null;
    }

    public static boolean loadAllTagsFromNBT(ConfigurationSection tags, Object tag) {
        return CompatibilityLib.getCompatibilityUtils().loadAllTagsFromNBT(tags, tag);
    }

    public static boolean loadAllTagsFromNBT(ConfigurationSection tags, ItemStack item) {
        if (item == null) {
            return false;
        }
        Object tag = CompatibilityLib.getItemUtils().getTag(item);
        if (tag == null) {
            return false;
        }
        return ConfigurationUtils.loadAllTagsFromNBT(tags, tag);
    }

    protected void combine(Map<Object, Object> to, Map<? extends Object, Object> from) {
        for (Map.Entry<? extends Object, Object> entry : from.entrySet()) {
            Object toValue;
            Object value = entry.getValue();
            Object key = entry.getKey();
            if (value instanceof Map && to.containsKey(key) && (toValue = to.get(key)) instanceof Map) {
                this.combine((Map)toValue, (Map)value);
                continue;
            }
            to.put(key, value);
        }
    }

    @Nonnull
    public static ConfigurationSection cloneEmptyConfiguration(ConfigurationSection section) {
        if (section instanceof SpellParameters) {
            return new SpellParameters((SpellParameters)section);
        }
        if (section instanceof MageParameters) {
            return new MageParameters((MageParameters)section);
        }
        if (section instanceof MagicConfiguration) {
            return new MagicConfiguration((MagicConfiguration)section);
        }
        if (section instanceof ParameterizedConfigurationSection) {
            return new ParameterizedConfigurationSection(section);
        }
        if (section instanceof TranslatingConfiguration) {
            return new TranslatingConfiguration();
        }
        if (section instanceof TranslatingConfigurationSection) {
            return new TranslatingConfigurationSection(section);
        }
        return ConfigurationUtils.newConfigurationSection();
    }

    @Nonnull
    public static ConfigurationSection cloneConfiguration(ConfigurationSection section) {
        ConfigurationSection copy = ConfigurationUtils.cloneEmptyConfiguration(section);
        return ConfigurationUtils.addConfigurations(copy, section);
    }

    @Nullable
    public static ConfigurationSection replaceParameters(ConfigurationSection configuration, ConfigurationSection parameters) {
        ConfigurationSection replaced = ConfigurationUtils.tryReplaceParameters(configuration, parameters);
        return replaced == null ? configuration : replaced;
    }

    @Nullable
    private static ConfigurationSection tryReplaceParameters(ConfigurationSection configuration, ConfigurationSection parameters) {
        if (configuration == null) {
            return null;
        }
        ConfigurationSection replaced = null;
        Set keys = configuration.getKeys(false);
        for (String key : keys) {
            Object value = configuration.get(key);
            Object replacement = ConfigurationUtils.tryReplaceParameters(value, parameters);
            if (replacement == null) continue;
            if (replaced == null) {
                replaced = ConfigurationUtils.cloneConfiguration(configuration);
            }
            replaced.set(key, replacement);
        }
        return replaced;
    }

    private static Map<String, Object> tryReplaceParameters(Map<String, Object> configuration, ConfigurationSection parameters) {
        if (configuration == null || configuration.isEmpty()) {
            return null;
        }
        HashMap<String, Object> replaced = null;
        for (Map.Entry<String, Object> entry : configuration.entrySet()) {
            Object entryValue = entry.getValue();
            Object replacement = ConfigurationUtils.tryReplaceParameters(entryValue, parameters);
            if (replacement == null) continue;
            if (replaced == null) {
                replaced = new HashMap<String, Object>(configuration);
            }
            replaced.put(entry.getKey(), replacement);
        }
        return replaced;
    }

    @Nullable
    private static Object tryReplaceParameters(Object value, ConfigurationSection parameters) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            value = ConfigurationUtils.tryReplaceParameters(map, parameters);
        } else if (value instanceof ConfigurationSection) {
            value = ConfigurationUtils.tryReplaceParameters(value, parameters);
        } else if (value instanceof List) {
            List list = (List)value;
            value = ConfigurationUtils.tryReplaceParameters(list, parameters);
        } else if (value instanceof String) {
            value = ConfigurationUtils.tryReplaceParameter((String)value, parameters);
        }
        return value;
    }

    private static List<Object> tryReplaceParameters(List<Object> configurations, ConfigurationSection parameters) {
        if (configurations == null || configurations.size() == 0) {
            return null;
        }
        ArrayList<Object> replaced = null;
        for (int i = 0; i < configurations.size(); ++i) {
            Object value = configurations.get(i);
            Object replacement = ConfigurationUtils.tryReplaceParameters(value, parameters);
            if (replacement == null) continue;
            if (replaced == null) {
                replaced = new ArrayList<Object>(configurations);
            }
            replaced.set(i, replacement);
        }
        return replaced;
    }

    private static Object tryReplaceParameter(String value, ConfigurationSection parameters) {
        if (value.length() < 2 || value.charAt(0) != '$') {
            return null;
        }
        return parameters.get(value.substring(1));
    }

    public static ConfigurationSection addConfigurations(ConfigurationSection first, ConfigurationSection second) {
        return ConfigurationUtils.addConfigurations(first, second, true);
    }

    public static ConfigurationSection addConfigurations(ConfigurationSection first, ConfigurationSection second, boolean override) {
        return ConfigurationUtils.addConfigurations(first, second, override, false, false);
    }

    public static ConfigurationSection addConfigurations(ConfigurationSection first, ConfigurationSection second, boolean override, boolean requireExisting) {
        return ConfigurationUtils.addConfigurations(first, second, override, requireExisting, false);
    }

    @Nonnull
    public static ConfigurationSection addConfigurations(@Nonnull ConfigurationSection first, @Nullable ConfigurationSection second, boolean override, boolean requireExisting, boolean isUserConfig) {
        if (second == null) {
            return first;
        }
        override = override || second.getBoolean("override");
        Map<String, Object> map = ConfigurationUtils.toMap(second);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key;
            Object existingValue;
            Object value = entry.getValue();
            if (value == null || (existingValue = first.get(key = entry.getKey())) == null && requireExisting) continue;
            if (value instanceof Map) {
                value = ConfigurationUtils.getConfigurationSection(second, key);
            }
            if (existingValue instanceof Map) {
                existingValue = ConfigurationUtils.getConfigurationSection(first, key);
            }
            if (value instanceof ConfigurationSection && (existingValue == null || existingValue instanceof ConfigurationSection)) {
                boolean skipMerge;
                ConfigurationSection addChild = (ConfigurationSection)value;
                boolean bl = isUserConfig ? addChild.contains("inherit") : (skipMerge = addChild.isBoolean("inherit") && !addChild.getBoolean("inherit", true));
                if (existingValue == null || skipMerge) {
                    ConfigurationSection newChild = first.createSection(key);
                    ConfigurationUtils.addConfigurations(newChild, addChild, override);
                    continue;
                }
                ConfigurationUtils.addConfigurations((ConfigurationSection)existingValue, addChild, override);
                continue;
            }
            if (!override && existingValue != null) continue;
            first.set(key, value);
        }
        return first;
    }

    @Nonnull
    public static ConfigurationSection addNumericConfigurations(@Nonnull ConfigurationSection first, @Nullable ConfigurationSection second, boolean override) {
        if (second == null) {
            return first;
        }
        Set keys = second.getKeys(true);
        for (String key : keys) {
            double value = second.getDouble(key);
            Object existingValue = first.get(key);
            if (existingValue != null && !override) continue;
            first.set(key, (Object)value);
        }
        return first;
    }

    @Nonnull
    public static ConfigurationSection overlayNumericConfigurations(@Nonnull ConfigurationSection first, @Nullable ConfigurationSection second) {
        return ConfigurationUtils.addNumericConfigurations(first, second, false);
    }

    public static ConfigurationSection replaceConfigurations(ConfigurationSection first, ConfigurationSection second) {
        if (second == null) {
            return first;
        }
        Map<String, Object> map = ConfigurationUtils.toMap(second);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            first.set(entry.getKey(), entry.getValue());
        }
        return first;
    }

    public static ConfigurationSection overlayConfigurations(ConfigurationSection first, ConfigurationSection second) {
        return ConfigurationUtils.addConfigurations(first, second, false);
    }

    public static ConfigurationSection mergeConfigurations(ConfigurationSection ... configs) {
        ConfigurationSection merged = null;
        for (ConfigurationSection config : configs) {
            if (config == null) continue;
            if (merged == null) {
                merged = ConfigurationUtils.cloneConfiguration(config);
                continue;
            }
            ConfigurationUtils.overlayConfigurations(merged, config);
        }
        return merged;
    }

    public static void mergeText(ConfigurationSection first, ConfigurationSection second) {
        for (String key : second.getKeys(true)) {
            if (!second.isString(key)) continue;
            String value = second.getString(key);
            String firstValue = first.getString(key);
            if (firstValue != null && !firstValue.isEmpty()) {
                value = firstValue + "\n" + value;
            }
            first.set(key, (Object)value);
        }
    }

    public static void addParameters(String[] extraParameters, ConfigurationSection parameters) {
        if (extraParameters != null) {
            for (int i = 0; i < extraParameters.length - 1; i += 2) {
                if (extraParameters[i] == null || extraParameters[i].isEmpty()) continue;
                ConfigurationUtils.set(parameters, extraParameters[i], extraParameters[i + 1]);
            }
        }
    }

    public static String getParameters(ConfigurationSection parameters) {
        ArrayList<String> parameterStrings = new ArrayList<String>();
        Map<String, Object> map = ConfigurationUtils.toMap(parameters);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            parameterStrings.add(entry.getKey());
            parameterStrings.add(entry.getValue().toString());
        }
        return StringUtils.join(parameterStrings, (char)' ');
    }

    public static SoundEffect toSoundEffect(String soundConfig) {
        return new SoundEffect(soundConfig);
    }

    @Nullable
    public static Particle toParticleEffect(String effectParticleName) {
        Particle effectParticle = null;
        if (effectParticleName.length() > 0) {
            String particleName = effectParticleName.toUpperCase();
            try {
                effectParticle = Particle.valueOf((String)particleName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return effectParticle;
    }

    public static Collection<String> getKeysOrList(@Nonnull ConfigurationSection node, @Nonnull String key) {
        ConfigurationSection spellSection;
        Collection<String> values = null;
        if (node.isString(key)) {
            values = ConfigurationUtils.getStringList(node, key);
        } else if (node.isConfigurationSection(key) && (spellSection = node.getConfigurationSection(key)) != null) {
            values = spellSection.getKeys(false);
        }
        if (values == null) {
            values = new ArrayList<String>(0);
        }
        return values;
    }

    public static Collection<PrerequisiteSpell> getPrerequisiteSpells(MageController controller, ConfigurationSection node, String key, String loadContext, boolean removeMissing) {
        if (node == null || key == null) {
            return new ArrayList<PrerequisiteSpell>(0);
        }
        Collection spells = null;
        if (node.isString(key)) {
            spells = ConfigurationUtils.getStringList(node, key);
        } else if (node.isConfigurationSection(key)) {
            ConfigurationSection spellSection = node.getConfigurationSection(key);
            if (spellSection != null) {
                spells = spellSection.getKeys(false);
            }
        } else {
            spells = node.getList(key);
        }
        if (spells == null) {
            spells = new ArrayList(0);
        }
        ArrayList<PrerequisiteSpell> requiredSpells = new ArrayList<PrerequisiteSpell>(spells.size());
        for (Object o : spells) {
            String spell;
            PrerequisiteSpell prerequisiteSpell = null;
            if (o instanceof String) {
                prerequisiteSpell = new PrerequisiteSpell(new SpellKey((String)o), 0L);
            } else if (o instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)o;
                spell = section.getString("spell");
                long progressLevel = section.getLong("progress_level");
                prerequisiteSpell = new PrerequisiteSpell(new SpellKey(spell), progressLevel);
            } else if (o instanceof Map) {
                String progressLevelString;
                Map map = (Map)o;
                spell = map.get("spell").toString();
                String string = progressLevelString = map.containsKey("progress_level") ? map.get("progress_level").toString() : "0";
                if (spell != null && StringUtils.isNumeric((String)progressLevelString)) {
                    long progressLevel = 0L;
                    try {
                        progressLevel = Long.parseLong(progressLevelString);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    prerequisiteSpell = new PrerequisiteSpell(new SpellKey(spell), progressLevel);
                }
            }
            if (prerequisiteSpell == null) continue;
            if (controller.getSpellTemplate(prerequisiteSpell.getSpellKey().getKey()) != null) {
                requiredSpells.add(prerequisiteSpell);
                continue;
            }
            if (!removeMissing) {
                requiredSpells.add(prerequisiteSpell);
                controller.getLogger().warning("Unknown or disabled spell requirement " + prerequisiteSpell.getSpellKey().getKey() + " in " + loadContext + ", upgrade will be disabled");
                continue;
            }
            controller.info("Unknown or disabled spell prerequisite " + prerequisiteSpell.getSpellKey().getKey() + " in " + loadContext + ", ignoring", 5);
        }
        return requiredSpells;
    }

    @Nullable
    public static Collection<PotionEffect> getPotionEffects(ConfigurationSection parentConfig, String effectKey, int defaultDuration) {
        if (parentConfig.isConfigurationSection(effectKey)) {
            return ConfigurationUtils.getPotionEffects(parentConfig.getConfigurationSection(effectKey), null);
        }
        ArrayList<PotionEffect> effects = null;
        if (parentConfig.isList(effectKey)) {
            effects = new ArrayList<PotionEffect>();
            List effectList = parentConfig.getStringList(effectKey);
            for (String value : effectList) {
                String[] pieces = StringUtils.split((String)value, (String)"@");
                String key = pieces[0];
                try {
                    PotionEffectType effectType = PotionEffectType.getByName((String)key.toUpperCase());
                    int power = 1;
                    if (pieces.length > 1) {
                        power = (int)Float.parseFloat(pieces[1]);
                    }
                    PotionEffect effect = new PotionEffect(effectType, defaultDuration, power, true, true);
                    effects.add(effect);
                }
                catch (Exception ex) {
                    Bukkit.getLogger().warning("Error parsing potion effect for " + key + ": " + value);
                }
            }
        }
        return effects;
    }

    @Nullable
    public static Collection<PotionEffect> getPotionEffects(ConfigurationSection effectConfig) {
        return ConfigurationUtils.getPotionEffects(effectConfig, null);
    }

    @Nullable
    public static Collection<PotionEffect> getPotionEffects(ConfigurationSection effectConfig, Integer duration) {
        return ConfigurationUtils.getPotionEffects(effectConfig, duration, true, true);
    }

    @Nullable
    public static Collection<PotionEffect> getPotionEffects(ConfigurationSection effectConfig, Integer duration, boolean ambient, boolean particles) {
        if (effectConfig == null) {
            return null;
        }
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        Set keys = effectConfig.getKeys(false);
        if (keys.isEmpty()) {
            return null;
        }
        for (String key : keys) {
            String value = effectConfig.getString(key);
            try {
                PotionEffectType effectType = PotionEffectType.getByName((String)key.toUpperCase());
                int ticks = 10;
                int power = 1;
                if (value.contains(",")) {
                    String[] pieces = StringUtils.split((String)value, (char)',');
                    ticks = (int)Float.parseFloat(pieces[0]);
                    power = (int)Float.parseFloat(pieces[1]);
                } else {
                    power = (int)Float.parseFloat(value);
                    if (duration != null) {
                        ticks = duration / 50;
                    }
                }
                PotionEffect effect = new PotionEffect(effectType, ticks, power, ambient, particles);
                effects.add(effect);
            }
            catch (Exception ex) {
                Bukkit.getLogger().warning("Error parsing potion effect for " + key + ": " + value);
            }
        }
        return effects;
    }

    public static ConfigurationSection subtractConfiguration(ConfigurationSection base, ConfigurationSection subtract) {
        Set keys = subtract.getKeys(false);
        for (String key : keys) {
            Object subtractObject;
            Object baseObject = base.get(key);
            if (baseObject == null || (subtractObject = subtract.get(key)) == null) continue;
            if (subtractObject instanceof ConfigurationSection && baseObject instanceof ConfigurationSection) {
                ConfigurationSection baseConfig = (ConfigurationSection)baseObject;
                ConfigurationSection subtractConfig = (ConfigurationSection)subtractObject;
                if (!(baseConfig = ConfigurationUtils.subtractConfiguration(baseConfig, subtractConfig)).getKeys(false).isEmpty()) {
                    continue;
                }
            } else if (!subtractObject.equals(baseObject)) continue;
            base.set(key, null);
        }
        return base;
    }

    public static VariableScope parseScope(String scopeString, VariableScope defaultScope, Logger logger) {
        VariableScope scope = defaultScope;
        if (scopeString != null && !scopeString.isEmpty()) {
            try {
                scope = VariableScope.valueOf(scopeString.toUpperCase());
            }
            catch (Exception ex) {
                logger.warning("Invalid variable scope: " + scopeString);
            }
        }
        return scope;
    }

    @Nullable
    public static Object convertProperty(@Nullable Object value) {
        if (value == null) {
            return value;
        }
        Object result = value;
        boolean isTrue = value.equals("true");
        boolean isFalse = value.equals("false");
        if (isTrue || isFalse) {
            result = isTrue;
        } else {
            try {
                result = value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString());
            }
            catch (Exception notAnInteger) {
                try {
                    result = value instanceof Double ? (Double)value : (value instanceof Float ? (double)((Float)value).floatValue() : Double.parseDouble(value.toString()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public static String getIcon(ConfigurationSection node, boolean legacy) {
        return ConfigurationUtils.getIcon(node, legacy, "icon");
    }

    public static String getIcon(ConfigurationSection node, boolean legacy, String iconKey) {
        if (legacy) {
            return node.getString("legacy_" + iconKey, node.getString(iconKey));
        }
        return node.getString(iconKey);
    }

    public static boolean isEnabled(ConfigurationSection configuration) {
        if (configuration == null) {
            return false;
        }
        if (!configuration.getBoolean("enabled", true)) {
            return false;
        }
        String required = configuration.getString("requires");
        return required == null || required.isEmpty() || Bukkit.getPluginManager().getPlugin(required) != null;
    }

    public static boolean deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                ConfigurationUtils.deleteDirectory(file);
            }
        }
        return directoryToBeDeleted.delete();
    }

    public static ConfigurationSection newConfigurationSection(String logContext) {
        if (controller != null) {
            return new MagicConfiguration(controller, logContext);
        }
        return new TranslatingConfiguration();
    }

    public static ConfigurationSection newConfigurationSection() {
        return ConfigurationUtils.newConfigurationSection("Anonymous");
    }

    @Nullable
    public static Set<Biome> loadBiomes(List<String> biomeNames, Logger logger, String logContext) {
        if (biomeNames == null || biomeNames.isEmpty()) {
            return null;
        }
        HashSet<Biome> set = new HashSet<Biome>();
        for (String biomeName : biomeNames) {
            try {
                Biome biome = Biome.valueOf((String)biomeName.trim().toUpperCase());
                set.add(biome);
            }
            catch (Exception exception) {}
        }
        return set;
    }

    public static ConfigurationSection addSection(ConfigurationSection parent, String path, Map<?, ?> nodeMap) {
        ConfigurationSection newSection = ConfigurationUtils.toConfigurationSection(parent, path, nodeMap);
        parent.set(path, (Object)newSection);
        return newSection;
    }

    @Nullable
    public static Collection<Requirement> getRequirements(ConfigurationSection configuration) {
        ConfigurationSection singleConfiguration;
        ArrayList<Requirement> requirements = null;
        List<ConfigurationSection> requirementConfigurations = ConfigurationUtils.getNodeList(configuration, "requirements");
        if (requirementConfigurations != null) {
            requirements = new ArrayList<Requirement>();
            for (ConfigurationSection requirementConfiguration : requirementConfigurations) {
                requirements.add(new Requirement(requirementConfiguration));
            }
        }
        if ((singleConfiguration = ConfigurationUtils.getConfigurationSection(configuration, "requirement")) != null) {
            if (requirements == null) {
                requirements = new ArrayList();
            }
            requirements.add(new Requirement(singleConfiguration));
        }
        return requirements;
    }

    @Nullable
    public static Material toMaterial(Object o) {
        if (o instanceof Material) {
            return (Material)o;
        }
        if (o instanceof Integer) {
            return Material.values()[(Integer)o];
        }
        if (o instanceof String) {
            String matName = (String)o;
            try {
                int value = Integer.parseInt(matName);
                return CompatibilityLib.getCompatibilityUtils().getMaterial(value);
            }
            catch (NumberFormatException numberFormatException) {
                return Material.getMaterial((String)matName.toUpperCase());
            }
        }
        return null;
    }

    @Nullable
    public static Material getMaterial(ConfigurationSection node, String path, Material def) {
        String stringData = node.getString(path);
        if (stringData == null || stringData.isEmpty()) {
            return def;
        }
        return ConfigurationUtils.toMaterial(stringData);
    }

    @Nullable
    public static Material getMaterial(ConfigurationSection node, String path) {
        return ConfigurationUtils.getMaterial(node, path, null);
    }

    public static String fromMaterial(Material material) {
        if (material == null) {
            return "";
        }
        return material.name().toLowerCase();
    }

    @Nullable
    public static Integer parseTime(String timeString, Logger log, String logContext) {
        Integer time = null;
        if (timeString != null) {
            if (timeString.equalsIgnoreCase("day")) {
                time = 0;
            } else if (timeString.equalsIgnoreCase("night")) {
                time = 13000;
            } else if (timeString.equalsIgnoreCase("dusk") || timeString.equalsIgnoreCase("sunset")) {
                time = 12000;
            } else if (timeString.equalsIgnoreCase("dawn") || timeString.equalsIgnoreCase("sunrise")) {
                time = 23000;
            } else if (timeString.equalsIgnoreCase("noon") || timeString.equalsIgnoreCase("midday")) {
                time = 6000;
            } else if (timeString.equalsIgnoreCase("midnight")) {
                time = 18000;
            } else {
                try {
                    time = Integer.parseInt(timeString);
                }
                catch (Exception ex) {
                    log.warning("Invalid time in " + logContext + ": " + timeString);
                }
            }
        }
        return time;
    }

    @Nullable
    public static Integer parseMoonPhase(String phaseString, Logger log, String logContext) {
        Integer phase = null;
        if (phaseString != null) {
            if (phaseString.equalsIgnoreCase("new")) {
                phase = 4;
            } else if (phaseString.equalsIgnoreCase("full")) {
                phase = 0;
            } else {
                try {
                    phase = Integer.parseInt(phaseString);
                }
                catch (Exception ex) {
                    log.warning("Invalid phase of moon in " + logContext + " config: " + phaseString);
                }
            }
        }
        return phase;
    }

    public static void parseDisguiseTarget(ConfigurationSection parameters, CastContext context) {
        String disguiseTarget = parameters.getString("disguise_target");
        if (disguiseTarget != null) {
            Entity targetEntity;
            Entity entity = targetEntity = disguiseTarget.equals("target") ? context.getTargetEntity() : context.getEntity();
            if (targetEntity != null) {
                ConfigurationSection disguiseConfig = parameters.createSection("disguise");
                disguiseConfig.set("type", (Object)targetEntity.getType().name().toLowerCase());
                if (targetEntity instanceof Player) {
                    MageController controller = context.getController();
                    Player targetPlayer = (Player)targetEntity;
                    disguiseConfig.set("name", (Object)targetPlayer.getName());
                    disguiseConfig.set("skin", (Object)targetPlayer.getName());
                    PlayerInventory inventory = targetPlayer.getInventory();
                    ItemStack helmet = inventory.getHelmet();
                    if (!CompatibilityLib.getItemUtils().isEmpty(helmet)) {
                        disguiseConfig.set("helmet", (Object)controller.getItemKey(helmet));
                    }
                    ItemStack chestplate = inventory.getChestplate();
                    if (!CompatibilityLib.getItemUtils().isEmpty(chestplate)) {
                        disguiseConfig.set("chestplate", (Object)controller.getItemKey(chestplate));
                    }
                    ItemStack leggings = inventory.getLeggings();
                    if (!CompatibilityLib.getItemUtils().isEmpty(leggings)) {
                        disguiseConfig.set("leggings", (Object)controller.getItemKey(leggings));
                    }
                    ItemStack boots = inventory.getBoots();
                    if (!CompatibilityLib.getItemUtils().isEmpty(boots)) {
                        disguiseConfig.set("boots", (Object)controller.getItemKey(boots));
                    }
                    ItemStack mainhand = inventory.getItemInMainHand();
                    if (!CompatibilityLib.getItemUtils().isEmpty(mainhand)) {
                        disguiseConfig.set("mainhand", (Object)controller.getItemKey(mainhand));
                    }
                    ItemStack offhand = inventory.getItemInOffHand();
                    if (!CompatibilityLib.getItemUtils().isEmpty(offhand)) {
                        disguiseConfig.set("offhand", (Object)controller.getItemKey(offhand));
                    }
                }
            }
        }
    }
}

