/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

@Name(value="Has Magic Item")
@Description(value={"Checks whether a player has a specific magc item or wand."})
@Examples(value={"player has \"emerald_sword\"", "player has \"lightsaber\" in offhand", "player does not have \"battle\"", "player is wearing \"magneticleggings\""})
public class CondHasItem
extends Condition {
    private Expression<Entity> entities;
    private Expression<String> itemKeys;
    private boolean offhand;
    private boolean armor;

    public static void register() {
        Skript.registerCondition(CondHasItem.class, (String[])new String[]{"[%entities%] ha(s|ve) [wand] [%-strings%] in [main] hand", "[%entities%] [(is|are)] holding [wand] [%-strings%] [in main hand]", "[%entities%] ha(s|ve) [wand] [%-strings%] in off[(-| )]hand", "[%entities%] [(is|are)] holding [wand] [%-strings%] in off[(-| )]hand", "[%entities%] (ha(s|ve) not|do[es]n't have) [wand] [%-strings%] in [main] hand", "[%entities%] [(is|are)] wearing [wand] [%-strings%]", "[%entities%] (is not|isn't) holding [wand] [%-strings%] [in main hand]", "[%entities%] (ha(s|ve) not|do[es]n't have) [wand] [%-strings%] in off[(-| )]hand", "[%entities%] (is not|isn't) holding [wand] [%-strings%] in off[(-| )]hand", "[%entities%] (is not|isn't) wearing [wand] [%-strings%]"});
    }

    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = vars[0];
        this.itemKeys = vars[1];
        this.offhand = matchedPattern == 2 || matchedPattern == 3 || matchedPattern == 7 || matchedPattern == 8;
        this.armor = matchedPattern == 5 || matchedPattern == 9;
        this.setNegated(matchedPattern >= 6);
        return true;
    }

    public boolean check(final Event e) {
        return this.entities.check(e, (Checker)new Checker<Entity>(){

            public boolean check(Entity entity) {
                EntityEquipment equipment;
                Wand wand;
                final MageController controller = MagicPlugin.getAPI().getController();
                Mage mage = controller.getRegisteredMage(entity);
                if (mage == null) {
                    return false;
                }
                Wand wand2 = wand = CondHasItem.this.offhand ? mage.getOffhandWand() : mage.getActiveWand();
                if (CondHasItem.this.itemKeys == null) {
                    return wand != null != CondHasItem.this.isNegated();
                }
                final LivingEntity living = mage.getLivingEntity();
                EntityEquipment entityEquipment = equipment = living == null ? null : living.getEquipment();
                final ItemStack item = wand == null && equipment != null ? (CondHasItem.this.offhand ? equipment.getItemInOffHand() : equipment.getItemInMainHand()) : null;
                return CondHasItem.this.itemKeys.check(e, (Checker)new Checker<String>(){

                    public boolean check(String targetKey) {
                        String itemKey;
                        if (CondHasItem.this.armor) {
                            if (living == null) {
                                return false;
                            }
                            for (ItemStack armorItem : living.getEquipment().getArmorContents()) {
                                if (armorItem == null) continue;
                                String key = controller.getWandKey(armorItem);
                                if (key != null && key.equalsIgnoreCase(targetKey)) {
                                    return true;
                                }
                                key = controller.getItemKey(armorItem);
                                if (key == null || !key.equalsIgnoreCase(targetKey)) continue;
                                return true;
                            }
                            return false;
                        }
                        if (wand != null && wand.getTemplateKey().equalsIgnoreCase(targetKey)) {
                            return true;
                        }
                        return item != null && (itemKey = controller.getItemKey(item)) != null && itemKey.equalsIgnoreCase(targetKey);
                    }
                }, CondHasItem.this.isNegated());
            }
        });
    }

    public String toString(@Nullable Event e, boolean debug) {
        String itemTypes = this.itemKeys == null ? "" : this.itemKeys.toString();
        return this.entities.toString(e, debug) + (this.entities.isSingle() ? " has" : " have") + (this.isNegated() ? " not" : "") + (this.armor ? " wearing " : " ") + itemTypes;
    }
}

