/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_18_2.goal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;

public class MagicGoal
extends PathfinderGoal {
    private final Collection<PathfinderGoal> goals;
    private final boolean interruptable;
    private PathfinderGoal currentGoal;

    public MagicGoal(Collection<PathfinderGoal> goals, boolean interruptable) {
        this(goals, interruptable, null);
    }

    public MagicGoal(Collection<PathfinderGoal> goals, boolean interruptable, List<String> flagKeys) {
        EnumSet<PathfinderGoal.Type> flags;
        this.goals = goals;
        this.interruptable = interruptable;
        if (flagKeys == null) {
            flags = EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b);
        } else {
            flags = EnumSet.noneOf(PathfinderGoal.Type.class);
            for (String flagKey : flagKeys) {
                try {
                    PathfinderGoal.Type flag = PathfinderGoal.Type.valueOf((String)flagKey.toUpperCase());
                    flags.add(flag);
                }
                catch (Exception exception) {}
            }
        }
        this.a(flags);
    }

    public boolean a() {
        for (PathfinderGoal goal : this.goals) {
            if (!goal.a() || this.currentGoal != null) continue;
            this.currentGoal = goal;
        }
        return this.currentGoal != null;
    }

    public boolean b() {
        boolean interrupt = false;
        boolean continuing = false;
        for (PathfinderGoal goal : this.goals) {
            if (goal == this.currentGoal) {
                boolean canContinue = goal.b();
                if (canContinue) {
                    continuing = true;
                } else {
                    interrupt = true;
                }
            } else {
                boolean canUse = goal.a();
                if (canUse && !continuing && (this.currentGoal == null || this.currentGoal.D_())) {
                    interrupt = true;
                }
            }
            if (!interrupt) continue;
            return false;
        }
        return true;
    }

    public boolean D_() {
        for (PathfinderGoal goal : this.goals) {
            if (goal.D_() || goal != this.currentGoal) continue;
            return false;
        }
        return this.interruptable;
    }

    public void c() {
        if (this.currentGoal != null) {
            this.currentGoal.c();
        }
    }

    public void d() {
        if (this.currentGoal != null) {
            this.currentGoal.d();
            this.currentGoal = null;
        }
    }

    public void e() {
        if (this.currentGoal != null) {
            this.currentGoal.e();
        }
    }

    protected String getSubDescription() {
        ArrayList<String> goalDescriptions = new ArrayList<String>();
        for (PathfinderGoal goal : this.goals) {
            String goalDescription = goal.toString();
            goalDescription = goal == this.currentGoal ? ChatColor.AQUA + goalDescription : ChatColor.DARK_AQUA + goalDescription;
            goalDescriptions.add(goalDescription);
        }
        return ChatColor.DARK_GRAY + " [" + StringUtils.join(goalDescriptions, (String)" ") + ChatColor.DARK_GRAY + "]";
    }

    protected String getDescription() {
        return "Group";
    }

    public String toString() {
        return this.getDescription() + this.getSubDescription();
    }
}

