/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block.magic;

import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.block.magic.Caster;
import com.elmakers.mine.bukkit.block.magic.InteractCaster;
import com.elmakers.mine.bukkit.block.magic.MagicBlock;
import com.elmakers.mine.bukkit.block.magic.Spawner;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.warp.MagicWarpDescription;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class MagicBlockTemplate {
    @Nonnull
    private final MageController controller;
    @Nonnull
    private final ConfigurationSection configuration;
    @Nonnull
    private final String key;
    @Nullable
    private String name;
    @Nullable
    private String description;
    private int interval;
    @Nullable
    private Spawner spawner;
    @Nullable
    private Caster caster;
    @Nullable
    private InteractCaster interactCaster;
    @Nullable
    private Collection<EffectPlayer> effects;
    @Nullable
    private MagicWarpDescription portalWarp;
    @Nullable
    private String portalSpell;
    private final int playerRange;
    private final int minPlayers;
    private final Integer minTimeOfDay;
    private final Integer maxTimeOfDay;
    private final Integer minPhaseOfMoon;
    private final Integer maxPhaseOfMoon;
    private final boolean alwaysActive;
    private final boolean removeWhenBroken;
    private final boolean remove;
    private final String dropWhenRemoved;

    public MagicBlockTemplate(@Nonnull MageController controller, @Nonnull String key, @Nonnull ConfigurationSection configuration) {
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.controller = controller;
        this.configuration = configuration;
        this.name = configuration.getString("name");
        this.description = configuration.getString("description");
        this.interval = configuration.getInt("interval", 0);
        this.alwaysActive = configuration.getBoolean("always_active", false);
        this.removeWhenBroken = configuration.getBoolean("remove_when_broken", false);
        this.remove = configuration.getBoolean("remove", false);
        this.dropWhenRemoved = configuration.getString("drop_when_removed");
        this.portalSpell = configuration.getString("portal_spell");
        String portalWarpKey = configuration.getString("portal_warp");
        if (portalWarpKey != null) {
            this.portalWarp = new MagicWarpDescription(controller, portalWarpKey, configuration.getBoolean("warp_maintain_direction", true));
            Collection<EffectPlayer> warpEffects = null;
            if (configuration.isList("warp_effects")) {
                warpEffects = controller.loadEffects(configuration, "warp_effects");
            } else {
                String effectKey = configuration.getString("warp_effects");
                if (effectKey != null) {
                    warpEffects = controller.getEffects(effectKey);
                    if (this.effects.isEmpty()) {
                        warpEffects = null;
                    }
                }
            }
            this.portalWarp.setPermission(configuration.getString("permission"));
            this.portalWarp.setEffects(warpEffects);
        }
        if (configuration.isList("effects")) {
            this.effects = controller.loadEffects(configuration, "effects");
        } else {
            String effectKey = configuration.getString("effects");
            if (effectKey != null) {
                this.effects = controller.getEffects(effectKey);
                if (this.effects.isEmpty()) {
                    this.effects = null;
                }
            }
        }
        if (configuration.contains("spawn")) {
            this.spawner = new Spawner(controller, this, configuration.getConfigurationSection("spawn"));
        }
        if (configuration.contains("cast")) {
            this.caster = new Caster(this, configuration.getConfigurationSection("cast"));
        }
        if (configuration.contains("interact")) {
            this.interactCaster = new InteractCaster(this, controller, configuration.getConfigurationSection("interact"));
        }
        this.playerRange = configuration.getInt("player_range", 64);
        this.minPlayers = configuration.getInt("min_players", 0);
        this.minTimeOfDay = this.parseTime(configuration, "min_time", controller.getLogger());
        this.maxTimeOfDay = this.parseTime(configuration, "max_time", controller.getLogger());
        if (configuration.contains("moon_phase")) {
            this.minPhaseOfMoon = this.maxPhaseOfMoon = this.parseMoonPhase(configuration, "moon_phase", controller.getLogger());
        } else {
            this.minPhaseOfMoon = this.parseMoonPhase(configuration, "min_moon_phase", controller.getLogger());
            this.maxPhaseOfMoon = this.parseMoonPhase(configuration, "max_moon_phase", controller.getLogger());
        }
    }

    @Nullable
    private Integer parseTime(ConfigurationSection configuration, String key, Logger log) {
        return ConfigurationUtils.parseTime(configuration.getString(key), log, "magic block");
    }

    @Nullable
    private Integer parseMoonPhase(ConfigurationSection configuration, String key, Logger log) {
        return ConfigurationUtils.parseMoonPhase(configuration.getString(key), log, "magic block");
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public String getName() {
        String name = this.name;
        return name == null ? this.key : name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public int getInterval() {
        return this.interval;
    }

    public boolean isAlwaysActive() {
        return this.alwaysActive;
    }

    public boolean interact(MagicBlock instance, Player player) {
        if (this.interactCaster == null) {
            return false;
        }
        Mage mage = instance.getMage();
        return this.interactCaster.onInteract(mage, instance.getLocation(), player);
    }

    public void tick(MagicBlock instance) {
        boolean isActive = this.checkActive(instance.getLocation());
        boolean firstActivate = false;
        if (isActive) {
            if (!instance.isActive()) {
                firstActivate = true;
                instance.activate();
            }
        } else {
            if (instance.isActive()) {
                instance.deactivate();
            }
            return;
        }
        if (this.spawner != null) {
            if (instance.getTimeToNextSpawn() <= 0L) {
                instance.spawn();
            }
            instance.checkEntities();
        }
        if (this.caster != null && (this.caster.isRecast() || firstActivate)) {
            Mage mage = instance.getMage();
            this.caster.cast(mage, instance.getLocation());
        }
    }

    public MagicBlockTemplate getVariant(ConfigurationSection parameters) {
        ConfigurationSection mergedConfiguration = ConfigurationUtils.cloneConfiguration(this.configuration);
        mergedConfiguration = ConfigurationUtils.addConfigurations(mergedConfiguration, parameters);
        return new MagicBlockTemplate(this.controller, this.key, mergedConfiguration);
    }

    @Nullable
    public Collection<EffectPlayer> getEffects() {
        return this.effects;
    }

    private boolean checkRange(Integer min, Integer max, int value) {
        if (min != null && (max != null && max < min ? value < min && value > max : value < min)) {
            return false;
        }
        return max == null || value <= max || min != null && min > max;
    }

    public boolean checkActive(Location location) {
        if (!this.checkRange(this.minTimeOfDay, this.maxTimeOfDay, (int)location.getWorld().getTime())) {
            return false;
        }
        if (!this.checkRange(this.minPhaseOfMoon, this.maxPhaseOfMoon, (int)(location.getWorld().getFullTime() / 24000L % 8L))) {
            return false;
        }
        if (this.minPlayers >= 0 && this.playerRange > 0) {
            int playerCount = 0;
            int rangeSquared = this.playerRange * this.playerRange;
            List players = location.getWorld().getPlayers();
            for (Player player : players) {
                if (!(player.getLocation().distanceSquared(location) <= (double)rangeSquared)) continue;
                ++playerCount;
            }
            if (playerCount < this.minPlayers) {
                return false;
            }
        }
        return true;
    }

    public boolean isUndoAll() {
        return this.caster != null && this.caster.isUndoAll();
    }

    @Nullable
    public Spawner getSpawner() {
        return this.spawner;
    }

    public ConfigurationSection getConfiguration() {
        return this.configuration;
    }

    public boolean removeWhenBroken() {
        return this.removeWhenBroken;
    }

    public boolean shouldRemove() {
        return this.remove;
    }

    public String getDropWhenRemoved() {
        return this.dropWhenRemoved;
    }

    public MagicWarpDescription getPortalWarp() {
        return this.portalWarp;
    }

    public String getPortalSpell() {
        return this.portalSpell;
    }
}

